package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNatIpCidrs invokes the vpc.ListNatIpCidrs API synchronously
func (client *Client) ListNatIpCidrs(request *ListNatIpCidrsRequest) (response *ListNatIpCidrsResponse, err error) {
	response = CreateListNatIpCidrsResponse()
	err = client.DoAction(request, response)
	return
}

// ListNatIpCidrsWithChan invokes the vpc.ListNatIpCidrs API asynchronously
func (client *Client) ListNatIpCidrsWithChan(request *ListNatIpCidrsRequest) (<-chan *ListNatIpCidrsResponse, <-chan error) {
	responseChan := make(chan *ListNatIpCidrsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNatIpCidrs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNatIpCidrsWithCallback invokes the vpc.ListNatIpCidrs API asynchronously
func (client *Client) ListNatIpCidrsWithCallback(request *ListNatIpCidrsRequest, callback func(response *ListNatIpCidrsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNatIpCidrsResponse
		var err error
		defer close(result)
		response, err = client.ListNatIpCidrs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNatIpCidrsRequest is the request struct for api ListNatIpCidrs
type ListNatIpCidrsRequest struct {
	*requests.RpcRequest
	NatIpCidrId          string           `position:"Query" name:"NatIpCidrId"`
	NatIpCidrs           *[]string        `position:"Query" name:"NatIpCidrs"  type:"Repeated"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NextToken            string           `position:"Query" name:"NextToken"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	NatIpCidrName        *[]string        `position:"Query" name:"NatIpCidrName"  type:"Repeated"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NatIpCidr            string           `position:"Query" name:"NatIpCidr"`
	NatIpCidrStatus      string           `position:"Query" name:"NatIpCidrStatus"`
	MaxResults           string           `position:"Query" name:"MaxResults"`
}

// ListNatIpCidrsResponse is the response struct for api ListNatIpCidrs
type ListNatIpCidrsResponse struct {
	*responses.BaseResponse
	NextToken  string      `json:"NextToken" xml:"NextToken"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount string      `json:"TotalCount" xml:"TotalCount"`
	MaxResults string      `json:"MaxResults" xml:"MaxResults"`
	NatIpCidrs []NatIpCidr `json:"NatIpCidrs" xml:"NatIpCidrs"`
}

// CreateListNatIpCidrsRequest creates a request to invoke ListNatIpCidrs API
func CreateListNatIpCidrsRequest() (request *ListNatIpCidrsRequest) {
	request = &ListNatIpCidrsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListNatIpCidrs", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListNatIpCidrsResponse creates a response to parse from ListNatIpCidrs response
func CreateListNatIpCidrsResponse() (response *ListNatIpCidrsResponse) {
	response = &ListNatIpCidrsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
