package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnassociateVpcCidrBlock invokes the vpc.UnassociateVpcCidrBlock API synchronously
func (client *Client) UnassociateVpcCidrBlock(request *UnassociateVpcCidrBlockRequest) (response *UnassociateVpcCidrBlockResponse, err error) {
	response = CreateUnassociateVpcCidrBlockResponse()
	err = client.DoAction(request, response)
	return
}

// UnassociateVpcCidrBlockWithChan invokes the vpc.UnassociateVpcCidrBlock API asynchronously
func (client *Client) UnassociateVpcCidrBlockWithChan(request *UnassociateVpcCidrBlockRequest) (<-chan *UnassociateVpcCidrBlockResponse, <-chan error) {
	responseChan := make(chan *UnassociateVpcCidrBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnassociateVpcCidrBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnassociateVpcCidrBlockWithCallback invokes the vpc.UnassociateVpcCidrBlock API asynchronously
func (client *Client) UnassociateVpcCidrBlockWithCallback(request *UnassociateVpcCidrBlockRequest, callback func(response *UnassociateVpcCidrBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnassociateVpcCidrBlockResponse
		var err error
		defer close(result)
		response, err = client.UnassociateVpcCidrBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnassociateVpcCidrBlockRequest is the request struct for api UnassociateVpcCidrBlock
type UnassociateVpcCidrBlockRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	IPv6CidrBlock        string           `position:"Query" name:"IPv6CidrBlock"`
	SecondaryCidrBlock   string           `position:"Query" name:"SecondaryCidrBlock"`
	VpcId                string           `position:"Query" name:"VpcId"`
}

// UnassociateVpcCidrBlockResponse is the response struct for api UnassociateVpcCidrBlock
type UnassociateVpcCidrBlockResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnassociateVpcCidrBlockRequest creates a request to invoke UnassociateVpcCidrBlock API
func CreateUnassociateVpcCidrBlockRequest() (request *UnassociateVpcCidrBlockRequest) {
	request = &UnassociateVpcCidrBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UnassociateVpcCidrBlock", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnassociateVpcCidrBlockResponse creates a response to parse from UnassociateVpcCidrBlock response
func CreateUnassociateVpcCidrBlockResponse() (response *UnassociateVpcCidrBlockResponse) {
	response = &UnassociateVpcCidrBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
