package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindPurchasedDevice invokes the vs.BindPurchasedDevice API synchronously
func (client *Client) BindPurchasedDevice(request *BindPurchasedDeviceRequest) (response *BindPurchasedDeviceResponse, err error) {
	response = CreateBindPurchasedDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BindPurchasedDeviceWithChan invokes the vs.BindPurchasedDevice API asynchronously
func (client *Client) BindPurchasedDeviceWithChan(request *BindPurchasedDeviceRequest) (<-chan *BindPurchasedDeviceResponse, <-chan error) {
	responseChan := make(chan *BindPurchasedDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindPurchasedDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindPurchasedDeviceWithCallback invokes the vs.BindPurchasedDevice API asynchronously
func (client *Client) BindPurchasedDeviceWithCallback(request *BindPurchasedDeviceRequest, callback func(response *BindPurchasedDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindPurchasedDeviceResponse
		var err error
		defer close(result)
		response, err = client.BindPurchasedDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindPurchasedDeviceRequest is the request struct for api BindPurchasedDevice
type BindPurchasedDeviceRequest struct {
	*requests.RpcRequest
	ShowLog  string           `position:"Query" name:"ShowLog"`
	GroupId  string           `position:"Query" name:"GroupId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId string           `position:"Query" name:"DeviceId"`
	Region   string           `position:"Query" name:"Region"`
}

// BindPurchasedDeviceResponse is the response struct for api BindPurchasedDevice
type BindPurchasedDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindPurchasedDeviceRequest creates a request to invoke BindPurchasedDevice API
func CreateBindPurchasedDeviceRequest() (request *BindPurchasedDeviceRequest) {
	request = &BindPurchasedDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BindPurchasedDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateBindPurchasedDeviceResponse creates a response to parse from BindPurchasedDevice response
func CreateBindPurchasedDeviceResponse() (response *BindPurchasedDeviceResponse) {
	response = &BindPurchasedDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
