package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDirectory invokes the vs.CreateDirectory API synchronously
func (client *Client) CreateDirectory(request *CreateDirectoryRequest) (response *CreateDirectoryResponse, err error) {
	response = CreateCreateDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDirectoryWithChan invokes the vs.CreateDirectory API asynchronously
func (client *Client) CreateDirectoryWithChan(request *CreateDirectoryRequest) (<-chan *CreateDirectoryResponse, <-chan error) {
	responseChan := make(chan *CreateDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDirectoryWithCallback invokes the vs.CreateDirectory API asynchronously
func (client *Client) CreateDirectoryWithCallback(request *CreateDirectoryRequest, callback func(response *CreateDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDirectoryResponse
		var err error
		defer close(result)
		response, err = client.CreateDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDirectoryRequest is the request struct for api CreateDirectory
type CreateDirectoryRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	ParentId    string           `position:"Query" name:"ParentId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	GroupId     string           `position:"Query" name:"GroupId"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	Name        string           `position:"Query" name:"Name"`
}

// CreateDirectoryResponse is the response struct for api CreateDirectory
type CreateDirectoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateDirectoryRequest creates a request to invoke CreateDirectory API
func CreateCreateDirectoryRequest() (request *CreateDirectoryRequest) {
	request = &CreateDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDirectoryResponse creates a response to parse from CreateDirectory response
func CreateCreateDirectoryResponse() (response *CreateDirectoryResponse) {
	response = &CreateDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
