package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDevice invokes the vs.ModifyDevice API synchronously
func (client *Client) ModifyDevice(request *ModifyDeviceRequest) (response *ModifyDeviceResponse, err error) {
	response = CreateModifyDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDeviceWithChan invokes the vs.ModifyDevice API asynchronously
func (client *Client) ModifyDeviceWithChan(request *ModifyDeviceRequest) (<-chan *ModifyDeviceResponse, <-chan error) {
	responseChan := make(chan *ModifyDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDeviceWithCallback invokes the vs.ModifyDevice API asynchronously
func (client *Client) ModifyDeviceWithCallback(request *ModifyDeviceRequest, callback func(response *ModifyDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDeviceResponse
		var err error
		defer close(result)
		response, err = client.ModifyDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDeviceRequest is the request struct for api ModifyDevice
type ModifyDeviceRequest struct {
	*requests.RpcRequest
	GbId        string           `position:"Query" name:"GbId"`
	Latitude    string           `position:"Query" name:"Latitude"`
	Description string           `position:"Query" name:"Description"`
	Type        string           `position:"Query" name:"Type"`
	AutoStart   requests.Boolean `position:"Query" name:"AutoStart"`
	ParentId    string           `position:"Query" name:"ParentId"`
	Password    string           `position:"Query" name:"Password"`
	Vendor      string           `position:"Query" name:"Vendor"`
	AlarmMethod string           `position:"Query" name:"AlarmMethod"`
	DirectoryId string           `position:"Query" name:"DirectoryId"`
	Id          string           `position:"Query" name:"Id"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	Longitude   string           `position:"Query" name:"Longitude"`
	GroupId     string           `position:"Query" name:"GroupId"`
	Ip          string           `position:"Query" name:"Ip"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	Params      string           `position:"Query" name:"Params"`
	Url         string           `position:"Query" name:"Url"`
	Port        requests.Integer `position:"Query" name:"Port"`
	Name        string           `position:"Query" name:"Name"`
	PosInterval requests.Integer `position:"Query" name:"PosInterval"`
	Username    string           `position:"Query" name:"Username"`
	AutoPos     requests.Boolean `position:"Query" name:"AutoPos"`
}

// ModifyDeviceResponse is the response struct for api ModifyDevice
type ModifyDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateModifyDeviceRequest creates a request to invoke ModifyDevice API
func CreateModifyDeviceRequest() (request *ModifyDeviceRequest) {
	request = &ModifyDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ModifyDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDeviceResponse creates a response to parse from ModifyDevice response
func CreateModifyDeviceResponse() (response *ModifyDeviceResponse) {
	response = &ModifyDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
