package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnvResource invokes the webplus.DescribeEnvResource API synchronously
// api document: https://help.aliyun.com/api/webplus/describeenvresource.html
func (client *Client) DescribeEnvResource(request *DescribeEnvResourceRequest) (response *DescribeEnvResourceResponse, err error) {
	response = CreateDescribeEnvResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnvResourceWithChan invokes the webplus.DescribeEnvResource API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeenvresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEnvResourceWithChan(request *DescribeEnvResourceRequest) (<-chan *DescribeEnvResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeEnvResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnvResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnvResourceWithCallback invokes the webplus.DescribeEnvResource API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeenvresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEnvResourceWithCallback(request *DescribeEnvResourceRequest, callback func(response *DescribeEnvResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnvResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnvResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnvResourceRequest is the request struct for api DescribeEnvResource
type DescribeEnvResourceRequest struct {
	*requests.RoaRequest
	EnvId string `position:"Query" name:"EnvId"`
}

// DescribeEnvResourceResponse is the response struct for api DescribeEnvResource
type DescribeEnvResourceResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	EnvResource EnvResource `json:"EnvResource" xml:"EnvResource"`
}

// CreateDescribeEnvResourceRequest creates a request to invoke DescribeEnvResource API
func CreateDescribeEnvResourceRequest() (request *DescribeEnvResourceRequest) {
	request = &DescribeEnvResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeEnvResource", "/pop/v1/wam/envResource", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeEnvResourceResponse creates a response to parse from DescribeEnvResource response
func CreateDescribeEnvResourceResponse() (response *DescribeEnvResourceResponse) {
	response = &DescribeEnvResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
