package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataAssets invokes the yundun_ds.DescribeDataAssets API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedataassets.html
func (client *Client) DescribeDataAssets(request *DescribeDataAssetsRequest) (response *DescribeDataAssetsResponse, err error) {
	response = CreateDescribeDataAssetsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataAssetsWithChan invokes the yundun_ds.DescribeDataAssets API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedataassets.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataAssetsWithChan(request *DescribeDataAssetsRequest) (<-chan *DescribeDataAssetsResponse, <-chan error) {
	responseChan := make(chan *DescribeDataAssetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataAssets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataAssetsWithCallback invokes the yundun_ds.DescribeDataAssets API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedataassets.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataAssetsWithCallback(request *DescribeDataAssetsRequest, callback func(response *DescribeDataAssetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataAssetsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataAssets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataAssetsRequest is the request struct for api DescribeDataAssets
type DescribeDataAssetsRequest struct {
	*requests.RpcRequest
	RangeId     requests.Integer `position:"Query" name:"RangeId"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	RiskLevels  string           `position:"Query" name:"RiskLevels"`
	Name        string           `position:"Query" name:"Name"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
	RuleId      requests.Integer `position:"Query" name:"RuleId"`
}

// DescribeDataAssetsResponse is the response struct for api DescribeDataAssets
type DescribeDataAssetsResponse struct {
	*responses.BaseResponse
	RequestId   string  `json:"RequestId" xml:"RequestId"`
	PageSize    int     `json:"PageSize" xml:"PageSize"`
	CurrentPage int     `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int     `json:"TotalCount" xml:"TotalCount"`
	Items       []Asset `json:"Items" xml:"Items"`
}

// CreateDescribeDataAssetsRequest creates a request to invoke DescribeDataAssets API
func CreateDescribeDataAssetsRequest() (request *DescribeDataAssetsRequest) {
	request = &DescribeDataAssetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeDataAssets", "sddp", "openAPI")
	return
}

// CreateDescribeDataAssetsResponse creates a response to parse from DescribeDataAssets response
func CreateDescribeDataAssetsResponse() (response *DescribeDataAssetsResponse) {
	response = &DescribeDataAssetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
