package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigInstanceNetwork invokes the yundun_bastionhost.ConfigInstanceNetwork API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/configinstancenetwork.html
func (client *Client) ConfigInstanceNetwork(request *ConfigInstanceNetworkRequest) (response *ConfigInstanceNetworkResponse, err error) {
	response = CreateConfigInstanceNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigInstanceNetworkWithChan invokes the yundun_bastionhost.ConfigInstanceNetwork API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/configinstancenetwork.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigInstanceNetworkWithChan(request *ConfigInstanceNetworkRequest) (<-chan *ConfigInstanceNetworkResponse, <-chan error) {
	responseChan := make(chan *ConfigInstanceNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigInstanceNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigInstanceNetworkWithCallback invokes the yundun_bastionhost.ConfigInstanceNetwork API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/configinstancenetwork.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigInstanceNetworkWithCallback(request *ConfigInstanceNetworkRequest, callback func(response *ConfigInstanceNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigInstanceNetworkResponse
		var err error
		defer close(result)
		response, err = client.ConfigInstanceNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigInstanceNetworkRequest is the request struct for api ConfigInstanceNetwork
type ConfigInstanceNetworkRequest struct {
	*requests.RpcRequest
	SourceIp            string           `position:"Query" name:"SourceIp"`
	PublicAccessControl requests.Integer `position:"Query" name:"PublicAccessControl"`
	Lang                string           `position:"Query" name:"Lang"`
	PrivateWhiteList    *[]string        `position:"Query" name:"PrivateWhiteList"  type:"Repeated"`
	PublicWhiteList     *[]string        `position:"Query" name:"PublicWhiteList"  type:"Repeated"`
	SecurityGroupIds    *[]string        `position:"Query" name:"SecurityGroupIds"  type:"Repeated"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
}

// ConfigInstanceNetworkResponse is the response struct for api ConfigInstanceNetwork
type ConfigInstanceNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigInstanceNetworkRequest creates a request to invoke ConfigInstanceNetwork API
func CreateConfigInstanceNetworkRequest() (request *ConfigInstanceNetworkRequest) {
	request = &ConfigInstanceNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "ConfigInstanceNetwork", "bastionhost", "openAPI")
	return
}

// CreateConfigInstanceNetworkResponse creates a response to parse from ConfigInstanceNetwork response
func CreateConfigInstanceNetworkResponse() (response *ConfigInstanceNetworkResponse) {
	response = &ConfigInstanceNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
