// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationRequest method.
//	req, resp := client.CreateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateApplication
func (c *AppConfig) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for Amazon AppConfig.
//
// Creates an application. In AppConfig, an application is simply an organizational
// construct like a folder. This organizational construct has a relationship
// with some unit of executable code. For example, you could create an application
// called MyMobileApp to organize and manage configuration data for a mobile
// application installed by your users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateApplication
func (c *AppConfig) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationProfile = "CreateConfigurationProfile"

// CreateConfigurationProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationProfile for more information on using the CreateConfigurationProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfigurationProfileRequest method.
//	req, resp := client.CreateConfigurationProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateConfigurationProfile
func (c *AppConfig) CreateConfigurationProfileRequest(input *CreateConfigurationProfileInput) (req *request.Request, output *CreateConfigurationProfileOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles",
	}

	if input == nil {
		input = &CreateConfigurationProfileInput{}
	}

	output = &CreateConfigurationProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfigurationProfile API operation for Amazon AppConfig.
//
// Creates a configuration profile, which is information that enables AppConfig
// to access the configuration source. Valid configuration sources include the
// AppConfig hosted configuration store, Amazon Web Services Systems Manager
// (SSM) documents, SSM Parameter Store parameters, Amazon S3 objects, or any
// integration source action (http://docs.aws.amazon.com/codepipeline/latest/userguide/integrations-action-type.html#integrations-source)
// supported by CodePipeline. A configuration profile includes the following
// information:
//
//   - The URI location of the configuration data.
//
//   - The Identity and Access Management (IAM) role that provides access to
//     the configuration data.
//
//   - A validator for the configuration data. Available validators include
//     either a JSON Schema or an Amazon Web Services Lambda function.
//
// For more information, see Create a Configuration and a Configuration Profile
// (http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateConfigurationProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateConfigurationProfile
func (c *AppConfig) CreateConfigurationProfile(input *CreateConfigurationProfileInput) (*CreateConfigurationProfileOutput, error) {
	req, out := c.CreateConfigurationProfileRequest(input)
	return out, req.Send()
}

// CreateConfigurationProfileWithContext is the same as CreateConfigurationProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateConfigurationProfileWithContext(ctx aws.Context, input *CreateConfigurationProfileInput, opts ...request.Option) (*CreateConfigurationProfileOutput, error) {
	req, out := c.CreateConfigurationProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeploymentStrategy = "CreateDeploymentStrategy"

// CreateDeploymentStrategyRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeploymentStrategy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeploymentStrategy for more information on using the CreateDeploymentStrategy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDeploymentStrategyRequest method.
//	req, resp := client.CreateDeploymentStrategyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateDeploymentStrategy
func (c *AppConfig) CreateDeploymentStrategyRequest(input *CreateDeploymentStrategyInput) (req *request.Request, output *CreateDeploymentStrategyOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentStrategy,
		HTTPMethod: "POST",
		HTTPPath:   "/deploymentstrategies",
	}

	if input == nil {
		input = &CreateDeploymentStrategyInput{}
	}

	output = &CreateDeploymentStrategyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeploymentStrategy API operation for Amazon AppConfig.
//
// Creates a deployment strategy that defines important criteria for rolling
// out your configuration to the designated targets. A deployment strategy includes
// the overall duration required, a percentage of targets to receive the deployment
// during each interval, an algorithm that defines how percentage grows, and
// bake time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateDeploymentStrategy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateDeploymentStrategy
func (c *AppConfig) CreateDeploymentStrategy(input *CreateDeploymentStrategyInput) (*CreateDeploymentStrategyOutput, error) {
	req, out := c.CreateDeploymentStrategyRequest(input)
	return out, req.Send()
}

// CreateDeploymentStrategyWithContext is the same as CreateDeploymentStrategy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeploymentStrategy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateDeploymentStrategyWithContext(ctx aws.Context, input *CreateDeploymentStrategyInput, opts ...request.Option) (*CreateDeploymentStrategyOutput, error) {
	req, out := c.CreateDeploymentStrategyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentRequest method.
//	req, resp := client.CreateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateEnvironment
func (c *AppConfig) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/environments",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for Amazon AppConfig.
//
// Creates an environment. For each application, you define one or more environments.
// An environment is a deployment group of AppConfig targets, such as applications
// in a Beta or Production environment. You can also define environments for
// application subcomponents such as the Web, Mobile and Back-end components
// for your application. You can configure Amazon CloudWatch alarms for each
// environment. The system monitors alarms during a configuration deployment.
// If an alarm is triggered, the system rolls back the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateEnvironment
func (c *AppConfig) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExtension = "CreateExtension"

// CreateExtensionRequest generates a "aws/request.Request" representing the
// client's request for the CreateExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExtension for more information on using the CreateExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExtensionRequest method.
//	req, resp := client.CreateExtensionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtension
func (c *AppConfig) CreateExtensionRequest(input *CreateExtensionInput) (req *request.Request, output *CreateExtensionOutput) {
	op := &request.Operation{
		Name:       opCreateExtension,
		HTTPMethod: "POST",
		HTTPPath:   "/extensions",
	}

	if input == nil {
		input = &CreateExtensionInput{}
	}

	output = &CreateExtensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExtension API operation for Amazon AppConfig.
//
// Creates an AppConfig extension. An extension augments your ability to inject
// logic or behavior at different points during the AppConfig workflow of creating
// or deploying a configuration.
//
// You can create your own extensions or use the Amazon Web Services-authored
// extensions provided by AppConfig. For most use-cases, to create your own
// extension, you must create an Lambda function to perform any computation
// and processing defined in the extension. For more information about extensions,
// see Working with AppConfig extensions (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateExtension for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ServiceQuotaExceededException
//     The number of hosted configuration versions exceeds the limit for the AppConfig
//     hosted configuration store. Delete one or more versions and try again.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtension
func (c *AppConfig) CreateExtension(input *CreateExtensionInput) (*CreateExtensionOutput, error) {
	req, out := c.CreateExtensionRequest(input)
	return out, req.Send()
}

// CreateExtensionWithContext is the same as CreateExtension with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateExtensionWithContext(ctx aws.Context, input *CreateExtensionInput, opts ...request.Option) (*CreateExtensionOutput, error) {
	req, out := c.CreateExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExtensionAssociation = "CreateExtensionAssociation"

// CreateExtensionAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateExtensionAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExtensionAssociation for more information on using the CreateExtensionAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExtensionAssociationRequest method.
//	req, resp := client.CreateExtensionAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtensionAssociation
func (c *AppConfig) CreateExtensionAssociationRequest(input *CreateExtensionAssociationInput) (req *request.Request, output *CreateExtensionAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateExtensionAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/extensionassociations",
	}

	if input == nil {
		input = &CreateExtensionAssociationInput{}
	}

	output = &CreateExtensionAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExtensionAssociation API operation for Amazon AppConfig.
//
// When you create an extension or configure an Amazon Web Services-authored
// extension, you associate the extension with an AppConfig application, environment,
// or configuration profile. For example, you can choose to run the AppConfig
// deployment events to Amazon SNS Amazon Web Services-authored extension and
// receive notifications on an Amazon SNS topic anytime a configuration deployment
// is started for a specific application. Defining which extension to associate
// with an AppConfig resource is called an extension association. An extension
// association is a specified relationship between an extension and an AppConfig
// resource, such as an application or a configuration profile. For more information
// about extensions and associations, see Working with AppConfig extensions
// (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateExtensionAssociation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - ServiceQuotaExceededException
//     The number of hosted configuration versions exceeds the limit for the AppConfig
//     hosted configuration store. Delete one or more versions and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateExtensionAssociation
func (c *AppConfig) CreateExtensionAssociation(input *CreateExtensionAssociationInput) (*CreateExtensionAssociationOutput, error) {
	req, out := c.CreateExtensionAssociationRequest(input)
	return out, req.Send()
}

// CreateExtensionAssociationWithContext is the same as CreateExtensionAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExtensionAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateExtensionAssociationWithContext(ctx aws.Context, input *CreateExtensionAssociationInput, opts ...request.Option) (*CreateExtensionAssociationOutput, error) {
	req, out := c.CreateExtensionAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHostedConfigurationVersion = "CreateHostedConfigurationVersion"

// CreateHostedConfigurationVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateHostedConfigurationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHostedConfigurationVersion for more information on using the CreateHostedConfigurationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateHostedConfigurationVersionRequest method.
//	req, resp := client.CreateHostedConfigurationVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateHostedConfigurationVersion
func (c *AppConfig) CreateHostedConfigurationVersionRequest(input *CreateHostedConfigurationVersionInput) (req *request.Request, output *CreateHostedConfigurationVersionOutput) {
	op := &request.Operation{
		Name:       opCreateHostedConfigurationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions",
	}

	if input == nil {
		input = &CreateHostedConfigurationVersionInput{}
	}

	output = &CreateHostedConfigurationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHostedConfigurationVersion API operation for Amazon AppConfig.
//
// Creates a new configuration in the AppConfig hosted configuration store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation CreateHostedConfigurationVersion for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ServiceQuotaExceededException
//     The number of hosted configuration versions exceeds the limit for the AppConfig
//     hosted configuration store. Delete one or more versions and try again.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - PayloadTooLargeException
//     The configuration size is too large.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateHostedConfigurationVersion
func (c *AppConfig) CreateHostedConfigurationVersion(input *CreateHostedConfigurationVersionInput) (*CreateHostedConfigurationVersionOutput, error) {
	req, out := c.CreateHostedConfigurationVersionRequest(input)
	return out, req.Send()
}

// CreateHostedConfigurationVersionWithContext is the same as CreateHostedConfigurationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHostedConfigurationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) CreateHostedConfigurationVersionWithContext(ctx aws.Context, input *CreateHostedConfigurationVersionInput, opts ...request.Option) (*CreateHostedConfigurationVersionOutput, error) {
	req, out := c.CreateHostedConfigurationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationRequest method.
//	req, resp := client.DeleteApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteApplication
func (c *AppConfig) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for Amazon AppConfig.
//
// Deletes an application. Deleting an application does not delete a configuration
// from a host.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteApplication
func (c *AppConfig) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationProfile = "DeleteConfigurationProfile"

// DeleteConfigurationProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationProfile for more information on using the DeleteConfigurationProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfigurationProfileRequest method.
//	req, resp := client.DeleteConfigurationProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteConfigurationProfile
func (c *AppConfig) DeleteConfigurationProfileRequest(input *DeleteConfigurationProfileInput) (req *request.Request, output *DeleteConfigurationProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}",
	}

	if input == nil {
		input = &DeleteConfigurationProfileInput{}
	}

	output = &DeleteConfigurationProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationProfile API operation for Amazon AppConfig.
//
// Deletes a configuration profile. Deleting a configuration profile does not
// delete a configuration from a host.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteConfigurationProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteConfigurationProfile
func (c *AppConfig) DeleteConfigurationProfile(input *DeleteConfigurationProfileInput) (*DeleteConfigurationProfileOutput, error) {
	req, out := c.DeleteConfigurationProfileRequest(input)
	return out, req.Send()
}

// DeleteConfigurationProfileWithContext is the same as DeleteConfigurationProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteConfigurationProfileWithContext(ctx aws.Context, input *DeleteConfigurationProfileInput, opts ...request.Option) (*DeleteConfigurationProfileOutput, error) {
	req, out := c.DeleteConfigurationProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeploymentStrategy = "DeleteDeploymentStrategy"

// DeleteDeploymentStrategyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeploymentStrategy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeploymentStrategy for more information on using the DeleteDeploymentStrategy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDeploymentStrategyRequest method.
//	req, resp := client.DeleteDeploymentStrategyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteDeploymentStrategy
func (c *AppConfig) DeleteDeploymentStrategyRequest(input *DeleteDeploymentStrategyInput) (req *request.Request, output *DeleteDeploymentStrategyOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentStrategy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deployementstrategies/{DeploymentStrategyId}",
	}

	if input == nil {
		input = &DeleteDeploymentStrategyInput{}
	}

	output = &DeleteDeploymentStrategyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeploymentStrategy API operation for Amazon AppConfig.
//
// Deletes a deployment strategy. Deleting a deployment strategy does not delete
// a configuration from a host.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteDeploymentStrategy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteDeploymentStrategy
func (c *AppConfig) DeleteDeploymentStrategy(input *DeleteDeploymentStrategyInput) (*DeleteDeploymentStrategyOutput, error) {
	req, out := c.DeleteDeploymentStrategyRequest(input)
	return out, req.Send()
}

// DeleteDeploymentStrategyWithContext is the same as DeleteDeploymentStrategy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeploymentStrategy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteDeploymentStrategyWithContext(ctx aws.Context, input *DeleteDeploymentStrategyInput, opts ...request.Option) (*DeleteDeploymentStrategyOutput, error) {
	req, out := c.DeleteDeploymentStrategyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentRequest method.
//	req, resp := client.DeleteEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteEnvironment
func (c *AppConfig) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironment API operation for Amazon AppConfig.
//
// Deletes an environment. Deleting an environment does not delete a configuration
// from a host.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteEnvironment
func (c *AppConfig) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExtension = "DeleteExtension"

// DeleteExtensionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExtension for more information on using the DeleteExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExtensionRequest method.
//	req, resp := client.DeleteExtensionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtension
func (c *AppConfig) DeleteExtensionRequest(input *DeleteExtensionInput) (req *request.Request, output *DeleteExtensionOutput) {
	op := &request.Operation{
		Name:       opDeleteExtension,
		HTTPMethod: "DELETE",
		HTTPPath:   "/extensions/{ExtensionIdentifier}",
	}

	if input == nil {
		input = &DeleteExtensionInput{}
	}

	output = &DeleteExtensionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteExtension API operation for Amazon AppConfig.
//
// Deletes an AppConfig extension. You must delete all associations to an extension
// before you delete the extension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteExtension for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtension
func (c *AppConfig) DeleteExtension(input *DeleteExtensionInput) (*DeleteExtensionOutput, error) {
	req, out := c.DeleteExtensionRequest(input)
	return out, req.Send()
}

// DeleteExtensionWithContext is the same as DeleteExtension with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteExtensionWithContext(ctx aws.Context, input *DeleteExtensionInput, opts ...request.Option) (*DeleteExtensionOutput, error) {
	req, out := c.DeleteExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExtensionAssociation = "DeleteExtensionAssociation"

// DeleteExtensionAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExtensionAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExtensionAssociation for more information on using the DeleteExtensionAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExtensionAssociationRequest method.
//	req, resp := client.DeleteExtensionAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtensionAssociation
func (c *AppConfig) DeleteExtensionAssociationRequest(input *DeleteExtensionAssociationInput) (req *request.Request, output *DeleteExtensionAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteExtensionAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/extensionassociations/{ExtensionAssociationId}",
	}

	if input == nil {
		input = &DeleteExtensionAssociationInput{}
	}

	output = &DeleteExtensionAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteExtensionAssociation API operation for Amazon AppConfig.
//
// Deletes an extension association. This action doesn't delete extensions defined
// in the association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteExtensionAssociation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteExtensionAssociation
func (c *AppConfig) DeleteExtensionAssociation(input *DeleteExtensionAssociationInput) (*DeleteExtensionAssociationOutput, error) {
	req, out := c.DeleteExtensionAssociationRequest(input)
	return out, req.Send()
}

// DeleteExtensionAssociationWithContext is the same as DeleteExtensionAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExtensionAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteExtensionAssociationWithContext(ctx aws.Context, input *DeleteExtensionAssociationInput, opts ...request.Option) (*DeleteExtensionAssociationOutput, error) {
	req, out := c.DeleteExtensionAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHostedConfigurationVersion = "DeleteHostedConfigurationVersion"

// DeleteHostedConfigurationVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHostedConfigurationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHostedConfigurationVersion for more information on using the DeleteHostedConfigurationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteHostedConfigurationVersionRequest method.
//	req, resp := client.DeleteHostedConfigurationVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteHostedConfigurationVersion
func (c *AppConfig) DeleteHostedConfigurationVersionRequest(input *DeleteHostedConfigurationVersionInput) (req *request.Request, output *DeleteHostedConfigurationVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteHostedConfigurationVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions/{VersionNumber}",
	}

	if input == nil {
		input = &DeleteHostedConfigurationVersionInput{}
	}

	output = &DeleteHostedConfigurationVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHostedConfigurationVersion API operation for Amazon AppConfig.
//
// Deletes a version of a configuration from the AppConfig hosted configuration
// store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation DeleteHostedConfigurationVersion for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteHostedConfigurationVersion
func (c *AppConfig) DeleteHostedConfigurationVersion(input *DeleteHostedConfigurationVersionInput) (*DeleteHostedConfigurationVersionOutput, error) {
	req, out := c.DeleteHostedConfigurationVersionRequest(input)
	return out, req.Send()
}

// DeleteHostedConfigurationVersionWithContext is the same as DeleteHostedConfigurationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHostedConfigurationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) DeleteHostedConfigurationVersionWithContext(ctx aws.Context, input *DeleteHostedConfigurationVersionInput, opts ...request.Option) (*DeleteHostedConfigurationVersionOutput, error) {
	req, out := c.DeleteHostedConfigurationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationRequest method.
//	req, resp := client.GetApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetApplication
func (c *AppConfig) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for Amazon AppConfig.
//
// Retrieves information about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetApplication
func (c *AppConfig) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguration = "GetConfiguration"

// GetConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguration for more information on using the GetConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfigurationRequest method.
//	req, resp := client.GetConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfiguration
//
// Deprecated: This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with StartConfigurationSession.
func (c *AppConfig) GetConfigurationRequest(input *GetConfigurationInput) (req *request.Request, output *GetConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{Application}/environments/{Environment}/configurations/{Configuration}",
	}

	if input == nil {
		input = &GetConfigurationInput{}
	}

	output = &GetConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguration API operation for Amazon AppConfig.
//
// Retrieves the latest deployed configuration.
//
// Note the following important information.
//
//   - This API action has been deprecated. Calls to receive configuration
//     data should use the StartConfigurationSession (https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html)
//     and GetLatestConfiguration (https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html)
//     APIs instead.
//
//   - GetConfiguration is a priced call. For more information, see Pricing
//     (https://aws.amazon.com/systems-manager/pricing/).
//
//   - AppConfig uses the value of the ClientConfigurationVersion parameter
//     to identify the configuration version on your clients. If you don’t
//     send ClientConfigurationVersion with each call to GetConfiguration, your
//     clients receive the current configuration. You are charged each time your
//     clients receive a configuration. To avoid excess charges, we recommend
//     you use the StartConfigurationSession (https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/StartConfigurationSession.html)
//     and GetLatestConfiguration (https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/GetLatestConfiguration.html)
//     APIs, which track the client configuration version on your behalf. If
//     you choose to continue using GetConfiguration, we recommend that you include
//     the ClientConfigurationVersion value with every call to GetConfiguration.
//     The value to use for ClientConfigurationVersion comes from the ConfigurationVersion
//     attribute returned by GetConfiguration when there is new or updated data,
//     and should be saved for subsequent calls to GetConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfiguration
//
// Deprecated: This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with StartConfigurationSession.
func (c *AppConfig) GetConfiguration(input *GetConfigurationInput) (*GetConfigurationOutput, error) {
	req, out := c.GetConfigurationRequest(input)
	return out, req.Send()
}

// GetConfigurationWithContext is the same as GetConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with StartConfigurationSession.
func (c *AppConfig) GetConfigurationWithContext(ctx aws.Context, input *GetConfigurationInput, opts ...request.Option) (*GetConfigurationOutput, error) {
	req, out := c.GetConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfigurationProfile = "GetConfigurationProfile"

// GetConfigurationProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetConfigurationProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfigurationProfile for more information on using the GetConfigurationProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfigurationProfileRequest method.
//	req, resp := client.GetConfigurationProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfigurationProfile
func (c *AppConfig) GetConfigurationProfileRequest(input *GetConfigurationProfileInput) (req *request.Request, output *GetConfigurationProfileOutput) {
	op := &request.Operation{
		Name:       opGetConfigurationProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}",
	}

	if input == nil {
		input = &GetConfigurationProfileInput{}
	}

	output = &GetConfigurationProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfigurationProfile API operation for Amazon AppConfig.
//
// Retrieves information about a configuration profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetConfigurationProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfigurationProfile
func (c *AppConfig) GetConfigurationProfile(input *GetConfigurationProfileInput) (*GetConfigurationProfileOutput, error) {
	req, out := c.GetConfigurationProfileRequest(input)
	return out, req.Send()
}

// GetConfigurationProfileWithContext is the same as GetConfigurationProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfigurationProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetConfigurationProfileWithContext(ctx aws.Context, input *GetConfigurationProfileInput, opts ...request.Option) (*GetConfigurationProfileOutput, error) {
	req, out := c.GetConfigurationProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeploymentRequest method.
//	req, resp := client.GetDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeployment
func (c *AppConfig) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments/{DeploymentNumber}",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for Amazon AppConfig.
//
// Retrieves information about a configuration deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeployment
func (c *AppConfig) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeploymentStrategy = "GetDeploymentStrategy"

// GetDeploymentStrategyRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentStrategy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeploymentStrategy for more information on using the GetDeploymentStrategy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeploymentStrategyRequest method.
//	req, resp := client.GetDeploymentStrategyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeploymentStrategy
func (c *AppConfig) GetDeploymentStrategyRequest(input *GetDeploymentStrategyInput) (req *request.Request, output *GetDeploymentStrategyOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentStrategy,
		HTTPMethod: "GET",
		HTTPPath:   "/deploymentstrategies/{DeploymentStrategyId}",
	}

	if input == nil {
		input = &GetDeploymentStrategyInput{}
	}

	output = &GetDeploymentStrategyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeploymentStrategy API operation for Amazon AppConfig.
//
// Retrieves information about a deployment strategy. A deployment strategy
// defines important criteria for rolling out your configuration to the designated
// targets. A deployment strategy includes the overall duration required, a
// percentage of targets to receive the deployment during each interval, an
// algorithm that defines how percentage grows, and bake time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetDeploymentStrategy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeploymentStrategy
func (c *AppConfig) GetDeploymentStrategy(input *GetDeploymentStrategyInput) (*GetDeploymentStrategyOutput, error) {
	req, out := c.GetDeploymentStrategyRequest(input)
	return out, req.Send()
}

// GetDeploymentStrategyWithContext is the same as GetDeploymentStrategy with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentStrategy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetDeploymentStrategyWithContext(ctx aws.Context, input *GetDeploymentStrategyInput, opts ...request.Option) (*GetDeploymentStrategyOutput, error) {
	req, out := c.GetDeploymentStrategyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentRequest method.
//	req, resp := client.GetEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetEnvironment
func (c *AppConfig) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironment API operation for Amazon AppConfig.
//
// Retrieves information about an environment. An environment is a deployment
// group of AppConfig applications, such as applications in a Production environment
// or in an EU_Region environment. Each configuration deployment targets an
// environment. You can enable one or more Amazon CloudWatch alarms for an environment.
// If an alarm is triggered during a deployment, AppConfig roles back the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetEnvironment
func (c *AppConfig) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExtension = "GetExtension"

// GetExtensionRequest generates a "aws/request.Request" representing the
// client's request for the GetExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExtension for more information on using the GetExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExtensionRequest method.
//	req, resp := client.GetExtensionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtension
func (c *AppConfig) GetExtensionRequest(input *GetExtensionInput) (req *request.Request, output *GetExtensionOutput) {
	op := &request.Operation{
		Name:       opGetExtension,
		HTTPMethod: "GET",
		HTTPPath:   "/extensions/{ExtensionIdentifier}",
	}

	if input == nil {
		input = &GetExtensionInput{}
	}

	output = &GetExtensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExtension API operation for Amazon AppConfig.
//
// Returns information about an AppConfig extension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetExtension for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtension
func (c *AppConfig) GetExtension(input *GetExtensionInput) (*GetExtensionOutput, error) {
	req, out := c.GetExtensionRequest(input)
	return out, req.Send()
}

// GetExtensionWithContext is the same as GetExtension with the addition of
// the ability to pass a context and additional request options.
//
// See GetExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetExtensionWithContext(ctx aws.Context, input *GetExtensionInput, opts ...request.Option) (*GetExtensionOutput, error) {
	req, out := c.GetExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExtensionAssociation = "GetExtensionAssociation"

// GetExtensionAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetExtensionAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExtensionAssociation for more information on using the GetExtensionAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExtensionAssociationRequest method.
//	req, resp := client.GetExtensionAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtensionAssociation
func (c *AppConfig) GetExtensionAssociationRequest(input *GetExtensionAssociationInput) (req *request.Request, output *GetExtensionAssociationOutput) {
	op := &request.Operation{
		Name:       opGetExtensionAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/extensionassociations/{ExtensionAssociationId}",
	}

	if input == nil {
		input = &GetExtensionAssociationInput{}
	}

	output = &GetExtensionAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExtensionAssociation API operation for Amazon AppConfig.
//
// Returns information about an AppConfig extension association. For more information
// about extensions and associations, see Working with AppConfig extensions
// (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetExtensionAssociation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetExtensionAssociation
func (c *AppConfig) GetExtensionAssociation(input *GetExtensionAssociationInput) (*GetExtensionAssociationOutput, error) {
	req, out := c.GetExtensionAssociationRequest(input)
	return out, req.Send()
}

// GetExtensionAssociationWithContext is the same as GetExtensionAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetExtensionAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetExtensionAssociationWithContext(ctx aws.Context, input *GetExtensionAssociationInput, opts ...request.Option) (*GetExtensionAssociationOutput, error) {
	req, out := c.GetExtensionAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHostedConfigurationVersion = "GetHostedConfigurationVersion"

// GetHostedConfigurationVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetHostedConfigurationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHostedConfigurationVersion for more information on using the GetHostedConfigurationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetHostedConfigurationVersionRequest method.
//	req, resp := client.GetHostedConfigurationVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetHostedConfigurationVersion
func (c *AppConfig) GetHostedConfigurationVersionRequest(input *GetHostedConfigurationVersionInput) (req *request.Request, output *GetHostedConfigurationVersionOutput) {
	op := &request.Operation{
		Name:       opGetHostedConfigurationVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions/{VersionNumber}",
	}

	if input == nil {
		input = &GetHostedConfigurationVersionInput{}
	}

	output = &GetHostedConfigurationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHostedConfigurationVersion API operation for Amazon AppConfig.
//
// Retrieves information about a specific configuration version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation GetHostedConfigurationVersion for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetHostedConfigurationVersion
func (c *AppConfig) GetHostedConfigurationVersion(input *GetHostedConfigurationVersionInput) (*GetHostedConfigurationVersionOutput, error) {
	req, out := c.GetHostedConfigurationVersionRequest(input)
	return out, req.Send()
}

// GetHostedConfigurationVersionWithContext is the same as GetHostedConfigurationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetHostedConfigurationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) GetHostedConfigurationVersionWithContext(ctx aws.Context, input *GetHostedConfigurationVersionInput, opts ...request.Option) (*GetHostedConfigurationVersionOutput, error) {
	req, out := c.GetHostedConfigurationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListApplications
func (c *AppConfig) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for Amazon AppConfig.
//
// Lists all applications in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListApplications
func (c *AppConfig) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *appconfig.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurationProfiles = "ListConfigurationProfiles"

// ListConfigurationProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationProfiles for more information on using the ListConfigurationProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfigurationProfilesRequest method.
//	req, resp := client.ListConfigurationProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListConfigurationProfiles
func (c *AppConfig) ListConfigurationProfilesRequest(input *ListConfigurationProfilesInput) (req *request.Request, output *ListConfigurationProfilesOutput) {
	op := &request.Operation{
		Name:       opListConfigurationProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationProfilesInput{}
	}

	output = &ListConfigurationProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationProfiles API operation for Amazon AppConfig.
//
// Lists the configuration profiles for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListConfigurationProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListConfigurationProfiles
func (c *AppConfig) ListConfigurationProfiles(input *ListConfigurationProfilesInput) (*ListConfigurationProfilesOutput, error) {
	req, out := c.ListConfigurationProfilesRequest(input)
	return out, req.Send()
}

// ListConfigurationProfilesWithContext is the same as ListConfigurationProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListConfigurationProfilesWithContext(ctx aws.Context, input *ListConfigurationProfilesInput, opts ...request.Option) (*ListConfigurationProfilesOutput, error) {
	req, out := c.ListConfigurationProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationProfilesPages iterates over the pages of a ListConfigurationProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurationProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfigurationProfiles operation.
//	pageNum := 0
//	err := client.ListConfigurationProfilesPages(params,
//	    func(page *appconfig.ListConfigurationProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListConfigurationProfilesPages(input *ListConfigurationProfilesInput, fn func(*ListConfigurationProfilesOutput, bool) bool) error {
	return c.ListConfigurationProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationProfilesPagesWithContext same as ListConfigurationProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListConfigurationProfilesPagesWithContext(ctx aws.Context, input *ListConfigurationProfilesInput, fn func(*ListConfigurationProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeploymentStrategies = "ListDeploymentStrategies"

// ListDeploymentStrategiesRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentStrategies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeploymentStrategies for more information on using the ListDeploymentStrategies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeploymentStrategiesRequest method.
//	req, resp := client.ListDeploymentStrategiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeploymentStrategies
func (c *AppConfig) ListDeploymentStrategiesRequest(input *ListDeploymentStrategiesInput) (req *request.Request, output *ListDeploymentStrategiesOutput) {
	op := &request.Operation{
		Name:       opListDeploymentStrategies,
		HTTPMethod: "GET",
		HTTPPath:   "/deploymentstrategies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentStrategiesInput{}
	}

	output = &ListDeploymentStrategiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeploymentStrategies API operation for Amazon AppConfig.
//
// Lists deployment strategies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListDeploymentStrategies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeploymentStrategies
func (c *AppConfig) ListDeploymentStrategies(input *ListDeploymentStrategiesInput) (*ListDeploymentStrategiesOutput, error) {
	req, out := c.ListDeploymentStrategiesRequest(input)
	return out, req.Send()
}

// ListDeploymentStrategiesWithContext is the same as ListDeploymentStrategies with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeploymentStrategies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListDeploymentStrategiesWithContext(ctx aws.Context, input *ListDeploymentStrategiesInput, opts ...request.Option) (*ListDeploymentStrategiesOutput, error) {
	req, out := c.ListDeploymentStrategiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentStrategiesPages iterates over the pages of a ListDeploymentStrategies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentStrategies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeploymentStrategies operation.
//	pageNum := 0
//	err := client.ListDeploymentStrategiesPages(params,
//	    func(page *appconfig.ListDeploymentStrategiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListDeploymentStrategiesPages(input *ListDeploymentStrategiesInput, fn func(*ListDeploymentStrategiesOutput, bool) bool) error {
	return c.ListDeploymentStrategiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentStrategiesPagesWithContext same as ListDeploymentStrategiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListDeploymentStrategiesPagesWithContext(ctx aws.Context, input *ListDeploymentStrategiesInput, fn func(*ListDeploymentStrategiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentStrategiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentStrategiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentStrategiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeploymentsRequest method.
//	req, resp := client.ListDeploymentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeployments
func (c *AppConfig) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for Amazon AppConfig.
//
// Lists the deployments for an environment in descending deployment number
// order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListDeployments for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListDeployments
func (c *AppConfig) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeployments operation.
//	pageNum := 0
//	err := client.ListDeploymentsPages(params,
//	    func(page *appconfig.ListDeploymentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListDeploymentsPages(input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool) error {
	return c.ListDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentsPagesWithContext same as ListDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListDeploymentsPagesWithContext(ctx aws.Context, input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentsRequest method.
//	req, resp := client.ListEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListEnvironments
func (c *AppConfig) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for Amazon AppConfig.
//
// Lists the environments for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListEnvironments
func (c *AppConfig) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironments operation.
//	pageNum := 0
//	err := client.ListEnvironmentsPages(params,
//	    func(page *appconfig.ListEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExtensionAssociations = "ListExtensionAssociations"

// ListExtensionAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListExtensionAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExtensionAssociations for more information on using the ListExtensionAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExtensionAssociationsRequest method.
//	req, resp := client.ListExtensionAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensionAssociations
func (c *AppConfig) ListExtensionAssociationsRequest(input *ListExtensionAssociationsInput) (req *request.Request, output *ListExtensionAssociationsOutput) {
	op := &request.Operation{
		Name:       opListExtensionAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/extensionassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExtensionAssociationsInput{}
	}

	output = &ListExtensionAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExtensionAssociations API operation for Amazon AppConfig.
//
// Lists all AppConfig extension associations in the account. For more information
// about extensions and associations, see Working with AppConfig extensions
// (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListExtensionAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensionAssociations
func (c *AppConfig) ListExtensionAssociations(input *ListExtensionAssociationsInput) (*ListExtensionAssociationsOutput, error) {
	req, out := c.ListExtensionAssociationsRequest(input)
	return out, req.Send()
}

// ListExtensionAssociationsWithContext is the same as ListExtensionAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListExtensionAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListExtensionAssociationsWithContext(ctx aws.Context, input *ListExtensionAssociationsInput, opts ...request.Option) (*ListExtensionAssociationsOutput, error) {
	req, out := c.ListExtensionAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExtensionAssociationsPages iterates over the pages of a ListExtensionAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExtensionAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExtensionAssociations operation.
//	pageNum := 0
//	err := client.ListExtensionAssociationsPages(params,
//	    func(page *appconfig.ListExtensionAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListExtensionAssociationsPages(input *ListExtensionAssociationsInput, fn func(*ListExtensionAssociationsOutput, bool) bool) error {
	return c.ListExtensionAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExtensionAssociationsPagesWithContext same as ListExtensionAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListExtensionAssociationsPagesWithContext(ctx aws.Context, input *ListExtensionAssociationsInput, fn func(*ListExtensionAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExtensionAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExtensionAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExtensionAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExtensions = "ListExtensions"

// ListExtensionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExtensions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExtensions for more information on using the ListExtensions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExtensionsRequest method.
//	req, resp := client.ListExtensionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensions
func (c *AppConfig) ListExtensionsRequest(input *ListExtensionsInput) (req *request.Request, output *ListExtensionsOutput) {
	op := &request.Operation{
		Name:       opListExtensions,
		HTTPMethod: "GET",
		HTTPPath:   "/extensions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExtensionsInput{}
	}

	output = &ListExtensionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExtensions API operation for Amazon AppConfig.
//
// Lists all custom and Amazon Web Services-authored AppConfig extensions in
// the account. For more information about extensions, see Working with AppConfig
// extensions (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListExtensions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListExtensions
func (c *AppConfig) ListExtensions(input *ListExtensionsInput) (*ListExtensionsOutput, error) {
	req, out := c.ListExtensionsRequest(input)
	return out, req.Send()
}

// ListExtensionsWithContext is the same as ListExtensions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExtensions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListExtensionsWithContext(ctx aws.Context, input *ListExtensionsInput, opts ...request.Option) (*ListExtensionsOutput, error) {
	req, out := c.ListExtensionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExtensionsPages iterates over the pages of a ListExtensions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExtensions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExtensions operation.
//	pageNum := 0
//	err := client.ListExtensionsPages(params,
//	    func(page *appconfig.ListExtensionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListExtensionsPages(input *ListExtensionsInput, fn func(*ListExtensionsOutput, bool) bool) error {
	return c.ListExtensionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExtensionsPagesWithContext same as ListExtensionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListExtensionsPagesWithContext(ctx aws.Context, input *ListExtensionsInput, fn func(*ListExtensionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExtensionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExtensionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExtensionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHostedConfigurationVersions = "ListHostedConfigurationVersions"

// ListHostedConfigurationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListHostedConfigurationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHostedConfigurationVersions for more information on using the ListHostedConfigurationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListHostedConfigurationVersionsRequest method.
//	req, resp := client.ListHostedConfigurationVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListHostedConfigurationVersions
func (c *AppConfig) ListHostedConfigurationVersionsRequest(input *ListHostedConfigurationVersionsInput) (req *request.Request, output *ListHostedConfigurationVersionsOutput) {
	op := &request.Operation{
		Name:       opListHostedConfigurationVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHostedConfigurationVersionsInput{}
	}

	output = &ListHostedConfigurationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHostedConfigurationVersions API operation for Amazon AppConfig.
//
// Lists configurations stored in the AppConfig hosted configuration store by
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListHostedConfigurationVersions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListHostedConfigurationVersions
func (c *AppConfig) ListHostedConfigurationVersions(input *ListHostedConfigurationVersionsInput) (*ListHostedConfigurationVersionsOutput, error) {
	req, out := c.ListHostedConfigurationVersionsRequest(input)
	return out, req.Send()
}

// ListHostedConfigurationVersionsWithContext is the same as ListHostedConfigurationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListHostedConfigurationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListHostedConfigurationVersionsWithContext(ctx aws.Context, input *ListHostedConfigurationVersionsInput, opts ...request.Option) (*ListHostedConfigurationVersionsOutput, error) {
	req, out := c.ListHostedConfigurationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHostedConfigurationVersionsPages iterates over the pages of a ListHostedConfigurationVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHostedConfigurationVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListHostedConfigurationVersions operation.
//	pageNum := 0
//	err := client.ListHostedConfigurationVersionsPages(params,
//	    func(page *appconfig.ListHostedConfigurationVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppConfig) ListHostedConfigurationVersionsPages(input *ListHostedConfigurationVersionsInput, fn func(*ListHostedConfigurationVersionsOutput, bool) bool) error {
	return c.ListHostedConfigurationVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHostedConfigurationVersionsPagesWithContext same as ListHostedConfigurationVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListHostedConfigurationVersionsPagesWithContext(ctx aws.Context, input *ListHostedConfigurationVersionsInput, fn func(*ListHostedConfigurationVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHostedConfigurationVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHostedConfigurationVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHostedConfigurationVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListTagsForResource
func (c *AppConfig) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon AppConfig.
//
// Retrieves the list of key-value tags assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ListTagsForResource
func (c *AppConfig) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDeployment = "StartDeployment"

// StartDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StartDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDeployment for more information on using the StartDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDeploymentRequest method.
//	req, resp := client.StartDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StartDeployment
func (c *AppConfig) StartDeploymentRequest(input *StartDeploymentInput) (req *request.Request, output *StartDeploymentOutput) {
	op := &request.Operation{
		Name:       opStartDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments",
	}

	if input == nil {
		input = &StartDeploymentInput{}
	}

	output = &StartDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDeployment API operation for Amazon AppConfig.
//
// Starts a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation StartDeployment for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StartDeployment
func (c *AppConfig) StartDeployment(input *StartDeploymentInput) (*StartDeploymentOutput, error) {
	req, out := c.StartDeploymentRequest(input)
	return out, req.Send()
}

// StartDeploymentWithContext is the same as StartDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StartDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) StartDeploymentWithContext(ctx aws.Context, input *StartDeploymentInput, opts ...request.Option) (*StartDeploymentOutput, error) {
	req, out := c.StartDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDeployment = "StopDeployment"

// StopDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StopDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDeployment for more information on using the StopDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopDeploymentRequest method.
//	req, resp := client.StopDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StopDeployment
func (c *AppConfig) StopDeploymentRequest(input *StopDeploymentInput) (req *request.Request, output *StopDeploymentOutput) {
	op := &request.Operation{
		Name:       opStopDeployment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments/{DeploymentNumber}",
	}

	if input == nil {
		input = &StopDeploymentInput{}
	}

	output = &StopDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDeployment API operation for Amazon AppConfig.
//
// Stops a deployment. This API action works only on deployments that have a
// status of DEPLOYING. This action moves the deployment to a status of ROLLED_BACK.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation StopDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StopDeployment
func (c *AppConfig) StopDeployment(input *StopDeploymentInput) (*StopDeploymentOutput, error) {
	req, out := c.StopDeploymentRequest(input)
	return out, req.Send()
}

// StopDeploymentWithContext is the same as StopDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StopDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) StopDeploymentWithContext(ctx aws.Context, input *StopDeploymentInput, opts ...request.Option) (*StopDeploymentOutput, error) {
	req, out := c.StopDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/TagResource
func (c *AppConfig) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon AppConfig.
//
// Assigns metadata to an AppConfig resource. Tags help organize and categorize
// your AppConfig resources. Each tag consists of a key and an optional value,
// both of which you define. You can specify a maximum of 50 tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/TagResource
func (c *AppConfig) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UntagResource
func (c *AppConfig) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon AppConfig.
//
// Deletes a tag key and value from an AppConfig resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UntagResource
func (c *AppConfig) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationRequest method.
//	req, resp := client.UpdateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateApplication
func (c *AppConfig) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{ApplicationId}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for Amazon AppConfig.
//
// Updates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateApplication
func (c *AppConfig) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationProfile = "UpdateConfigurationProfile"

// UpdateConfigurationProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationProfile for more information on using the UpdateConfigurationProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationProfileRequest method.
//	req, resp := client.UpdateConfigurationProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateConfigurationProfile
func (c *AppConfig) UpdateConfigurationProfileRequest(input *UpdateConfigurationProfileInput) (req *request.Request, output *UpdateConfigurationProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}",
	}

	if input == nil {
		input = &UpdateConfigurationProfileInput{}
	}

	output = &UpdateConfigurationProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfigurationProfile API operation for Amazon AppConfig.
//
// Updates a configuration profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UpdateConfigurationProfile for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateConfigurationProfile
func (c *AppConfig) UpdateConfigurationProfile(input *UpdateConfigurationProfileInput) (*UpdateConfigurationProfileOutput, error) {
	req, out := c.UpdateConfigurationProfileRequest(input)
	return out, req.Send()
}

// UpdateConfigurationProfileWithContext is the same as UpdateConfigurationProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UpdateConfigurationProfileWithContext(ctx aws.Context, input *UpdateConfigurationProfileInput, opts ...request.Option) (*UpdateConfigurationProfileOutput, error) {
	req, out := c.UpdateConfigurationProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeploymentStrategy = "UpdateDeploymentStrategy"

// UpdateDeploymentStrategyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeploymentStrategy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeploymentStrategy for more information on using the UpdateDeploymentStrategy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDeploymentStrategyRequest method.
//	req, resp := client.UpdateDeploymentStrategyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateDeploymentStrategy
func (c *AppConfig) UpdateDeploymentStrategyRequest(input *UpdateDeploymentStrategyInput) (req *request.Request, output *UpdateDeploymentStrategyOutput) {
	op := &request.Operation{
		Name:       opUpdateDeploymentStrategy,
		HTTPMethod: "PATCH",
		HTTPPath:   "/deploymentstrategies/{DeploymentStrategyId}",
	}

	if input == nil {
		input = &UpdateDeploymentStrategyInput{}
	}

	output = &UpdateDeploymentStrategyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeploymentStrategy API operation for Amazon AppConfig.
//
// Updates a deployment strategy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UpdateDeploymentStrategy for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateDeploymentStrategy
func (c *AppConfig) UpdateDeploymentStrategy(input *UpdateDeploymentStrategyInput) (*UpdateDeploymentStrategyOutput, error) {
	req, out := c.UpdateDeploymentStrategyRequest(input)
	return out, req.Send()
}

// UpdateDeploymentStrategyWithContext is the same as UpdateDeploymentStrategy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeploymentStrategy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UpdateDeploymentStrategyWithContext(ctx aws.Context, input *UpdateDeploymentStrategyInput, opts ...request.Option) (*UpdateDeploymentStrategyOutput, error) {
	req, out := c.UpdateDeploymentStrategyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentRequest method.
//	req, resp := client.UpdateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateEnvironment
func (c *AppConfig) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for Amazon AppConfig.
//
// Updates an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateEnvironment
func (c *AppConfig) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExtension = "UpdateExtension"

// UpdateExtensionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExtension for more information on using the UpdateExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExtensionRequest method.
//	req, resp := client.UpdateExtensionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtension
func (c *AppConfig) UpdateExtensionRequest(input *UpdateExtensionInput) (req *request.Request, output *UpdateExtensionOutput) {
	op := &request.Operation{
		Name:       opUpdateExtension,
		HTTPMethod: "PATCH",
		HTTPPath:   "/extensions/{ExtensionIdentifier}",
	}

	if input == nil {
		input = &UpdateExtensionInput{}
	}

	output = &UpdateExtensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExtension API operation for Amazon AppConfig.
//
// Updates an AppConfig extension. For more information about extensions, see
// Working with AppConfig extensions (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UpdateExtension for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtension
func (c *AppConfig) UpdateExtension(input *UpdateExtensionInput) (*UpdateExtensionOutput, error) {
	req, out := c.UpdateExtensionRequest(input)
	return out, req.Send()
}

// UpdateExtensionWithContext is the same as UpdateExtension with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UpdateExtensionWithContext(ctx aws.Context, input *UpdateExtensionInput, opts ...request.Option) (*UpdateExtensionOutput, error) {
	req, out := c.UpdateExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExtensionAssociation = "UpdateExtensionAssociation"

// UpdateExtensionAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExtensionAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExtensionAssociation for more information on using the UpdateExtensionAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExtensionAssociationRequest method.
//	req, resp := client.UpdateExtensionAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtensionAssociation
func (c *AppConfig) UpdateExtensionAssociationRequest(input *UpdateExtensionAssociationInput) (req *request.Request, output *UpdateExtensionAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateExtensionAssociation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/extensionassociations/{ExtensionAssociationId}",
	}

	if input == nil {
		input = &UpdateExtensionAssociationInput{}
	}

	output = &UpdateExtensionAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExtensionAssociation API operation for Amazon AppConfig.
//
// Updates an association. For more information about extensions and associations,
// see Working with AppConfig extensions (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation UpdateExtensionAssociation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/UpdateExtensionAssociation
func (c *AppConfig) UpdateExtensionAssociation(input *UpdateExtensionAssociationInput) (*UpdateExtensionAssociationOutput, error) {
	req, out := c.UpdateExtensionAssociationRequest(input)
	return out, req.Send()
}

// UpdateExtensionAssociationWithContext is the same as UpdateExtensionAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExtensionAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) UpdateExtensionAssociationWithContext(ctx aws.Context, input *UpdateExtensionAssociationInput, opts ...request.Option) (*UpdateExtensionAssociationOutput, error) {
	req, out := c.UpdateExtensionAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateConfiguration = "ValidateConfiguration"

// ValidateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ValidateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateConfiguration for more information on using the ValidateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateConfigurationRequest method.
//	req, resp := client.ValidateConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ValidateConfiguration
func (c *AppConfig) ValidateConfigurationRequest(input *ValidateConfigurationInput) (req *request.Request, output *ValidateConfigurationOutput) {
	op := &request.Operation{
		Name:       opValidateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/validators",
	}

	if input == nil {
		input = &ValidateConfigurationInput{}
	}

	output = &ValidateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ValidateConfiguration API operation for Amazon AppConfig.
//
// Uses the validators in a configuration profile to validate a configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppConfig's
// API operation ValidateConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - InternalServerException
//     There was an internal failure in the AppConfig service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ValidateConfiguration
func (c *AppConfig) ValidateConfiguration(input *ValidateConfigurationInput) (*ValidateConfigurationOutput, error) {
	req, out := c.ValidateConfigurationRequest(input)
	return out, req.Send()
}

// ValidateConfigurationWithContext is the same as ValidateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppConfig) ValidateConfigurationWithContext(ctx aws.Context, input *ValidateConfigurationInput, opts ...request.Option) (*ValidateConfigurationOutput, error) {
	req, out := c.ValidateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An action defines the tasks the extension performs during the AppConfig workflow.
// Each action includes an action point such as ON_CREATE_HOSTED_CONFIGURATION,
// PRE_DEPLOYMENT, or ON_DEPLOYMENT. Each action also includes a name, a URI
// to an Lambda function, and an Amazon Resource Name (ARN) for an Identity
// and Access Management assume role. You specify the name, URI, and ARN for
// each action point defined in the extension. You can specify the following
// actions for an extension:
//
//   - PRE_CREATE_HOSTED_CONFIGURATION_VERSION
//
//   - PRE_START_DEPLOYMENT
//
//   - ON_DEPLOYMENT_START
//
//   - ON_DEPLOYMENT_STEP
//
//   - ON_DEPLOYMENT_BAKING
//
//   - ON_DEPLOYMENT_COMPLETE
//
//   - ON_DEPLOYMENT_ROLLED_BACK
type Action struct {
	_ struct{} `type:"structure"`

	// Information about the action.
	Description *string `type:"string"`

	// The action name.
	Name *string `min:"1" type:"string"`

	// An Amazon Resource Name (ARN) for an Identity and Access Management assume
	// role.
	RoleArn *string `min:"20" type:"string"`

	// The extension URI associated to the action point in the extension definition.
	// The URI can be an Amazon Resource Name (ARN) for one of the following: an
	// Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification
	// Service topic, or the Amazon EventBridge default event bus.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Action) SetDescription(v string) *Action {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Action) SetName(v string) *Action {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Action) SetRoleArn(v string) *Action {
	s.RoleArn = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *Action) SetUri(v string) *Action {
	s.Uri = &v
	return s
}

// An extension that was invoked as part of a deployment event.
type ActionInvocation struct {
	_ struct{} `type:"structure"`

	// The name of the action.
	ActionName *string `min:"1" type:"string"`

	// The error code when an extension invocation fails.
	ErrorCode *string `type:"string"`

	// The error message when an extension invocation fails.
	ErrorMessage *string `type:"string"`

	// The name, the ID, or the Amazon Resource Name (ARN) of the extension.
	ExtensionIdentifier *string `min:"1" type:"string"`

	// A system-generated ID for this invocation.
	InvocationId *string `type:"string"`

	// An Amazon Resource Name (ARN) for an Identity and Access Management assume
	// role.
	RoleArn *string `min:"20" type:"string"`

	// The extension URI associated to the action point in the extension definition.
	// The URI can be an Amazon Resource Name (ARN) for one of the following: an
	// Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification
	// Service topic, or the Amazon EventBridge default event bus.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionInvocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionInvocation) GoString() string {
	return s.String()
}

// SetActionName sets the ActionName field's value.
func (s *ActionInvocation) SetActionName(v string) *ActionInvocation {
	s.ActionName = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ActionInvocation) SetErrorCode(v string) *ActionInvocation {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ActionInvocation) SetErrorMessage(v string) *ActionInvocation {
	s.ErrorMessage = &v
	return s
}

// SetExtensionIdentifier sets the ExtensionIdentifier field's value.
func (s *ActionInvocation) SetExtensionIdentifier(v string) *ActionInvocation {
	s.ExtensionIdentifier = &v
	return s
}

// SetInvocationId sets the InvocationId field's value.
func (s *ActionInvocation) SetInvocationId(v string) *ActionInvocation {
	s.InvocationId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ActionInvocation) SetRoleArn(v string) *ActionInvocation {
	s.RoleArn = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ActionInvocation) SetUri(v string) *ActionInvocation {
	s.Uri = &v
	return s
}

type Application struct {
	_ struct{} `type:"structure"`

	// The description of the application.
	Description *string `type:"string"`

	// The application ID.
	Id *string `type:"string"`

	// The application name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Application) SetDescription(v string) *Application {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Application) SetId(v string) *Application {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// An extension that was invoked during a deployment.
type AppliedExtension struct {
	_ struct{} `type:"structure"`

	// The system-generated ID for the association.
	ExtensionAssociationId *string `type:"string"`

	// The system-generated ID of the extension.
	ExtensionId *string `type:"string"`

	// One or more parameters for the actions called by the extension.
	Parameters map[string]*string `type:"map"`

	// The extension version number.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedExtension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedExtension) GoString() string {
	return s.String()
}

// SetExtensionAssociationId sets the ExtensionAssociationId field's value.
func (s *AppliedExtension) SetExtensionAssociationId(v string) *AppliedExtension {
	s.ExtensionAssociationId = &v
	return s
}

// SetExtensionId sets the ExtensionId field's value.
func (s *AppliedExtension) SetExtensionId(v string) *AppliedExtension {
	s.ExtensionId = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AppliedExtension) SetParameters(v map[string]*string) *AppliedExtension {
	s.Parameters = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *AppliedExtension) SetVersionNumber(v int64) *AppliedExtension {
	s.VersionNumber = &v
	return s
}

// Detailed information about the input that failed to satisfy the constraints
// specified by a call.
type BadRequestDetails struct {
	_ struct{} `type:"structure"`

	// Detailed information about the bad request exception error when creating
	// a hosted configuration version.
	InvalidConfiguration []*InvalidConfigurationDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestDetails) GoString() string {
	return s.String()
}

// SetInvalidConfiguration sets the InvalidConfiguration field's value.
func (s *BadRequestDetails) SetInvalidConfiguration(v []*InvalidConfigurationDetail) *BadRequestDetails {
	s.InvalidConfiguration = v
	return s
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Detailed information about the input that failed to satisfy the constraints
	// specified by a call.
	Details *BadRequestDetails `type:"structure"`

	Message_ *string `locationName:"Message" type:"string"`

	Reason *string `type:"string" enum:"BadRequestReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary of a configuration profile.
type ConfigurationProfileSummary struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The ID of the configuration profile.
	Id *string `type:"string"`

	// The URI location of the configuration.
	LocationUri *string `min:"1" type:"string"`

	// The name of the configuration profile.
	Name *string `min:"1" type:"string"`

	// The type of configurations contained in the profile. AppConfig supports feature
	// flags and freeform configurations. We recommend you create feature flag configurations
	// to enable or disable new features and freeform configurations to distribute
	// configurations to an application. When calling this API, enter one of the
	// following values for Type:
	//
	// AWS.AppConfig.FeatureFlags
	//
	// AWS.Freeform
	Type *string `type:"string"`

	// The types of validators in the configuration profile.
	ValidatorTypes []*string `type:"list" enum:"ValidatorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationProfileSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ConfigurationProfileSummary) SetApplicationId(v string) *ConfigurationProfileSummary {
	s.ApplicationId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConfigurationProfileSummary) SetId(v string) *ConfigurationProfileSummary {
	s.Id = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *ConfigurationProfileSummary) SetLocationUri(v string) *ConfigurationProfileSummary {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigurationProfileSummary) SetName(v string) *ConfigurationProfileSummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConfigurationProfileSummary) SetType(v string) *ConfigurationProfileSummary {
	s.Type = &v
	return s
}

// SetValidatorTypes sets the ValidatorTypes field's value.
func (s *ConfigurationProfileSummary) SetValidatorTypes(v []*string) *ConfigurationProfileSummary {
	s.ValidatorTypes = v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// A description of the application.
	Description *string `type:"string"`

	// A name for the application.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Metadata to assign to the application. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the application.
	Description *string `type:"string"`

	// The application ID.
	Id *string `type:"string"`

	// The application name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationOutput) SetDescription(v string) *CreateApplicationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateApplicationOutput) SetId(v string) *CreateApplicationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationOutput) SetName(v string) *CreateApplicationOutput {
	s.Name = &v
	return s
}

type CreateConfigurationProfileInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// A description of the configuration profile.
	Description *string `type:"string"`

	// A URI to locate the configuration. You can specify the AppConfig hosted configuration
	// store, Systems Manager (SSM) document, an SSM Parameter Store parameter,
	// or an Amazon S3 object. For the hosted configuration store and for feature
	// flags, specify hosted. For an SSM document, specify either the document name
	// in the format ssm-document://<Document_name> or the Amazon Resource Name
	// (ARN). For a parameter, specify either the parameter name in the format ssm-parameter://<Parameter_name>
	// or the ARN. For an Amazon S3 object, specify the URI in the following format:
	// s3://<bucket>/<objectKey> . Here is an example: s3://my-bucket/my-app/us-east-1/my-config.json
	//
	// LocationUri is a required field
	LocationUri *string `min:"1" type:"string" required:"true"`

	// A name for the configuration profile.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	//
	// A retrieval role ARN is not required for configurations stored in the AppConfig
	// hosted configuration store. It is required for all other sources that store
	// your configuration.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// Metadata to assign to the configuration profile. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`

	// The type of configurations contained in the profile. AppConfig supports feature
	// flags and freeform configurations. We recommend you create feature flag configurations
	// to enable or disable new features and freeform configurations to distribute
	// configurations to an application. When calling this API, enter one of the
	// following values for Type:
	//
	// AWS.AppConfig.FeatureFlags
	//
	// AWS.Freeform
	Type *string `type:"string"`

	// A list of methods for validating the configuration.
	Validators []*Validator `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationProfileInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.LocationUri == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationUri"))
	}
	if s.LocationUri != nil && len(*s.LocationUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationUri", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RetrievalRoleArn != nil && len(*s.RetrievalRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RetrievalRoleArn", 20))
	}
	if s.Validators != nil {
		for i, v := range s.Validators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Validators", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateConfigurationProfileInput) SetApplicationId(v string) *CreateConfigurationProfileInput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfigurationProfileInput) SetDescription(v string) *CreateConfigurationProfileInput {
	s.Description = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *CreateConfigurationProfileInput) SetLocationUri(v string) *CreateConfigurationProfileInput {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationProfileInput) SetName(v string) *CreateConfigurationProfileInput {
	s.Name = &v
	return s
}

// SetRetrievalRoleArn sets the RetrievalRoleArn field's value.
func (s *CreateConfigurationProfileInput) SetRetrievalRoleArn(v string) *CreateConfigurationProfileInput {
	s.RetrievalRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationProfileInput) SetTags(v map[string]*string) *CreateConfigurationProfileInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateConfigurationProfileInput) SetType(v string) *CreateConfigurationProfileInput {
	s.Type = &v
	return s
}

// SetValidators sets the Validators field's value.
func (s *CreateConfigurationProfileInput) SetValidators(v []*Validator) *CreateConfigurationProfileInput {
	s.Validators = v
	return s
}

type CreateConfigurationProfileOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The configuration profile description.
	Description *string `type:"string"`

	// The configuration profile ID.
	Id *string `type:"string"`

	// The URI location of the configuration.
	LocationUri *string `min:"1" type:"string"`

	// The name of the configuration profile.
	Name *string `min:"1" type:"string"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// The type of configurations contained in the profile. AppConfig supports feature
	// flags and freeform configurations. We recommend you create feature flag configurations
	// to enable or disable new features and freeform configurations to distribute
	// configurations to an application. When calling this API, enter one of the
	// following values for Type:
	//
	// AWS.AppConfig.FeatureFlags
	//
	// AWS.Freeform
	Type *string `type:"string"`

	// A list of methods for validating the configuration.
	Validators []*Validator `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationProfileOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateConfigurationProfileOutput) SetApplicationId(v string) *CreateConfigurationProfileOutput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfigurationProfileOutput) SetDescription(v string) *CreateConfigurationProfileOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateConfigurationProfileOutput) SetId(v string) *CreateConfigurationProfileOutput {
	s.Id = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *CreateConfigurationProfileOutput) SetLocationUri(v string) *CreateConfigurationProfileOutput {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationProfileOutput) SetName(v string) *CreateConfigurationProfileOutput {
	s.Name = &v
	return s
}

// SetRetrievalRoleArn sets the RetrievalRoleArn field's value.
func (s *CreateConfigurationProfileOutput) SetRetrievalRoleArn(v string) *CreateConfigurationProfileOutput {
	s.RetrievalRoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateConfigurationProfileOutput) SetType(v string) *CreateConfigurationProfileOutput {
	s.Type = &v
	return s
}

// SetValidators sets the Validators field's value.
func (s *CreateConfigurationProfileOutput) SetValidators(v []*Validator) *CreateConfigurationProfileOutput {
	s.Validators = v
	return s
}

type CreateDeploymentStrategyInput struct {
	_ struct{} `type:"structure"`

	// Total amount of time for a deployment to last.
	//
	// DeploymentDurationInMinutes is a required field
	DeploymentDurationInMinutes *int64 `type:"integer" required:"true"`

	// A description of the deployment strategy.
	Description *string `type:"string"`

	// Specifies the amount of time AppConfig monitors for Amazon CloudWatch alarms
	// after the configuration has been deployed to 100% of its targets, before
	// considering the deployment to be complete. If an alarm is triggered during
	// this time, AppConfig rolls back the deployment. You must configure permissions
	// for AppConfig to roll back based on CloudWatch alarms. For more information,
	// see Configuring permissions for rollback based on Amazon CloudWatch alarms
	// (https://docs.aws.amazon.com/appconfig/latest/userguide/getting-started-with-appconfig-cloudwatch-alarms-permissions.html)
	// in the AppConfig User Guide.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	//
	// GrowthFactor is a required field
	GrowthFactor *float64 `min:"1" type:"float" required:"true"`

	// The algorithm used to define how percentage grows over time. AppConfig supports
	// the following growth types:
	//
	// Linear: For this type, AppConfig processes the deployment by dividing the
	// total number of targets by the value specified for Step percentage. For example,
	// a linear deployment that uses a Step percentage of 10 deploys the configuration
	// to 10 percent of the hosts. After those deployments are complete, the system
	// deploys the configuration to the next 10 percent. This continues until 100%
	// of the targets have successfully received the configuration.
	//
	// Exponential: For this type, AppConfig processes the deployment exponentially
	// using the following formula: G*(2^N). In this formula, G is the growth factor
	// specified by the user and N is the number of steps until the configuration
	// is deployed to all targets. For example, if you specify a growth factor of
	// 2, then the system rolls out the configuration as follows:
	//
	// 2*(2^0)
	//
	// 2*(2^1)
	//
	// 2*(2^2)
	//
	// Expressed numerically, the deployment rolls out as follows: 2% of the targets,
	// 4% of the targets, 8% of the targets, and continues until the configuration
	// has been deployed to all targets.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// A name for the deployment strategy.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo *string `type:"string" enum:"ReplicateTo"`

	// Metadata to assign to the deployment strategy. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentStrategyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentStrategyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentStrategyInput"}
	if s.DeploymentDurationInMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentDurationInMinutes"))
	}
	if s.GrowthFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("GrowthFactor"))
	}
	if s.GrowthFactor != nil && *s.GrowthFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("GrowthFactor", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *CreateDeploymentStrategyInput) SetDeploymentDurationInMinutes(v int64) *CreateDeploymentStrategyInput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentStrategyInput) SetDescription(v string) *CreateDeploymentStrategyInput {
	s.Description = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *CreateDeploymentStrategyInput) SetFinalBakeTimeInMinutes(v int64) *CreateDeploymentStrategyInput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *CreateDeploymentStrategyInput) SetGrowthFactor(v float64) *CreateDeploymentStrategyInput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *CreateDeploymentStrategyInput) SetGrowthType(v string) *CreateDeploymentStrategyInput {
	s.GrowthType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeploymentStrategyInput) SetName(v string) *CreateDeploymentStrategyInput {
	s.Name = &v
	return s
}

// SetReplicateTo sets the ReplicateTo field's value.
func (s *CreateDeploymentStrategyInput) SetReplicateTo(v string) *CreateDeploymentStrategyInput {
	s.ReplicateTo = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeploymentStrategyInput) SetTags(v map[string]*string) *CreateDeploymentStrategyInput {
	s.Tags = v
	return s
}

type CreateDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The deployment strategy ID.
	Id *string `type:"string"`

	// The name of the deployment strategy.
	Name *string `min:"1" type:"string"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo *string `type:"string" enum:"ReplicateTo"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentStrategyOutput) GoString() string {
	return s.String()
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *CreateDeploymentStrategyOutput) SetDeploymentDurationInMinutes(v int64) *CreateDeploymentStrategyOutput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentStrategyOutput) SetDescription(v string) *CreateDeploymentStrategyOutput {
	s.Description = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *CreateDeploymentStrategyOutput) SetFinalBakeTimeInMinutes(v int64) *CreateDeploymentStrategyOutput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *CreateDeploymentStrategyOutput) SetGrowthFactor(v float64) *CreateDeploymentStrategyOutput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *CreateDeploymentStrategyOutput) SetGrowthType(v string) *CreateDeploymentStrategyOutput {
	s.GrowthType = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDeploymentStrategyOutput) SetId(v string) *CreateDeploymentStrategyOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeploymentStrategyOutput) SetName(v string) *CreateDeploymentStrategyOutput {
	s.Name = &v
	return s
}

// SetReplicateTo sets the ReplicateTo field's value.
func (s *CreateDeploymentStrategyOutput) SetReplicateTo(v string) *CreateDeploymentStrategyOutput {
	s.ReplicateTo = &v
	return s
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// A description of the environment.
	Description *string `type:"string"`

	// Amazon CloudWatch alarms to monitor during the deployment process.
	Monitors []*Monitor `type:"list"`

	// A name for the environment.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Metadata to assign to the environment. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Monitors != nil {
		for i, v := range s.Monitors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Monitors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateEnvironmentInput) SetApplicationId(v string) *CreateEnvironmentInput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetMonitors sets the Monitors field's value.
func (s *CreateEnvironmentInput) SetMonitors(v []*Monitor) *CreateEnvironmentInput {
	s.Monitors = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v map[string]*string) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The description of the environment.
	Description *string `type:"string"`

	// The environment ID.
	Id *string `type:"string"`

	// Amazon CloudWatch alarms monitored during the deployment.
	Monitors []*Monitor `type:"list"`

	// The name of the environment.
	Name *string `min:"1" type:"string"`

	// The state of the environment. An environment can be in one of the following
	// states: READY_FOR_DEPLOYMENT, DEPLOYING, ROLLING_BACK, or ROLLED_BACK
	State *string `type:"string" enum:"EnvironmentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateEnvironmentOutput) SetApplicationId(v string) *CreateEnvironmentOutput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentOutput) SetDescription(v string) *CreateEnvironmentOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEnvironmentOutput) SetId(v string) *CreateEnvironmentOutput {
	s.Id = &v
	return s
}

// SetMonitors sets the Monitors field's value.
func (s *CreateEnvironmentOutput) SetMonitors(v []*Monitor) *CreateEnvironmentOutput {
	s.Monitors = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentOutput) SetName(v string) *CreateEnvironmentOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateEnvironmentOutput) SetState(v string) *CreateEnvironmentOutput {
	s.State = &v
	return s
}

type CreateExtensionAssociationInput struct {
	_ struct{} `type:"structure"`

	// The name, the ID, or the Amazon Resource Name (ARN) of the extension.
	//
	// ExtensionIdentifier is a required field
	ExtensionIdentifier *string `min:"1" type:"string" required:"true"`

	// The version number of the extension. If not specified, AppConfig uses the
	// maximum version of the extension.
	ExtensionVersionNumber *int64 `type:"integer"`

	// The parameter names and values defined in the extensions. Extension parameters
	// marked Required must be entered for this field.
	Parameters map[string]*string `type:"map"`

	// The ARN of an application, configuration profile, or environment.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `min:"1" type:"string" required:"true"`

	// Adds one or more tags for the specified extension association. Tags are metadata
	// that help you categorize resources in different ways, for example, by purpose,
	// owner, or environment. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExtensionAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExtensionAssociationInput"}
	if s.ExtensionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionIdentifier"))
	}
	if s.ExtensionIdentifier != nil && len(*s.ExtensionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionIdentifier", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionIdentifier sets the ExtensionIdentifier field's value.
func (s *CreateExtensionAssociationInput) SetExtensionIdentifier(v string) *CreateExtensionAssociationInput {
	s.ExtensionIdentifier = &v
	return s
}

// SetExtensionVersionNumber sets the ExtensionVersionNumber field's value.
func (s *CreateExtensionAssociationInput) SetExtensionVersionNumber(v int64) *CreateExtensionAssociationInput {
	s.ExtensionVersionNumber = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExtensionAssociationInput) SetParameters(v map[string]*string) *CreateExtensionAssociationInput {
	s.Parameters = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateExtensionAssociationInput) SetResourceIdentifier(v string) *CreateExtensionAssociationInput {
	s.ResourceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExtensionAssociationInput) SetTags(v map[string]*string) *CreateExtensionAssociationInput {
	s.Tags = v
	return s
}

type CreateExtensionAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// The ARN of the extension defined in the association.
	ExtensionArn *string `min:"20" type:"string"`

	// The version number for the extension defined in the association.
	ExtensionVersionNumber *int64 `type:"integer"`

	// The system-generated ID for the association.
	Id *string `min:"1" type:"string"`

	// The parameter names and values defined in the association.
	Parameters map[string]*string `type:"map"`

	// The ARNs of applications, configuration profiles, or environments defined
	// in the association.
	ResourceArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateExtensionAssociationOutput) SetArn(v string) *CreateExtensionAssociationOutput {
	s.Arn = &v
	return s
}

// SetExtensionArn sets the ExtensionArn field's value.
func (s *CreateExtensionAssociationOutput) SetExtensionArn(v string) *CreateExtensionAssociationOutput {
	s.ExtensionArn = &v
	return s
}

// SetExtensionVersionNumber sets the ExtensionVersionNumber field's value.
func (s *CreateExtensionAssociationOutput) SetExtensionVersionNumber(v int64) *CreateExtensionAssociationOutput {
	s.ExtensionVersionNumber = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateExtensionAssociationOutput) SetId(v string) *CreateExtensionAssociationOutput {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExtensionAssociationOutput) SetParameters(v map[string]*string) *CreateExtensionAssociationOutput {
	s.Parameters = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateExtensionAssociationOutput) SetResourceArn(v string) *CreateExtensionAssociationOutput {
	s.ResourceArn = &v
	return s
}

type CreateExtensionInput struct {
	_ struct{} `type:"structure"`

	// The actions defined in the extension.
	//
	// Actions is a required field
	Actions map[string][]*Action `min:"1" type:"map" required:"true"`

	// Information about the extension.
	Description *string `type:"string"`

	// You can omit this field when you create an extension. When you create a new
	// version, specify the most recent current version number. For example, you
	// create version 3, enter 2 for this field.
	LatestVersionNumber *int64 `location:"header" locationName:"Latest-Version-Number" type:"integer"`

	// A name for the extension. Each extension name in your account must be unique.
	// Extension versions use the same name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The parameters accepted by the extension. You specify parameter values when
	// you associate the extension to an AppConfig resource by using the CreateExtensionAssociation
	// API action. For Lambda extension actions, these parameters are included in
	// the Lambda request object.
	Parameters map[string]*Parameter `min:"1" type:"map"`

	// Adds one or more tags for the specified extension. Tags are metadata that
	// help you categorize resources in different ways, for example, by purpose,
	// owner, or environment. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExtensionInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateExtensionInput) SetActions(v map[string][]*Action) *CreateExtensionInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateExtensionInput) SetDescription(v string) *CreateExtensionInput {
	s.Description = &v
	return s
}

// SetLatestVersionNumber sets the LatestVersionNumber field's value.
func (s *CreateExtensionInput) SetLatestVersionNumber(v int64) *CreateExtensionInput {
	s.LatestVersionNumber = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateExtensionInput) SetName(v string) *CreateExtensionInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExtensionInput) SetParameters(v map[string]*Parameter) *CreateExtensionInput {
	s.Parameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExtensionInput) SetTags(v map[string]*string) *CreateExtensionInput {
	s.Tags = v
	return s
}

type CreateExtensionOutput struct {
	_ struct{} `type:"structure"`

	// The actions defined in the extension.
	Actions map[string][]*Action `min:"1" type:"map"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// Information about the extension.
	Description *string `type:"string"`

	// The system-generated ID of the extension.
	Id *string `type:"string"`

	// The extension name.
	Name *string `min:"1" type:"string"`

	// The parameters accepted by the extension. You specify parameter values when
	// you associate the extension to an AppConfig resource by using the CreateExtensionAssociation
	// API action. For Lambda extension actions, these parameters are included in
	// the Lambda request object.
	Parameters map[string]*Parameter `min:"1" type:"map"`

	// The extension version number.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExtensionOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *CreateExtensionOutput) SetActions(v map[string][]*Action) *CreateExtensionOutput {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateExtensionOutput) SetArn(v string) *CreateExtensionOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateExtensionOutput) SetDescription(v string) *CreateExtensionOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateExtensionOutput) SetId(v string) *CreateExtensionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateExtensionOutput) SetName(v string) *CreateExtensionOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateExtensionOutput) SetParameters(v map[string]*Parameter) *CreateExtensionOutput {
	s.Parameters = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *CreateExtensionOutput) SetVersionNumber(v int64) *CreateExtensionOutput {
	s.VersionNumber = &v
	return s
}

type CreateHostedConfigurationVersionInput struct {
	_ struct{} `type:"structure" payload:"Content"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The content of the configuration or the configuration data.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateHostedConfigurationVersionInput's
	// String and GoString methods.
	//
	// Content is a required field
	Content []byte `type:"blob" required:"true" sensitive:"true"`

	// A standard MIME type describing the format of the configuration content.
	// For more information, see Content-Type (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string" required:"true"`

	// A description of the configuration.
	Description *string `location:"header" locationName:"Description" type:"string"`

	// An optional locking token used to prevent race conditions from overwriting
	// configuration updates when creating a new version. To ensure your data is
	// not overwritten when creating multiple hosted configuration versions in rapid
	// succession, specify the version number of the latest hosted configuration
	// version.
	LatestVersionNumber *int64 `location:"header" locationName:"Latest-Version-Number" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostedConfigurationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostedConfigurationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHostedConfigurationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHostedConfigurationVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateHostedConfigurationVersionInput) SetApplicationId(v string) *CreateHostedConfigurationVersionInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *CreateHostedConfigurationVersionInput) SetConfigurationProfileId(v string) *CreateHostedConfigurationVersionInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateHostedConfigurationVersionInput) SetContent(v []byte) *CreateHostedConfigurationVersionInput {
	s.Content = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateHostedConfigurationVersionInput) SetContentType(v string) *CreateHostedConfigurationVersionInput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateHostedConfigurationVersionInput) SetDescription(v string) *CreateHostedConfigurationVersionInput {
	s.Description = &v
	return s
}

// SetLatestVersionNumber sets the LatestVersionNumber field's value.
func (s *CreateHostedConfigurationVersionInput) SetLatestVersionNumber(v int64) *CreateHostedConfigurationVersionInput {
	s.LatestVersionNumber = &v
	return s
}

type CreateHostedConfigurationVersionOutput struct {
	_ struct{} `type:"structure" payload:"Content"`

	// The application ID.
	ApplicationId *string `location:"header" locationName:"Application-Id" type:"string"`

	// The configuration profile ID.
	ConfigurationProfileId *string `location:"header" locationName:"Configuration-Profile-Id" type:"string"`

	// The content of the configuration or the configuration data.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateHostedConfigurationVersionOutput's
	// String and GoString methods.
	Content []byte `type:"blob" sensitive:"true"`

	// A standard MIME type describing the format of the configuration content.
	// For more information, see Content-Type (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// A description of the configuration.
	Description *string `location:"header" locationName:"Description" type:"string"`

	// The configuration version.
	VersionNumber *int64 `location:"header" locationName:"Version-Number" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostedConfigurationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHostedConfigurationVersionOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateHostedConfigurationVersionOutput) SetApplicationId(v string) *CreateHostedConfigurationVersionOutput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *CreateHostedConfigurationVersionOutput) SetConfigurationProfileId(v string) *CreateHostedConfigurationVersionOutput {
	s.ConfigurationProfileId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateHostedConfigurationVersionOutput) SetContent(v []byte) *CreateHostedConfigurationVersionOutput {
	s.Content = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateHostedConfigurationVersionOutput) SetContentType(v string) *CreateHostedConfigurationVersionOutput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateHostedConfigurationVersionOutput) SetDescription(v string) *CreateHostedConfigurationVersionOutput {
	s.Description = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *CreateHostedConfigurationVersionOutput) SetVersionNumber(v int64) *CreateHostedConfigurationVersionOutput {
	s.VersionNumber = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application to delete.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationInput) SetApplicationId(v string) *DeleteApplicationInput {
	s.ApplicationId = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteConfigurationProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID that includes the configuration profile you want to delete.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The ID of the configuration profile you want to delete.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationProfileInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteConfigurationProfileInput) SetApplicationId(v string) *DeleteConfigurationProfileInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *DeleteConfigurationProfileInput) SetConfigurationProfileId(v string) *DeleteConfigurationProfileInput {
	s.ConfigurationProfileId = &v
	return s
}

type DeleteConfigurationProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationProfileOutput) GoString() string {
	return s.String()
}

type DeleteDeploymentStrategyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the deployment strategy you want to delete.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `location:"uri" locationName:"DeploymentStrategyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentStrategyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentStrategyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentStrategyInput"}
	if s.DeploymentStrategyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentStrategyId"))
	}
	if s.DeploymentStrategyId != nil && len(*s.DeploymentStrategyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentStrategyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *DeleteDeploymentStrategyInput) SetDeploymentStrategyId(v string) *DeleteDeploymentStrategyInput {
	s.DeploymentStrategyId = &v
	return s
}

type DeleteDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentStrategyOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID that includes the environment that you want to delete.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The ID of the environment that you want to delete.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEnvironmentInput) SetApplicationId(v string) *DeleteEnvironmentInput {
	s.ApplicationId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteEnvironmentInput) SetEnvironmentId(v string) *DeleteEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

type DeleteExtensionAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the extension association to delete.
	//
	// ExtensionAssociationId is a required field
	ExtensionAssociationId *string `location:"uri" locationName:"ExtensionAssociationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExtensionAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExtensionAssociationInput"}
	if s.ExtensionAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionAssociationId"))
	}
	if s.ExtensionAssociationId != nil && len(*s.ExtensionAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionAssociationId sets the ExtensionAssociationId field's value.
func (s *DeleteExtensionAssociationInput) SetExtensionAssociationId(v string) *DeleteExtensionAssociationInput {
	s.ExtensionAssociationId = &v
	return s
}

type DeleteExtensionAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionAssociationOutput) GoString() string {
	return s.String()
}

type DeleteExtensionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name, ID, or Amazon Resource Name (ARN) of the extension you want to
	// delete.
	//
	// ExtensionIdentifier is a required field
	ExtensionIdentifier *string `location:"uri" locationName:"ExtensionIdentifier" min:"1" type:"string" required:"true"`

	// A specific version of an extension to delete. If omitted, the highest version
	// is deleted.
	VersionNumber *int64 `location:"querystring" locationName:"version" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExtensionInput"}
	if s.ExtensionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionIdentifier"))
	}
	if s.ExtensionIdentifier != nil && len(*s.ExtensionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionIdentifier sets the ExtensionIdentifier field's value.
func (s *DeleteExtensionInput) SetExtensionIdentifier(v string) *DeleteExtensionInput {
	s.ExtensionIdentifier = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteExtensionInput) SetVersionNumber(v int64) *DeleteExtensionInput {
	s.VersionNumber = &v
	return s
}

type DeleteExtensionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExtensionOutput) GoString() string {
	return s.String()
}

type DeleteHostedConfigurationVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The versions number to delete.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostedConfigurationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostedConfigurationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHostedConfigurationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHostedConfigurationVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteHostedConfigurationVersionInput) SetApplicationId(v string) *DeleteHostedConfigurationVersionInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *DeleteHostedConfigurationVersionInput) SetConfigurationProfileId(v string) *DeleteHostedConfigurationVersionInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteHostedConfigurationVersionInput) SetVersionNumber(v int64) *DeleteHostedConfigurationVersionInput {
	s.VersionNumber = &v
	return s
}

type DeleteHostedConfigurationVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostedConfigurationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHostedConfigurationVersionOutput) GoString() string {
	return s.String()
}

// An object that describes a deployment event.
type DeploymentEvent struct {
	_ struct{} `type:"structure"`

	// The list of extensions that were invoked as part of the deployment.
	ActionInvocations []*ActionInvocation `type:"list"`

	// A description of the deployment event. Descriptions include, but are not
	// limited to, the user account or the Amazon CloudWatch alarm ARN that initiated
	// a rollback, the percentage of hosts that received the deployment, or in the
	// case of an internal error, a recommendation to attempt a new deployment.
	Description *string `type:"string"`

	// The type of deployment event. Deployment event types include the start, stop,
	// or completion of a deployment; a percentage update; the start or stop of
	// a bake period; and the start or completion of a rollback.
	EventType *string `type:"string" enum:"DeploymentEventType"`

	// The date and time the event occurred.
	OccurredAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The entity that triggered the deployment event. Events can be triggered by
	// a user, AppConfig, an Amazon CloudWatch alarm, or an internal error.
	TriggeredBy *string `type:"string" enum:"TriggeredBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentEvent) GoString() string {
	return s.String()
}

// SetActionInvocations sets the ActionInvocations field's value.
func (s *DeploymentEvent) SetActionInvocations(v []*ActionInvocation) *DeploymentEvent {
	s.ActionInvocations = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DeploymentEvent) SetDescription(v string) *DeploymentEvent {
	s.Description = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *DeploymentEvent) SetEventType(v string) *DeploymentEvent {
	s.EventType = &v
	return s
}

// SetOccurredAt sets the OccurredAt field's value.
func (s *DeploymentEvent) SetOccurredAt(v time.Time) *DeploymentEvent {
	s.OccurredAt = &v
	return s
}

// SetTriggeredBy sets the TriggeredBy field's value.
func (s *DeploymentEvent) SetTriggeredBy(v string) *DeploymentEvent {
	s.TriggeredBy = &v
	return s
}

type DeploymentStrategy struct {
	_ struct{} `type:"structure"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The deployment strategy ID.
	Id *string `type:"string"`

	// The name of the deployment strategy.
	Name *string `min:"1" type:"string"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo *string `type:"string" enum:"ReplicateTo"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentStrategy) GoString() string {
	return s.String()
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *DeploymentStrategy) SetDeploymentDurationInMinutes(v int64) *DeploymentStrategy {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DeploymentStrategy) SetDescription(v string) *DeploymentStrategy {
	s.Description = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *DeploymentStrategy) SetFinalBakeTimeInMinutes(v int64) *DeploymentStrategy {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *DeploymentStrategy) SetGrowthFactor(v float64) *DeploymentStrategy {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *DeploymentStrategy) SetGrowthType(v string) *DeploymentStrategy {
	s.GrowthType = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeploymentStrategy) SetId(v string) *DeploymentStrategy {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeploymentStrategy) SetName(v string) *DeploymentStrategy {
	s.Name = &v
	return s
}

// SetReplicateTo sets the ReplicateTo field's value.
func (s *DeploymentStrategy) SetReplicateTo(v string) *DeploymentStrategy {
	s.ReplicateTo = &v
	return s
}

// Information about the deployment.
type DeploymentSummary struct {
	_ struct{} `type:"structure"`

	// Time the deployment completed.
	CompletedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The version of the configuration.
	ConfigurationVersion *string `min:"1" type:"string"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The sequence number of the deployment.
	DeploymentNumber *int64 `type:"integer"`

	// The amount of time that AppConfig monitors for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grows over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The percentage of targets for which the deployment is available.
	PercentageComplete *float64 `min:"1" type:"float"`

	// Time the deployment started.
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the deployment.
	State *string `type:"string" enum:"DeploymentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentSummary) GoString() string {
	return s.String()
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *DeploymentSummary) SetCompletedAt(v time.Time) *DeploymentSummary {
	s.CompletedAt = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *DeploymentSummary) SetConfigurationName(v string) *DeploymentSummary {
	s.ConfigurationName = &v
	return s
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *DeploymentSummary) SetConfigurationVersion(v string) *DeploymentSummary {
	s.ConfigurationVersion = &v
	return s
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *DeploymentSummary) SetDeploymentDurationInMinutes(v int64) *DeploymentSummary {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDeploymentNumber sets the DeploymentNumber field's value.
func (s *DeploymentSummary) SetDeploymentNumber(v int64) *DeploymentSummary {
	s.DeploymentNumber = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *DeploymentSummary) SetFinalBakeTimeInMinutes(v int64) *DeploymentSummary {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *DeploymentSummary) SetGrowthFactor(v float64) *DeploymentSummary {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *DeploymentSummary) SetGrowthType(v string) *DeploymentSummary {
	s.GrowthType = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *DeploymentSummary) SetPercentageComplete(v float64) *DeploymentSummary {
	s.PercentageComplete = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *DeploymentSummary) SetStartedAt(v time.Time) *DeploymentSummary {
	s.StartedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *DeploymentSummary) SetState(v string) *DeploymentSummary {
	s.State = &v
	return s
}

type Environment struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The description of the environment.
	Description *string `type:"string"`

	// The environment ID.
	Id *string `type:"string"`

	// Amazon CloudWatch alarms monitored during the deployment.
	Monitors []*Monitor `type:"list"`

	// The name of the environment.
	Name *string `min:"1" type:"string"`

	// The state of the environment. An environment can be in one of the following
	// states: READY_FOR_DEPLOYMENT, DEPLOYING, ROLLING_BACK, or ROLLED_BACK
	State *string `type:"string" enum:"EnvironmentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Environment) SetApplicationId(v string) *Environment {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Environment) SetDescription(v string) *Environment {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Environment) SetId(v string) *Environment {
	s.Id = &v
	return s
}

// SetMonitors sets the Monitors field's value.
func (s *Environment) SetMonitors(v []*Monitor) *Environment {
	s.Monitors = v
	return s
}

// SetName sets the Name field's value.
func (s *Environment) SetName(v string) *Environment {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Environment) SetState(v string) *Environment {
	s.State = &v
	return s
}

// Information about an association between an extension and an AppConfig resource
// such as an application, environment, or configuration profile. Call GetExtensionAssociation
// to get more information about an association.
type ExtensionAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	ExtensionArn *string `min:"20" type:"string"`

	// The extension association ID. This ID is used to call other ExtensionAssociation
	// API actions such as GetExtensionAssociation or DeleteExtensionAssociation.
	Id *string `min:"1" type:"string"`

	// The ARNs of applications, configuration profiles, or environments defined
	// in the association.
	ResourceArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionAssociationSummary) GoString() string {
	return s.String()
}

// SetExtensionArn sets the ExtensionArn field's value.
func (s *ExtensionAssociationSummary) SetExtensionArn(v string) *ExtensionAssociationSummary {
	s.ExtensionArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExtensionAssociationSummary) SetId(v string) *ExtensionAssociationSummary {
	s.Id = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ExtensionAssociationSummary) SetResourceArn(v string) *ExtensionAssociationSummary {
	s.ResourceArn = &v
	return s
}

// Information about an extension. Call GetExtension to get more information
// about an extension.
type ExtensionSummary struct {
	_ struct{} `type:"structure"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// Information about the extension.
	Description *string `type:"string"`

	// The system-generated ID of the extension.
	Id *string `type:"string"`

	// The extension name.
	Name *string `min:"1" type:"string"`

	// The extension version number.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExtensionSummary) SetArn(v string) *ExtensionSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ExtensionSummary) SetDescription(v string) *ExtensionSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExtensionSummary) SetId(v string) *ExtensionSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExtensionSummary) SetName(v string) *ExtensionSummary {
	s.Name = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *ExtensionSummary) SetVersionNumber(v int64) *ExtensionSummary {
	s.VersionNumber = &v
	return s
}

type GetApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application you want to get.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationInput) SetApplicationId(v string) *GetApplicationInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the application.
	Description *string `type:"string"`

	// The application ID.
	Id *string `type:"string"`

	// The application name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetApplicationOutput) SetDescription(v string) *GetApplicationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetApplicationOutput) SetId(v string) *GetApplicationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationOutput) SetName(v string) *GetApplicationOutput {
	s.Name = &v
	return s
}

type GetConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application to get. Specify either the application name or the application
	// ID.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"Application" min:"1" type:"string" required:"true"`

	// The configuration version returned in the most recent GetConfiguration response.
	//
	// AppConfig uses the value of the ClientConfigurationVersion parameter to identify
	// the configuration version on your clients. If you don’t send ClientConfigurationVersion
	// with each call to GetConfiguration, your clients receive the current configuration.
	// You are charged each time your clients receive a configuration.
	//
	// To avoid excess charges, we recommend that you include the ClientConfigurationVersion
	// value with every call to GetConfiguration. This value must be saved on your
	// client. Subsequent calls to GetConfiguration must pass this value by using
	// the ClientConfigurationVersion parameter.
	//
	// For more information about working with configurations, see Retrieving the
	// Configuration (http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html)
	// in the AppConfig User Guide.
	ClientConfigurationVersion *string `location:"querystring" locationName:"client_configuration_version" min:"1" type:"string"`

	// The clientId parameter in the following command is a unique, user-specified
	// ID to identify the client for the configuration. This ID enables AppConfig
	// to deploy the configuration in intervals, as defined in the deployment strategy.
	//
	// ClientId is a required field
	ClientId *string `location:"querystring" locationName:"client_id" min:"1" type:"string" required:"true"`

	// The configuration to get. Specify either the configuration name or the configuration
	// ID.
	//
	// Configuration is a required field
	Configuration *string `location:"uri" locationName:"Configuration" min:"1" type:"string" required:"true"`

	// The environment to get. Specify either the environment name or the environment
	// ID.
	//
	// Environment is a required field
	Environment *string `location:"uri" locationName:"Environment" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ClientConfigurationVersion != nil && len(*s.ClientConfigurationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientConfigurationVersion", 1))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Configuration != nil && len(*s.Configuration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Configuration", 1))
	}
	if s.Environment == nil {
		invalidParams.Add(request.NewErrParamRequired("Environment"))
	}
	if s.Environment != nil && len(*s.Environment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Environment", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *GetConfigurationInput) SetApplication(v string) *GetConfigurationInput {
	s.Application = &v
	return s
}

// SetClientConfigurationVersion sets the ClientConfigurationVersion field's value.
func (s *GetConfigurationInput) SetClientConfigurationVersion(v string) *GetConfigurationInput {
	s.ClientConfigurationVersion = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *GetConfigurationInput) SetClientId(v string) *GetConfigurationInput {
	s.ClientId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetConfigurationInput) SetConfiguration(v string) *GetConfigurationInput {
	s.Configuration = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *GetConfigurationInput) SetEnvironment(v string) *GetConfigurationInput {
	s.Environment = &v
	return s
}

type GetConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"Content"`

	// The configuration version.
	ConfigurationVersion *string `location:"header" locationName:"Configuration-Version" min:"1" type:"string"`

	// The content of the configuration or the configuration data.
	//
	// The Content attribute only contains data if the system finds new or updated
	// configuration data. If there is no new or updated data and ClientConfigurationVersion
	// matches the version of the current configuration, AppConfig returns a 204
	// No Content HTTP response code and the Content value will be empty.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetConfigurationOutput's
	// String and GoString methods.
	Content []byte `type:"blob" sensitive:"true"`

	// A standard MIME type describing the format of the configuration content.
	// For more information, see Content-Type (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *GetConfigurationOutput) SetConfigurationVersion(v string) *GetConfigurationOutput {
	s.ConfigurationVersion = &v
	return s
}

// SetContent sets the Content field's value.
func (s *GetConfigurationOutput) SetContent(v []byte) *GetConfigurationOutput {
	s.Content = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetConfigurationOutput) SetContentType(v string) *GetConfigurationOutput {
	s.ContentType = &v
	return s
}

type GetConfigurationProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application that includes the configuration profile you want
	// to get.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The ID of the configuration profile that you want to get.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationProfileInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetConfigurationProfileInput) SetApplicationId(v string) *GetConfigurationProfileInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *GetConfigurationProfileInput) SetConfigurationProfileId(v string) *GetConfigurationProfileInput {
	s.ConfigurationProfileId = &v
	return s
}

type GetConfigurationProfileOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The configuration profile description.
	Description *string `type:"string"`

	// The configuration profile ID.
	Id *string `type:"string"`

	// The URI location of the configuration.
	LocationUri *string `min:"1" type:"string"`

	// The name of the configuration profile.
	Name *string `min:"1" type:"string"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// The type of configurations contained in the profile. AppConfig supports feature
	// flags and freeform configurations. We recommend you create feature flag configurations
	// to enable or disable new features and freeform configurations to distribute
	// configurations to an application. When calling this API, enter one of the
	// following values for Type:
	//
	// AWS.AppConfig.FeatureFlags
	//
	// AWS.Freeform
	Type *string `type:"string"`

	// A list of methods for validating the configuration.
	Validators []*Validator `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationProfileOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetConfigurationProfileOutput) SetApplicationId(v string) *GetConfigurationProfileOutput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetConfigurationProfileOutput) SetDescription(v string) *GetConfigurationProfileOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetConfigurationProfileOutput) SetId(v string) *GetConfigurationProfileOutput {
	s.Id = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *GetConfigurationProfileOutput) SetLocationUri(v string) *GetConfigurationProfileOutput {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetConfigurationProfileOutput) SetName(v string) *GetConfigurationProfileOutput {
	s.Name = &v
	return s
}

// SetRetrievalRoleArn sets the RetrievalRoleArn field's value.
func (s *GetConfigurationProfileOutput) SetRetrievalRoleArn(v string) *GetConfigurationProfileOutput {
	s.RetrievalRoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetConfigurationProfileOutput) SetType(v string) *GetConfigurationProfileOutput {
	s.Type = &v
	return s
}

// SetValidators sets the Validators field's value.
func (s *GetConfigurationProfileOutput) SetValidators(v []*Validator) *GetConfigurationProfileOutput {
	s.Validators = v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application that includes the deployment you want to get.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The sequence number of the deployment.
	//
	// DeploymentNumber is a required field
	DeploymentNumber *int64 `location:"uri" locationName:"DeploymentNumber" type:"integer" required:"true"`

	// The ID of the environment that includes the deployment you want to get.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.DeploymentNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentNumber"))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDeploymentInput) SetApplicationId(v string) *GetDeploymentInput {
	s.ApplicationId = &v
	return s
}

// SetDeploymentNumber sets the DeploymentNumber field's value.
func (s *GetDeploymentInput) SetDeploymentNumber(v int64) *GetDeploymentInput {
	s.DeploymentNumber = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetDeploymentInput) SetEnvironmentId(v string) *GetDeploymentInput {
	s.EnvironmentId = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that was deployed.
	ApplicationId *string `type:"string"`

	// A list of extensions that were processed as part of the deployment. The extensions
	// that were previously associated to the configuration profile, environment,
	// or the application when StartDeployment was called.
	AppliedExtensions []*AppliedExtension `type:"list"`

	// The time the deployment completed.
	CompletedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Information about the source location of the configuration.
	ConfigurationLocationUri *string `min:"1" type:"string"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The ID of the configuration profile that was deployed.
	ConfigurationProfileId *string `type:"string"`

	// The configuration version that was deployed.
	ConfigurationVersion *string `min:"1" type:"string"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The sequence number of the deployment.
	DeploymentNumber *int64 `type:"integer"`

	// The ID of the deployment strategy that was deployed.
	DeploymentStrategyId *string `type:"string"`

	// The description of the deployment.
	Description *string `type:"string"`

	// The ID of the environment that was deployed.
	EnvironmentId *string `type:"string"`

	// A list containing all events related to a deployment. The most recent events
	// are displayed first.
	EventLog []*DeploymentEvent `type:"list"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The percentage of targets for which the deployment is available.
	PercentageComplete *float64 `min:"1" type:"float"`

	// The time the deployment started.
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the deployment.
	State *string `type:"string" enum:"DeploymentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDeploymentOutput) SetApplicationId(v string) *GetDeploymentOutput {
	s.ApplicationId = &v
	return s
}

// SetAppliedExtensions sets the AppliedExtensions field's value.
func (s *GetDeploymentOutput) SetAppliedExtensions(v []*AppliedExtension) *GetDeploymentOutput {
	s.AppliedExtensions = v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *GetDeploymentOutput) SetCompletedAt(v time.Time) *GetDeploymentOutput {
	s.CompletedAt = &v
	return s
}

// SetConfigurationLocationUri sets the ConfigurationLocationUri field's value.
func (s *GetDeploymentOutput) SetConfigurationLocationUri(v string) *GetDeploymentOutput {
	s.ConfigurationLocationUri = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *GetDeploymentOutput) SetConfigurationName(v string) *GetDeploymentOutput {
	s.ConfigurationName = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *GetDeploymentOutput) SetConfigurationProfileId(v string) *GetDeploymentOutput {
	s.ConfigurationProfileId = &v
	return s
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *GetDeploymentOutput) SetConfigurationVersion(v string) *GetDeploymentOutput {
	s.ConfigurationVersion = &v
	return s
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *GetDeploymentOutput) SetDeploymentDurationInMinutes(v int64) *GetDeploymentOutput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDeploymentNumber sets the DeploymentNumber field's value.
func (s *GetDeploymentOutput) SetDeploymentNumber(v int64) *GetDeploymentOutput {
	s.DeploymentNumber = &v
	return s
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *GetDeploymentOutput) SetDeploymentStrategyId(v string) *GetDeploymentOutput {
	s.DeploymentStrategyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDeploymentOutput) SetDescription(v string) *GetDeploymentOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetDeploymentOutput) SetEnvironmentId(v string) *GetDeploymentOutput {
	s.EnvironmentId = &v
	return s
}

// SetEventLog sets the EventLog field's value.
func (s *GetDeploymentOutput) SetEventLog(v []*DeploymentEvent) *GetDeploymentOutput {
	s.EventLog = v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *GetDeploymentOutput) SetFinalBakeTimeInMinutes(v int64) *GetDeploymentOutput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *GetDeploymentOutput) SetGrowthFactor(v float64) *GetDeploymentOutput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *GetDeploymentOutput) SetGrowthType(v string) *GetDeploymentOutput {
	s.GrowthType = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *GetDeploymentOutput) SetPercentageComplete(v float64) *GetDeploymentOutput {
	s.PercentageComplete = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetDeploymentOutput) SetStartedAt(v time.Time) *GetDeploymentOutput {
	s.StartedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *GetDeploymentOutput) SetState(v string) *GetDeploymentOutput {
	s.State = &v
	return s
}

type GetDeploymentStrategyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the deployment strategy to get.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `location:"uri" locationName:"DeploymentStrategyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentStrategyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentStrategyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentStrategyInput"}
	if s.DeploymentStrategyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentStrategyId"))
	}
	if s.DeploymentStrategyId != nil && len(*s.DeploymentStrategyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentStrategyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *GetDeploymentStrategyInput) SetDeploymentStrategyId(v string) *GetDeploymentStrategyInput {
	s.DeploymentStrategyId = &v
	return s
}

type GetDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The deployment strategy ID.
	Id *string `type:"string"`

	// The name of the deployment strategy.
	Name *string `min:"1" type:"string"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo *string `type:"string" enum:"ReplicateTo"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentStrategyOutput) GoString() string {
	return s.String()
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *GetDeploymentStrategyOutput) SetDeploymentDurationInMinutes(v int64) *GetDeploymentStrategyOutput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDeploymentStrategyOutput) SetDescription(v string) *GetDeploymentStrategyOutput {
	s.Description = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *GetDeploymentStrategyOutput) SetFinalBakeTimeInMinutes(v int64) *GetDeploymentStrategyOutput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *GetDeploymentStrategyOutput) SetGrowthFactor(v float64) *GetDeploymentStrategyOutput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *GetDeploymentStrategyOutput) SetGrowthType(v string) *GetDeploymentStrategyOutput {
	s.GrowthType = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeploymentStrategyOutput) SetId(v string) *GetDeploymentStrategyOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDeploymentStrategyOutput) SetName(v string) *GetDeploymentStrategyOutput {
	s.Name = &v
	return s
}

// SetReplicateTo sets the ReplicateTo field's value.
func (s *GetDeploymentStrategyOutput) SetReplicateTo(v string) *GetDeploymentStrategyOutput {
	s.ReplicateTo = &v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application that includes the environment you want to get.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The ID of the environment that you want to get.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEnvironmentInput) SetApplicationId(v string) *GetEnvironmentInput {
	s.ApplicationId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetEnvironmentInput) SetEnvironmentId(v string) *GetEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The description of the environment.
	Description *string `type:"string"`

	// The environment ID.
	Id *string `type:"string"`

	// Amazon CloudWatch alarms monitored during the deployment.
	Monitors []*Monitor `type:"list"`

	// The name of the environment.
	Name *string `min:"1" type:"string"`

	// The state of the environment. An environment can be in one of the following
	// states: READY_FOR_DEPLOYMENT, DEPLOYING, ROLLING_BACK, or ROLLED_BACK
	State *string `type:"string" enum:"EnvironmentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEnvironmentOutput) SetApplicationId(v string) *GetEnvironmentOutput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEnvironmentOutput) SetDescription(v string) *GetEnvironmentOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetEnvironmentOutput) SetId(v string) *GetEnvironmentOutput {
	s.Id = &v
	return s
}

// SetMonitors sets the Monitors field's value.
func (s *GetEnvironmentOutput) SetMonitors(v []*Monitor) *GetEnvironmentOutput {
	s.Monitors = v
	return s
}

// SetName sets the Name field's value.
func (s *GetEnvironmentOutput) SetName(v string) *GetEnvironmentOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *GetEnvironmentOutput) SetState(v string) *GetEnvironmentOutput {
	s.State = &v
	return s
}

type GetExtensionAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The extension association ID to get.
	//
	// ExtensionAssociationId is a required field
	ExtensionAssociationId *string `location:"uri" locationName:"ExtensionAssociationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExtensionAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExtensionAssociationInput"}
	if s.ExtensionAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionAssociationId"))
	}
	if s.ExtensionAssociationId != nil && len(*s.ExtensionAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionAssociationId sets the ExtensionAssociationId field's value.
func (s *GetExtensionAssociationInput) SetExtensionAssociationId(v string) *GetExtensionAssociationInput {
	s.ExtensionAssociationId = &v
	return s
}

type GetExtensionAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// The ARN of the extension defined in the association.
	ExtensionArn *string `min:"20" type:"string"`

	// The version number for the extension defined in the association.
	ExtensionVersionNumber *int64 `type:"integer"`

	// The system-generated ID for the association.
	Id *string `min:"1" type:"string"`

	// The parameter names and values defined in the association.
	Parameters map[string]*string `type:"map"`

	// The ARNs of applications, configuration profiles, or environments defined
	// in the association.
	ResourceArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetExtensionAssociationOutput) SetArn(v string) *GetExtensionAssociationOutput {
	s.Arn = &v
	return s
}

// SetExtensionArn sets the ExtensionArn field's value.
func (s *GetExtensionAssociationOutput) SetExtensionArn(v string) *GetExtensionAssociationOutput {
	s.ExtensionArn = &v
	return s
}

// SetExtensionVersionNumber sets the ExtensionVersionNumber field's value.
func (s *GetExtensionAssociationOutput) SetExtensionVersionNumber(v int64) *GetExtensionAssociationOutput {
	s.ExtensionVersionNumber = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetExtensionAssociationOutput) SetId(v string) *GetExtensionAssociationOutput {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetExtensionAssociationOutput) SetParameters(v map[string]*string) *GetExtensionAssociationOutput {
	s.Parameters = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetExtensionAssociationOutput) SetResourceArn(v string) *GetExtensionAssociationOutput {
	s.ResourceArn = &v
	return s
}

type GetExtensionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name, the ID, or the Amazon Resource Name (ARN) of the extension.
	//
	// ExtensionIdentifier is a required field
	ExtensionIdentifier *string `location:"uri" locationName:"ExtensionIdentifier" min:"1" type:"string" required:"true"`

	// The extension version number. If no version number was defined, AppConfig
	// uses the highest version.
	VersionNumber *int64 `location:"querystring" locationName:"version_number" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExtensionInput"}
	if s.ExtensionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionIdentifier"))
	}
	if s.ExtensionIdentifier != nil && len(*s.ExtensionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionIdentifier sets the ExtensionIdentifier field's value.
func (s *GetExtensionInput) SetExtensionIdentifier(v string) *GetExtensionInput {
	s.ExtensionIdentifier = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetExtensionInput) SetVersionNumber(v int64) *GetExtensionInput {
	s.VersionNumber = &v
	return s
}

type GetExtensionOutput struct {
	_ struct{} `type:"structure"`

	// The actions defined in the extension.
	Actions map[string][]*Action `min:"1" type:"map"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// Information about the extension.
	Description *string `type:"string"`

	// The system-generated ID of the extension.
	Id *string `type:"string"`

	// The extension name.
	Name *string `min:"1" type:"string"`

	// The parameters accepted by the extension. You specify parameter values when
	// you associate the extension to an AppConfig resource by using the CreateExtensionAssociation
	// API action. For Lambda extension actions, these parameters are included in
	// the Lambda request object.
	Parameters map[string]*Parameter `min:"1" type:"map"`

	// The extension version number.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *GetExtensionOutput) SetActions(v map[string][]*Action) *GetExtensionOutput {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetExtensionOutput) SetArn(v string) *GetExtensionOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetExtensionOutput) SetDescription(v string) *GetExtensionOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetExtensionOutput) SetId(v string) *GetExtensionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetExtensionOutput) SetName(v string) *GetExtensionOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetExtensionOutput) SetParameters(v map[string]*Parameter) *GetExtensionOutput {
	s.Parameters = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetExtensionOutput) SetVersionNumber(v int64) *GetExtensionOutput {
	s.VersionNumber = &v
	return s
}

type GetHostedConfigurationVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The version.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostedConfigurationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostedConfigurationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostedConfigurationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHostedConfigurationVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetHostedConfigurationVersionInput) SetApplicationId(v string) *GetHostedConfigurationVersionInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *GetHostedConfigurationVersionInput) SetConfigurationProfileId(v string) *GetHostedConfigurationVersionInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetHostedConfigurationVersionInput) SetVersionNumber(v int64) *GetHostedConfigurationVersionInput {
	s.VersionNumber = &v
	return s
}

type GetHostedConfigurationVersionOutput struct {
	_ struct{} `type:"structure" payload:"Content"`

	// The application ID.
	ApplicationId *string `location:"header" locationName:"Application-Id" type:"string"`

	// The configuration profile ID.
	ConfigurationProfileId *string `location:"header" locationName:"Configuration-Profile-Id" type:"string"`

	// The content of the configuration or the configuration data.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetHostedConfigurationVersionOutput's
	// String and GoString methods.
	Content []byte `type:"blob" sensitive:"true"`

	// A standard MIME type describing the format of the configuration content.
	// For more information, see Content-Type (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// A description of the configuration.
	Description *string `location:"header" locationName:"Description" type:"string"`

	// The configuration version.
	VersionNumber *int64 `location:"header" locationName:"Version-Number" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostedConfigurationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHostedConfigurationVersionOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetHostedConfigurationVersionOutput) SetApplicationId(v string) *GetHostedConfigurationVersionOutput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *GetHostedConfigurationVersionOutput) SetConfigurationProfileId(v string) *GetHostedConfigurationVersionOutput {
	s.ConfigurationProfileId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *GetHostedConfigurationVersionOutput) SetContent(v []byte) *GetHostedConfigurationVersionOutput {
	s.Content = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetHostedConfigurationVersionOutput) SetContentType(v string) *GetHostedConfigurationVersionOutput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetHostedConfigurationVersionOutput) SetDescription(v string) *GetHostedConfigurationVersionOutput {
	s.Description = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetHostedConfigurationVersionOutput) SetVersionNumber(v int64) *GetHostedConfigurationVersionOutput {
	s.VersionNumber = &v
	return s
}

// Information about the configuration.
type HostedConfigurationVersionSummary struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The configuration profile ID.
	ConfigurationProfileId *string `type:"string"`

	// A standard MIME type describing the format of the configuration content.
	// For more information, see Content-Type (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string `min:"1" type:"string"`

	// A description of the configuration.
	Description *string `type:"string"`

	// The configuration version.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostedConfigurationVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostedConfigurationVersionSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *HostedConfigurationVersionSummary) SetApplicationId(v string) *HostedConfigurationVersionSummary {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *HostedConfigurationVersionSummary) SetConfigurationProfileId(v string) *HostedConfigurationVersionSummary {
	s.ConfigurationProfileId = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *HostedConfigurationVersionSummary) SetContentType(v string) *HostedConfigurationVersionSummary {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *HostedConfigurationVersionSummary) SetDescription(v string) *HostedConfigurationVersionSummary {
	s.Description = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *HostedConfigurationVersionSummary) SetVersionNumber(v int64) *HostedConfigurationVersionSummary {
	s.VersionNumber = &v
	return s
}

// There was an internal failure in the AppConfig service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Detailed information about the bad request exception error when creating
// a hosted configuration version.
type InvalidConfigurationDetail struct {
	_ struct{} `type:"structure"`

	// The invalid or out-of-range validation constraint in your JSON schema that
	// failed validation.
	Constraint *string `type:"string"`

	// Location of the validation constraint in the configuration JSON schema that
	// failed validation.
	Location *string `type:"string"`

	// The reason for an invalid configuration error.
	Reason *string `type:"string"`

	// The type of error for an invalid configuration.
	Type *string `type:"string"`

	// Details about an error with Lambda when a synchronous extension experiences
	// an error during an invocation.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidConfigurationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidConfigurationDetail) GoString() string {
	return s.String()
}

// SetConstraint sets the Constraint field's value.
func (s *InvalidConfigurationDetail) SetConstraint(v string) *InvalidConfigurationDetail {
	s.Constraint = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *InvalidConfigurationDetail) SetLocation(v string) *InvalidConfigurationDetail {
	s.Location = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *InvalidConfigurationDetail) SetReason(v string) *InvalidConfigurationDetail {
	s.Reason = &v
	return s
}

// SetType sets the Type field's value.
func (s *InvalidConfigurationDetail) SetType(v string) *InvalidConfigurationDetail {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *InvalidConfigurationDetail) SetValue(v string) *InvalidConfigurationDetail {
	s.Value = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A token to start the list. Next token is a pagination token generated by
	// AppConfig to describe what page the previous List call ended on. For the
	// first List request, the nextToken should not be set. On subsequent calls,
	// the nextToken parameter should be set to the previous responses nextToken
	// value. Use this token to get the next set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The elements from this collection.
	Items []*Application `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListApplicationsOutput) SetItems(v []*Application) *ListApplicationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListConfigurationProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`

	// A filter based on the type of configurations that the configuration profile
	// contains. A configuration can be a feature flag or a freeform configuration.
	Type *string `location:"querystring" locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationProfilesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListConfigurationProfilesInput) SetApplicationId(v string) *ListConfigurationProfilesInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationProfilesInput) SetMaxResults(v int64) *ListConfigurationProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationProfilesInput) SetNextToken(v string) *ListConfigurationProfilesInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListConfigurationProfilesInput) SetType(v string) *ListConfigurationProfilesInput {
	s.Type = &v
	return s
}

type ListConfigurationProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The elements from this collection.
	Items []*ConfigurationProfileSummary `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationProfilesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListConfigurationProfilesOutput) SetItems(v []*ConfigurationProfileSummary) *ListConfigurationProfilesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationProfilesOutput) SetNextToken(v string) *ListConfigurationProfilesOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentStrategiesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentStrategiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentStrategiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentStrategiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentStrategiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentStrategiesInput) SetMaxResults(v int64) *ListDeploymentStrategiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentStrategiesInput) SetNextToken(v string) *ListDeploymentStrategiesInput {
	s.NextToken = &v
	return s
}

type ListDeploymentStrategiesOutput struct {
	_ struct{} `type:"structure"`

	// The elements from this collection.
	Items []*DeploymentStrategy `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentStrategiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentStrategiesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDeploymentStrategiesOutput) SetItems(v []*DeploymentStrategy) *ListDeploymentStrategiesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentStrategiesOutput) SetNextToken(v string) *ListDeploymentStrategiesOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`

	// The maximum number of items that may be returned for this call. If there
	// are items that have not yet been returned, the response will include a non-null
	// NextToken that you can provide in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The token returned by a prior call to this operation indicating the next
	// set of results to be returned. If not specified, the operation will return
	// the first set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDeploymentsInput) SetApplicationId(v string) *ListDeploymentsInput {
	s.ApplicationId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListDeploymentsInput) SetEnvironmentId(v string) *ListDeploymentsInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v int64) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The elements from this collection.
	Items []*DeploymentSummary `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDeploymentsOutput) SetItems(v []*DeploymentSummary) *ListDeploymentsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListEnvironmentsInput) SetApplicationId(v string) *ListEnvironmentsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The elements from this collection.
	Items []*Environment `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListEnvironmentsOutput) SetItems(v []*Environment) *ListEnvironmentsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListExtensionAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name, the ID, or the Amazon Resource Name (ARN) of the extension.
	ExtensionIdentifier *string `location:"querystring" locationName:"extension_identifier" min:"1" type:"string"`

	// The version number for the extension defined in the association.
	ExtensionVersionNumber *int64 `location:"querystring" locationName:"extension_version_number" type:"integer"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results
	// or pass null to get the first set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`

	// The ARN of an application, configuration profile, or environment.
	ResourceIdentifier *string `location:"querystring" locationName:"resource_identifier" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExtensionAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExtensionAssociationsInput"}
	if s.ExtensionIdentifier != nil && len(*s.ExtensionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionIdentifier sets the ExtensionIdentifier field's value.
func (s *ListExtensionAssociationsInput) SetExtensionIdentifier(v string) *ListExtensionAssociationsInput {
	s.ExtensionIdentifier = &v
	return s
}

// SetExtensionVersionNumber sets the ExtensionVersionNumber field's value.
func (s *ListExtensionAssociationsInput) SetExtensionVersionNumber(v int64) *ListExtensionAssociationsInput {
	s.ExtensionVersionNumber = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExtensionAssociationsInput) SetMaxResults(v int64) *ListExtensionAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionAssociationsInput) SetNextToken(v string) *ListExtensionAssociationsInput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ListExtensionAssociationsInput) SetResourceIdentifier(v string) *ListExtensionAssociationsInput {
	s.ResourceIdentifier = &v
	return s
}

type ListExtensionAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of extension associations. Each item represents an extension association
	// to an application, environment, or configuration profile.
	Items []*ExtensionAssociationSummary `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionAssociationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListExtensionAssociationsOutput) SetItems(v []*ExtensionAssociationSummary) *ListExtensionAssociationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionAssociationsOutput) SetNextToken(v string) *ListExtensionAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListExtensionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The extension name.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExtensionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExtensionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExtensionsInput) SetMaxResults(v int64) *ListExtensionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListExtensionsInput) SetName(v string) *ListExtensionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionsInput) SetNextToken(v string) *ListExtensionsInput {
	s.NextToken = &v
	return s
}

type ListExtensionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of available extensions. The list includes Amazon Web Services-authored
	// and user-created extensions.
	Items []*ExtensionSummary `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListExtensionsOutput) SetItems(v []*ExtensionSummary) *ListExtensionsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionsOutput) SetNextToken(v string) *ListExtensionsOutput {
	s.NextToken = &v
	return s
}

type ListHostedConfigurationVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `location:"querystring" locationName:"next_token" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostedConfigurationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostedConfigurationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHostedConfigurationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHostedConfigurationVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListHostedConfigurationVersionsInput) SetApplicationId(v string) *ListHostedConfigurationVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *ListHostedConfigurationVersionsInput) SetConfigurationProfileId(v string) *ListHostedConfigurationVersionsInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHostedConfigurationVersionsInput) SetMaxResults(v int64) *ListHostedConfigurationVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHostedConfigurationVersionsInput) SetNextToken(v string) *ListHostedConfigurationVersionsInput {
	s.NextToken = &v
	return s
}

type ListHostedConfigurationVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The elements from this collection.
	Items []*HostedConfigurationVersionSummary `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostedConfigurationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHostedConfigurationVersionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListHostedConfigurationVersionsOutput) SetItems(v []*HostedConfigurationVersionSummary) *ListHostedConfigurationVersionsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHostedConfigurationVersionsOutput) SetNextToken(v string) *ListHostedConfigurationVersionsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Metadata to assign to AppConfig resources. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Amazon CloudWatch alarms to monitor during the deployment process.
type Monitor struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
	//
	// AlarmArn is a required field
	AlarmArn *string `min:"1" type:"string" required:"true"`

	// ARN of an Identity and Access Management (IAM) role for AppConfig to monitor
	// AlarmArn.
	AlarmRoleArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Monitor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Monitor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Monitor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Monitor"}
	if s.AlarmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmArn"))
	}
	if s.AlarmArn != nil && len(*s.AlarmArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmArn", 1))
	}
	if s.AlarmRoleArn != nil && len(*s.AlarmRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmRoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmArn sets the AlarmArn field's value.
func (s *Monitor) SetAlarmArn(v string) *Monitor {
	s.AlarmArn = &v
	return s
}

// SetAlarmRoleArn sets the AlarmRoleArn field's value.
func (s *Monitor) SetAlarmRoleArn(v string) *Monitor {
	s.AlarmRoleArn = &v
	return s
}

// A value such as an Amazon Resource Name (ARN) or an Amazon Simple Notification
// Service topic entered in an extension when invoked. Parameter values are
// specified in an extension association. For more information about extensions,
// see Working with AppConfig extensions (https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html)
// in the AppConfig User Guide.
type Parameter struct {
	_ struct{} `type:"structure"`

	// Information about the parameter.
	Description *string `type:"string"`

	// A parameter value must be specified in the extension association.
	Required *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *Parameter) SetRequired(v bool) *Parameter {
	s.Required = &v
	return s
}

// The configuration size is too large.
type PayloadTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Limit *float64 `type:"float"`

	Measure *string `type:"string" enum:"BytesMeasure"`

	Message_ *string `locationName:"Message" type:"string"`

	Size *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadTooLargeException) GoString() string {
	return s.String()
}

func newErrorPayloadTooLargeException(v protocol.ResponseMetadata) error {
	return &PayloadTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PayloadTooLargeException) Code() string {
	return "PayloadTooLargeException"
}

// Message returns the exception's message.
func (s *PayloadTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PayloadTooLargeException) OrigErr() error {
	return nil
}

func (s *PayloadTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PayloadTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PayloadTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The number of hosted configuration versions exceeds the limit for the AppConfig
// hosted configuration store. Delete one or more versions and try again.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `type:"string" required:"true"`

	// The configuration version to deploy.
	//
	// ConfigurationVersion is a required field
	ConfigurationVersion *string `min:"1" type:"string" required:"true"`

	// The deployment strategy ID.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `type:"string" required:"true"`

	// A description of the deployment.
	Description *string `type:"string"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`

	// Metadata to assign to the deployment. Tags help organize and categorize your
	// AppConfig resources. Each tag consists of a key and an optional value, both
	// of which you define.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDeploymentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationVersion"))
	}
	if s.ConfigurationVersion != nil && len(*s.ConfigurationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationVersion", 1))
	}
	if s.DeploymentStrategyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentStrategyId"))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartDeploymentInput) SetApplicationId(v string) *StartDeploymentInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *StartDeploymentInput) SetConfigurationProfileId(v string) *StartDeploymentInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *StartDeploymentInput) SetConfigurationVersion(v string) *StartDeploymentInput {
	s.ConfigurationVersion = &v
	return s
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *StartDeploymentInput) SetDeploymentStrategyId(v string) *StartDeploymentInput {
	s.DeploymentStrategyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartDeploymentInput) SetDescription(v string) *StartDeploymentInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *StartDeploymentInput) SetEnvironmentId(v string) *StartDeploymentInput {
	s.EnvironmentId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartDeploymentInput) SetTags(v map[string]*string) *StartDeploymentInput {
	s.Tags = v
	return s
}

type StartDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that was deployed.
	ApplicationId *string `type:"string"`

	// A list of extensions that were processed as part of the deployment. The extensions
	// that were previously associated to the configuration profile, environment,
	// or the application when StartDeployment was called.
	AppliedExtensions []*AppliedExtension `type:"list"`

	// The time the deployment completed.
	CompletedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Information about the source location of the configuration.
	ConfigurationLocationUri *string `min:"1" type:"string"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The ID of the configuration profile that was deployed.
	ConfigurationProfileId *string `type:"string"`

	// The configuration version that was deployed.
	ConfigurationVersion *string `min:"1" type:"string"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The sequence number of the deployment.
	DeploymentNumber *int64 `type:"integer"`

	// The ID of the deployment strategy that was deployed.
	DeploymentStrategyId *string `type:"string"`

	// The description of the deployment.
	Description *string `type:"string"`

	// The ID of the environment that was deployed.
	EnvironmentId *string `type:"string"`

	// A list containing all events related to a deployment. The most recent events
	// are displayed first.
	EventLog []*DeploymentEvent `type:"list"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The percentage of targets for which the deployment is available.
	PercentageComplete *float64 `min:"1" type:"float"`

	// The time the deployment started.
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the deployment.
	State *string `type:"string" enum:"DeploymentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeploymentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartDeploymentOutput) SetApplicationId(v string) *StartDeploymentOutput {
	s.ApplicationId = &v
	return s
}

// SetAppliedExtensions sets the AppliedExtensions field's value.
func (s *StartDeploymentOutput) SetAppliedExtensions(v []*AppliedExtension) *StartDeploymentOutput {
	s.AppliedExtensions = v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *StartDeploymentOutput) SetCompletedAt(v time.Time) *StartDeploymentOutput {
	s.CompletedAt = &v
	return s
}

// SetConfigurationLocationUri sets the ConfigurationLocationUri field's value.
func (s *StartDeploymentOutput) SetConfigurationLocationUri(v string) *StartDeploymentOutput {
	s.ConfigurationLocationUri = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *StartDeploymentOutput) SetConfigurationName(v string) *StartDeploymentOutput {
	s.ConfigurationName = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *StartDeploymentOutput) SetConfigurationProfileId(v string) *StartDeploymentOutput {
	s.ConfigurationProfileId = &v
	return s
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *StartDeploymentOutput) SetConfigurationVersion(v string) *StartDeploymentOutput {
	s.ConfigurationVersion = &v
	return s
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *StartDeploymentOutput) SetDeploymentDurationInMinutes(v int64) *StartDeploymentOutput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDeploymentNumber sets the DeploymentNumber field's value.
func (s *StartDeploymentOutput) SetDeploymentNumber(v int64) *StartDeploymentOutput {
	s.DeploymentNumber = &v
	return s
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *StartDeploymentOutput) SetDeploymentStrategyId(v string) *StartDeploymentOutput {
	s.DeploymentStrategyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartDeploymentOutput) SetDescription(v string) *StartDeploymentOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *StartDeploymentOutput) SetEnvironmentId(v string) *StartDeploymentOutput {
	s.EnvironmentId = &v
	return s
}

// SetEventLog sets the EventLog field's value.
func (s *StartDeploymentOutput) SetEventLog(v []*DeploymentEvent) *StartDeploymentOutput {
	s.EventLog = v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *StartDeploymentOutput) SetFinalBakeTimeInMinutes(v int64) *StartDeploymentOutput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *StartDeploymentOutput) SetGrowthFactor(v float64) *StartDeploymentOutput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *StartDeploymentOutput) SetGrowthType(v string) *StartDeploymentOutput {
	s.GrowthType = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *StartDeploymentOutput) SetPercentageComplete(v float64) *StartDeploymentOutput {
	s.PercentageComplete = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *StartDeploymentOutput) SetStartedAt(v time.Time) *StartDeploymentOutput {
	s.StartedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *StartDeploymentOutput) SetState(v string) *StartDeploymentOutput {
	s.State = &v
	return s
}

type StopDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The sequence number of the deployment.
	//
	// DeploymentNumber is a required field
	DeploymentNumber *int64 `location:"uri" locationName:"DeploymentNumber" type:"integer" required:"true"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDeploymentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.DeploymentNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentNumber"))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StopDeploymentInput) SetApplicationId(v string) *StopDeploymentInput {
	s.ApplicationId = &v
	return s
}

// SetDeploymentNumber sets the DeploymentNumber field's value.
func (s *StopDeploymentInput) SetDeploymentNumber(v int64) *StopDeploymentInput {
	s.DeploymentNumber = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *StopDeploymentInput) SetEnvironmentId(v string) *StopDeploymentInput {
	s.EnvironmentId = &v
	return s
}

type StopDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that was deployed.
	ApplicationId *string `type:"string"`

	// A list of extensions that were processed as part of the deployment. The extensions
	// that were previously associated to the configuration profile, environment,
	// or the application when StartDeployment was called.
	AppliedExtensions []*AppliedExtension `type:"list"`

	// The time the deployment completed.
	CompletedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Information about the source location of the configuration.
	ConfigurationLocationUri *string `min:"1" type:"string"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The ID of the configuration profile that was deployed.
	ConfigurationProfileId *string `type:"string"`

	// The configuration version that was deployed.
	ConfigurationVersion *string `min:"1" type:"string"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The sequence number of the deployment.
	DeploymentNumber *int64 `type:"integer"`

	// The ID of the deployment strategy that was deployed.
	DeploymentStrategyId *string `type:"string"`

	// The description of the deployment.
	Description *string `type:"string"`

	// The ID of the environment that was deployed.
	EnvironmentId *string `type:"string"`

	// A list containing all events related to a deployment. The most recent events
	// are displayed first.
	EventLog []*DeploymentEvent `type:"list"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The percentage of targets for which the deployment is available.
	PercentageComplete *float64 `min:"1" type:"float"`

	// The time the deployment started.
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the deployment.
	State *string `type:"string" enum:"DeploymentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeploymentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StopDeploymentOutput) SetApplicationId(v string) *StopDeploymentOutput {
	s.ApplicationId = &v
	return s
}

// SetAppliedExtensions sets the AppliedExtensions field's value.
func (s *StopDeploymentOutput) SetAppliedExtensions(v []*AppliedExtension) *StopDeploymentOutput {
	s.AppliedExtensions = v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *StopDeploymentOutput) SetCompletedAt(v time.Time) *StopDeploymentOutput {
	s.CompletedAt = &v
	return s
}

// SetConfigurationLocationUri sets the ConfigurationLocationUri field's value.
func (s *StopDeploymentOutput) SetConfigurationLocationUri(v string) *StopDeploymentOutput {
	s.ConfigurationLocationUri = &v
	return s
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *StopDeploymentOutput) SetConfigurationName(v string) *StopDeploymentOutput {
	s.ConfigurationName = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *StopDeploymentOutput) SetConfigurationProfileId(v string) *StopDeploymentOutput {
	s.ConfigurationProfileId = &v
	return s
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *StopDeploymentOutput) SetConfigurationVersion(v string) *StopDeploymentOutput {
	s.ConfigurationVersion = &v
	return s
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *StopDeploymentOutput) SetDeploymentDurationInMinutes(v int64) *StopDeploymentOutput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDeploymentNumber sets the DeploymentNumber field's value.
func (s *StopDeploymentOutput) SetDeploymentNumber(v int64) *StopDeploymentOutput {
	s.DeploymentNumber = &v
	return s
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *StopDeploymentOutput) SetDeploymentStrategyId(v string) *StopDeploymentOutput {
	s.DeploymentStrategyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StopDeploymentOutput) SetDescription(v string) *StopDeploymentOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *StopDeploymentOutput) SetEnvironmentId(v string) *StopDeploymentOutput {
	s.EnvironmentId = &v
	return s
}

// SetEventLog sets the EventLog field's value.
func (s *StopDeploymentOutput) SetEventLog(v []*DeploymentEvent) *StopDeploymentOutput {
	s.EventLog = v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *StopDeploymentOutput) SetFinalBakeTimeInMinutes(v int64) *StopDeploymentOutput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *StopDeploymentOutput) SetGrowthFactor(v float64) *StopDeploymentOutput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *StopDeploymentOutput) SetGrowthType(v string) *StopDeploymentOutput {
	s.GrowthType = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *StopDeploymentOutput) SetPercentageComplete(v float64) *StopDeploymentOutput {
	s.PercentageComplete = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *StopDeploymentOutput) SetStartedAt(v time.Time) *StopDeploymentOutput {
	s.StartedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *StopDeploymentOutput) SetState(v string) *StopDeploymentOutput {
	s.State = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which to retrieve tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The
	// tag key can be up to 128 characters and must not start with aws:. The tag
	// value can be up to 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which to remove tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The tag keys to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// A description of the application.
	Description *string `type:"string"`

	// The name of the application.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationInput) SetApplicationId(v string) *UpdateApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationInput) SetName(v string) *UpdateApplicationInput {
	s.Name = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the application.
	Description *string `type:"string"`

	// The application ID.
	Id *string `type:"string"`

	// The application name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationOutput) SetDescription(v string) *UpdateApplicationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateApplicationOutput) SetId(v string) *UpdateApplicationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationOutput) SetName(v string) *UpdateApplicationOutput {
	s.Name = &v
	return s
}

type UpdateConfigurationProfileInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The ID of the configuration profile.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// A description of the configuration profile.
	Description *string `type:"string"`

	// The name of the configuration profile.
	Name *string `min:"1" type:"string"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// A list of methods for validating the configuration.
	Validators []*Validator `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationProfileInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RetrievalRoleArn != nil && len(*s.RetrievalRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RetrievalRoleArn", 20))
	}
	if s.Validators != nil {
		for i, v := range s.Validators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Validators", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateConfigurationProfileInput) SetApplicationId(v string) *UpdateConfigurationProfileInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *UpdateConfigurationProfileInput) SetConfigurationProfileId(v string) *UpdateConfigurationProfileInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfigurationProfileInput) SetDescription(v string) *UpdateConfigurationProfileInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConfigurationProfileInput) SetName(v string) *UpdateConfigurationProfileInput {
	s.Name = &v
	return s
}

// SetRetrievalRoleArn sets the RetrievalRoleArn field's value.
func (s *UpdateConfigurationProfileInput) SetRetrievalRoleArn(v string) *UpdateConfigurationProfileInput {
	s.RetrievalRoleArn = &v
	return s
}

// SetValidators sets the Validators field's value.
func (s *UpdateConfigurationProfileInput) SetValidators(v []*Validator) *UpdateConfigurationProfileInput {
	s.Validators = v
	return s
}

type UpdateConfigurationProfileOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The configuration profile description.
	Description *string `type:"string"`

	// The configuration profile ID.
	Id *string `type:"string"`

	// The URI location of the configuration.
	LocationUri *string `min:"1" type:"string"`

	// The name of the configuration profile.
	Name *string `min:"1" type:"string"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// The type of configurations contained in the profile. AppConfig supports feature
	// flags and freeform configurations. We recommend you create feature flag configurations
	// to enable or disable new features and freeform configurations to distribute
	// configurations to an application. When calling this API, enter one of the
	// following values for Type:
	//
	// AWS.AppConfig.FeatureFlags
	//
	// AWS.Freeform
	Type *string `type:"string"`

	// A list of methods for validating the configuration.
	Validators []*Validator `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationProfileOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateConfigurationProfileOutput) SetApplicationId(v string) *UpdateConfigurationProfileOutput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfigurationProfileOutput) SetDescription(v string) *UpdateConfigurationProfileOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateConfigurationProfileOutput) SetId(v string) *UpdateConfigurationProfileOutput {
	s.Id = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *UpdateConfigurationProfileOutput) SetLocationUri(v string) *UpdateConfigurationProfileOutput {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConfigurationProfileOutput) SetName(v string) *UpdateConfigurationProfileOutput {
	s.Name = &v
	return s
}

// SetRetrievalRoleArn sets the RetrievalRoleArn field's value.
func (s *UpdateConfigurationProfileOutput) SetRetrievalRoleArn(v string) *UpdateConfigurationProfileOutput {
	s.RetrievalRoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateConfigurationProfileOutput) SetType(v string) *UpdateConfigurationProfileOutput {
	s.Type = &v
	return s
}

// SetValidators sets the Validators field's value.
func (s *UpdateConfigurationProfileOutput) SetValidators(v []*Validator) *UpdateConfigurationProfileOutput {
	s.Validators = v
	return s
}

type UpdateDeploymentStrategyInput struct {
	_ struct{} `type:"structure"`

	// Total amount of time for a deployment to last.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The deployment strategy ID.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `location:"uri" locationName:"DeploymentStrategyId" type:"string" required:"true"`

	// A description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time that AppConfig monitors for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grows over time. AppConfig supports
	// the following growth types:
	//
	// Linear: For this type, AppConfig processes the deployment by increments of
	// the growth factor evenly distributed over the deployment time. For example,
	// a linear deployment that uses a growth factor of 20 initially makes the configuration
	// available to 20 percent of the targets. After 1/5th of the deployment time
	// has passed, the system updates the percentage to 40 percent. This continues
	// until 100% of the targets are set to receive the deployed configuration.
	//
	// Exponential: For this type, AppConfig processes the deployment exponentially
	// using the following formula: G*(2^N). In this formula, G is the growth factor
	// specified by the user and N is the number of steps until the configuration
	// is deployed to all targets. For example, if you specify a growth factor of
	// 2, then the system rolls out the configuration as follows:
	//
	// 2*(2^0)
	//
	// 2*(2^1)
	//
	// 2*(2^2)
	//
	// Expressed numerically, the deployment rolls out as follows: 2% of the targets,
	// 4% of the targets, 8% of the targets, and continues until the configuration
	// has been deployed to all targets.
	GrowthType *string `type:"string" enum:"GrowthType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeploymentStrategyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentStrategyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentStrategyInput"}
	if s.DeploymentStrategyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentStrategyId"))
	}
	if s.DeploymentStrategyId != nil && len(*s.DeploymentStrategyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentStrategyId", 1))
	}
	if s.GrowthFactor != nil && *s.GrowthFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("GrowthFactor", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *UpdateDeploymentStrategyInput) SetDeploymentDurationInMinutes(v int64) *UpdateDeploymentStrategyInput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDeploymentStrategyId sets the DeploymentStrategyId field's value.
func (s *UpdateDeploymentStrategyInput) SetDeploymentStrategyId(v string) *UpdateDeploymentStrategyInput {
	s.DeploymentStrategyId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDeploymentStrategyInput) SetDescription(v string) *UpdateDeploymentStrategyInput {
	s.Description = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *UpdateDeploymentStrategyInput) SetFinalBakeTimeInMinutes(v int64) *UpdateDeploymentStrategyInput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *UpdateDeploymentStrategyInput) SetGrowthFactor(v float64) *UpdateDeploymentStrategyInput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *UpdateDeploymentStrategyInput) SetGrowthType(v string) *UpdateDeploymentStrategyInput {
	s.GrowthType = &v
	return s
}

type UpdateDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time that AppConfig monitored for alarms before considering
	// the deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType *string `type:"string" enum:"GrowthType"`

	// The deployment strategy ID.
	Id *string `type:"string"`

	// The name of the deployment strategy.
	Name *string `min:"1" type:"string"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo *string `type:"string" enum:"ReplicateTo"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeploymentStrategyOutput) GoString() string {
	return s.String()
}

// SetDeploymentDurationInMinutes sets the DeploymentDurationInMinutes field's value.
func (s *UpdateDeploymentStrategyOutput) SetDeploymentDurationInMinutes(v int64) *UpdateDeploymentStrategyOutput {
	s.DeploymentDurationInMinutes = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDeploymentStrategyOutput) SetDescription(v string) *UpdateDeploymentStrategyOutput {
	s.Description = &v
	return s
}

// SetFinalBakeTimeInMinutes sets the FinalBakeTimeInMinutes field's value.
func (s *UpdateDeploymentStrategyOutput) SetFinalBakeTimeInMinutes(v int64) *UpdateDeploymentStrategyOutput {
	s.FinalBakeTimeInMinutes = &v
	return s
}

// SetGrowthFactor sets the GrowthFactor field's value.
func (s *UpdateDeploymentStrategyOutput) SetGrowthFactor(v float64) *UpdateDeploymentStrategyOutput {
	s.GrowthFactor = &v
	return s
}

// SetGrowthType sets the GrowthType field's value.
func (s *UpdateDeploymentStrategyOutput) SetGrowthType(v string) *UpdateDeploymentStrategyOutput {
	s.GrowthType = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDeploymentStrategyOutput) SetId(v string) *UpdateDeploymentStrategyOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDeploymentStrategyOutput) SetName(v string) *UpdateDeploymentStrategyOutput {
	s.Name = &v
	return s
}

// SetReplicateTo sets the ReplicateTo field's value.
func (s *UpdateDeploymentStrategyOutput) SetReplicateTo(v string) *UpdateDeploymentStrategyOutput {
	s.ReplicateTo = &v
	return s
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// A description of the environment.
	Description *string `type:"string"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`

	// Amazon CloudWatch alarms to monitor during the deployment process.
	Monitors []*Monitor `type:"list"`

	// The name of the environment.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Monitors != nil {
		for i, v := range s.Monitors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Monitors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEnvironmentInput) SetApplicationId(v string) *UpdateEnvironmentInput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentInput) SetDescription(v string) *UpdateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentId(v string) *UpdateEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetMonitors sets the Monitors field's value.
func (s *UpdateEnvironmentInput) SetMonitors(v []*Monitor) *UpdateEnvironmentInput {
	s.Monitors = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentInput) SetName(v string) *UpdateEnvironmentInput {
	s.Name = &v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The description of the environment.
	Description *string `type:"string"`

	// The environment ID.
	Id *string `type:"string"`

	// Amazon CloudWatch alarms monitored during the deployment.
	Monitors []*Monitor `type:"list"`

	// The name of the environment.
	Name *string `min:"1" type:"string"`

	// The state of the environment. An environment can be in one of the following
	// states: READY_FOR_DEPLOYMENT, DEPLOYING, ROLLING_BACK, or ROLLED_BACK
	State *string `type:"string" enum:"EnvironmentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEnvironmentOutput) SetApplicationId(v string) *UpdateEnvironmentOutput {
	s.ApplicationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentOutput) SetDescription(v string) *UpdateEnvironmentOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateEnvironmentOutput) SetId(v string) *UpdateEnvironmentOutput {
	s.Id = &v
	return s
}

// SetMonitors sets the Monitors field's value.
func (s *UpdateEnvironmentOutput) SetMonitors(v []*Monitor) *UpdateEnvironmentOutput {
	s.Monitors = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentOutput) SetName(v string) *UpdateEnvironmentOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateEnvironmentOutput) SetState(v string) *UpdateEnvironmentOutput {
	s.State = &v
	return s
}

type UpdateExtensionAssociationInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID for the association.
	//
	// ExtensionAssociationId is a required field
	ExtensionAssociationId *string `location:"uri" locationName:"ExtensionAssociationId" type:"string" required:"true"`

	// The parameter names and values defined in the extension.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExtensionAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExtensionAssociationInput"}
	if s.ExtensionAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionAssociationId"))
	}
	if s.ExtensionAssociationId != nil && len(*s.ExtensionAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionAssociationId sets the ExtensionAssociationId field's value.
func (s *UpdateExtensionAssociationInput) SetExtensionAssociationId(v string) *UpdateExtensionAssociationInput {
	s.ExtensionAssociationId = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExtensionAssociationInput) SetParameters(v map[string]*string) *UpdateExtensionAssociationInput {
	s.Parameters = v
	return s
}

type UpdateExtensionAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// The ARN of the extension defined in the association.
	ExtensionArn *string `min:"20" type:"string"`

	// The version number for the extension defined in the association.
	ExtensionVersionNumber *int64 `type:"integer"`

	// The system-generated ID for the association.
	Id *string `min:"1" type:"string"`

	// The parameter names and values defined in the association.
	Parameters map[string]*string `type:"map"`

	// The ARNs of applications, configuration profiles, or environments defined
	// in the association.
	ResourceArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionAssociationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateExtensionAssociationOutput) SetArn(v string) *UpdateExtensionAssociationOutput {
	s.Arn = &v
	return s
}

// SetExtensionArn sets the ExtensionArn field's value.
func (s *UpdateExtensionAssociationOutput) SetExtensionArn(v string) *UpdateExtensionAssociationOutput {
	s.ExtensionArn = &v
	return s
}

// SetExtensionVersionNumber sets the ExtensionVersionNumber field's value.
func (s *UpdateExtensionAssociationOutput) SetExtensionVersionNumber(v int64) *UpdateExtensionAssociationOutput {
	s.ExtensionVersionNumber = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateExtensionAssociationOutput) SetId(v string) *UpdateExtensionAssociationOutput {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExtensionAssociationOutput) SetParameters(v map[string]*string) *UpdateExtensionAssociationOutput {
	s.Parameters = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateExtensionAssociationOutput) SetResourceArn(v string) *UpdateExtensionAssociationOutput {
	s.ResourceArn = &v
	return s
}

type UpdateExtensionInput struct {
	_ struct{} `type:"structure"`

	// The actions defined in the extension.
	Actions map[string][]*Action `min:"1" type:"map"`

	// Information about the extension.
	Description *string `type:"string"`

	// The name, the ID, or the Amazon Resource Name (ARN) of the extension.
	//
	// ExtensionIdentifier is a required field
	ExtensionIdentifier *string `location:"uri" locationName:"ExtensionIdentifier" min:"1" type:"string" required:"true"`

	// One or more parameters for the actions called by the extension.
	Parameters map[string]*Parameter `min:"1" type:"map"`

	// The extension version number.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExtensionInput"}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.ExtensionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionIdentifier"))
	}
	if s.ExtensionIdentifier != nil && len(*s.ExtensionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionIdentifier", 1))
	}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *UpdateExtensionInput) SetActions(v map[string][]*Action) *UpdateExtensionInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateExtensionInput) SetDescription(v string) *UpdateExtensionInput {
	s.Description = &v
	return s
}

// SetExtensionIdentifier sets the ExtensionIdentifier field's value.
func (s *UpdateExtensionInput) SetExtensionIdentifier(v string) *UpdateExtensionInput {
	s.ExtensionIdentifier = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExtensionInput) SetParameters(v map[string]*Parameter) *UpdateExtensionInput {
	s.Parameters = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *UpdateExtensionInput) SetVersionNumber(v int64) *UpdateExtensionInput {
	s.VersionNumber = &v
	return s
}

type UpdateExtensionOutput struct {
	_ struct{} `type:"structure"`

	// The actions defined in the extension.
	Actions map[string][]*Action `min:"1" type:"map"`

	// The system-generated Amazon Resource Name (ARN) for the extension.
	Arn *string `min:"20" type:"string"`

	// Information about the extension.
	Description *string `type:"string"`

	// The system-generated ID of the extension.
	Id *string `type:"string"`

	// The extension name.
	Name *string `min:"1" type:"string"`

	// The parameters accepted by the extension. You specify parameter values when
	// you associate the extension to an AppConfig resource by using the CreateExtensionAssociation
	// API action. For Lambda extension actions, these parameters are included in
	// the Lambda request object.
	Parameters map[string]*Parameter `min:"1" type:"map"`

	// The extension version number.
	VersionNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExtensionOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *UpdateExtensionOutput) SetActions(v map[string][]*Action) *UpdateExtensionOutput {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateExtensionOutput) SetArn(v string) *UpdateExtensionOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateExtensionOutput) SetDescription(v string) *UpdateExtensionOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateExtensionOutput) SetId(v string) *UpdateExtensionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateExtensionOutput) SetName(v string) *UpdateExtensionOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateExtensionOutput) SetParameters(v map[string]*Parameter) *UpdateExtensionOutput {
	s.Parameters = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *UpdateExtensionOutput) SetVersionNumber(v int64) *UpdateExtensionOutput {
	s.VersionNumber = &v
	return s
}

type ValidateConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The version of the configuration to validate.
	//
	// ConfigurationVersion is a required field
	ConfigurationVersion *string `location:"querystring" locationName:"configuration_version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateConfigurationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ConfigurationProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationProfileId"))
	}
	if s.ConfigurationProfileId != nil && len(*s.ConfigurationProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationProfileId", 1))
	}
	if s.ConfigurationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationVersion"))
	}
	if s.ConfigurationVersion != nil && len(*s.ConfigurationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ValidateConfigurationInput) SetApplicationId(v string) *ValidateConfigurationInput {
	s.ApplicationId = &v
	return s
}

// SetConfigurationProfileId sets the ConfigurationProfileId field's value.
func (s *ValidateConfigurationInput) SetConfigurationProfileId(v string) *ValidateConfigurationInput {
	s.ConfigurationProfileId = &v
	return s
}

// SetConfigurationVersion sets the ConfigurationVersion field's value.
func (s *ValidateConfigurationInput) SetConfigurationVersion(v string) *ValidateConfigurationInput {
	s.ConfigurationVersion = &v
	return s
}

type ValidateConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateConfigurationOutput) GoString() string {
	return s.String()
}

// A validator provides a syntactic or semantic check to ensure the configuration
// that you want to deploy functions as intended. To validate your application
// configuration data, you provide a schema or an Amazon Web Services Lambda
// function that runs against the configuration. The configuration deployment
// or update can only proceed when the configuration data is valid.
type Validator struct {
	_ struct{} `type:"structure"`

	// Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda
	// function.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Validator's
	// String and GoString methods.
	//
	// Content is a required field
	Content *string `type:"string" required:"true" sensitive:"true"`

	// AppConfig supports validators of type JSON_SCHEMA and LAMBDA
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ValidatorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Validator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Validator"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *Validator) SetContent(v string) *Validator {
	s.Content = &v
	return s
}

// SetType sets the Type field's value.
func (s *Validator) SetType(v string) *Validator {
	s.Type = &v
	return s
}

const (
	// ActionPointPreCreateHostedConfigurationVersion is a ActionPoint enum value
	ActionPointPreCreateHostedConfigurationVersion = "PRE_CREATE_HOSTED_CONFIGURATION_VERSION"

	// ActionPointPreStartDeployment is a ActionPoint enum value
	ActionPointPreStartDeployment = "PRE_START_DEPLOYMENT"

	// ActionPointOnDeploymentStart is a ActionPoint enum value
	ActionPointOnDeploymentStart = "ON_DEPLOYMENT_START"

	// ActionPointOnDeploymentStep is a ActionPoint enum value
	ActionPointOnDeploymentStep = "ON_DEPLOYMENT_STEP"

	// ActionPointOnDeploymentBaking is a ActionPoint enum value
	ActionPointOnDeploymentBaking = "ON_DEPLOYMENT_BAKING"

	// ActionPointOnDeploymentComplete is a ActionPoint enum value
	ActionPointOnDeploymentComplete = "ON_DEPLOYMENT_COMPLETE"

	// ActionPointOnDeploymentRolledBack is a ActionPoint enum value
	ActionPointOnDeploymentRolledBack = "ON_DEPLOYMENT_ROLLED_BACK"
)

// ActionPoint_Values returns all elements of the ActionPoint enum
func ActionPoint_Values() []string {
	return []string{
		ActionPointPreCreateHostedConfigurationVersion,
		ActionPointPreStartDeployment,
		ActionPointOnDeploymentStart,
		ActionPointOnDeploymentStep,
		ActionPointOnDeploymentBaking,
		ActionPointOnDeploymentComplete,
		ActionPointOnDeploymentRolledBack,
	}
}

const (
	// BadRequestReasonInvalidConfiguration is a BadRequestReason enum value
	BadRequestReasonInvalidConfiguration = "InvalidConfiguration"
)

// BadRequestReason_Values returns all elements of the BadRequestReason enum
func BadRequestReason_Values() []string {
	return []string{
		BadRequestReasonInvalidConfiguration,
	}
}

const (
	// BytesMeasureKilobytes is a BytesMeasure enum value
	BytesMeasureKilobytes = "KILOBYTES"
)

// BytesMeasure_Values returns all elements of the BytesMeasure enum
func BytesMeasure_Values() []string {
	return []string{
		BytesMeasureKilobytes,
	}
}

const (
	// DeploymentEventTypePercentageUpdated is a DeploymentEventType enum value
	DeploymentEventTypePercentageUpdated = "PERCENTAGE_UPDATED"

	// DeploymentEventTypeRollbackStarted is a DeploymentEventType enum value
	DeploymentEventTypeRollbackStarted = "ROLLBACK_STARTED"

	// DeploymentEventTypeRollbackCompleted is a DeploymentEventType enum value
	DeploymentEventTypeRollbackCompleted = "ROLLBACK_COMPLETED"

	// DeploymentEventTypeBakeTimeStarted is a DeploymentEventType enum value
	DeploymentEventTypeBakeTimeStarted = "BAKE_TIME_STARTED"

	// DeploymentEventTypeDeploymentStarted is a DeploymentEventType enum value
	DeploymentEventTypeDeploymentStarted = "DEPLOYMENT_STARTED"

	// DeploymentEventTypeDeploymentCompleted is a DeploymentEventType enum value
	DeploymentEventTypeDeploymentCompleted = "DEPLOYMENT_COMPLETED"
)

// DeploymentEventType_Values returns all elements of the DeploymentEventType enum
func DeploymentEventType_Values() []string {
	return []string{
		DeploymentEventTypePercentageUpdated,
		DeploymentEventTypeRollbackStarted,
		DeploymentEventTypeRollbackCompleted,
		DeploymentEventTypeBakeTimeStarted,
		DeploymentEventTypeDeploymentStarted,
		DeploymentEventTypeDeploymentCompleted,
	}
}

const (
	// DeploymentStateBaking is a DeploymentState enum value
	DeploymentStateBaking = "BAKING"

	// DeploymentStateValidating is a DeploymentState enum value
	DeploymentStateValidating = "VALIDATING"

	// DeploymentStateDeploying is a DeploymentState enum value
	DeploymentStateDeploying = "DEPLOYING"

	// DeploymentStateComplete is a DeploymentState enum value
	DeploymentStateComplete = "COMPLETE"

	// DeploymentStateRollingBack is a DeploymentState enum value
	DeploymentStateRollingBack = "ROLLING_BACK"

	// DeploymentStateRolledBack is a DeploymentState enum value
	DeploymentStateRolledBack = "ROLLED_BACK"
)

// DeploymentState_Values returns all elements of the DeploymentState enum
func DeploymentState_Values() []string {
	return []string{
		DeploymentStateBaking,
		DeploymentStateValidating,
		DeploymentStateDeploying,
		DeploymentStateComplete,
		DeploymentStateRollingBack,
		DeploymentStateRolledBack,
	}
}

const (
	// EnvironmentStateReadyForDeployment is a EnvironmentState enum value
	EnvironmentStateReadyForDeployment = "READY_FOR_DEPLOYMENT"

	// EnvironmentStateDeploying is a EnvironmentState enum value
	EnvironmentStateDeploying = "DEPLOYING"

	// EnvironmentStateRollingBack is a EnvironmentState enum value
	EnvironmentStateRollingBack = "ROLLING_BACK"

	// EnvironmentStateRolledBack is a EnvironmentState enum value
	EnvironmentStateRolledBack = "ROLLED_BACK"
)

// EnvironmentState_Values returns all elements of the EnvironmentState enum
func EnvironmentState_Values() []string {
	return []string{
		EnvironmentStateReadyForDeployment,
		EnvironmentStateDeploying,
		EnvironmentStateRollingBack,
		EnvironmentStateRolledBack,
	}
}

const (
	// GrowthTypeLinear is a GrowthType enum value
	GrowthTypeLinear = "LINEAR"

	// GrowthTypeExponential is a GrowthType enum value
	GrowthTypeExponential = "EXPONENTIAL"
)

// GrowthType_Values returns all elements of the GrowthType enum
func GrowthType_Values() []string {
	return []string{
		GrowthTypeLinear,
		GrowthTypeExponential,
	}
}

const (
	// ReplicateToNone is a ReplicateTo enum value
	ReplicateToNone = "NONE"

	// ReplicateToSsmDocument is a ReplicateTo enum value
	ReplicateToSsmDocument = "SSM_DOCUMENT"
)

// ReplicateTo_Values returns all elements of the ReplicateTo enum
func ReplicateTo_Values() []string {
	return []string{
		ReplicateToNone,
		ReplicateToSsmDocument,
	}
}

const (
	// TriggeredByUser is a TriggeredBy enum value
	TriggeredByUser = "USER"

	// TriggeredByAppconfig is a TriggeredBy enum value
	TriggeredByAppconfig = "APPCONFIG"

	// TriggeredByCloudwatchAlarm is a TriggeredBy enum value
	TriggeredByCloudwatchAlarm = "CLOUDWATCH_ALARM"

	// TriggeredByInternalError is a TriggeredBy enum value
	TriggeredByInternalError = "INTERNAL_ERROR"
)

// TriggeredBy_Values returns all elements of the TriggeredBy enum
func TriggeredBy_Values() []string {
	return []string{
		TriggeredByUser,
		TriggeredByAppconfig,
		TriggeredByCloudwatchAlarm,
		TriggeredByInternalError,
	}
}

const (
	// ValidatorTypeJsonSchema is a ValidatorType enum value
	ValidatorTypeJsonSchema = "JSON_SCHEMA"

	// ValidatorTypeLambda is a ValidatorType enum value
	ValidatorTypeLambda = "LAMBDA"
)

// ValidatorType_Values returns all elements of the ValidatorType enum
func ValidatorType_Values() []string {
	return []string{
		ValidatorTypeJsonSchema,
		ValidatorTypeLambda,
	}
}
