// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emrcontainers

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelJobRun = "CancelJobRun"

// CancelJobRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJobRun for more information on using the CancelJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelJobRunRequest method.
//	req, resp := client.CancelJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CancelJobRun
func (c *EMRContainers) CancelJobRunRequest(input *CancelJobRunInput) (req *request.Request, output *CancelJobRunOutput) {
	op := &request.Operation{
		Name:       opCancelJobRun,
		HTTPMethod: "DELETE",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/jobruns/{jobRunId}",
	}

	if input == nil {
		input = &CancelJobRunInput{}
	}

	output = &CancelJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJobRun API operation for Amazon EMR Containers.
//
// Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark
// script, or SparkSQL query, that you submit to Amazon EMR on EKS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation CancelJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CancelJobRun
func (c *EMRContainers) CancelJobRun(input *CancelJobRunInput) (*CancelJobRunOutput, error) {
	req, out := c.CancelJobRunRequest(input)
	return out, req.Send()
}

// CancelJobRunWithContext is the same as CancelJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) CancelJobRunWithContext(ctx aws.Context, input *CancelJobRunInput, opts ...request.Option) (*CancelJobRunOutput, error) {
	req, out := c.CancelJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateManagedEndpoint = "CreateManagedEndpoint"

// CreateManagedEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateManagedEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateManagedEndpoint for more information on using the CreateManagedEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateManagedEndpointRequest method.
//	req, resp := client.CreateManagedEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CreateManagedEndpoint
func (c *EMRContainers) CreateManagedEndpointRequest(input *CreateManagedEndpointInput) (req *request.Request, output *CreateManagedEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateManagedEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/endpoints",
	}

	if input == nil {
		input = &CreateManagedEndpointInput{}
	}

	output = &CreateManagedEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateManagedEndpoint API operation for Amazon EMR Containers.
//
// Creates a managed endpoint. A managed endpoint is a gateway that connects
// EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your
// virtual cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation CreateManagedEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CreateManagedEndpoint
func (c *EMRContainers) CreateManagedEndpoint(input *CreateManagedEndpointInput) (*CreateManagedEndpointOutput, error) {
	req, out := c.CreateManagedEndpointRequest(input)
	return out, req.Send()
}

// CreateManagedEndpointWithContext is the same as CreateManagedEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateManagedEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) CreateManagedEndpointWithContext(ctx aws.Context, input *CreateManagedEndpointInput, opts ...request.Option) (*CreateManagedEndpointOutput, error) {
	req, out := c.CreateManagedEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualCluster = "CreateVirtualCluster"

// CreateVirtualClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVirtualCluster for more information on using the CreateVirtualCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVirtualClusterRequest method.
//	req, resp := client.CreateVirtualClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CreateVirtualCluster
func (c *EMRContainers) CreateVirtualClusterRequest(input *CreateVirtualClusterInput) (req *request.Request, output *CreateVirtualClusterOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/virtualclusters",
	}

	if input == nil {
		input = &CreateVirtualClusterInput{}
	}

	output = &CreateVirtualClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualCluster API operation for Amazon EMR Containers.
//
// Creates a virtual cluster. Virtual cluster is a managed entity on Amazon
// EMR on EKS. You can create, describe, list and delete virtual clusters. They
// do not consume any additional resource in your system. A single virtual cluster
// maps to a single Kubernetes namespace. Given this relationship, you can model
// virtual clusters the same way you model Kubernetes namespaces to meet your
// requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation CreateVirtualCluster for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CreateVirtualCluster
func (c *EMRContainers) CreateVirtualCluster(input *CreateVirtualClusterInput) (*CreateVirtualClusterOutput, error) {
	req, out := c.CreateVirtualClusterRequest(input)
	return out, req.Send()
}

// CreateVirtualClusterWithContext is the same as CreateVirtualCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) CreateVirtualClusterWithContext(ctx aws.Context, input *CreateVirtualClusterInput, opts ...request.Option) (*CreateVirtualClusterOutput, error) {
	req, out := c.CreateVirtualClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteManagedEndpoint = "DeleteManagedEndpoint"

// DeleteManagedEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteManagedEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteManagedEndpoint for more information on using the DeleteManagedEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteManagedEndpointRequest method.
//	req, resp := client.DeleteManagedEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DeleteManagedEndpoint
func (c *EMRContainers) DeleteManagedEndpointRequest(input *DeleteManagedEndpointInput) (req *request.Request, output *DeleteManagedEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteManagedEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/endpoints/{endpointId}",
	}

	if input == nil {
		input = &DeleteManagedEndpointInput{}
	}

	output = &DeleteManagedEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteManagedEndpoint API operation for Amazon EMR Containers.
//
// Deletes a managed endpoint. A managed endpoint is a gateway that connects
// EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your
// virtual cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation DeleteManagedEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DeleteManagedEndpoint
func (c *EMRContainers) DeleteManagedEndpoint(input *DeleteManagedEndpointInput) (*DeleteManagedEndpointOutput, error) {
	req, out := c.DeleteManagedEndpointRequest(input)
	return out, req.Send()
}

// DeleteManagedEndpointWithContext is the same as DeleteManagedEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteManagedEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) DeleteManagedEndpointWithContext(ctx aws.Context, input *DeleteManagedEndpointInput, opts ...request.Option) (*DeleteManagedEndpointOutput, error) {
	req, out := c.DeleteManagedEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVirtualCluster = "DeleteVirtualCluster"

// DeleteVirtualClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVirtualCluster for more information on using the DeleteVirtualCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVirtualClusterRequest method.
//	req, resp := client.DeleteVirtualClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DeleteVirtualCluster
func (c *EMRContainers) DeleteVirtualClusterRequest(input *DeleteVirtualClusterInput) (req *request.Request, output *DeleteVirtualClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/virtualclusters/{virtualClusterId}",
	}

	if input == nil {
		input = &DeleteVirtualClusterInput{}
	}

	output = &DeleteVirtualClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualCluster API operation for Amazon EMR Containers.
//
// Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon
// EMR on EKS. You can create, describe, list and delete virtual clusters. They
// do not consume any additional resource in your system. A single virtual cluster
// maps to a single Kubernetes namespace. Given this relationship, you can model
// virtual clusters the same way you model Kubernetes namespaces to meet your
// requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation DeleteVirtualCluster for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DeleteVirtualCluster
func (c *EMRContainers) DeleteVirtualCluster(input *DeleteVirtualClusterInput) (*DeleteVirtualClusterOutput, error) {
	req, out := c.DeleteVirtualClusterRequest(input)
	return out, req.Send()
}

// DeleteVirtualClusterWithContext is the same as DeleteVirtualCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVirtualCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) DeleteVirtualClusterWithContext(ctx aws.Context, input *DeleteVirtualClusterInput, opts ...request.Option) (*DeleteVirtualClusterOutput, error) {
	req, out := c.DeleteVirtualClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobRun = "DescribeJobRun"

// DescribeJobRunRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobRun for more information on using the DescribeJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobRunRequest method.
//	req, resp := client.DescribeJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DescribeJobRun
func (c *EMRContainers) DescribeJobRunRequest(input *DescribeJobRunInput) (req *request.Request, output *DescribeJobRunOutput) {
	op := &request.Operation{
		Name:       opDescribeJobRun,
		HTTPMethod: "GET",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/jobruns/{jobRunId}",
	}

	if input == nil {
		input = &DescribeJobRunInput{}
	}

	output = &DescribeJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobRun API operation for Amazon EMR Containers.
//
// Displays detailed information about a job run. A job run is a unit of work,
// such as a Spark jar, PySpark script, or SparkSQL query, that you submit to
// Amazon EMR on EKS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation DescribeJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DescribeJobRun
func (c *EMRContainers) DescribeJobRun(input *DescribeJobRunInput) (*DescribeJobRunOutput, error) {
	req, out := c.DescribeJobRunRequest(input)
	return out, req.Send()
}

// DescribeJobRunWithContext is the same as DescribeJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) DescribeJobRunWithContext(ctx aws.Context, input *DescribeJobRunInput, opts ...request.Option) (*DescribeJobRunOutput, error) {
	req, out := c.DescribeJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeManagedEndpoint = "DescribeManagedEndpoint"

// DescribeManagedEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeManagedEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeManagedEndpoint for more information on using the DescribeManagedEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeManagedEndpointRequest method.
//	req, resp := client.DescribeManagedEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DescribeManagedEndpoint
func (c *EMRContainers) DescribeManagedEndpointRequest(input *DescribeManagedEndpointInput) (req *request.Request, output *DescribeManagedEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeManagedEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/endpoints/{endpointId}",
	}

	if input == nil {
		input = &DescribeManagedEndpointInput{}
	}

	output = &DescribeManagedEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeManagedEndpoint API operation for Amazon EMR Containers.
//
// Displays detailed information about a managed endpoint. A managed endpoint
// is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio
// can communicate with your virtual cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation DescribeManagedEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DescribeManagedEndpoint
func (c *EMRContainers) DescribeManagedEndpoint(input *DescribeManagedEndpointInput) (*DescribeManagedEndpointOutput, error) {
	req, out := c.DescribeManagedEndpointRequest(input)
	return out, req.Send()
}

// DescribeManagedEndpointWithContext is the same as DescribeManagedEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeManagedEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) DescribeManagedEndpointWithContext(ctx aws.Context, input *DescribeManagedEndpointInput, opts ...request.Option) (*DescribeManagedEndpointOutput, error) {
	req, out := c.DescribeManagedEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVirtualCluster = "DescribeVirtualCluster"

// DescribeVirtualClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVirtualCluster for more information on using the DescribeVirtualCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVirtualClusterRequest method.
//	req, resp := client.DescribeVirtualClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DescribeVirtualCluster
func (c *EMRContainers) DescribeVirtualClusterRequest(input *DescribeVirtualClusterInput) (req *request.Request, output *DescribeVirtualClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/virtualclusters/{virtualClusterId}",
	}

	if input == nil {
		input = &DescribeVirtualClusterInput{}
	}

	output = &DescribeVirtualClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualCluster API operation for Amazon EMR Containers.
//
// Displays detailed information about a specified virtual cluster. Virtual
// cluster is a managed entity on Amazon EMR on EKS. You can create, describe,
// list and delete virtual clusters. They do not consume any additional resource
// in your system. A single virtual cluster maps to a single Kubernetes namespace.
// Given this relationship, you can model virtual clusters the same way you
// model Kubernetes namespaces to meet your requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation DescribeVirtualCluster for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/DescribeVirtualCluster
func (c *EMRContainers) DescribeVirtualCluster(input *DescribeVirtualClusterInput) (*DescribeVirtualClusterOutput, error) {
	req, out := c.DescribeVirtualClusterRequest(input)
	return out, req.Send()
}

// DescribeVirtualClusterWithContext is the same as DescribeVirtualCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVirtualCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) DescribeVirtualClusterWithContext(ctx aws.Context, input *DescribeVirtualClusterInput, opts ...request.Option) (*DescribeVirtualClusterOutput, error) {
	req, out := c.DescribeVirtualClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobRuns = "ListJobRuns"

// ListJobRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobRuns for more information on using the ListJobRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobRunsRequest method.
//	req, resp := client.ListJobRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListJobRuns
func (c *EMRContainers) ListJobRunsRequest(input *ListJobRunsInput) (req *request.Request, output *ListJobRunsOutput) {
	op := &request.Operation{
		Name:       opListJobRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/jobruns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobRunsInput{}
	}

	output = &ListJobRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobRuns API operation for Amazon EMR Containers.
//
// Lists job runs based on a set of parameters. A job run is a unit of work,
// such as a Spark jar, PySpark script, or SparkSQL query, that you submit to
// Amazon EMR on EKS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation ListJobRuns for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListJobRuns
func (c *EMRContainers) ListJobRuns(input *ListJobRunsInput) (*ListJobRunsOutput, error) {
	req, out := c.ListJobRunsRequest(input)
	return out, req.Send()
}

// ListJobRunsWithContext is the same as ListJobRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListJobRunsWithContext(ctx aws.Context, input *ListJobRunsInput, opts ...request.Option) (*ListJobRunsOutput, error) {
	req, out := c.ListJobRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobRunsPages iterates over the pages of a ListJobRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobRuns operation.
//	pageNum := 0
//	err := client.ListJobRunsPages(params,
//	    func(page *emrcontainers.ListJobRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EMRContainers) ListJobRunsPages(input *ListJobRunsInput, fn func(*ListJobRunsOutput, bool) bool) error {
	return c.ListJobRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobRunsPagesWithContext same as ListJobRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListJobRunsPagesWithContext(ctx aws.Context, input *ListJobRunsInput, fn func(*ListJobRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListManagedEndpoints = "ListManagedEndpoints"

// ListManagedEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedEndpoints for more information on using the ListManagedEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListManagedEndpointsRequest method.
//	req, resp := client.ListManagedEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListManagedEndpoints
func (c *EMRContainers) ListManagedEndpointsRequest(input *ListManagedEndpointsInput) (req *request.Request, output *ListManagedEndpointsOutput) {
	op := &request.Operation{
		Name:       opListManagedEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/endpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedEndpointsInput{}
	}

	output = &ListManagedEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedEndpoints API operation for Amazon EMR Containers.
//
// Lists managed endpoints based on a set of parameters. A managed endpoint
// is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio
// can communicate with your virtual cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation ListManagedEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListManagedEndpoints
func (c *EMRContainers) ListManagedEndpoints(input *ListManagedEndpointsInput) (*ListManagedEndpointsOutput, error) {
	req, out := c.ListManagedEndpointsRequest(input)
	return out, req.Send()
}

// ListManagedEndpointsWithContext is the same as ListManagedEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListManagedEndpointsWithContext(ctx aws.Context, input *ListManagedEndpointsInput, opts ...request.Option) (*ListManagedEndpointsOutput, error) {
	req, out := c.ListManagedEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListManagedEndpointsPages iterates over the pages of a ListManagedEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListManagedEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListManagedEndpoints operation.
//	pageNum := 0
//	err := client.ListManagedEndpointsPages(params,
//	    func(page *emrcontainers.ListManagedEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EMRContainers) ListManagedEndpointsPages(input *ListManagedEndpointsInput, fn func(*ListManagedEndpointsOutput, bool) bool) error {
	return c.ListManagedEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListManagedEndpointsPagesWithContext same as ListManagedEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListManagedEndpointsPagesWithContext(ctx aws.Context, input *ListManagedEndpointsInput, fn func(*ListManagedEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListManagedEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListManagedEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListManagedEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListTagsForResource
func (c *EMRContainers) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon EMR Containers.
//
// Lists the tags assigned to the resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This is an internal server exception.
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListTagsForResource
func (c *EMRContainers) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVirtualClusters = "ListVirtualClusters"

// ListVirtualClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVirtualClusters for more information on using the ListVirtualClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVirtualClustersRequest method.
//	req, resp := client.ListVirtualClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListVirtualClusters
func (c *EMRContainers) ListVirtualClustersRequest(input *ListVirtualClustersInput) (req *request.Request, output *ListVirtualClustersOutput) {
	op := &request.Operation{
		Name:       opListVirtualClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/virtualclusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVirtualClustersInput{}
	}

	output = &ListVirtualClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualClusters API operation for Amazon EMR Containers.
//
// Lists information about the specified virtual cluster. Virtual cluster is
// a managed entity on Amazon EMR on EKS. You can create, describe, list and
// delete virtual clusters. They do not consume any additional resource in your
// system. A single virtual cluster maps to a single Kubernetes namespace. Given
// this relationship, you can model virtual clusters the same way you model
// Kubernetes namespaces to meet your requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation ListVirtualClusters for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/ListVirtualClusters
func (c *EMRContainers) ListVirtualClusters(input *ListVirtualClustersInput) (*ListVirtualClustersOutput, error) {
	req, out := c.ListVirtualClustersRequest(input)
	return out, req.Send()
}

// ListVirtualClustersWithContext is the same as ListVirtualClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVirtualClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListVirtualClustersWithContext(ctx aws.Context, input *ListVirtualClustersInput, opts ...request.Option) (*ListVirtualClustersOutput, error) {
	req, out := c.ListVirtualClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVirtualClustersPages iterates over the pages of a ListVirtualClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVirtualClusters operation.
//	pageNum := 0
//	err := client.ListVirtualClustersPages(params,
//	    func(page *emrcontainers.ListVirtualClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EMRContainers) ListVirtualClustersPages(input *ListVirtualClustersInput, fn func(*ListVirtualClustersOutput, bool) bool) error {
	return c.ListVirtualClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVirtualClustersPagesWithContext same as ListVirtualClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) ListVirtualClustersPagesWithContext(ctx aws.Context, input *ListVirtualClustersInput, fn func(*ListVirtualClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVirtualClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVirtualClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVirtualClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartJobRun = "StartJobRun"

// StartJobRunRequest generates a "aws/request.Request" representing the
// client's request for the StartJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJobRun for more information on using the StartJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartJobRunRequest method.
//	req, resp := client.StartJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/StartJobRun
func (c *EMRContainers) StartJobRunRequest(input *StartJobRunInput) (req *request.Request, output *StartJobRunOutput) {
	op := &request.Operation{
		Name:       opStartJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/virtualclusters/{virtualClusterId}/jobruns",
	}

	if input == nil {
		input = &StartJobRunInput{}
	}

	output = &StartJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartJobRun API operation for Amazon EMR Containers.
//
// Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark
// script, or SparkSQL query, that you submit to Amazon EMR on EKS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation StartJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     This is an internal server exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/StartJobRun
func (c *EMRContainers) StartJobRun(input *StartJobRunInput) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	return out, req.Send()
}

// StartJobRunWithContext is the same as StartJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) StartJobRunWithContext(ctx aws.Context, input *StartJobRunInput, opts ...request.Option) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/TagResource
func (c *EMRContainers) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon EMR Containers.
//
// Assigns tags to resources. A tag is a label that you assign to an AWS resource.
// Each tag consists of a key and an optional value, both of which you define.
// Tags enable you to categorize your AWS resources by attributes such as purpose,
// owner, or environment. When you have many resources of the same type, you
// can quickly identify a specific resource based on the tags you've assigned
// to it. For example, you can define a set of tags for your Amazon EMR on EKS
// clusters to help you track each cluster's owner and stack level. We recommend
// that you devise a consistent set of tag keys for each resource type. You
// can then search and filter the resources based on the tags that you add.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This is an internal server exception.
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/TagResource
func (c *EMRContainers) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/UntagResource
func (c *EMRContainers) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon EMR Containers.
//
// Removes tags from resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EMR Containers's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This is an internal server exception.
//
//   - ValidationException
//     There are invalid parameters in the client request.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/UntagResource
func (c *EMRContainers) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRContainers) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CancelJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the job run to cancel.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"jobRunId" min:"1" type:"string" required:"true"`

	// The ID of the virtual cluster for which the job run will be canceled.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobRunInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CancelJobRunInput) SetId(v string) *CancelJobRunInput {
	s.Id = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *CancelJobRunInput) SetVirtualClusterId(v string) *CancelJobRunInput {
	s.VirtualClusterId = &v
	return s
}

type CancelJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The output contains the ID of the cancelled job run.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The output contains the virtual cluster ID for which the job run is cancelled.
	VirtualClusterId *string `locationName:"virtualClusterId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CancelJobRunOutput) SetId(v string) *CancelJobRunOutput {
	s.Id = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *CancelJobRunOutput) SetVirtualClusterId(v string) *CancelJobRunOutput {
	s.VirtualClusterId = &v
	return s
}

// The entity representing certificate data generated for managed endpoint.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate generated for managed endpoint.
	CertificateArn *string `locationName:"certificateArn" min:"44" type:"string"`

	// The base64 encoded PEM certificate data generated for managed endpoint.
	CertificateData *string `locationName:"certificateData" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateData sets the CertificateData field's value.
func (s *Certificate) SetCertificateData(v string) *Certificate {
	s.CertificateData = &v
	return s
}

// A configuration for CloudWatch monitoring. You can configure your jobs to
// send log information to CloudWatch Logs.
type CloudWatchMonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the log group for log publishing.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The specified name prefix for log streams.
	LogStreamNamePrefix *string `locationName:"logStreamNamePrefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchMonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchMonitoringConfiguration"}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.LogStreamNamePrefix != nil && len(*s.LogStreamNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogStreamNamePrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchMonitoringConfiguration) SetLogGroupName(v string) *CloudWatchMonitoringConfiguration {
	s.LogGroupName = &v
	return s
}

// SetLogStreamNamePrefix sets the LogStreamNamePrefix field's value.
func (s *CloudWatchMonitoringConfiguration) SetLogStreamNamePrefix(v string) *CloudWatchMonitoringConfiguration {
	s.LogStreamNamePrefix = &v
	return s
}

// A configuration specification to be used when provisioning virtual clusters,
// which can include configurations for applications and software bundled with
// Amazon EMR on EKS. A configuration consists of a classification, properties,
// and optional nested configurations. A classification refers to an application-specific
// configuration file. Properties are the settings you want to change in that
// file.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The classification within a configuration.
	//
	// Classification is a required field
	Classification *string `locationName:"classification" min:"1" type:"string" required:"true"`

	// A list of additional configurations to apply within a configuration object.
	Configurations []*Configuration `locationName:"configurations" type:"list"`

	// A set of properties specified within a configuration classification.
	//
	// Properties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Configuration's
	// String and GoString methods.
	Properties map[string]*string `locationName:"properties" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Configuration"}
	if s.Classification == nil {
		invalidParams.Add(request.NewErrParamRequired("Classification"))
	}
	if s.Classification != nil && len(*s.Classification) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Classification", 1))
	}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *Configuration) SetClassification(v string) *Configuration {
	s.Classification = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *Configuration) SetConfigurations(v []*Configuration) *Configuration {
	s.Configurations = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Configuration) SetProperties(v map[string]*string) *Configuration {
	s.Properties = v
	return s
}

// A configuration specification to be used to override existing configurations.
type ConfigurationOverrides struct {
	_ struct{} `type:"structure"`

	// The configurations for the application running by the job run.
	ApplicationConfiguration []*Configuration `locationName:"applicationConfiguration" type:"list"`

	// The configurations for monitoring.
	MonitoringConfiguration *MonitoringConfiguration `locationName:"monitoringConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationOverrides"}
	if s.ApplicationConfiguration != nil {
		for i, v := range s.ApplicationConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ApplicationConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MonitoringConfiguration != nil {
		if err := s.MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfiguration sets the ApplicationConfiguration field's value.
func (s *ConfigurationOverrides) SetApplicationConfiguration(v []*Configuration) *ConfigurationOverrides {
	s.ApplicationConfiguration = v
	return s
}

// SetMonitoringConfiguration sets the MonitoringConfiguration field's value.
func (s *ConfigurationOverrides) SetMonitoringConfiguration(v *MonitoringConfiguration) *ConfigurationOverrides {
	s.MonitoringConfiguration = v
	return s
}

// The information about the container used for a job run or a managed endpoint.
type ContainerInfo struct {
	_ struct{} `type:"structure"`

	// The information about the EKS cluster.
	EksInfo *EksInfo `locationName:"eksInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerInfo"}
	if s.EksInfo != nil {
		if err := s.EksInfo.Validate(); err != nil {
			invalidParams.AddNested("EksInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEksInfo sets the EksInfo field's value.
func (s *ContainerInfo) SetEksInfo(v *EksInfo) *ContainerInfo {
	s.EksInfo = v
	return s
}

// The information about the container provider.
type ContainerProvider struct {
	_ struct{} `type:"structure"`

	// The ID of the container cluster.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The information about the container cluster.
	Info *ContainerInfo `locationName:"info" type:"structure"`

	// The type of the container provider. EKS is the only supported type as of
	// now.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ContainerProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProvider"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Info != nil {
		if err := s.Info.Validate(); err != nil {
			invalidParams.AddNested("Info", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ContainerProvider) SetId(v string) *ContainerProvider {
	s.Id = &v
	return s
}

// SetInfo sets the Info field's value.
func (s *ContainerProvider) SetInfo(v *ContainerInfo) *ContainerProvider {
	s.Info = v
	return s
}

// SetType sets the Type field's value.
func (s *ContainerProvider) SetType(v string) *ContainerProvider {
	s.Type = &v
	return s
}

type CreateManagedEndpointInput struct {
	_ struct{} `type:"structure"`

	// The certificate ARN provided by users for the managed endpoint. This field
	// is under deprecation and will be removed in future releases.
	//
	// Deprecated: Customer provided certificate-arn is deprecated and would be removed in future.
	CertificateArn *string `locationName:"certificateArn" min:"44" deprecated:"true" type:"string"`

	// The client idempotency token for this create call.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration settings that will be used to override existing configurations.
	ConfigurationOverrides *ConfigurationOverrides `locationName:"configurationOverrides" type:"structure"`

	// The ARN of the execution role.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string" required:"true"`

	// The name of the managed endpoint.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon EMR release version.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The tags of the managed endpoint.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the managed endpoint.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`

	// The ID of the virtual cluster for which a managed endpoint is created.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateManagedEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateManagedEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateManagedEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateManagedEndpointInput"}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 44 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 44))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ReleaseLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("ReleaseLabel"))
	}
	if s.ReleaseLabel != nil && len(*s.ReleaseLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReleaseLabel", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}
	if s.ConfigurationOverrides != nil {
		if err := s.ConfigurationOverrides.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationOverrides", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateManagedEndpointInput) SetCertificateArn(v string) *CreateManagedEndpointInput {
	s.CertificateArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateManagedEndpointInput) SetClientToken(v string) *CreateManagedEndpointInput {
	s.ClientToken = &v
	return s
}

// SetConfigurationOverrides sets the ConfigurationOverrides field's value.
func (s *CreateManagedEndpointInput) SetConfigurationOverrides(v *ConfigurationOverrides) *CreateManagedEndpointInput {
	s.ConfigurationOverrides = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateManagedEndpointInput) SetExecutionRoleArn(v string) *CreateManagedEndpointInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateManagedEndpointInput) SetName(v string) *CreateManagedEndpointInput {
	s.Name = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *CreateManagedEndpointInput) SetReleaseLabel(v string) *CreateManagedEndpointInput {
	s.ReleaseLabel = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateManagedEndpointInput) SetTags(v map[string]*string) *CreateManagedEndpointInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateManagedEndpointInput) SetType(v string) *CreateManagedEndpointInput {
	s.Type = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *CreateManagedEndpointInput) SetVirtualClusterId(v string) *CreateManagedEndpointInput {
	s.VirtualClusterId = &v
	return s
}

type CreateManagedEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The output contains the ARN of the managed endpoint.
	Arn *string `locationName:"arn" min:"60" type:"string"`

	// The output contains the ID of the managed endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The output contains the name of the managed endpoint.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The output contains the ID of the virtual cluster.
	VirtualClusterId *string `locationName:"virtualClusterId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateManagedEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateManagedEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateManagedEndpointOutput) SetArn(v string) *CreateManagedEndpointOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateManagedEndpointOutput) SetId(v string) *CreateManagedEndpointOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateManagedEndpointOutput) SetName(v string) *CreateManagedEndpointOutput {
	s.Name = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *CreateManagedEndpointOutput) SetVirtualClusterId(v string) *CreateManagedEndpointOutput {
	s.VirtualClusterId = &v
	return s
}

type CreateVirtualClusterInput struct {
	_ struct{} `type:"structure"`

	// The client token of the virtual cluster.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The container provider of the virtual cluster.
	//
	// ContainerProvider is a required field
	ContainerProvider *ContainerProvider `locationName:"containerProvider" type:"structure" required:"true"`

	// The specified name of the virtual cluster.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The tags assigned to the virtual cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualClusterInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ContainerProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerProvider"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ContainerProvider != nil {
		if err := s.ContainerProvider.Validate(); err != nil {
			invalidParams.AddNested("ContainerProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVirtualClusterInput) SetClientToken(v string) *CreateVirtualClusterInput {
	s.ClientToken = &v
	return s
}

// SetContainerProvider sets the ContainerProvider field's value.
func (s *CreateVirtualClusterInput) SetContainerProvider(v *ContainerProvider) *CreateVirtualClusterInput {
	s.ContainerProvider = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVirtualClusterInput) SetName(v string) *CreateVirtualClusterInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVirtualClusterInput) SetTags(v map[string]*string) *CreateVirtualClusterInput {
	s.Tags = v
	return s
}

type CreateVirtualClusterOutput struct {
	_ struct{} `type:"structure"`

	// This output contains the ARN of virtual cluster.
	Arn *string `locationName:"arn" min:"60" type:"string"`

	// This output contains the virtual cluster ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// This output contains the name of the virtual cluster.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVirtualClusterOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateVirtualClusterOutput) SetArn(v string) *CreateVirtualClusterOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateVirtualClusterOutput) SetId(v string) *CreateVirtualClusterOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVirtualClusterOutput) SetName(v string) *CreateVirtualClusterOutput {
	s.Name = &v
	return s
}

type DeleteManagedEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the managed endpoint.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"endpointId" min:"1" type:"string" required:"true"`

	// The ID of the endpoint's virtual cluster.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteManagedEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteManagedEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteManagedEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteManagedEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteManagedEndpointInput) SetId(v string) *DeleteManagedEndpointInput {
	s.Id = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *DeleteManagedEndpointInput) SetVirtualClusterId(v string) *DeleteManagedEndpointInput {
	s.VirtualClusterId = &v
	return s
}

type DeleteManagedEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The output displays the ID of the managed endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The output displays the ID of the endpoint's virtual cluster.
	VirtualClusterId *string `locationName:"virtualClusterId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteManagedEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteManagedEndpointOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteManagedEndpointOutput) SetId(v string) *DeleteManagedEndpointOutput {
	s.Id = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *DeleteManagedEndpointOutput) SetVirtualClusterId(v string) *DeleteManagedEndpointOutput {
	s.VirtualClusterId = &v
	return s
}

type DeleteVirtualClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the virtual cluster that will be deleted.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualClusterInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteVirtualClusterInput) SetId(v string) *DeleteVirtualClusterInput {
	s.Id = &v
	return s
}

type DeleteVirtualClusterOutput struct {
	_ struct{} `type:"structure"`

	// This output contains the ID of the virtual cluster that will be deleted.
	Id *string `locationName:"id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVirtualClusterOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteVirtualClusterOutput) SetId(v string) *DeleteVirtualClusterOutput {
	s.Id = &v
	return s
}

type DescribeJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the job run request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"jobRunId" min:"1" type:"string" required:"true"`

	// The ID of the virtual cluster for which the job run is submitted.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobRunInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeJobRunInput) SetId(v string) *DescribeJobRunInput {
	s.Id = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *DescribeJobRunInput) SetVirtualClusterId(v string) *DescribeJobRunInput {
	s.VirtualClusterId = &v
	return s
}

type DescribeJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The output displays information about a job run.
	JobRun *JobRun `locationName:"jobRun" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunOutput) GoString() string {
	return s.String()
}

// SetJobRun sets the JobRun field's value.
func (s *DescribeJobRunOutput) SetJobRun(v *JobRun) *DescribeJobRunOutput {
	s.JobRun = v
	return s
}

type DescribeManagedEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This output displays ID of the managed endpoint.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"endpointId" min:"1" type:"string" required:"true"`

	// The ID of the endpoint's virtual cluster.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeManagedEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeManagedEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeManagedEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeManagedEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeManagedEndpointInput) SetId(v string) *DescribeManagedEndpointInput {
	s.Id = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *DescribeManagedEndpointInput) SetVirtualClusterId(v string) *DescribeManagedEndpointInput {
	s.VirtualClusterId = &v
	return s
}

type DescribeManagedEndpointOutput struct {
	_ struct{} `type:"structure"`

	// This output displays information about a managed endpoint.
	Endpoint *Endpoint `locationName:"endpoint" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeManagedEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeManagedEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DescribeManagedEndpointOutput) SetEndpoint(v *Endpoint) *DescribeManagedEndpointOutput {
	s.Endpoint = v
	return s
}

type DescribeVirtualClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the virtual cluster that will be described.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVirtualClusterInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeVirtualClusterInput) SetId(v string) *DescribeVirtualClusterInput {
	s.Id = &v
	return s
}

type DescribeVirtualClusterOutput struct {
	_ struct{} `type:"structure"`

	// This output displays information about the specified virtual cluster.
	VirtualCluster *VirtualCluster `locationName:"virtualCluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVirtualClusterOutput) GoString() string {
	return s.String()
}

// SetVirtualCluster sets the VirtualCluster field's value.
func (s *DescribeVirtualClusterOutput) SetVirtualCluster(v *VirtualCluster) *DescribeVirtualClusterOutput {
	s.VirtualCluster = v
	return s
}

// The information about the EKS cluster.
type EksInfo struct {
	_ struct{} `type:"structure"`

	// The namespaces of the EKS cluster.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksInfo"}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespace sets the Namespace field's value.
func (s *EksInfo) SetNamespace(v string) *EksInfo {
	s.Namespace = &v
	return s
}

// This entity represents the endpoint that is managed by Amazon EMR on EKS.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The ARN of the endpoint.
	Arn *string `locationName:"arn" min:"60" type:"string"`

	// The certificate ARN of the endpoint. This field is under deprecation and
	// will be removed in future.
	//
	// Deprecated: Customer provided certificate-arn is deprecated and would be removed in future.
	CertificateArn *string `locationName:"certificateArn" min:"44" deprecated:"true" type:"string"`

	// The certificate generated by emr control plane on customer behalf to secure
	// the managed endpoint.
	CertificateAuthority *Certificate `locationName:"certificateAuthority" type:"structure"`

	// The configuration settings that are used to override existing configurations
	// for endpoints.
	ConfigurationOverrides *ConfigurationOverrides `locationName:"configurationOverrides" type:"structure"`

	// The date and time when the endpoint was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The execution role ARN of the endpoint.
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string"`

	// The reasons why the endpoint has failed.
	FailureReason *string `locationName:"failureReason" type:"string" enum:"FailureReason"`

	// The ID of the endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the endpoint.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The EMR release version to be used for the endpoint.
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string"`

	// The security group configuration of the endpoint.
	SecurityGroup *string `locationName:"securityGroup" min:"1" type:"string"`

	// The server URL of the endpoint.
	ServerUrl *string `locationName:"serverUrl" min:"1" type:"string"`

	// The state of the endpoint.
	State *string `locationName:"state" type:"string" enum:"EndpointState"`

	// Additional details of the endpoint state.
	StateDetails *string `locationName:"stateDetails" min:"1" type:"string"`

	// The subnet IDs of the endpoint.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The tags of the endpoint.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the endpoint.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The ID of the endpoint's virtual cluster.
	VirtualClusterId *string `locationName:"virtualClusterId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Endpoint) SetArn(v string) *Endpoint {
	s.Arn = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Endpoint) SetCertificateArn(v string) *Endpoint {
	s.CertificateArn = &v
	return s
}

// SetCertificateAuthority sets the CertificateAuthority field's value.
func (s *Endpoint) SetCertificateAuthority(v *Certificate) *Endpoint {
	s.CertificateAuthority = v
	return s
}

// SetConfigurationOverrides sets the ConfigurationOverrides field's value.
func (s *Endpoint) SetConfigurationOverrides(v *ConfigurationOverrides) *Endpoint {
	s.ConfigurationOverrides = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Endpoint) SetCreatedAt(v time.Time) *Endpoint {
	s.CreatedAt = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *Endpoint) SetExecutionRoleArn(v string) *Endpoint {
	s.ExecutionRoleArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Endpoint) SetFailureReason(v string) *Endpoint {
	s.FailureReason = &v
	return s
}

// SetId sets the Id field's value.
func (s *Endpoint) SetId(v string) *Endpoint {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Endpoint) SetName(v string) *Endpoint {
	s.Name = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *Endpoint) SetReleaseLabel(v string) *Endpoint {
	s.ReleaseLabel = &v
	return s
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *Endpoint) SetSecurityGroup(v string) *Endpoint {
	s.SecurityGroup = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *Endpoint) SetServerUrl(v string) *Endpoint {
	s.ServerUrl = &v
	return s
}

// SetState sets the State field's value.
func (s *Endpoint) SetState(v string) *Endpoint {
	s.State = &v
	return s
}

// SetStateDetails sets the StateDetails field's value.
func (s *Endpoint) SetStateDetails(v string) *Endpoint {
	s.StateDetails = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *Endpoint) SetSubnetIds(v []*string) *Endpoint {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Endpoint) SetTags(v map[string]*string) *Endpoint {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Endpoint) SetType(v string) *Endpoint {
	s.Type = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *Endpoint) SetVirtualClusterId(v string) *Endpoint {
	s.VirtualClusterId = &v
	return s
}

// This is an internal server exception.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specify the driver that the job runs on.
type JobDriver struct {
	_ struct{} `type:"structure"`

	// The job driver for job type.
	SparkSqlJobDriver *SparkSqlJobDriver `locationName:"sparkSqlJobDriver" type:"structure"`

	// The job driver parameters specified for spark submit.
	SparkSubmitJobDriver *SparkSubmitJobDriver `locationName:"sparkSubmitJobDriver" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDriver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDriver) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobDriver) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobDriver"}
	if s.SparkSqlJobDriver != nil {
		if err := s.SparkSqlJobDriver.Validate(); err != nil {
			invalidParams.AddNested("SparkSqlJobDriver", err.(request.ErrInvalidParams))
		}
	}
	if s.SparkSubmitJobDriver != nil {
		if err := s.SparkSubmitJobDriver.Validate(); err != nil {
			invalidParams.AddNested("SparkSubmitJobDriver", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSparkSqlJobDriver sets the SparkSqlJobDriver field's value.
func (s *JobDriver) SetSparkSqlJobDriver(v *SparkSqlJobDriver) *JobDriver {
	s.SparkSqlJobDriver = v
	return s
}

// SetSparkSubmitJobDriver sets the SparkSubmitJobDriver field's value.
func (s *JobDriver) SetSparkSubmitJobDriver(v *SparkSubmitJobDriver) *JobDriver {
	s.SparkSubmitJobDriver = v
	return s
}

// This entity describes a job run. A job run is a unit of work, such as a Spark
// jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on
// EKS.
type JobRun struct {
	_ struct{} `type:"structure"`

	// The ARN of job run.
	Arn *string `locationName:"arn" min:"60" type:"string"`

	// The client token used to start a job run.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The configuration settings that are used to override default configuration.
	ConfigurationOverrides *ConfigurationOverrides `locationName:"configurationOverrides" type:"structure"`

	// The date and time when the job run was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user who created the job run.
	CreatedBy *string `locationName:"createdBy" min:"20" type:"string"`

	// The execution role ARN of the job run.
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string"`

	// The reasons why the job run has failed.
	FailureReason *string `locationName:"failureReason" type:"string" enum:"FailureReason"`

	// The date and time when the job run has finished.
	FinishedAt *time.Time `locationName:"finishedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the job run.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Parameters of job driver for the job run.
	JobDriver *JobDriver `locationName:"jobDriver" type:"structure"`

	// The name of the job run.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The release version of Amazon EMR.
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string"`

	// The state of the job run.
	State *string `locationName:"state" type:"string" enum:"JobRunState"`

	// Additional details of the job run state.
	StateDetails *string `locationName:"stateDetails" min:"1" type:"string"`

	// The assigned tags of the job run.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the job run's virtual cluster.
	VirtualClusterId *string `locationName:"virtualClusterId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRun) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *JobRun) SetArn(v string) *JobRun {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *JobRun) SetClientToken(v string) *JobRun {
	s.ClientToken = &v
	return s
}

// SetConfigurationOverrides sets the ConfigurationOverrides field's value.
func (s *JobRun) SetConfigurationOverrides(v *ConfigurationOverrides) *JobRun {
	s.ConfigurationOverrides = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobRun) SetCreatedAt(v time.Time) *JobRun {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *JobRun) SetCreatedBy(v string) *JobRun {
	s.CreatedBy = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *JobRun) SetExecutionRoleArn(v string) *JobRun {
	s.ExecutionRoleArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *JobRun) SetFailureReason(v string) *JobRun {
	s.FailureReason = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *JobRun) SetFinishedAt(v time.Time) *JobRun {
	s.FinishedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *JobRun) SetId(v string) *JobRun {
	s.Id = &v
	return s
}

// SetJobDriver sets the JobDriver field's value.
func (s *JobRun) SetJobDriver(v *JobDriver) *JobRun {
	s.JobDriver = v
	return s
}

// SetName sets the Name field's value.
func (s *JobRun) SetName(v string) *JobRun {
	s.Name = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *JobRun) SetReleaseLabel(v string) *JobRun {
	s.ReleaseLabel = &v
	return s
}

// SetState sets the State field's value.
func (s *JobRun) SetState(v string) *JobRun {
	s.State = &v
	return s
}

// SetStateDetails sets the StateDetails field's value.
func (s *JobRun) SetStateDetails(v string) *JobRun {
	s.StateDetails = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JobRun) SetTags(v map[string]*string) *JobRun {
	s.Tags = v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *JobRun) SetVirtualClusterId(v string) *JobRun {
	s.VirtualClusterId = &v
	return s
}

type ListJobRunsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The date and time after which the job runs were submitted.
	CreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time before which the job runs were submitted.
	CreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of job runs that can be listed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The name of the job run.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The token for the next set of job runs to return.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The states of the job run.
	States []*string `location:"querystring" locationName:"states" type:"list" enum:"JobRunState"`

	// The ID of the virtual cluster for which to list the job run.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobRunsInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ListJobRunsInput) SetCreatedAfter(v time.Time) *ListJobRunsInput {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ListJobRunsInput) SetCreatedBefore(v time.Time) *ListJobRunsInput {
	s.CreatedBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobRunsInput) SetMaxResults(v int64) *ListJobRunsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListJobRunsInput) SetName(v string) *ListJobRunsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobRunsInput) SetNextToken(v string) *ListJobRunsInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListJobRunsInput) SetStates(v []*string) *ListJobRunsInput {
	s.States = v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *ListJobRunsInput) SetVirtualClusterId(v string) *ListJobRunsInput {
	s.VirtualClusterId = &v
	return s
}

type ListJobRunsOutput struct {
	_ struct{} `type:"structure"`

	// This output lists information about the specified job runs.
	JobRuns []*JobRun `locationName:"jobRuns" type:"list"`

	// This output displays the token for the next set of job runs.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsOutput) GoString() string {
	return s.String()
}

// SetJobRuns sets the JobRuns field's value.
func (s *ListJobRunsOutput) SetJobRuns(v []*JobRun) *ListJobRunsOutput {
	s.JobRuns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobRunsOutput) SetNextToken(v string) *ListJobRunsOutput {
	s.NextToken = &v
	return s
}

type ListManagedEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The date and time after which the endpoints are created.
	CreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time before which the endpoints are created.
	CreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of managed endpoints that can be listed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The token for the next set of managed endpoints to return.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The states of the managed endpoints.
	States []*string `location:"querystring" locationName:"states" type:"list" enum:"EndpointState"`

	// The types of the managed endpoints.
	Types []*string `location:"querystring" locationName:"types" type:"list"`

	// The ID of the virtual cluster.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedEndpointsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ListManagedEndpointsInput) SetCreatedAfter(v time.Time) *ListManagedEndpointsInput {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ListManagedEndpointsInput) SetCreatedBefore(v time.Time) *ListManagedEndpointsInput {
	s.CreatedBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListManagedEndpointsInput) SetMaxResults(v int64) *ListManagedEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedEndpointsInput) SetNextToken(v string) *ListManagedEndpointsInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListManagedEndpointsInput) SetStates(v []*string) *ListManagedEndpointsInput {
	s.States = v
	return s
}

// SetTypes sets the Types field's value.
func (s *ListManagedEndpointsInput) SetTypes(v []*string) *ListManagedEndpointsInput {
	s.Types = v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *ListManagedEndpointsInput) SetVirtualClusterId(v string) *ListManagedEndpointsInput {
	s.VirtualClusterId = &v
	return s
}

type ListManagedEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The managed endpoints to be listed.
	Endpoints []*Endpoint `locationName:"endpoints" type:"list"`

	// The token for the next set of endpoints to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListManagedEndpointsOutput) SetEndpoints(v []*Endpoint) *ListManagedEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedEndpointsOutput) SetNextToken(v string) *ListManagedEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of tagged resources.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"60" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 60 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags assigned to resources.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVirtualClustersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The container provider ID of the virtual cluster.
	ContainerProviderId *string `location:"querystring" locationName:"containerProviderId" min:"1" type:"string"`

	// The container provider type of the virtual cluster. EKS is the only supported
	// type as of now.
	ContainerProviderType *string `location:"querystring" locationName:"containerProviderType" type:"string" enum:"ContainerProviderType"`

	// The date and time after which the virtual clusters are created.
	CreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp" timestampFormat:"iso8601"`

	// The date and time before which the virtual clusters are created.
	CreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of virtual clusters that can be listed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The token for the next set of virtual clusters to return.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The states of the requested virtual clusters.
	States []*string `location:"querystring" locationName:"states" type:"list" enum:"VirtualClusterState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualClustersInput"}
	if s.ContainerProviderId != nil && len(*s.ContainerProviderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerProviderId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerProviderId sets the ContainerProviderId field's value.
func (s *ListVirtualClustersInput) SetContainerProviderId(v string) *ListVirtualClustersInput {
	s.ContainerProviderId = &v
	return s
}

// SetContainerProviderType sets the ContainerProviderType field's value.
func (s *ListVirtualClustersInput) SetContainerProviderType(v string) *ListVirtualClustersInput {
	s.ContainerProviderType = &v
	return s
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ListVirtualClustersInput) SetCreatedAfter(v time.Time) *ListVirtualClustersInput {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ListVirtualClustersInput) SetCreatedBefore(v time.Time) *ListVirtualClustersInput {
	s.CreatedBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVirtualClustersInput) SetMaxResults(v int64) *ListVirtualClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualClustersInput) SetNextToken(v string) *ListVirtualClustersInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListVirtualClustersInput) SetStates(v []*string) *ListVirtualClustersInput {
	s.States = v
	return s
}

type ListVirtualClustersOutput struct {
	_ struct{} `type:"structure"`

	// This output displays the token for the next set of virtual clusters.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// This output lists the specified virtual clusters.
	VirtualClusters []*VirtualCluster `locationName:"virtualClusters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVirtualClustersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVirtualClustersOutput) SetNextToken(v string) *ListVirtualClustersOutput {
	s.NextToken = &v
	return s
}

// SetVirtualClusters sets the VirtualClusters field's value.
func (s *ListVirtualClustersOutput) SetVirtualClusters(v []*VirtualCluster) *ListVirtualClustersOutput {
	s.VirtualClusters = v
	return s
}

// Configuration setting for monitoring.
type MonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// Monitoring configurations for CloudWatch.
	CloudWatchMonitoringConfiguration *CloudWatchMonitoringConfiguration `locationName:"cloudWatchMonitoringConfiguration" type:"structure"`

	// Monitoring configurations for the persistent application UI.
	PersistentAppUI *string `locationName:"persistentAppUI" type:"string" enum:"PersistentAppUI"`

	// Amazon S3 configuration for monitoring log publishing.
	S3MonitoringConfiguration *S3MonitoringConfiguration `locationName:"s3MonitoringConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MonitoringConfiguration"}
	if s.CloudWatchMonitoringConfiguration != nil {
		if err := s.CloudWatchMonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchMonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3MonitoringConfiguration != nil {
		if err := s.S3MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3MonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchMonitoringConfiguration sets the CloudWatchMonitoringConfiguration field's value.
func (s *MonitoringConfiguration) SetCloudWatchMonitoringConfiguration(v *CloudWatchMonitoringConfiguration) *MonitoringConfiguration {
	s.CloudWatchMonitoringConfiguration = v
	return s
}

// SetPersistentAppUI sets the PersistentAppUI field's value.
func (s *MonitoringConfiguration) SetPersistentAppUI(v string) *MonitoringConfiguration {
	s.PersistentAppUI = &v
	return s
}

// SetS3MonitoringConfiguration sets the S3MonitoringConfiguration field's value.
func (s *MonitoringConfiguration) SetS3MonitoringConfiguration(v *S3MonitoringConfiguration) *MonitoringConfiguration {
	s.S3MonitoringConfiguration = v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon S3 configuration for monitoring log publishing. You can configure
// your jobs to send log information to Amazon S3.
type S3MonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// Amazon S3 destination URI for log publishing.
	//
	// LogUri is a required field
	LogUri *string `locationName:"logUri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3MonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3MonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3MonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3MonitoringConfiguration"}
	if s.LogUri == nil {
		invalidParams.Add(request.NewErrParamRequired("LogUri"))
	}
	if s.LogUri != nil && len(*s.LogUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogUri sets the LogUri field's value.
func (s *S3MonitoringConfiguration) SetLogUri(v string) *S3MonitoringConfiguration {
	s.LogUri = &v
	return s
}

// The job driver for job type.
type SparkSqlJobDriver struct {
	_ struct{} `type:"structure"`

	// The SQL file to be executed.
	//
	// EntryPoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SparkSqlJobDriver's
	// String and GoString methods.
	EntryPoint *string `locationName:"entryPoint" min:"1" type:"string" sensitive:"true"`

	// The Spark parameters to be included in the Spark SQL command.
	//
	// SparkSqlParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SparkSqlJobDriver's
	// String and GoString methods.
	SparkSqlParameters *string `locationName:"sparkSqlParameters" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparkSqlJobDriver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparkSqlJobDriver) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SparkSqlJobDriver) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SparkSqlJobDriver"}
	if s.EntryPoint != nil && len(*s.EntryPoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryPoint", 1))
	}
	if s.SparkSqlParameters != nil && len(*s.SparkSqlParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SparkSqlParameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *SparkSqlJobDriver) SetEntryPoint(v string) *SparkSqlJobDriver {
	s.EntryPoint = &v
	return s
}

// SetSparkSqlParameters sets the SparkSqlParameters field's value.
func (s *SparkSqlJobDriver) SetSparkSqlParameters(v string) *SparkSqlJobDriver {
	s.SparkSqlParameters = &v
	return s
}

// The information about job driver for Spark submit.
type SparkSubmitJobDriver struct {
	_ struct{} `type:"structure"`

	// The entry point of job application.
	//
	// EntryPoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SparkSubmitJobDriver's
	// String and GoString methods.
	//
	// EntryPoint is a required field
	EntryPoint *string `locationName:"entryPoint" min:"1" type:"string" required:"true" sensitive:"true"`

	// The arguments for job application.
	EntryPointArguments []*string `locationName:"entryPointArguments" type:"list"`

	// The Spark submit parameters that are used for job runs.
	//
	// SparkSubmitParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SparkSubmitJobDriver's
	// String and GoString methods.
	SparkSubmitParameters *string `locationName:"sparkSubmitParameters" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparkSubmitJobDriver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparkSubmitJobDriver) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SparkSubmitJobDriver) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SparkSubmitJobDriver"}
	if s.EntryPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryPoint"))
	}
	if s.EntryPoint != nil && len(*s.EntryPoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryPoint", 1))
	}
	if s.SparkSubmitParameters != nil && len(*s.SparkSubmitParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SparkSubmitParameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *SparkSubmitJobDriver) SetEntryPoint(v string) *SparkSubmitJobDriver {
	s.EntryPoint = &v
	return s
}

// SetEntryPointArguments sets the EntryPointArguments field's value.
func (s *SparkSubmitJobDriver) SetEntryPointArguments(v []*string) *SparkSubmitJobDriver {
	s.EntryPointArguments = v
	return s
}

// SetSparkSubmitParameters sets the SparkSubmitParameters field's value.
func (s *SparkSubmitJobDriver) SetSparkSubmitParameters(v string) *SparkSubmitJobDriver {
	s.SparkSubmitParameters = &v
	return s
}

type StartJobRunInput struct {
	_ struct{} `type:"structure"`

	// The client idempotency token of the job run request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration overrides for the job run.
	ConfigurationOverrides *ConfigurationOverrides `locationName:"configurationOverrides" type:"structure"`

	// The execution role ARN for the job run.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string" required:"true"`

	// The job driver for the job run.
	//
	// JobDriver is a required field
	JobDriver *JobDriver `locationName:"jobDriver" type:"structure" required:"true"`

	// The name of the job run.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon EMR release version to use for the job run.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The tags assigned to job runs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The virtual cluster ID for which the job run request is submitted.
	//
	// VirtualClusterId is a required field
	VirtualClusterId *string `location:"uri" locationName:"virtualClusterId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartJobRunInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.JobDriver == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDriver"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ReleaseLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("ReleaseLabel"))
	}
	if s.ReleaseLabel != nil && len(*s.ReleaseLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReleaseLabel", 1))
	}
	if s.VirtualClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualClusterId"))
	}
	if s.VirtualClusterId != nil && len(*s.VirtualClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualClusterId", 1))
	}
	if s.ConfigurationOverrides != nil {
		if err := s.ConfigurationOverrides.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationOverrides", err.(request.ErrInvalidParams))
		}
	}
	if s.JobDriver != nil {
		if err := s.JobDriver.Validate(); err != nil {
			invalidParams.AddNested("JobDriver", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartJobRunInput) SetClientToken(v string) *StartJobRunInput {
	s.ClientToken = &v
	return s
}

// SetConfigurationOverrides sets the ConfigurationOverrides field's value.
func (s *StartJobRunInput) SetConfigurationOverrides(v *ConfigurationOverrides) *StartJobRunInput {
	s.ConfigurationOverrides = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartJobRunInput) SetExecutionRoleArn(v string) *StartJobRunInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetJobDriver sets the JobDriver field's value.
func (s *StartJobRunInput) SetJobDriver(v *JobDriver) *StartJobRunInput {
	s.JobDriver = v
	return s
}

// SetName sets the Name field's value.
func (s *StartJobRunInput) SetName(v string) *StartJobRunInput {
	s.Name = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *StartJobRunInput) SetReleaseLabel(v string) *StartJobRunInput {
	s.ReleaseLabel = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartJobRunInput) SetTags(v map[string]*string) *StartJobRunInput {
	s.Tags = v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *StartJobRunInput) SetVirtualClusterId(v string) *StartJobRunInput {
	s.VirtualClusterId = &v
	return s
}

type StartJobRunOutput struct {
	_ struct{} `type:"structure"`

	// This output lists the ARN of job run.
	Arn *string `locationName:"arn" min:"60" type:"string"`

	// This output displays the started job run ID.
	Id *string `locationName:"id" min:"1" type:"string"`

	// This output displays the name of the started job run.
	Name *string `locationName:"name" min:"1" type:"string"`

	// This output displays the virtual cluster ID for which the job run was submitted.
	VirtualClusterId *string `locationName:"virtualClusterId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartJobRunOutput) SetArn(v string) *StartJobRunOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartJobRunOutput) SetId(v string) *StartJobRunOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartJobRunOutput) SetName(v string) *StartJobRunOutput {
	s.Name = &v
	return s
}

// SetVirtualClusterId sets the VirtualClusterId field's value.
func (s *StartJobRunOutput) SetVirtualClusterId(v string) *StartJobRunOutput {
	s.VirtualClusterId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of resources.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"60" type:"string" required:"true"`

	// The tags assigned to resources.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 60 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 60))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of resources.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"60" type:"string" required:"true"`

	// The tag keys of the resources.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 60 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 60))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// There are invalid parameters in the client request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This entity describes a virtual cluster. A virtual cluster is a Kubernetes
// namespace that Amazon EMR is registered with. Amazon EMR uses virtual clusters
// to run jobs and host endpoints. Multiple virtual clusters can be backed by
// the same physical cluster. However, each virtual cluster maps to one namespace
// on an EKS cluster. Virtual clusters do not create any active resources that
// contribute to your bill or that require lifecycle management outside the
// service.
type VirtualCluster struct {
	_ struct{} `type:"structure"`

	// The ARN of the virtual cluster.
	Arn *string `locationName:"arn" min:"60" type:"string"`

	// The container provider of the virtual cluster.
	ContainerProvider *ContainerProvider `locationName:"containerProvider" type:"structure"`

	// The date and time when the virtual cluster is created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the virtual cluster.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the virtual cluster.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The state of the virtual cluster.
	State *string `locationName:"state" type:"string" enum:"VirtualClusterState"`

	// The assigned tags of the virtual cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualCluster) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VirtualCluster) SetArn(v string) *VirtualCluster {
	s.Arn = &v
	return s
}

// SetContainerProvider sets the ContainerProvider field's value.
func (s *VirtualCluster) SetContainerProvider(v *ContainerProvider) *VirtualCluster {
	s.ContainerProvider = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *VirtualCluster) SetCreatedAt(v time.Time) *VirtualCluster {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *VirtualCluster) SetId(v string) *VirtualCluster {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *VirtualCluster) SetName(v string) *VirtualCluster {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *VirtualCluster) SetState(v string) *VirtualCluster {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *VirtualCluster) SetTags(v map[string]*string) *VirtualCluster {
	s.Tags = v
	return s
}

const (
	// ContainerProviderTypeEks is a ContainerProviderType enum value
	ContainerProviderTypeEks = "EKS"
)

// ContainerProviderType_Values returns all elements of the ContainerProviderType enum
func ContainerProviderType_Values() []string {
	return []string{
		ContainerProviderTypeEks,
	}
}

const (
	// EndpointStateCreating is a EndpointState enum value
	EndpointStateCreating = "CREATING"

	// EndpointStateActive is a EndpointState enum value
	EndpointStateActive = "ACTIVE"

	// EndpointStateTerminating is a EndpointState enum value
	EndpointStateTerminating = "TERMINATING"

	// EndpointStateTerminated is a EndpointState enum value
	EndpointStateTerminated = "TERMINATED"

	// EndpointStateTerminatedWithErrors is a EndpointState enum value
	EndpointStateTerminatedWithErrors = "TERMINATED_WITH_ERRORS"
)

// EndpointState_Values returns all elements of the EndpointState enum
func EndpointState_Values() []string {
	return []string{
		EndpointStateCreating,
		EndpointStateActive,
		EndpointStateTerminating,
		EndpointStateTerminated,
		EndpointStateTerminatedWithErrors,
	}
}

const (
	// FailureReasonInternalError is a FailureReason enum value
	FailureReasonInternalError = "INTERNAL_ERROR"

	// FailureReasonUserError is a FailureReason enum value
	FailureReasonUserError = "USER_ERROR"

	// FailureReasonValidationError is a FailureReason enum value
	FailureReasonValidationError = "VALIDATION_ERROR"

	// FailureReasonClusterUnavailable is a FailureReason enum value
	FailureReasonClusterUnavailable = "CLUSTER_UNAVAILABLE"
)

// FailureReason_Values returns all elements of the FailureReason enum
func FailureReason_Values() []string {
	return []string{
		FailureReasonInternalError,
		FailureReasonUserError,
		FailureReasonValidationError,
		FailureReasonClusterUnavailable,
	}
}

const (
	// JobRunStatePending is a JobRunState enum value
	JobRunStatePending = "PENDING"

	// JobRunStateSubmitted is a JobRunState enum value
	JobRunStateSubmitted = "SUBMITTED"

	// JobRunStateRunning is a JobRunState enum value
	JobRunStateRunning = "RUNNING"

	// JobRunStateFailed is a JobRunState enum value
	JobRunStateFailed = "FAILED"

	// JobRunStateCancelled is a JobRunState enum value
	JobRunStateCancelled = "CANCELLED"

	// JobRunStateCancelPending is a JobRunState enum value
	JobRunStateCancelPending = "CANCEL_PENDING"

	// JobRunStateCompleted is a JobRunState enum value
	JobRunStateCompleted = "COMPLETED"
)

// JobRunState_Values returns all elements of the JobRunState enum
func JobRunState_Values() []string {
	return []string{
		JobRunStatePending,
		JobRunStateSubmitted,
		JobRunStateRunning,
		JobRunStateFailed,
		JobRunStateCancelled,
		JobRunStateCancelPending,
		JobRunStateCompleted,
	}
}

const (
	// PersistentAppUIEnabled is a PersistentAppUI enum value
	PersistentAppUIEnabled = "ENABLED"

	// PersistentAppUIDisabled is a PersistentAppUI enum value
	PersistentAppUIDisabled = "DISABLED"
)

// PersistentAppUI_Values returns all elements of the PersistentAppUI enum
func PersistentAppUI_Values() []string {
	return []string{
		PersistentAppUIEnabled,
		PersistentAppUIDisabled,
	}
}

const (
	// VirtualClusterStateRunning is a VirtualClusterState enum value
	VirtualClusterStateRunning = "RUNNING"

	// VirtualClusterStateTerminating is a VirtualClusterState enum value
	VirtualClusterStateTerminating = "TERMINATING"

	// VirtualClusterStateTerminated is a VirtualClusterState enum value
	VirtualClusterStateTerminated = "TERMINATED"

	// VirtualClusterStateArrested is a VirtualClusterState enum value
	VirtualClusterStateArrested = "ARRESTED"
)

// VirtualClusterState_Values returns all elements of the VirtualClusterState enum
func VirtualClusterState_Values() []string {
	return []string{
		VirtualClusterStateRunning,
		VirtualClusterStateTerminating,
		VirtualClusterStateTerminated,
		VirtualClusterStateArrested,
	}
}
