//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

pub type NSImageName = NSString;

extern "C" {
    #[cfg(feature = "NSImageRep")]
    pub static NSImageHintCTM: &'static NSImageHintKey;
}

extern "C" {
    #[cfg(feature = "NSImageRep")]
    pub static NSImageHintInterpolation: &'static NSImageHintKey;
}

extern "C" {
    #[cfg(feature = "NSImageRep")]
    pub static NSImageHintUserInterfaceLayoutDirection: &'static NSImageHintKey;
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageLoadStatus(pub NSUInteger);
impl NSImageLoadStatus {
    #[doc(alias = "NSImageLoadStatusCompleted")]
    pub const Completed: Self = Self(0);
    #[doc(alias = "NSImageLoadStatusCancelled")]
    pub const Cancelled: Self = Self(1);
    #[doc(alias = "NSImageLoadStatusInvalidData")]
    pub const InvalidData: Self = Self(2);
    #[doc(alias = "NSImageLoadStatusUnexpectedEOF")]
    pub const UnexpectedEOF: Self = Self(3);
    #[doc(alias = "NSImageLoadStatusReadError")]
    pub const ReadError: Self = Self(4);
}

unsafe impl Encode for NSImageLoadStatus {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSImageLoadStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageCacheMode(pub NSUInteger);
impl NSImageCacheMode {
    pub const NSImageCacheDefault: Self = Self(0);
    pub const NSImageCacheAlways: Self = Self(1);
    pub const NSImageCacheBySize: Self = Self(2);
    pub const NSImageCacheNever: Self = Self(3);
}

unsafe impl Encode for NSImageCacheMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSImageCacheMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSImage;

    unsafe impl ClassType for NSImage {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSObjectProtocol for NSImage {}

extern_methods!(
    unsafe impl NSImage {
        #[method_id(@__retain_semantics Other imageNamed:)]
        pub unsafe fn imageNamed(name: &NSImageName) -> Option<Retained<NSImage>>;

        #[method_id(@__retain_semantics Other imageWithSystemSymbolName:accessibilityDescription:)]
        pub unsafe fn imageWithSystemSymbolName_accessibilityDescription(
            name: &NSString,
            description: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other imageWithSystemSymbolName:variableValue:accessibilityDescription:)]
        pub unsafe fn imageWithSystemSymbolName_variableValue_accessibilityDescription(
            name: &NSString,
            value: c_double,
            description: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other imageWithSymbolName:variableValue:)]
        pub unsafe fn imageWithSymbolName_variableValue(
            name: &NSString,
            value: c_double,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other imageWithSymbolName:bundle:variableValue:)]
        pub unsafe fn imageWithSymbolName_bundle_variableValue(
            name: &NSString,
            bundle: Option<&NSBundle>,
            value: c_double,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithSize:)]
        pub unsafe fn initWithSize(this: Allocated<Self>, size: NSSize) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithData:)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithContentsOfFile:)]
        pub unsafe fn initWithContentsOfFile(
            this: Allocated<Self>,
            file_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithContentsOfURL:)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initByReferencingFile:)]
        pub fn initByReferencingFile(
            this: Allocated<Self>,
            file_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initByReferencingURL:)]
        pub unsafe fn initByReferencingURL(this: Allocated<Self>, url: &NSURL) -> Retained<Self>;

        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Init initWithPasteboard:)]
        pub unsafe fn initWithPasteboard(
            this: Allocated<Self>,
            pasteboard: &NSPasteboard,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithDataIgnoringOrientation:)]
        pub unsafe fn initWithDataIgnoringOrientation(
            this: Allocated<Self>,
            data: &NSData,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "block2")]
        #[method_id(@__retain_semantics Other imageWithSize:flipped:drawingHandler:)]
        pub unsafe fn imageWithSize_flipped_drawingHandler(
            size: NSSize,
            drawing_handler_should_be_called_with_flipped_context: bool,
            drawing_handler: &block2::Block<dyn Fn(NSRect) -> Bool>,
        ) -> Retained<Self>;

        #[method(size)]
        pub unsafe fn size(&self) -> NSSize;

        #[method(setSize:)]
        pub unsafe fn setSize(&self, size: NSSize);

        #[method(setName:)]
        pub unsafe fn setName(&self, string: Option<&NSImageName>) -> bool;

        #[method_id(@__retain_semantics Other name)]
        pub unsafe fn name(&self) -> Option<Retained<NSImageName>>;

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other backgroundColor)]
        pub unsafe fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        #[method(setBackgroundColor:)]
        pub unsafe fn setBackgroundColor(&self, background_color: &NSColor);

        #[method(usesEPSOnResolutionMismatch)]
        pub unsafe fn usesEPSOnResolutionMismatch(&self) -> bool;

        #[method(setUsesEPSOnResolutionMismatch:)]
        pub unsafe fn setUsesEPSOnResolutionMismatch(&self, uses_eps_on_resolution_mismatch: bool);

        #[method(prefersColorMatch)]
        pub unsafe fn prefersColorMatch(&self) -> bool;

        #[method(setPrefersColorMatch:)]
        pub unsafe fn setPrefersColorMatch(&self, prefers_color_match: bool);

        #[method(matchesOnMultipleResolution)]
        pub unsafe fn matchesOnMultipleResolution(&self) -> bool;

        #[method(setMatchesOnMultipleResolution:)]
        pub unsafe fn setMatchesOnMultipleResolution(&self, matches_on_multiple_resolution: bool);

        #[method(matchesOnlyOnBestFittingAxis)]
        pub unsafe fn matchesOnlyOnBestFittingAxis(&self) -> bool;

        #[method(setMatchesOnlyOnBestFittingAxis:)]
        pub unsafe fn setMatchesOnlyOnBestFittingAxis(
            &self,
            matches_only_on_best_fitting_axis: bool,
        );

        #[cfg(feature = "NSGraphics")]
        #[method(drawAtPoint:fromRect:operation:fraction:)]
        pub unsafe fn drawAtPoint_fromRect_operation_fraction(
            &self,
            point: NSPoint,
            from_rect: NSRect,
            op: NSCompositingOperation,
            delta: CGFloat,
        );

        #[cfg(feature = "NSGraphics")]
        #[method(drawInRect:fromRect:operation:fraction:)]
        pub unsafe fn drawInRect_fromRect_operation_fraction(
            &self,
            rect: NSRect,
            from_rect: NSRect,
            op: NSCompositingOperation,
            delta: CGFloat,
        );

        #[cfg(all(feature = "NSGraphics", feature = "NSImageRep"))]
        #[method(drawInRect:fromRect:operation:fraction:respectFlipped:hints:)]
        pub unsafe fn drawInRect_fromRect_operation_fraction_respectFlipped_hints(
            &self,
            dst_space_portion_rect: NSRect,
            src_space_portion_rect: NSRect,
            op: NSCompositingOperation,
            requested_alpha: CGFloat,
            respect_context_is_flipped: bool,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        );

        #[cfg(feature = "NSImageRep")]
        #[method(drawRepresentation:inRect:)]
        pub unsafe fn drawRepresentation_inRect(
            &self,
            image_rep: &NSImageRep,
            rect: NSRect,
        ) -> bool;

        #[method(drawInRect:)]
        pub unsafe fn drawInRect(&self, rect: NSRect);

        #[method(recache)]
        pub unsafe fn recache(&self);

        #[method_id(@__retain_semantics Other TIFFRepresentation)]
        pub unsafe fn TIFFRepresentation(&self) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSBitmapImageRep")]
        #[method_id(@__retain_semantics Other TIFFRepresentationUsingCompression:factor:)]
        pub unsafe fn TIFFRepresentationUsingCompression_factor(
            &self,
            comp: NSTIFFCompression,
            factor: c_float,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSImageRep")]
        #[method_id(@__retain_semantics Other representations)]
        pub unsafe fn representations(&self) -> Retained<NSArray<NSImageRep>>;

        #[cfg(feature = "NSImageRep")]
        #[method(addRepresentations:)]
        pub unsafe fn addRepresentations(&self, image_reps: &NSArray<NSImageRep>);

        #[cfg(feature = "NSImageRep")]
        #[method(addRepresentation:)]
        pub unsafe fn addRepresentation(&self, image_rep: &NSImageRep);

        #[cfg(feature = "NSImageRep")]
        #[method(removeRepresentation:)]
        pub unsafe fn removeRepresentation(&self, image_rep: &NSImageRep);

        #[method(isValid)]
        pub unsafe fn isValid(&self) -> bool;

        #[method_id(@__retain_semantics Other delegate)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSImageDelegate>>>;

        #[method(setDelegate:)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSImageDelegate>>);

        #[method_id(@__retain_semantics Other imageTypes)]
        pub unsafe fn imageTypes() -> Retained<NSArray<NSString>>;

        #[method_id(@__retain_semantics Other imageUnfilteredTypes)]
        pub unsafe fn imageUnfilteredTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[method(canInitWithPasteboard:)]
        pub unsafe fn canInitWithPasteboard(pasteboard: &NSPasteboard) -> bool;

        #[method(cacheMode)]
        pub unsafe fn cacheMode(&self) -> NSImageCacheMode;

        #[method(setCacheMode:)]
        pub unsafe fn setCacheMode(&self, cache_mode: NSImageCacheMode);

        #[method(alignmentRect)]
        pub unsafe fn alignmentRect(&self) -> NSRect;

        #[method(setAlignmentRect:)]
        pub unsafe fn setAlignmentRect(&self, alignment_rect: NSRect);

        #[method(isTemplate)]
        pub unsafe fn isTemplate(&self) -> bool;

        #[method(setTemplate:)]
        pub unsafe fn setTemplate(&self, template: bool);

        #[method_id(@__retain_semantics Other accessibilityDescription)]
        pub unsafe fn accessibilityDescription(&self) -> Option<Retained<NSString>>;

        #[method(setAccessibilityDescription:)]
        pub unsafe fn setAccessibilityDescription(
            &self,
            accessibility_description: Option<&NSString>,
        );

        #[cfg(all(feature = "NSGraphicsContext", feature = "NSImageRep"))]
        #[method_id(@__retain_semantics Other bestRepresentationForRect:context:hints:)]
        pub unsafe fn bestRepresentationForRect_context_hints(
            &self,
            rect: NSRect,
            reference_context: Option<&NSGraphicsContext>,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        ) -> Option<Retained<NSImageRep>>;

        #[cfg(all(feature = "NSGraphicsContext", feature = "NSImageRep"))]
        #[method(hitTestRect:withImageDestinationRect:context:hints:flipped:)]
        pub unsafe fn hitTestRect_withImageDestinationRect_context_hints_flipped(
            &self,
            test_rect_dest_space: NSRect,
            image_rect_dest_space: NSRect,
            context: Option<&NSGraphicsContext>,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
            flipped: bool,
        ) -> bool;

        #[method(recommendedLayerContentsScale:)]
        pub unsafe fn recommendedLayerContentsScale(
            &self,
            preferred_contents_scale: CGFloat,
        ) -> CGFloat;

        #[method_id(@__retain_semantics Other layerContentsForContentsScale:)]
        pub unsafe fn layerContentsForContentsScale(
            &self,
            layer_contents_scale: CGFloat,
        ) -> Retained<AnyObject>;

        #[method(capInsets)]
        pub unsafe fn capInsets(&self) -> NSEdgeInsets;

        #[method(setCapInsets:)]
        pub unsafe fn setCapInsets(&self, cap_insets: NSEdgeInsets);

        #[method(resizingMode)]
        pub unsafe fn resizingMode(&self) -> NSImageResizingMode;

        #[method(setResizingMode:)]
        pub unsafe fn setResizingMode(&self, resizing_mode: NSImageResizingMode);

        #[method_id(@__retain_semantics Other imageWithSymbolConfiguration:)]
        pub unsafe fn imageWithSymbolConfiguration(
            &self,
            configuration: &NSImageSymbolConfiguration,
        ) -> Option<Retained<NSImage>>;

        #[method_id(@__retain_semantics Other symbolConfiguration)]
        pub unsafe fn symbolConfiguration(&self) -> Retained<NSImageSymbolConfiguration>;

        #[method_id(@__retain_semantics Other imageWithLocale:)]
        pub unsafe fn imageWithLocale(&self, locale: Option<&NSLocale>) -> Retained<NSImage>;

        #[method_id(@__retain_semantics Other locale)]
        pub unsafe fn locale(&self) -> Option<Retained<NSLocale>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSImage {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_methods!(
    unsafe impl NSImage {}
);

unsafe impl NSCopying for NSImage {}

#[cfg(feature = "NSPasteboard")]
unsafe impl NSPasteboardReading for NSImage {}

#[cfg(feature = "NSPasteboard")]
unsafe impl NSPasteboardWriting for NSImage {}

unsafe impl NSSecureCoding for NSImage {}

extern_methods!(
    unsafe impl NSImage {}
);

unsafe impl NSItemProviderReading for NSImage {}

unsafe impl NSItemProviderWriting for NSImage {}

extern_protocol!(
    pub unsafe trait NSImageDelegate: NSObjectProtocol {
        #[optional]
        #[method_id(@__retain_semantics Other imageDidNotDraw:inRect:)]
        unsafe fn imageDidNotDraw_inRect(
            &self,
            sender: &NSImage,
            rect: NSRect,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[method(image:willLoadRepresentation:)]
        unsafe fn image_willLoadRepresentation(&self, image: &NSImage, rep: &NSImageRep);

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[method(image:didLoadRepresentationHeader:)]
        unsafe fn image_didLoadRepresentationHeader(&self, image: &NSImage, rep: &NSImageRep);

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[method(image:didLoadPartOfRepresentation:withValidRows:)]
        unsafe fn image_didLoadPartOfRepresentation_withValidRows(
            &self,
            image: &NSImage,
            rep: &NSImageRep,
            rows: NSInteger,
        );

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[method(image:didLoadRepresentation:withStatus:)]
        unsafe fn image_didLoadRepresentation_withStatus(
            &self,
            image: &NSImage,
            rep: &NSImageRep,
            status: NSImageLoadStatus,
        );
    }

    unsafe impl ProtocolType for dyn NSImageDelegate {}
);

extern_category!(
    /// Category on [`NSBundle`].
    pub unsafe trait NSBundleImageExtension {
        #[method_id(@__retain_semantics Other imageForResource:)]
        unsafe fn imageForResource(&self, name: &NSImageName) -> Option<Retained<NSImage>>;

        #[method_id(@__retain_semantics Other pathForImageResource:)]
        unsafe fn pathForImageResource(&self, name: &NSImageName) -> Option<Retained<NSString>>;

        #[method_id(@__retain_semantics Other URLForImageResource:)]
        unsafe fn URLForImageResource(&self, name: &NSImageName) -> Option<Retained<NSURL>>;
    }

    unsafe impl NSBundleImageExtension for NSBundle {}
);

extern_methods!(
    /// Deprecated
    unsafe impl NSImage {
        #[deprecated = "Use +imageUnfilteredTypes instead"]
        #[method_id(@__retain_semantics Other imageUnfilteredFileTypes)]
        pub unsafe fn imageUnfilteredFileTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageUnfilteredTypes instead"]
        #[method_id(@__retain_semantics Other imageUnfilteredPasteboardTypes)]
        pub unsafe fn imageUnfilteredPasteboardTypes() -> Retained<NSArray<NSPasteboardType>>;

        #[deprecated = "Use +imageTypes instead"]
        #[method_id(@__retain_semantics Other imageFileTypes)]
        pub unsafe fn imageFileTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageTypes instead"]
        #[method_id(@__retain_semantics Other imagePasteboardTypes)]
        pub unsafe fn imagePasteboardTypes() -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "Use -[NSImage bestRepresentationForRect:context:hints:] instead.  Any deviceDescription dictionary is also a valid hints dictionary."]
        #[method_id(@__retain_semantics Other bestRepresentationForDevice:)]
        pub unsafe fn bestRepresentationForDevice(
            &self,
            device_description: Option<&NSDictionary>,
        ) -> Option<Retained<NSImageRep>>;

        #[deprecated = "This method is incompatible with resolution-independent drawing and should not be used. Instead, use +[NSImage imageWithSize:flipped:drawingHandler:] to create a block-based image describing the desired image drawing, or use +[NSGraphicsContext graphicsContextWithBitmapImageRep:] to manipulate specific bitmap image representations."]
        #[method(lockFocus)]
        pub unsafe fn lockFocus(&self);

        #[deprecated = "This method is incompatible with resolution-independent drawing and should not be used. Instead, use +[NSImage imageWithSize:flipped:drawingHandler:] to create a block-based image describing the desired image drawing, or use +[NSGraphicsContext graphicsContextWithBitmapImageRep:] to manipulate specific bitmap image representations."]
        #[method(lockFocusFlipped:)]
        pub unsafe fn lockFocusFlipped(&self, flipped: bool);

        #[deprecated = "This method is incompatible with resolution-independent drawing and should not be used. Instead, use +[NSImage imageWithSize:flipped:drawingHandler:] to create a block-based image describing the desired image drawing, or use +[NSGraphicsContext graphicsContextWithBitmapImageRep:] to manipulate specific bitmap image representations."]
        #[method(unlockFocus)]
        pub unsafe fn unlockFocus(&self);

        #[deprecated = "The concept of flippedness for NSImage is deprecated.  Please see the AppKit 10.6 release notes for a discussion of why and for how to replace existing usage."]
        #[method(setFlipped:)]
        pub unsafe fn setFlipped(&self, flag: bool);

        #[deprecated = "The concept of flippedness for NSImage is deprecated.  Please see the AppKit 10.6 release notes for a discussion of why and for how to replace existing usage."]
        #[method(isFlipped)]
        pub unsafe fn isFlipped(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(setScalesWhenResized:)]
        pub unsafe fn setScalesWhenResized(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(scalesWhenResized)]
        pub unsafe fn scalesWhenResized(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(setDataRetained:)]
        pub unsafe fn setDataRetained(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(isDataRetained)]
        pub unsafe fn isDataRetained(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(setCachedSeparately:)]
        pub unsafe fn setCachedSeparately(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(isCachedSeparately)]
        pub unsafe fn isCachedSeparately(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(setCacheDepthMatchesImageDepth:)]
        pub unsafe fn setCacheDepthMatchesImageDepth(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[method(cacheDepthMatchesImageDepth)]
        pub unsafe fn cacheDepthMatchesImageDepth(&self) -> bool;

        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[method(dissolveToPoint:fraction:)]
        pub unsafe fn dissolveToPoint_fraction(&self, point: NSPoint, fraction: CGFloat);

        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[method(dissolveToPoint:fromRect:fraction:)]
        pub unsafe fn dissolveToPoint_fromRect_fraction(
            &self,
            point: NSPoint,
            rect: NSRect,
            fraction: CGFloat,
        );

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[method(compositeToPoint:operation:)]
        pub unsafe fn compositeToPoint_operation(
            &self,
            point: NSPoint,
            operation: NSCompositingOperation,
        );

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[method(compositeToPoint:fromRect:operation:)]
        pub unsafe fn compositeToPoint_fromRect_operation(
            &self,
            point: NSPoint,
            rect: NSRect,
            operation: NSCompositingOperation,
        );

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[method(compositeToPoint:operation:fraction:)]
        pub unsafe fn compositeToPoint_operation_fraction(
            &self,
            point: NSPoint,
            operation: NSCompositingOperation,
            fraction: CGFloat,
        );

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[method(compositeToPoint:fromRect:operation:fraction:)]
        pub unsafe fn compositeToPoint_fromRect_operation_fraction(
            &self,
            point: NSPoint,
            rect: NSRect,
            operation: NSCompositingOperation,
            fraction: CGFloat,
        );

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "Create an image using +[NSImage imageWithSize:flipped:drawingHandler:], and begin your custom drawing with -[NSImageRep drawInRect:] instead."]
        #[method(lockFocusOnRepresentation:)]
        pub unsafe fn lockFocusOnRepresentation(&self, image_representation: Option<&NSImageRep>);

        #[deprecated = "This method does not perform any operation on 10.4 or later."]
        #[method(cancelIncrementalLoad)]
        pub unsafe fn cancelIncrementalLoad(&self);
    }
);

extern "C" {
    pub static NSImageNameAddTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameBluetoothTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameBonjour: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameBookmarksTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameCaution: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameComputer: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameEnterFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameExitFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameFolder: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameFolderBurnable: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameFolderSmart: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameFollowLinkFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameHomeTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameIChatTheaterTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameLockLockedTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameLockUnlockedTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameNetwork: &'static NSImageName;
}

extern "C" {
    pub static NSImageNamePathTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameQuickLookTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameRefreshFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameRefreshTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameRemoveTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameRevealFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameShareTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameSlideshowTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameStatusAvailable: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameStatusNone: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameStatusPartiallyAvailable: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameStatusUnavailable: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameStopProgressFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameStopProgressTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTrashEmpty: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTrashFull: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameActionTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameSmartBadgeTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameIconViewTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameListViewTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameColumnViewTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameFlowViewTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameInvalidDataFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameGoForwardTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameGoBackTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameGoRightTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameGoLeftTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameRightFacingTriangleTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameLeftFacingTriangleTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameDotMac: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameMobileMe: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameMultipleDocuments: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameUserAccounts: &'static NSImageName;
}

extern "C" {
    pub static NSImageNamePreferencesGeneral: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameAdvanced: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameInfo: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameFontPanel: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameColorPanel: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameUser: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameUserGroup: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameEveryone: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameUserGuest: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameMenuOnStateTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameMenuMixedStateTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameApplicationIcon: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAddDetailTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAddTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAlarmTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioInputMuteTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioInputTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioOutputMuteTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioOutputVolumeHighTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioOutputVolumeLowTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioOutputVolumeMediumTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarAudioOutputVolumeOffTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarBookmarksTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarColorPickerFill: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarColorPickerFont: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarColorPickerStroke: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarCommunicationAudioTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarCommunicationVideoTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarComposeTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarDeleteTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarDownloadTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarEnterFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarExitFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarFastForwardTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarFolderCopyToTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarFolderMoveToTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarFolderTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarGetInfoTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarGoBackTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarGoDownTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarGoForwardTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarGoUpTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarHistoryTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarIconViewTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarListViewTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarMailTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarNewFolderTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarNewMessageTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarOpenInBrowserTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarPauseTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarPlayPauseTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarPlayTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarQuickLookTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRecordStartTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRecordStopTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRefreshTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRemoveTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRewindTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRotateLeftTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarRotateRightTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSearchTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarShareTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSidebarTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipAhead15SecondsTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipAhead30SecondsTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipAheadTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipBack15SecondsTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipBack30SecondsTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipBackTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipToEndTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSkipToStartTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarSlideshowTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTagIconTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextBoldTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextBoxTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextCenterAlignTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextItalicTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextJustifiedAlignTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextLeftAlignTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextListTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextRightAlignTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextStrikethroughTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarTextUnderlineTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarUserAddTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarUserGroupTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarUserTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarVolumeDownTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarVolumeUpTemplate: &'static NSImageName;
}

extern "C" {
    pub static NSImageNameTouchBarPlayheadTemplate: &'static NSImageName;
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageSymbolScale(pub NSInteger);
impl NSImageSymbolScale {
    #[doc(alias = "NSImageSymbolScaleSmall")]
    pub const Small: Self = Self(1);
    #[doc(alias = "NSImageSymbolScaleMedium")]
    pub const Medium: Self = Self(2);
    #[doc(alias = "NSImageSymbolScaleLarge")]
    pub const Large: Self = Self(3);
}

unsafe impl Encode for NSImageSymbolScale {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSImageSymbolScale {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSImageSymbolConfiguration;

    unsafe impl ClassType for NSImageSymbolConfiguration {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCoding for NSImageSymbolConfiguration {}

unsafe impl NSCopying for NSImageSymbolConfiguration {}

unsafe impl NSObjectProtocol for NSImageSymbolConfiguration {}

unsafe impl NSSecureCoding for NSImageSymbolConfiguration {}

extern_methods!(
    unsafe impl NSImageSymbolConfiguration {
        #[cfg(feature = "NSFontDescriptor")]
        #[method_id(@__retain_semantics Other configurationWithPointSize:weight:scale:)]
        pub unsafe fn configurationWithPointSize_weight_scale(
            point_size: CGFloat,
            weight: NSFontWeight,
            scale: NSImageSymbolScale,
        ) -> Retained<Self>;

        #[cfg(feature = "NSFontDescriptor")]
        #[method_id(@__retain_semantics Other configurationWithPointSize:weight:)]
        pub unsafe fn configurationWithPointSize_weight(
            point_size: CGFloat,
            weight: NSFontWeight,
        ) -> Retained<Self>;

        #[cfg(feature = "NSFontDescriptor")]
        #[method_id(@__retain_semantics Other configurationWithTextStyle:scale:)]
        pub unsafe fn configurationWithTextStyle_scale(
            style: &NSFontTextStyle,
            scale: NSImageSymbolScale,
        ) -> Retained<Self>;

        #[cfg(feature = "NSFontDescriptor")]
        #[method_id(@__retain_semantics Other configurationWithTextStyle:)]
        pub unsafe fn configurationWithTextStyle(style: &NSFontTextStyle) -> Retained<Self>;

        #[method_id(@__retain_semantics Other configurationWithScale:)]
        pub unsafe fn configurationWithScale(scale: NSImageSymbolScale) -> Retained<Self>;

        #[method_id(@__retain_semantics Other configurationPreferringMonochrome)]
        pub unsafe fn configurationPreferringMonochrome() -> Retained<Self>;

        #[method_id(@__retain_semantics Other configurationPreferringHierarchical)]
        pub unsafe fn configurationPreferringHierarchical() -> Retained<Self>;

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other configurationWithHierarchicalColor:)]
        pub unsafe fn configurationWithHierarchicalColor(
            hierarchical_color: &NSColor,
        ) -> Retained<Self>;

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other configurationWithPaletteColors:)]
        pub unsafe fn configurationWithPaletteColors(
            palette_colors: &NSArray<NSColor>,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Other configurationPreferringMulticolor)]
        pub unsafe fn configurationPreferringMulticolor() -> Retained<Self>;

        #[method_id(@__retain_semantics Other configurationByApplyingConfiguration:)]
        pub unsafe fn configurationByApplyingConfiguration(
            &self,
            configuration: &NSImageSymbolConfiguration,
        ) -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSImageSymbolConfiguration {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);
