#!/bin/bash 
# init script for Mandrake (works proably also for Fedora/Redhat)
#
# (c) 2004, Rroberto A. Foglietta
#     Released under GPL v2.0 terms
#
# Source function library.
. /etc/rc.d/init.d/functions

SYSCONF_FILE=/etc/sysconfig/cdspeed

if [ -f $SYSCONF_FILE ]
then
	for dev in $(grep -ve "#" $SYSCONF_FILE | cut -d\  -f1 | cut -f1)
	do
		case "$1" in
		stop)
			speed=0
			echo -n "Resetting $dev speed"
			;;
		start)
			speed=$(grep -ve "#" $SYSCONF_FILE | grep -e "$dev" | cut -d\  -f2 | cut -f2)
			echo -n "Setting $dev speed at" $speed"x"
			;;
		
	  	*)
		        gprintf "Usage: %s {start|stop}\n" "$0"
		        exit 1
		esac
		/usr/bin/cdspeed -s $speed -d $dev
		if [ $? == 0 ]
		then
			echo_success 
		else
			echo_failure 
		fi
		echo
	done
fi
