/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.tipoftheday;

import java.net.URI;
import java.util.List;
import java.util.Random;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;

public class ShowTipOfTheDayDialog
extends AbstractPopupPanel {
    private static final String UI_SHOW_TIP_OF_THE_DAY_ON_STARTUP = "ui.show.tip.of.the.day.on.startup";
    private static final Log log = Log.getLog(ShowTipOfTheDayDialog.class);
    private static final String DIALOG_ID = "DBeaver." + ShowTipOfTheDayDialog.class.getSimpleName();
    private final List<String> tips;
    private Composite tipArea;
    private boolean displayShowOnStartup;
    private ScrolledFormText scrolledFormText;
    private int tipIndex;

    public ShowTipOfTheDayDialog(@NotNull Shell parentShell, List<String> tips) {
        super(parentShell, "Tip of the day");
        this.tips = List.copyOf(tips);
        this.setModeless(true);
        this.setBlockOnOpen(false);
    }

    public static boolean isShowOnStartup() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        return store.getBoolean(UI_SHOW_TIP_OF_THE_DAY_ON_STARTUP);
    }

    public static void setShowOnStartup(boolean showOnStartup) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue(UI_SHOW_TIP_OF_THE_DAY_ON_STARTUP, showOnStartup);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        UIUtils.asyncExec(() -> {
            if (!this.tipArea.isDisposed()) {
                this.tipArea.layout();
            }
        });
        return contents;
    }

    protected Composite createDialogArea(Composite parent) {
        this.getShell().setText("Tip of the day");
        this.tipIndex = new Random(System.currentTimeMillis()).nextInt(this.tips.size());
        Font dialogFont = JFaceResources.getDialogFont();
        FontData[] fontData = dialogFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            FontData fd = fontData[i];
            fontData[i] = new FontData(fd.getName(), fd.getHeight() + 1, 0);
            ++i;
        }
        Font largeFont = new Font(dialogFont.getDevice(), fontData);
        parent.addDisposeListener(e -> largeFont.dispose());
        Composite dialogArea = super.createDialogArea(parent);
        this.tipArea = new Composite(dialogArea, 2048);
        this.tipArea.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.tipArea.setLayout((Layout)gl);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        toolkit.setBorderStyle(0);
        Form form = toolkit.createForm(this.tipArea);
        form.setLayoutData((Object)new GridData(1808));
        form.setLayout((Layout)new GridLayout(1, true));
        form.getBody().setLayoutData((Object)new GridData(1808));
        form.getBody().setLayout((Layout)new GridLayout(1, true));
        this.scrolledFormText = new ScrolledFormText(form.getBody(), 512, false);
        FormText formText = new FormText((Composite)this.scrolledFormText, 524352);
        this.scrolledFormText.setFormText(formText);
        this.scrolledFormText.setExpandVertical(true);
        this.scrolledFormText.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.adapt((Composite)this.scrolledFormText);
        formText.marginWidth = 1;
        formText.marginHeight = 0;
        formText.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        toolkit.adapt((Control)formText, false, false);
        formText.setMenu(form.getBody().getMenu());
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        formText.setLayoutData((Object)gd);
        formText.setFont(largeFont);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ShowTipOfTheDayDialog.this.navigateLink(e);
            }
        });
        this.showTip();
        if (this.displayShowOnStartup) {
            final Button showTipButton = toolkit.createButton(form.getBody(), "Show tips on startup", 32);
            showTipButton.setSelection(ShowTipOfTheDayDialog.isShowOnStartup());
            showTipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowTipOfTheDayDialog.setShowOnStartup(showTipButton.getSelection());
                }
            });
            form.getBody().setTabList(new Control[]{showTipButton});
        }
        return dialogArea;
    }

    protected boolean needsButtonBar() {
        return true;
    }

    private void navigateLink(HyperlinkEvent e) {
        Object href = e.getHref();
        if (href == null) {
            return;
        }
        URI uri = URI.create(href.toString());
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                ShellUtils.launchProgram((String)href.toString());
                break;
            }
            case "prefs": {
                this.close();
                UIUtils.asyncExec(() -> {
                    DBNProject element = null;
                    if (uri.getFragment() != null) {
                        if (uri.getFragment().equals("project")) {
                            element = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
                        } else {
                            log.warn((Object)("Unknown element type: '" + uri.getFragment() + "'"));
                        }
                    }
                    UIUtils.showPreferencesFor((Shell)UIUtils.getActiveWorkbenchShell(), element, (String[])new String[]{uri.getHost()});
                });
                break;
            }
            case "view": {
                this.close();
                UIUtils.asyncExec(() -> {
                    try {
                        UIUtils.getActiveWorkbenchWindow().getActivePage().showView(uri.getHost());
                    }
                    catch (PartInitException e1) {
                        DBWorkbench.getPlatformUI().showError("Open view", "Error opening view " + uri.getHost(), (Throwable)e1);
                    }
                });
                break;
            }
            default: {
                log.warn((Object)("Unknown scheme: '" + uri.getScheme() + "'"));
            }
        }
    }

    private void showTip() {
        String tipText = "<form><p>" + this.tips.get(this.tipIndex) + "</p></form>";
        try {
            this.scrolledFormText.getFormText().setText(tipText, true, false);
            this.scrolledFormText.reflow(true);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        UIUtils.asyncExec(() -> {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setFocus();
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 14: {
                this.tipIndex = this.tipIndex == 0 ? this.tips.size() - 1 : this.tipIndex - 1;
                this.showTip();
                return;
            }
            case 15: {
                this.tipIndex = this.tipIndex == this.tips.size() - 1 ? 0 : this.tipIndex + 1;
                this.showTip();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void setDisplayShowOnStartup(boolean displayShowOnStartup) {
        this.displayShowOnStartup = displayShowOnStartup;
    }
}

