/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.validator;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;

public class IntegerValidator
implements VerifyListener {
    private final int minValue;
    private final int maxValue;

    public IntegerValidator(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void verifyText(VerifyEvent e) {
        String newText = e.text;
        if (newText.isEmpty()) {
            return;
        }
        try {
            int value = Integer.parseInt(newText);
            if (value < this.minValue || value > this.maxValue) {
                e.doit = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }
}

