/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.util.Arrays;
import org.jkiss.code.NotNull;

public enum OpenAIModel {
    GPT_4_OMNI("gpt-4o", 128000, true),
    GPT_4_MINI("gpt-4o-mini", 128000, true),
    GPT_TURBO_4("gpt-4-turbo", 128000, true),
    GPT_TURBO("gpt-3.5-turbo", 16384, true),
    GPT_4("gpt-4", 8192, true),
    GPT_TURBO_INSTRUCT("gpt-3.5-turbo-instruct", 4096, false, GPT_TURBO),
    GPT_TURBO16("gpt-3.5-turbo-16k", 16384, true, GPT_TURBO),
    TEXT_ADA("text-ada-001", 2048, false, GPT_TURBO_INSTRUCT),
    TEXT_CURIE("text-curie-001", 2048, false, GPT_TURBO_INSTRUCT),
    TEXT_BABBAGE("text-babbage-001", 2048, false, GPT_TURBO_INSTRUCT),
    TEXT_DAVINCI01("text-davinci-003", 4096, false, GPT_TURBO_INSTRUCT),
    TEXT_DAVINCI02("text-davinci-002", 4096, false, GPT_TURBO_INSTRUCT),
    TEXT_DAVINCI03("text-davinci-001", 2048, false, GPT_TURBO_INSTRUCT);

    private final String name;
    private final int maxTokens;
    private final boolean isChatAPI;
    private OpenAIModel deprecationReplacementModel = null;

    @NotNull
    public static OpenAIModel getByName(@NotNull String name) {
        return OpenAIModel.getByName(name, GPT_4_MINI);
    }

    @NotNull
    public static OpenAIModel getByName(@NotNull String name, @NotNull OpenAIModel defaultModel) {
        return Arrays.stream(OpenAIModel.values()).filter(it -> it.name.equals(name)).findFirst().map(OpenAIModel::getFinalReplacementModel).orElse(defaultModel);
    }

    private OpenAIModel(String name, int maxTokens, boolean isChatAPI) {
        this.name = name;
        this.maxTokens = maxTokens;
        this.isChatAPI = isChatAPI;
    }

    private OpenAIModel(String name, int maxTokens, boolean isChatAPI, OpenAIModel deprecationReplacementModel) {
        this.name = name;
        this.maxTokens = maxTokens;
        this.isChatAPI = isChatAPI;
        this.deprecationReplacementModel = deprecationReplacementModel;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public boolean isChatAPI() {
        return this.isChatAPI;
    }

    public String getName() {
        return this.name;
    }

    public OpenAIModel getDeprecationReplacementModel() {
        return this.deprecationReplacementModel;
    }

    public OpenAIModel getFinalReplacementModel() {
        OpenAIModel lastReplacement = this;
        while (lastReplacement.getDeprecationReplacementModel() != null) {
            lastReplacement = lastReplacement.getDeprecationReplacementModel();
        }
        return lastReplacement;
    }
}

