/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableColumn;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableIndex;
import org.jkiss.dbeaver.ext.cubrid.model.CubridView;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndexColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public class CubridUser
extends GenericSchema {
    private String name;
    private String comment;
    private final CubridIndexCache cubridIndexCache;

    public CubridUser(@NotNull GenericDataSource dataSource, @NotNull String schemaName, @Nullable String comment) {
        super(dataSource, null, schemaName);
        this.name = schemaName;
        this.comment = comment;
        this.cubridIndexCache = new CubridIndexCache(this.getTableCache());
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @NotNull
    public boolean supportsSystemTable() {
        return this.name.equals("DBA");
    }

    @NotNull
    public boolean supportsSystemView() {
        return this.name.equals("DBA");
    }

    @NotNull
    public boolean showSystemTableFolder() {
        return this.getDataSource().getContainer().getNavigatorSettings().isShowSystemObjects();
    }

    @NotNull
    public boolean supportsSynonym() {
        return ((CubridDataSource)this.getDataSource()).getSupportMultiSchema();
    }

    @NotNull
    public boolean supportsTrigger() {
        return "dba".equals(this.getDataSource().getContainer().getConnectionConfiguration().getUserName());
    }

    @NotNull
    public TableCache createTableCache(@NotNull GenericDataSource datasource) {
        return new CubridTableCache(datasource);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getTable(monitor, childName.toLowerCase());
    }

    @NotNull
    public CubridIndexCache getCubridIndexCache() {
        return this.cubridIndexCache;
    }

    @Nullable
    public List<CubridTable> getPhysicalTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridTable> tables = new ArrayList<CubridTable>();
        for (GenericTable table : super.getPhysicalTables(monitor)) {
            if (table.isSystem()) continue;
            tables.add((CubridTable)table);
        }
        return tables;
    }

    @Nullable
    public List<? extends CubridTable> getPhysicalSystemTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridTable> tables = new ArrayList<CubridTable>();
        for (GenericTable table : super.getPhysicalTables(monitor)) {
            if (!table.isSystem()) continue;
            tables.add((CubridTable)table);
        }
        return tables;
    }

    @Nullable
    public List<CubridView> getViews(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridView> views = new ArrayList<CubridView>();
        for (GenericView view : super.getViews(monitor)) {
            if (view.isSystem()) continue;
            views.add((CubridView)view);
        }
        return views;
    }

    @Nullable
    public List<CubridView> getSystemViews(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridView> views = new ArrayList<CubridView>();
        for (GenericView view : super.getViews(monitor)) {
            if (!view.isSystem()) continue;
            views.add((CubridView)view);
        }
        return views;
    }

    @Nullable
    public List<GenericTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<GenericTableIndex> indexes = new ArrayList<GenericTableIndex>();
        for (CubridTable table : this.getPhysicalTables(monitor)) {
            indexes.addAll(table.getIndexes(monitor));
        }
        return indexes;
    }

    public class CubridIndexCache
    extends JDBCCompositeCache<GenericStructContainer, CubridTable, CubridTableIndex, GenericTableIndexColumn> {
        CubridIndexCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, CubridTable.class, (Object)"TABLE_NAME", (Object)"INDEX_NAME");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable CubridTable forParent) throws SQLException {
            return session.getMetaData().getIndexInfo(null, null, forParent.getUniqueName(), false, true).getSourceStatement();
        }

        @Nullable
        protected CubridTableIndex fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable CubridTable parent, @Nullable String indexName, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            DBSIndexType indexType;
            boolean isNonUnique = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NON_UNIQUE");
            String indexQualifier = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"INDEX_QUALIFIER");
            long cardinality = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CARDINALITY");
            int indexTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"TYPE");
            Object name = indexName;
            switch (indexTypeNum) {
                case 0: {
                    return null;
                }
                case 1: {
                    indexType = DBSIndexType.CLUSTERED;
                    break;
                }
                case 2: {
                    indexType = DBSIndexType.HASHED;
                    break;
                }
                case 3: {
                    indexType = DBSIndexType.OTHER;
                    break;
                }
                default: {
                    indexType = DBSIndexType.UNKNOWN;
                }
            }
            if (CommonUtils.isEmpty((String)name)) {
                name = parent.getName().toUpperCase(Locale.ENGLISH) + "_INDEX";
            }
            return new CubridTableIndex((GenericTableBase)parent, isNonUnique, indexQualifier, cardinality, (String)name, indexType, true);
        }

        @Nullable
        protected GenericTableIndexColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull CubridTable parent, @NotNull CubridTableIndex object, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            int ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
            String ascOrDesc = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"ASC_OR_DESC");
            if (CommonUtils.isEmpty((String)columnName)) {
                return null;
            }
            GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
            if (tableColumn == null) {
                return null;
            }
            return new GenericTableIndexColumn[]{new GenericTableIndexColumn((GenericTableIndex)object, tableColumn, ordinalPosition, !"D".equalsIgnoreCase(ascOrDesc))};
        }

        protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @Nullable CubridTableIndex object, @Nullable List<GenericTableIndexColumn> children) {
            object.setColumns(children);
        }
    }

    public class CubridTableCache
    extends TableCache {
        protected CubridTableCache(GenericDataSource dataSource) {
            super(dataSource);
        }

        @NotNull
        protected GenericTableColumn fetchChild(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attr_name");
            String dataType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"data_type");
            boolean isForeignKey = "YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_foreign_key"));
            String showDataType = null;
            boolean autoIncrement = false;
            String tableName = table.isSystem() ? table.getName() : ((CubridDataSource)this.getDataSource()).getMetaModel().getTableOrViewName(table);
            String sql = "show columns from " + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)tableName) + " where Field = ?";
            Throwable throwable = null;
            Object var13_14 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                dbStat.setString(1, columnName);
                Throwable throwable2 = null;
                Object var16_19 = null;
                try (JDBCResultSet result = dbStat.executeQuery();){
                    if (result.next()) {
                        showDataType = JDBCUtils.safeGetString((ResultSet)result, (String)"Type");
                        autoIncrement = "auto_increment".equals(JDBCUtils.safeGetString((ResultSet)result, (String)"Extra"));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return new CubridTableColumn(table, columnName, showDataType == null ? dataType : showDataType, autoIncrement, isForeignKey, dbResult);
        }
    }
}

