/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverClassFindJob;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverFileInfo;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.registry.driver.DriverLibraryLocal;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesPanel;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPropertiesControl;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditHelpers;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverLibraryDetailsDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.EditMavenArtifactDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DriverEditDialog
extends HelpEnabledDialog {
    private static final Log log = Log.getLog(DriverEditDialog.class);
    private static final String DIALOG_ID = "DBeaver.DriverEditDialog";
    private static int dialogCount;
    private final boolean newDriver;
    private DataSourceProviderDescriptor provider;
    private DriverDescriptor driver;
    private String curFolder = null;
    private TreeViewer libTable;
    private Button editButton;
    private Button deleteButton;
    private Button updateVersionButton;
    private Button detailsButton;
    private Combo classListCombo;
    private Button findClassButton;
    private Text driverNameText;
    private Text driverDescText;
    private Text driverClassText;
    private Text driverURLText;
    private Text driverPortText;
    private Text driverUserText;
    private Text driverDatabaseText;
    private PropertyTreeViewer parametersEditor;
    private ConnectionPropertiesControl connectionPropertiesEditor;
    private PropertySourceCustom driverPropertySource;
    private PropertySourceCustom connectionPropertySource;
    private ClientHomesPanel clientHomesPanel;
    private Button embeddedDriverCheck;
    private Button anonymousDriverCheck;
    private Button allowsEmptyPasswordCheck;
    private Button nonInstantiableCheck;
    private Button propagateDriverPropertiesCheck;
    private Button threadSafeCheck;
    private boolean showAddFiles = false;
    private final List<DBPDriverLibrary> libraries = new ArrayList<DBPDriverLibrary>();

    static int getDialogCount() {
        return dialogCount;
    }

    public DriverEditDialog(Shell shell, DBPDriver driver) {
        super(shell, "database-drivers");
        this.driver = (DriverDescriptor)driver;
        this.provider = this.driver.getProviderDescriptor();
        this.newDriver = false;
    }

    DriverEditDialog(Shell shell, DataSourceProviderDescriptor provider, String category) {
        super(shell, "database-drivers");
        this.provider = provider;
        this.driver = provider.createDriver();
        this.newDriver = true;
    }

    DriverEditDialog(Shell shell, DataSourceProviderDescriptor provider, DriverDescriptor driver) {
        super(shell, "database-drivers");
        this.provider = provider;
        this.driver = provider.createDriver(driver);
        this.driver.setName(this.driver.getName() + " Copy");
        this.driver.setModified(true);
        this.driver.setCustom(true);
        for (DBPDriverLibrary library : this.driver.getDriverLibraries()) {
            if (!(library instanceof DriverLibraryAbstract)) continue;
            ((DriverLibraryAbstract)library).setCustom(true);
        }
        this.newDriver = true;
    }

    public DriverDescriptor getDriver() {
        return this.driver;
    }

    public int open(boolean addFiles) {
        this.showAddFiles = addFiles;
        return this.open();
    }

    public int open() {
        try {
            ++dialogCount;
            int n = super.open();
            return n;
        }
        finally {
            --dialogCount;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        this.onChangeProperty();
        return ctl;
    }

    protected Composite createDialogArea(Composite parent) {
        String license;
        if (this.newDriver) {
            this.getShell().setText(UIConnectionMessages.dialog_edit_driver_title_create_driver);
        } else {
            this.getShell().setText(UIConnectionMessages.dialog_edit_driver_title_edit_driver + this.driver.getName() + "'");
            this.getShell().setImage(DBeaverIcons.getImage((DBPImage)this.driver.getPlainIcon()));
        }
        Composite group = super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 700;
        group.setLayoutData((Object)gd);
        CTabFolder tabFolder = new CTabFolder(group, 0x800000);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createMainTab(tabFolder);
        this.createLibrariesTab(tabFolder);
        this.createConnectionPropertiesTab(tabFolder);
        this.createParametersTab(tabFolder);
        if (this.driver.getNativeClientManager() != null) {
            this.createClientHomesTab(tabFolder);
        }
        if ((license = this.driver.getLicense()) != null) {
            this.createLicenseTab(tabFolder, license);
        }
        tabFolder.setSelection(0);
        this.loadSettings(false);
        if (this.showAddFiles) {
            this.getShell().getDisplay().asyncExec(this::addLibraryFiles);
        }
        this.driverNameText.setFocus();
        return group;
    }

    private void createMainTab(CTabFolder group) {
        boolean isReadOnly = !this.provider.isDriversManagable();
        int advStyle = isReadOnly ? 8 : 0;
        Composite propsGroup = new Composite((Composite)group, 0);
        propsGroup.setLayout((Layout)new GridLayout(4, false));
        propsGroup.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Control)propsGroup) * 20;
        this.driverNameText = UIUtils.createLabelText((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_label_driver_name, (String)this.driver.getName(), (int)(0x800 | advStyle), (Object)gd);
        this.driverNameText.setEnabled(this.driver == null || this.driver.isCustom());
        this.driverNameText.addModifyListener(e -> this.onChangeProperty());
        Composite driverTypeGroup = UIUtils.createComposite((Composite)propsGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        driverTypeGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)driverTypeGroup, (String)UIConnectionMessages.dialog_edit_driver_type_label);
        final CSmartCombo providerCombo = new CSmartCombo(driverTypeGroup, 2060, (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)((DataSourceProviderDescriptor)element).getIcon());
            }

            public String getText(Object element) {
                return ((DataSourceProviderDescriptor)element).getName();
            }
        });
        gd = new GridData(768);
        gd.minimumWidth = UIUtils.getFontHeight((Control)propsGroup) * 20;
        providerCombo.setLayoutData((Object)gd);
        if (this.newDriver) {
            for (DataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getDataSourceProviders()) {
                if (!provider.isDriversManagable()) continue;
                providerCombo.addItem((Object)provider);
            }
            providerCombo.select((Object)this.provider);
            providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DriverEditDialog.this.provider = (DataSourceProviderDescriptor)providerCombo.getItem(providerCombo.getSelectionIndex());
                    DriverEditDialog.this.driver = DriverEditDialog.this.provider.createDriver();
                }
            });
        } else {
            providerCombo.addItem((Object)this.provider);
            providerCombo.select((Object)this.provider);
        }
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.driverClassText = UIUtils.createLabelText((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_label_class_name, (String)CommonUtils.notEmpty((String)this.driver.getDriverClassName()), (int)(0x800 | advStyle), (Object)gd);
        this.driverClassText.setToolTipText(UIConnectionMessages.dialog_edit_driver_label_class_name_tip);
        this.driverClassText.addModifyListener(e -> this.onChangeProperty());
        this.driverURLText = UIUtils.createLabelText((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_label_sample_url, (String)CommonUtils.notEmpty((String)this.driver.getSampleURL()), (int)(0x800 | advStyle), (Object)gd);
        this.driverURLText.setToolTipText(UIConnectionMessages.dialog_edit_driver_label_sample_url_tip);
        this.driverURLText.addModifyListener(e -> this.onChangeProperty());
        this.driverURLText.setEnabled(this.driver == null || this.driver.isSampleURLApplicable());
        this.driverPortText = UIUtils.createLabelText((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_label_default_port, (String)CommonUtils.notEmpty((String)this.driver.getDefaultPort()), (int)(0x800 | advStyle));
        this.driverPortText.setLayoutData((Object)new GridData(768));
        this.driverPortText.addModifyListener(e -> this.onChangeProperty());
        this.driverDatabaseText = UIUtils.createLabelText((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_label_default_database, (String)CommonUtils.notEmpty((String)this.driver.getDefaultDatabase()), (int)(0x800 | advStyle));
        this.driverDatabaseText.setLayoutData((Object)new GridData(768));
        this.driverDatabaseText.addModifyListener(e -> this.onChangeProperty());
        this.driverUserText = UIUtils.createLabelText((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_label_default_user, (String)CommonUtils.notEmpty((String)this.driver.getDefaultUser()), (int)(0x800 | advStyle));
        this.driverUserText.setLayoutData((Object)new GridData(768));
        this.driverUserText.addModifyListener(e -> this.onChangeProperty());
        UIUtils.createEmptyLabel((Composite)propsGroup, (int)2, (int)1);
        Composite optionsPanel = new Composite(propsGroup, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        optionsPanel.setLayoutData((Object)gd);
        optionsPanel.setLayout((Layout)new RowLayout());
        this.embeddedDriverCheck = UIUtils.createCheckbox((Composite)optionsPanel, (String)UIConnectionMessages.dialog_edit_driver_embedded_label, (String)UIConnectionMessages.dialog_edit_driver_embedded_tip, (boolean)this.driver.isEmbedded(), (int)1);
        this.propagateDriverPropertiesCheck = UIUtils.createCheckbox((Composite)optionsPanel, (String)UIConnectionMessages.dialog_edit_driver_propagate_driver_properties_label, (String)UIConnectionMessages.dialog_edit_driver_propagate_driver_properties_tip, (boolean)this.driver.isPropagateDriverProperties(), (int)1);
        this.anonymousDriverCheck = UIUtils.createCheckbox((Composite)optionsPanel, (String)UIConnectionMessages.dialog_edit_driver_anonymous_label, (String)UIConnectionMessages.dialog_edit_driver_anonymous_tip, (boolean)this.driver.isAnonymousAccess(), (int)1);
        this.allowsEmptyPasswordCheck = UIUtils.createCheckbox((Composite)optionsPanel, (String)UIConnectionMessages.dialog_edit_driver_allows_empty_password_label, (String)UIConnectionMessages.dialog_edit_driver_allows_empty_password_tip, (boolean)this.driver.isAnonymousAccess(), (int)1);
        this.nonInstantiableCheck = UIUtils.createCheckbox((Composite)optionsPanel, (String)UIConnectionMessages.dialog_edit_driver_use_legacy_instantiation_label, (String)UIConnectionMessages.dialog_edit_driver_use_legacy_instantiation_tip, (!this.driver.isInstantiable() ? 1 : 0) != 0, (int)1);
        this.threadSafeCheck = UIUtils.createCheckbox((Composite)optionsPanel, (String)"Thread safe driver", (String)"Driver is thread safe (default). Otherwise DBeaver will lock all driver invocations to protect it from any data corruptions.", (boolean)this.driver.isThreadSafeDriver(), (int)1);
        if (isReadOnly) {
            this.embeddedDriverCheck.setEnabled(false);
            this.anonymousDriverCheck.setEnabled(false);
            this.allowsEmptyPasswordCheck.setEnabled(false);
            this.nonInstantiableCheck.setEnabled(false);
            this.threadSafeCheck.setEnabled(false);
        }
        Group infoGroup = UIUtils.createControlGroup((Composite)propsGroup, (String)UIConnectionMessages.dialog_edit_driver_description, (int)4, (int)-1, (int)-1);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        infoGroup.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Text idText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.dialog_edit_driver_label_id, (String)this.driver.getId(), (int)2056, (Object)gd);
        idText.setToolTipText(UIConnectionMessages.dialog_edit_driver_label_id_tip);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 3 * UIUtils.getFontHeight((Control)infoGroup);
        this.driverDescText = UIUtils.createLabelText((Composite)infoGroup, (String)UIConnectionMessages.dialog_edit_driver_label_description, (String)CommonUtils.notEmpty((String)this.driver.getDescription()), (int)(0xA42 | advStyle), (Object)gd);
        if (!CommonUtils.isEmpty((String)this.driver.getWebURL())) {
            UIUtils.createControlLabel((Composite)infoGroup, (String)UIConnectionMessages.dialog_edit_driver_label_website);
            Link urlLabel = UIUtils.createLink((Composite)infoGroup, (String)("<a>" + this.driver.getWebURL() + "</a>"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShellUtils.launchProgram((String)DriverEditDialog.this.driver.getWebURL());
                }
            });
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.driverDescText.setLayoutData((Object)gd);
            urlLabel.setLayoutData((Object)gd);
        }
        CTabItem paramsTab = new CTabItem(group, 0);
        paramsTab.setText(UIConnectionMessages.dialog_edit_driver_setting);
        paramsTab.setControl((Control)propsGroup);
        UIUtils.asyncExec(() -> propsGroup.layout(true, true));
    }

    private void createLibrariesTab(CTabFolder group) {
        this.libraries.addAll(this.driver.getEnabledDriverLibraries());
        Composite libsGroup = new Composite((Composite)group, 0);
        libsGroup.setLayout((Layout)new GridLayout(2, false));
        Composite libsListGroup = new Composite(libsGroup, 0);
        GridData gd = new GridData(1808);
        libsListGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        libsListGroup.setLayout((Layout)layout);
        this.libTable = new TreeViewer(libsListGroup, 2818);
        this.libTable.setContentProvider((IContentProvider)new LibContentProvider());
        this.libTable.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof DBPDriverLibrary) {
                    DBPDriverLibrary lib = (DBPDriverLibrary)element;
                    Object displayName = lib.getDisplayName();
                    if (lib.getPreferredVersion() != null) {
                        displayName = (String)displayName + " [" + lib.getPreferredVersion() + "]";
                    }
                    cell.setText((String)displayName);
                    Path localFile = lib.getLocalFile();
                    if (localFile != null && !Files.exists(localFile, new LinkOption[0])) {
                        cell.setForeground(JFaceColors.getErrorText((Display)Display.getDefault()));
                    } else if (!DriverEditDialog.this.driver.getDefaultDriverLoader().isLibraryResolved(lib)) {
                        cell.setForeground(JFaceColors.getHyperlinkText((Display)Display.getDefault()));
                    } else {
                        cell.setForeground(null);
                    }
                    cell.setImage(DBeaverIcons.getImage((DBPImage)lib.getIcon()));
                } else {
                    cell.setText(element.toString());
                    if (element instanceof DriverFileInfo) {
                        if (((DriverFileInfo)element).getType() == DBPDriverLibrary.FileType.license) {
                            cell.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_TEXT));
                        } else {
                            cell.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.JAR));
                        }
                    } else {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.JAR));
                    }
                }
            }

            public String getToolTipText(Object element) {
                if (element instanceof DBPDriverLibrary) {
                    DBPDriverLibrary dl = (DBPDriverLibrary)element;
                    Path localFile = dl.getLocalFile();
                    return localFile == null ? "N/A" : localFile.toAbsolutePath().toString();
                }
                if (element instanceof DriverFileInfo) {
                    DriverFileInfo dfi = (DriverFileInfo)element;
                    Path localFile = dfi.getFile();
                    return localFile == null ? "N/A" : localFile.toString();
                }
                return super.getToolTipText(element);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.libTable);
        this.libTable.getControl().setLayoutData((Object)new GridData(1808));
        this.libTable.getControl().addListener(13, event -> this.changeLibSelection());
        this.libTable.addDoubleClickListener(event -> this.editSelectedLibrary());
        UIWidgets.setControlContextMenu((Control)this.libTable.getTree(), manager -> UIWidgets.fillDefaultTreeContextMenu((IContributionManager)manager, (Tree)this.libTable.getTree()));
        boolean isReadOnly = !this.provider.isDriversManagable();
        Composite findClassGroup = new Composite(libsListGroup, 128);
        findClassGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        findClassGroup.setLayout((Layout)layout);
        UIUtils.createControlLabel((Composite)findClassGroup, (String)UIConnectionMessages.dialog_edit_driver_label_driver_class);
        this.classListCombo = new Combo(findClassGroup, 12);
        this.classListCombo.setLayoutData((Object)new GridData(768));
        this.classListCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = DriverEditDialog.this.classListCombo.getSelectionIndex();
                if (selIndex >= 0) {
                    DriverEditDialog.this.driverClassText.setText(DriverEditDialog.this.classListCombo.getItem(selIndex));
                }
            }
        });
        this.classListCombo.setEnabled(!isReadOnly);
        this.findClassButton = new Button(findClassGroup, 8);
        this.findClassButton.setText(UIConnectionMessages.dialog_edit_driver_button_bind_class);
        this.findClassButton.addListener(13, event -> {
            try {
                DriverDescriptor test = new DriverDescriptor(this.driver.getProviderDescriptor(), "test", this.driver);
                this.saveDriverSettings(test);
                DriverClassFindJob classFinder = new DriverClassFindJob((DBPDriver)test, Driver.class.getName(), true);
                UIUtils.runInProgressDialog((DBRRunnableWithProgress)classFinder);
                if (this.classListCombo != null && !this.classListCombo.isDisposed()) {
                    List classNames = classFinder.getDriverClassNames();
                    this.classListCombo.setItems(classNames.toArray(new String[0]));
                    if (!RuntimeUtils.isMacOS()) {
                        this.classListCombo.setListVisible(true);
                    } else if (!classNames.isEmpty()) {
                        this.classListCombo.setText((String)classNames.get(0));
                    }
                }
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
        });
        this.findClassButton.setEnabled(!isReadOnly);
        Composite libsControlGroup = new Composite(libsGroup, 128);
        libsControlGroup.setLayout((Layout)new GridLayout(1, true));
        libsControlGroup.setLayoutData((Object)new GridData(2));
        UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_add_file, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog.this.addLibraryFiles();
            }
        });
        UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_add_folder, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog.this.addLibraryFolder();
            }
        });
        if (!DBWorkbench.isDistributed()) {
            UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_add_artifact, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DriverEditDialog.this.addMavenArtifact();
                }
            });
            this.editButton = UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_driver_manager_button_edit, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DriverEditDialog.this.editSelectedLibrary();
                }
            });
            this.editButton.setEnabled(false);
        }
        this.deleteButton = UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DriverEditDialog.this.libTable.getSelection();
                if (selection != null && !selection.isEmpty() && UIUtils.confirmAction((Shell)DriverEditDialog.this.getShell(), (String)UIConnectionMessages.dialog_edit_driver_dialog_delete_library_title, (String)UIConnectionMessages.dialog_edit_driver_dialog_delete_library_message)) {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof DriverLibraryAbstract) {
                            DriverEditDialog.this.driver.resetDriverInstance();
                            DriverEditDialog.this.libraries.remove(obj);
                            DriverEditDialog.this.changeLibContent();
                        }
                        ++n2;
                    }
                }
                DriverEditDialog.this.changeLibContent();
            }
        });
        this.deleteButton.setEnabled(false);
        UIUtils.createHorizontalLine((Composite)libsControlGroup);
        if (!DBWorkbench.isDistributed()) {
            this.updateVersionButton = UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_update_version, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DriverEditDialog.this.driver.setDriverLibraries(DriverEditDialog.this.libraries);
                    DriverEditDialog.this.driver.getDefaultDriverLoader().updateFiles();
                    DriverEditDialog.this.changeLibContent();
                }
            });
        }
        this.detailsButton = UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_details, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DriverLibraryDetailsDialog(DriverEditDialog.this.getShell(), (DBPDriver)DriverEditDialog.this.driver, (DBPDriverLibrary)DriverEditDialog.this.getSelectedLibrary()).open();
            }
        });
        this.detailsButton.setEnabled(false);
        UIUtils.createToolButton((Composite)libsControlGroup, (String)UIConnectionMessages.dialog_edit_driver_button_classpath, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.showPreferencesFor(null, null, (String[])new String[]{"org.jkiss.dbeaver.preferences.drivers.classpath"});
            }
        });
        UIUtils.createToolButton((Composite)libsControlGroup, (String)ActionUtils.findCommandName((String)"org.eclipse.ui.file.export"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (DBPDriverLibrary lib : DriverEditDialog.this.libraries) {
                    if (DriverEditDialog.this.driver.getDefaultDriverLoader().isLibraryResolved(lib)) continue;
                    if (UIUtils.confirmAction((Shell)DriverEditDialog.this.getShell(), (String)"Not all files present", (String)("Driver files weren't downloaded. You need to click '" + UIConnectionMessages.dialog_edit_driver_button_update_version + "' before exporting.\nAre you sure you want to continue with incomplete files?"))) break;
                    return;
                }
                DriverEditHelpers.exportDriverLibraries(DriverEditDialog.this.getShell(), DriverEditDialog.this.libraries);
            }
        });
        this.changeLibContent();
        CTabItem libsTab = new CTabItem(group, 0);
        libsTab.setText(UIConnectionMessages.dialog_edit_driver_tab_name_driver_libraries);
        libsTab.setToolTipText(UIConnectionMessages.dialog_edit_driver_tab_tooltip_driver_libraries);
        libsTab.setControl((Control)libsGroup);
    }

    private void editSelectedLibrary() {
        DriverLibraryAbstract selectedLibrary = this.getSelectedLibrary();
        if (selectedLibrary instanceof DriverLibraryMavenArtifact) {
            this.editMavenArtifact();
        } else if (selectedLibrary instanceof DriverLibraryLocal) {
            DriverEditHelpers.showFileInExplorer(selectedLibrary.getLocalFile());
        } else {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)this.libTable.getSelection();
            if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof DriverFileInfo) {
                DriverFileInfo dfi = (DriverFileInfo)element;
                DriverEditHelpers.showFileInExplorer(dfi.getFile());
            }
        }
    }

    private void addMavenArtifact() {
        EditMavenArtifactDialog fd = new EditMavenArtifactDialog(this.getShell(), this.driver, null);
        if (fd.open() == 0) {
            this.libraries.addAll(fd.getArtifacts());
            this.changeLibContent();
        }
    }

    private void editMavenArtifact() {
        EditMavenArtifactDialog fd;
        DriverLibraryAbstract selectedLibrary = this.getSelectedLibrary();
        if (selectedLibrary instanceof DriverLibraryMavenArtifact && (fd = new EditMavenArtifactDialog(this.getShell(), this.driver, (DriverLibraryMavenArtifact)selectedLibrary)).open() == 0) {
            this.libTable.refresh();
        }
    }

    private void addLibraryFolder() {
        DirectoryDialog fd = new DirectoryDialog(this.getShell(), 2);
        fd.setText(UIConnectionMessages.dialog_edit_driver_dialog_open_driver_directory);
        fd.setFilterPath(this.curFolder);
        String selected = fd.open();
        if (selected != null) {
            this.curFolder = fd.getFilterPath();
            this.libraries.add((DBPDriverLibrary)DriverLibraryAbstract.createFromPath((DriverDescriptor)this.driver, (DBPDriverLibrary.FileType)DBPDriverLibrary.FileType.jar, (String)selected, null));
            this.changeLibContent();
        }
    }

    private void addLibraryFiles() {
        FileDialog fd = new FileDialog(this.getShell(), 4098);
        fd.setText(UIConnectionMessages.dialog_edit_driver_dialog_open_driver_library);
        fd.setFilterPath(this.curFolder);
        String[] filterExt = new String[]{"*.jar;*.zip", "*.dll;*.so", "*", "*.*"};
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        if (selected != null) {
            this.curFolder = fd.getFilterPath();
            Object[] fileNames = fd.getFileNames();
            if (!ArrayUtils.isEmpty((Object[])fileNames)) {
                File folderFile = new File(this.curFolder);
                Object[] objectArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object fileName = objectArray[n2];
                    this.libraries.add((DBPDriverLibrary)DriverLibraryAbstract.createFromPath((DriverDescriptor)this.driver, (DBPDriverLibrary.FileType)DBPDriverLibrary.FileType.getFileTypeByFileName((String)fileName), (String)new File(folderFile, (String)fileName).getAbsolutePath(), null));
                    ++n2;
                }
                this.changeLibContent();
            }
        }
    }

    private void createParametersTab(CTabFolder group) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        this.parametersEditor = new PropertyTreeViewer(paramsGroup, 2048);
        this.driverPropertySource = new PropertySourceCustom((Collection)this.driver.getProviderDescriptor().getDriverProperties(), this.driver.getDriverParameters());
        this.driverPropertySource.addDefaultValues(this.driver.getDefaultDriverParameters());
        this.parametersEditor.loadProperties((DBPPropertySource)this.driverPropertySource);
        CTabItem paramsTab = new CTabItem(group, 0);
        paramsTab.setText(UIConnectionMessages.dialog_edit_driver_tab_name_advanced_parameters);
        paramsTab.setToolTipText(UIConnectionMessages.dialog_edit_driver_tab_tooltip_advanced_parameters);
        paramsTab.setControl((Control)paramsGroup);
    }

    private void createConnectionPropertiesTab(CTabFolder group) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        this.connectionPropertiesEditor = new ConnectionPropertiesControl(paramsGroup, 2048);
        this.connectionPropertySource = this.connectionPropertiesEditor.makeProperties((DBPDriver)this.driver, this.driver.getConnectionProperties());
        this.connectionPropertiesEditor.loadProperties((DBPPropertySource)this.connectionPropertySource);
        CTabItem paramsTab = new CTabItem(group, 0);
        paramsTab.setText(UIConnectionMessages.dialog_edit_driver_tab_name_connection_properties);
        paramsTab.setToolTipText(UIConnectionMessages.dialog_edit_driver_tab_tooltip_connection_properties);
        paramsTab.setControl((Control)paramsGroup);
    }

    private void createClientHomesTab(final CTabFolder group) {
        this.clientHomesPanel = new ClientHomesPanel((Composite)group, 0);
        this.clientHomesPanel.setLayoutData(new GridData(1808));
        final CTabItem paramsTab = new CTabItem(group, 0);
        paramsTab.setText(UIConnectionMessages.dialog_edit_driver_tab_name_client_homes);
        paramsTab.setToolTipText(UIConnectionMessages.dialog_edit_driver_tab_name_client_homes);
        paramsTab.setControl((Control)this.clientHomesPanel);
        group.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == paramsTab) {
                    DriverEditDialog.this.clientHomesPanel.loadHomes((DBPDriver)DriverEditDialog.this.driver);
                    group.removeSelectionListener((SelectionListener)this);
                }
            }
        });
    }

    private void createLicenseTab(CTabFolder group, String license) {
        Composite paramsGroup = new Composite((Composite)group, 0);
        paramsGroup.setLayout((Layout)new GridLayout(1, false));
        Text licenseText = new Text(paramsGroup, 2626);
        licenseText.setText(license);
        licenseText.setEditable(false);
        licenseText.setMessage(UIConnectionMessages.dialog_edit_driver_text_driver_license);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        licenseText.setLayoutData((Object)gd);
        CTabItem paramsTab = new CTabItem(group, 0);
        paramsTab.setText(UIConnectionMessages.dialog_edit_driver_tab_name_license);
        paramsTab.setToolTipText(UIConnectionMessages.dialog_edit_driver_tab_tooltip_license);
        paramsTab.setControl((Control)paramsGroup);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button resetButton = this.createButton(parent, 8, UIMessages.button_reset_to_defaults, false);
        if (this.driver.isCustom()) {
            resetButton.setEnabled(false);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private DriverLibraryAbstract getSelectedLibrary() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.libTable.getSelection();
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof DriverLibraryAbstract) {
            return (DriverLibraryAbstract)element;
        }
        return null;
    }

    private void changeLibContent() {
        this.libTable.setInput(this.libraries);
        boolean hasFiles = false;
        boolean hasDownloads = false;
        for (DBPDriverLibrary library : this.libraries) {
            Collection files;
            Path localFile = library.getLocalFile();
            boolean bl = hasFiles = hasFiles || localFile != null && Files.exists(localFile, new LinkOption[0]);
            if (!hasFiles && (files = this.driver.getDefaultDriverLoader().getLibraryFiles(library)) != null) {
                for (DriverFileInfo file : files) {
                    if (file.getFile() == null || !Files.exists(file.getFile(), new LinkOption[0])) continue;
                    hasFiles = true;
                }
            }
            if (!library.isDownloadable()) continue;
            hasDownloads = true;
        }
        this.findClassButton.setEnabled(this.provider.isDriversManagable() && hasFiles);
        if (this.updateVersionButton != null) {
            this.updateVersionButton.setEnabled(hasDownloads);
        }
        this.detailsButton.setEnabled(hasFiles);
        this.classListCombo.setEnabled(hasFiles);
    }

    private void changeLibSelection() {
        DriverLibraryAbstract selectedLib = this.getSelectedLibrary();
        this.detailsButton.setEnabled(selectedLib != null);
        this.deleteButton.setEnabled(selectedLib != null);
        if (this.editButton != null) {
            this.editButton.setEnabled(selectedLib instanceof DriverLibraryMavenArtifact);
        }
    }

    private void onChangeProperty() {
        Button button = this.getButton(0);
        if (button != null) {
            boolean isValid = !CommonUtils.isEmpty((String)this.driverNameText.getText());
            button.setEnabled(isValid);
        }
    }

    private void loadSettings(boolean original) {
        this.driverNameText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigName() : this.driver.getName())));
        this.driverDescText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigDescription() : this.driver.getDescription())));
        this.driverClassText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigClassName() : this.driver.getDriverClassName())));
        this.driverURLText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigSampleURL() : this.driver.getSampleURL())));
        this.driverPortText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigDefaultPort() : this.driver.getDefaultPort())));
        this.driverDatabaseText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigDefaultDatabase() : this.driver.getDefaultDatabase())));
        this.driverUserText.setText(CommonUtils.notEmpty((String)(original ? this.driver.getOrigDefaultUser() : this.driver.getDefaultUser())));
        this.propagateDriverPropertiesCheck.setSelection(original ? this.driver.isOrigPropagateDriverProperties() : this.driver.isPropagateDriverProperties());
        this.embeddedDriverCheck.setSelection(original ? this.driver.isOrigEmbedded() : this.driver.isEmbedded());
        this.anonymousDriverCheck.setSelection(original ? this.driver.isOrigAnonymousAccess() : this.driver.isAnonymousAccess());
        this.allowsEmptyPasswordCheck.setSelection(original ? this.driver.isOrigAllowsEmptyPassword() : this.driver.isAllowsEmptyPassword());
        this.nonInstantiableCheck.setSelection(original ? !this.driver.isOrigInstantiable() : !this.driver.isInstantiable());
        this.threadSafeCheck.setSelection(this.driver.isThreadSafeDriver());
        if (original) {
            this.resetLibraries();
        }
        if (this.libTable != null) {
            this.libTable.setInput(this.libraries);
            this.changeLibContent();
            this.changeLibSelection();
        }
        this.parametersEditor.loadProperties((DBPPropertySource)this.driverPropertySource);
        this.connectionPropertiesEditor.loadProperties((DBPPropertySource)this.connectionPropertySource);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 8) {
            this.loadSettings(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void resetLibraries() {
        this.libraries.clear();
        this.libraries.addAll(this.driver.getOrigLibraries());
    }

    protected void okPressed() {
        this.saveDriverSettings(this.driver);
        DriverDescriptor oldDriver = this.provider.getDriverByName(this.driver.getCategory(), this.driver.getName());
        if (oldDriver != null && oldDriver != this.driver && !oldDriver.isDisabled() && oldDriver.getReplacedBy() == null) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)UIConnectionMessages.dialog_edit_driver_dialog_save_exists_title, (String)NLS.bind((String)UIConnectionMessages.dialog_edit_driver_dialog_save_exists_message, (Object)this.driver.getName()), (int)1);
            return;
        }
        if (DBWorkbench.isDistributed()) {
            try {
                this.syncDriverLibraries();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error saving driver", "Driver libraries sync failed", (Throwable)e);
                return;
            }
        }
        if (this.provider.getDriver(this.driver.getId()) == null) {
            this.provider.addDriver(this.driver);
        }
        this.provider.getRegistry().saveDrivers();
        super.okPressed();
    }

    private void saveDriverSettings(DriverDescriptor drv) {
        drv.setName(this.driverNameText.getText());
        drv.setDescription(CommonUtils.notEmpty((String)this.driverDescText.getText()));
        drv.setDriverClassName(this.driverClassText.getText());
        drv.setSampleURL(this.driverURLText.getText());
        drv.setDriverDefaultPort(this.driverPortText.getText());
        drv.setDriverDefaultDatabase(this.driverDatabaseText.getText());
        drv.setDriverDefaultUser(this.driverUserText.getText());
        drv.setEmbedded(this.embeddedDriverCheck.getSelection());
        drv.setPropagateDriverProperties(this.propagateDriverPropertiesCheck.getSelection());
        drv.setAnonymousAccess(this.anonymousDriverCheck.getSelection());
        drv.setAllowsEmptyPassword(this.allowsEmptyPasswordCheck.getSelection());
        drv.setInstantiable(!this.nonInstantiableCheck.getSelection());
        drv.setThreadSafeDriver(this.threadSafeCheck.getSelection());
        drv.setModified(true);
        drv.setDriverParameters(this.driverPropertySource.getPropertiesWithDefaults());
        drv.setConnectionProperties(this.connectionPropertySource.getPropertyValues());
        if (this.clientHomesPanel != null) {
            drv.setNativeClientLocations(this.clientHomesPanel.getLocalLocations());
        }
        drv.setDriverLibraries(this.libraries);
    }

    private void syncDriverLibraries() throws DBException {
        List oldLibs = this.driver.getEnabledDriverLibraries();
        for (DBPDriverLibrary oldLib : oldLibs) {
            List<DBPDriver> usedBy;
            if (this.libraries.contains(oldLib) || (usedBy = DriverEditHelpers.getDriversByLibrary(oldLib)).size() > 1) continue;
            this.syncRemoveDriverLibFile(oldLib);
        }
        for (DBPDriverLibrary newLib : this.libraries) {
            if (newLib instanceof DriverLibraryMavenArtifact) continue;
            if (!(newLib instanceof DriverLibraryLocal)) {
                log.error((Object)("Wrong driver library found: " + String.valueOf(newLib) + ". Must be a local file"));
                continue;
            }
            Path localFilePath = newLib.getLocalFile();
            if (localFilePath == null || !Files.exists(localFilePath, new LinkOption[0])) {
                log.error((Object)("Driver library doesn't exist: " + String.valueOf(localFilePath) + "."));
                continue;
            }
            String shortFileName = localFilePath.getFileName().toString();
            this.driver.getDefaultDriverLoader().removeLibraryFiles(newLib);
            if (Files.isDirectory(localFilePath, new LinkOption[0])) {
                this.synAddDriverLibDirectory(newLib, localFilePath, shortFileName);
                continue;
            }
            this.syncAddDriverLibFile(newLib, localFilePath, shortFileName);
        }
    }

    private void syncRemoveDriverLibFile(DBPDriverLibrary library) throws DBException {
        Collection libraryFiles = this.driver.getDefaultDriverLoader().getLibraryFiles(library);
        if (libraryFiles == null) {
            return;
        }
        DBFileController fileController = DBWorkbench.getPlatform().getFileController();
        for (DriverFileInfo file : libraryFiles) {
            fileController.deleteFile("libraries", file.getFile().toString(), false);
        }
    }

    private void synAddDriverLibDirectory(DBPDriverLibrary newLib, Path localFilePath, String shortFileName) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<Path> list = Files.list(localFilePath);){
                for (Path file : list.toList()) {
                    String shortFileNameForCurrentLevel = shortFileName + "/" + file.getFileName().toString();
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        this.synAddDriverLibDirectory(newLib, file, shortFileNameForCurrentLevel + "/" + file.getFileName().toString());
                        continue;
                    }
                    this.syncAddDriverLibFile(newLib, file, shortFileNameForCurrentLevel);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error sync lib directory", (Throwable)e);
        }
    }

    private void syncAddDriverLibFile(DBPDriverLibrary library, Path localFilePath, String shortFileName) throws DBException {
        DBFileController fileController = DBWorkbench.getPlatform().getFileController();
        boolean isNewLib = Path.of(library.getPath(), new String[0]).isAbsolute();
        Object driverFilePath = isNewLib ? this.driver.getId() + "/" + shortFileName : DriverDescriptor.getExternalDriversStorageFolder().relativize(localFilePath).toString();
        if (library instanceof DriverLibraryLocal) {
            DriverLibraryLocal libraryLocal = (DriverLibraryLocal)library;
            if (isNewLib) {
                libraryLocal.setPath((String)driverFilePath);
            }
        }
        try {
            byte[] fileData = Files.readAllBytes(localFilePath);
            fileController.saveFileData("libraries", (String)driverFilePath, fileData);
        }
        catch (IOException e) {
            throw new DBException("IO error while saving driver file", (Throwable)e);
        }
        DriverFileInfo fileInfo = new DriverFileInfo((String)driverFilePath, null, library.getType(), Path.of((String)driverFilePath, new String[0]), (String)driverFilePath);
        fileInfo.setFileCRC(DriverUtils.calculateFileCRC((Path)localFilePath));
        this.driver.getDefaultDriverLoader().addLibraryFile(library, fileInfo);
    }

    private class LibContentProvider
    implements ITreeContentProvider {
        private LibContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DBPDriverLibrary) {
                Collection files = DriverEditDialog.this.driver.getDefaultDriverLoader().getLibraryFiles((DBPDriverLibrary)parentElement);
                if (CommonUtils.isEmpty((Collection)files)) {
                    return null;
                }
                return files.toArray(new Object[0]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DBPDriverLibrary && !CommonUtils.isEmpty((Collection)DriverEditDialog.this.driver.getDefaultDriverLoader().getLibraryFiles((DBPDriverLibrary)element));
        }
    }
}

