/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.CommonUtils;

public class SQLQueryValueFunctionExpression
extends SQLQueryValueExpression {
    @Nullable
    private final SQLQueryComplexName procName;
    @NotNull
    private final List<SQLQueryValueExpression> operands;
    @Nullable
    private DBSProcedure procedure = null;
    private boolean forRows;

    public SQLQueryValueFunctionExpression(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryComplexName procName, @NotNull List<SQLQueryValueExpression> operands, boolean forRows) {
        super(syntaxNode, (SQLQueryNodeModel[])operands.toArray(SQLQueryValueExpression[]::new));
        this.procName = procName;
        this.operands = operands;
        this.forRows = forRows;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.procName);
    }

    @Nullable
    public SQLQueryComplexName getProcName() {
        return this.procName;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.procName != null && this.procName.parts.getLast() != null ? this.procName.parts.getLast().getSymbol() : new SQLQuerySymbol("?");
    }

    @NotNull
    public List<SQLQueryValueExpression> getOperands() {
        return this.operands;
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        for (SQLQueryValueExpression expr : this.operands) {
            expr.resolveRowSources(context, statistics);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        void var6_15;
        SQLQuerySymbolOrigin origin;
        if (this.procName == null) {
            statistics.appendError(this.getSyntaxNode(), "Invalid function reference");
            return SQLQueryExprType.UNKNOWN;
        }
        SQLQuerySymbolOrigin sQLQuerySymbolOrigin = origin = this.forRows ? new SQLQuerySymbolOrigin.RowsSourceRef(context.getRowsSources()) : new SQLQuerySymbolOrigin.RowsDataRef(context);
        if (this.procName.invalidPartsCount > 0) {
            SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName, origin, Set.of(RelationalObjectType.TYPE_UNKNOWN), SQLQuerySymbolClass.ERROR);
            statistics.appendError(this.getSyntaxNode(), "Invalid function reference");
            return SQLQueryExprType.UNKNOWN;
        }
        if (context.getConnection().isDummy()) {
            this.procName.parts.forEach(p -> p.getSymbol().setSymbolClass(SQLQuerySymbolClass.FUNCTION));
            return SQLQueryExprType.UNKNOWN;
        }
        if (!statistics.validateFunctions()) {
            SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName, origin, Set.of(RelationalObjectType.TYPE_UNKNOWN), SQLQuerySymbolClass.FUNCTION);
            return SQLQueryExprType.UNKNOWN;
        }
        if (this.procName.parts.size() == 1) {
            SQLQuerySymbolEntry name = this.procName.parts.getFirst();
            if (context.getConnection().dialect.getFunctions().contains(name.getName())) {
                name.getSymbol().setSymbolClass(SQLQuerySymbolClass.FUNCTION);
                name.setOrigin(origin);
                return SQLQueryExprType.UNKNOWN;
            }
        }
        List<? extends DBSObject> candidates = context.getConnection().findRealObjects(statistics.getMonitor(), RelationalObjectType.TYPE_PROCEDURE, this.procName.stringParts);
        ArrayList<CandidateProcedure> procs = new ArrayList<CandidateProcedure>(candidates.size());
        try {
            for (DBSObject dBSObject : candidates) {
                DBSObject targetObj = SQLQueryConnectionContext.expandAliases(statistics.getMonitor(), dBSObject);
                if (!(targetObj instanceof DBSProcedure)) continue;
                DBSProcedure p2 = (DBSProcedure)targetObj;
                procs.add(SQLQueryValueFunctionExpression.prepareFunctionApplication(this, dBSObject, p2, statistics));
            }
        }
        catch (DBException dBException) {
            statistics.appendError(this.procName.syntaxNode, "Failed to obtain function information", dBException);
            return SQLQueryExprType.UNKNOWN;
        }
        if (procs.isEmpty()) {
            Object var6_9 = null;
        } else if (procs.size() == 1) {
            CandidateProcedure candidateProcedure = (CandidateProcedure)procs.getFirst();
        } else {
            void var6_14;
            CandidateProcedure firstMatch = procs.stream().filter(p -> CommonUtils.isEmpty(p.validationErrors)).findFirst().orElse(null);
            long totalOkMatches = procs.stream().filter(p -> CommonUtils.isEmpty(p.validationErrors)).count();
            if (procs.stream().allMatch(CandidateProcedure::checked)) {
                if (firstMatch != null && totalOkMatches == 1L) {
                    CandidateProcedure candidateProcedure = firstMatch;
                } else {
                    Object var6_12 = null;
                }
            } else {
                Object var6_13 = null;
            }
            if (var6_14 == null) {
                this.procName.parts.getLast().getSymbol().setSymbolClass(SQLQuerySymbolClass.FUNCTION);
                if (this.procName.parts.size() > 1) {
                    SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName.trimEnd(), origin, Set.of(RelationalObjectType.TYPE_UNKNOWN), SQLQuerySymbolClass.FUNCTION);
                }
                return SQLQueryExprType.UNKNOWN;
            }
        }
        DBSProcedure dBSProcedure = this.procedure = var6_15 == null ? null : var6_15.procedure;
        if (this.procedure != null) {
            SQLQuerySemanticUtils.setNamePartsDefinition(this.procName, var6_15.referenceTarget, SQLQuerySymbolClass.FUNCTION, origin);
            if (var6_15.validationErrors != null) {
                var6_15.validationErrors.forEach(Runnable::run);
            }
            SQLQueryExprType resultType = null;
            try {
                try {
                    if (var6_15.results != null) {
                        if (var6_15.results.size() == 1) {
                            resultType = SQLQueryExprType.forTypedObject(statistics.getMonitor(), var6_15.results.getFirst().getParameterType(), SQLQuerySymbolClass.FUNCTION);
                        } else if (var6_15.results.size() > 1 && var6_15.results.getFirst().getParameterKind() == DBSProcedureParameterKind.TABLE) {
                            HashMap<String, SQLQueryExprType> fields = new HashMap<String, SQLQueryExprType>(var6_15.results.size());
                            for (DBSProcedureParameter ret : var6_15.results) {
                                SQLQueryExprType fieldType = SQLQueryExprType.forTypedObject(statistics.getMonitor(), ret.getParameterType(), SQLQuerySymbolClass.COMPOSITE_FIELD);
                                fields.put(ret.getName(), fieldType);
                            }
                            SQLQuerySymbolByDbObjectDefinition declarator = new SQLQuerySymbolByDbObjectDefinition((DBSObject)this.procedure, SQLQuerySymbolClass.FUNCTION);
                            resultType = SQLQueryExprType.forSynthesizedArray(this.procName.getNameString() + ":resultTable", declarator, SQLQueryExprType.forSynthesizedComposite(this.procName.getNameString() + ":resultRow", this.procedure.getDataSource(), declarator, fields));
                        }
                    }
                    if (resultType == null && var6_15.returnType != null) {
                        resultType = SQLQueryExprType.forTypedObject(statistics.getMonitor(), var6_15.returnType, SQLQuerySymbolClass.FUNCTION);
                    }
                }
                catch (DBException e) {
                    statistics.appendError(this.procName.syntaxNode, this.procName.getNameString() + " failed to obtain function info", e);
                    if (resultType == null) {
                        resultType = SQLQueryExprType.UNKNOWN;
                    }
                }
            }
            finally {
                if (resultType == null) {
                    resultType = SQLQueryExprType.UNKNOWN;
                }
            }
            return resultType;
        }
        SQLQuerySymbolClass tableSymbolClass = statistics.isTreatErrorsAsWarnings() ? SQLQuerySymbolClass.FUNCTION : SQLQuerySymbolClass.ERROR;
        SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName, origin, Set.of(RelationalObjectType.TYPE_UNKNOWN), tableSymbolClass);
        if (candidates.isEmpty()) {
            statistics.appendError(this.procName.syntaxNode, "Function " + this.procName.getNameString() + " not found");
        }
        return SQLQueryExprType.UNKNOWN;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueFunctionExpr(this, arg);
    }

    @NotNull
    private static CandidateProcedure prepareFunctionApplication(@NotNull SQLQueryValueFunctionExpression callExpr, @NotNull DBSObject referenceTarget, @NotNull DBSProcedure procedure, @NotNull SQLQueryRecognitionContext statistics) throws DBException {
        boolean checked;
        ArrayList<DBSProcedureParameter> results;
        ArrayList<DBSProcedureParameter> arguments;
        DBSTypedObject returnType = procedure.getReturnType(statistics.getMonitor());
        List<Runnable> errors = null;
        Collection params = procedure.getParameters(statistics.getMonitor());
        if (params != null) {
            arguments = new ArrayList<DBSProcedureParameter>(params.size());
            results = new ArrayList<DBSProcedureParameter>(params.size());
            for (DBSProcedureParameter param : params) {
                switch (param.getParameterKind()) {
                    case IN: 
                    case OUT: 
                    case INOUT: {
                        arguments.add(param);
                        break;
                    }
                    case RETURN: 
                    case RESULTSET: 
                    case TABLE: {
                        results.add(param);
                    }
                }
            }
        } else {
            arguments = null;
            results = null;
        }
        if (arguments != null) {
            if (arguments.size() != callExpr.operands.size()) {
                errors = SQLQueryValueFunctionExpression.noteError(errors, callExpr.getSyntaxNode(), "Illegal amount of arguments: given " + callExpr.operands.size() + " while expected " + arguments.size(), statistics);
            }
            int i = 0;
            while (i < arguments.size() && i < callExpr.operands.size()) {
                boolean comparable;
                SQLQueryExprType srcType = callExpr.operands.get((int)i).type;
                DBSTypedObject tgtType = ((DBSProcedureParameter)arguments.get(i)).getParameterType();
                DBPDataKind src = srcType.getDataKind();
                DBPDataKind tgt = tgtType.getDataKind();
                boolean bl = comparable = src != DBPDataKind.UNKNOWN && src != DBPDataKind.ANY && tgt != DBPDataKind.UNKNOWN && tgt != DBPDataKind.ANY;
                if (comparable && !DBPDataKind.canConsume((DBPDataKind)src, (DBPDataKind)tgt)) {
                    errors = SQLQueryValueFunctionExpression.noteError(errors, callExpr.operands.get(i).getSyntaxNode(), "Inconsistent parameter type: expected " + tgtType.getFullTypeName() + " while given " + srcType.getDisplayName(), statistics);
                }
                ++i;
            }
            checked = true;
        } else {
            checked = false;
        }
        return new CandidateProcedure(referenceTarget, procedure, arguments, results, returnType, checked, errors);
    }

    @NotNull
    private static List<Runnable> noteError(@Nullable List<Runnable> validationErrors, @NotNull STMTreeNode syntaxNode, @NotNull String message, @NotNull SQLQueryRecognitionContext statistics) {
        if (validationErrors == null) {
            validationErrors = new ArrayList<Runnable>();
        }
        validationErrors.add(() -> statistics.appendError(syntaxNode, message));
        return validationErrors;
    }

    private record CandidateProcedure(@NotNull DBSObject referenceTarget, @NotNull DBSProcedure procedure, @Nullable List<DBSProcedureParameter> arguments, @Nullable List<DBSProcedureParameter> results, @Nullable DBSTypedObject returnType, boolean checked, @Nullable List<Runnable> validationErrors) {
    }
}

