/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConnectionLostDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInputFactory;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.ErrorEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseLazyEditorInput
implements IDatabaseEditorInput,
ILazyEditorInput,
IPersistableElement,
DBPDataSourceContainerProvider {
    private static final Log log = Log.getLog(DatabaseLazyEditorInput.class);
    private final String nodePath;
    private final String nodeName;
    private final String activePageId;
    private final String activeFolderId;
    private final Color connectionColor;
    private final String dataSourceId;
    private final String inputClass;
    private final boolean canLoadImmediately;
    @Nullable
    private DBPProject project;
    private DBPDataSourceContainer dataSourceContainer;

    public DatabaseLazyEditorInput(IMemento memento) {
        this.inputClass = memento.getString("class");
        this.nodePath = memento.getString("node");
        String nodeName = memento.getString("node-name");
        String projectName = memento.getString("project");
        this.project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
        this.dataSourceId = memento.getString("data-source");
        if (this.nodePath == null || this.inputClass == null || this.dataSourceId == null) {
            log.error((Object)"Corrupted memento");
        }
        this.activePageId = memento.getString("page");
        this.activeFolderId = memento.getString("folder");
        RGB connectionColorRgb = StringConverter.asRGB((String)memento.getString("connection-color"), null);
        this.connectionColor = connectionColorRgb != null ? new Color(connectionColorRgb) : null;
        if (nodeName == null && this.nodePath != null) {
            int divPos = this.nodePath.lastIndexOf(47);
            nodeName = divPos == -1 ? this.nodePath : this.nodePath.substring(divPos + 1);
        }
        this.nodeName = nodeName;
        this.canLoadImmediately = true;
    }

    DatabaseLazyEditorInput(String nodePath, String nodeName, String activePageId, String activeFolderId, @Nullable Color connectionColor, String dataSourceId, String inputClass, @Nullable DBPProject project, @Nullable DBPDataSourceContainer dataSourceContainer, boolean canLoadImmediately) {
        this.nodePath = nodePath;
        this.nodeName = nodeName;
        this.activePageId = activePageId;
        this.activeFolderId = activeFolderId;
        this.connectionColor = connectionColor;
        this.dataSourceId = dataSourceId;
        this.inputClass = inputClass;
        this.project = project;
        this.dataSourceContainer = dataSourceContainer;
        this.canLoadImmediately = canLoadImmediately;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_OBJECT);
    }

    public String getName() {
        return this.nodeName;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public IPersistableElement getPersistable() {
        if (!this.canLoadImmediately && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.editors.reopen-after-restart")) {
            return this;
        }
        return null;
    }

    public String getToolTipText() {
        return this.nodeName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public DBCExecutionContext getExecutionContext() {
        return null;
    }

    @Override
    public DBNDatabaseNode getNavigatorNode() {
        return null;
    }

    @Override
    public DBSObject getDatabaseObject() {
        return this.dataSourceContainer;
    }

    @Override
    public String getDefaultPageId() {
        return this.activePageId;
    }

    @Override
    public String getDefaultFolderId() {
        return this.activeFolderId;
    }

    @Override
    @Nullable
    public Color getConnectionColor() {
        return this.connectionColor;
    }

    @Override
    @Nullable
    public DBECommandContext getCommandContext() {
        return null;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.emptyList();
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        return null;
    }

    @Override
    public DBPPropertySource getPropertySource() {
        return new PropertySourceCustom();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseLazyEditorInput that = (DatabaseLazyEditorInput)o;
        return Objects.equals(this.nodePath, that.nodePath) && Objects.equals(this.activePageId, that.activePageId) && Objects.equals(this.activeFolderId, that.activeFolderId) && Objects.equals(this.dataSourceId, that.dataSourceId);
    }

    public int hashCode() {
        return Objects.hash(this.nodePath, this.activePageId, this.activeFolderId, this.dataSourceId);
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        return this.project;
    }

    @Override
    public IDatabaseEditorInput initializeRealInput(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.dataSourceId == null) {
            return null;
        }
        if (this.project != null) {
            this.dataSourceContainer = this.project.getDataSourceRegistry().getDataSource(this.dataSourceId);
        }
        if (this.dataSourceContainer == null) {
            log.error((Object)("Can not find data source '" + this.dataSourceId + "'"));
            return null;
        }
        if (this.project == null) {
            this.project = this.dataSourceContainer.getRegistry().getProject();
        }
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        long connectionTimeout = this.dataSourceContainer.getPreferenceStore().getInt("connection.validation.timeout");
        long connectionStart = System.currentTimeMillis();
        while (!this.dataSourceContainer.isConnected()) {
            try {
                this.dataSourceContainer.connect(monitor, true, true);
            }
            catch (DBException e) {
                Integer result = (Integer)new UITask<Integer>(){

                    protected Integer runTask() {
                        ConnectionLostDialog clDialog = new ConnectionLostDialog(UIUtils.getActiveWorkbenchShell(), DatabaseLazyEditorInput.this.dataSourceContainer, (Throwable)e, "Close");
                        return clDialog.open();
                    }
                }.execute();
                if (result == 6) {
                    return null;
                }
                if (result == 8) {
                    connectionStart = System.currentTimeMillis();
                    continue;
                }
                return new ErrorEditorInput(GeneralUtils.makeExceptionStatus((Throwable)e), navigatorModel.getNodeByObject((DBSObject)this.dataSourceContainer));
            }
            if (connectionTimeout > 0L && connectionStart + connectionTimeout <= System.currentTimeMillis()) break;
            RuntimeUtils.pause((int)1000);
        }
        try {
            DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
            if (dataSource == null) {
                throw new DBException("Connection to '" + this.dataSourceContainer.getName() + "' canceled");
            }
            DBNNode[] editorNodeResult = new DBNNode[1];
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataSource, param -> {
                try {
                    navigatorModel.ensureProjectLoaded(this.project);
                    DBNDataSource dsNode = (DBNDataSource)navigatorModel.getNodeByObject(monitor, (DBSObject)this.dataSourceContainer, true);
                    if (dsNode == null) {
                        throw new DBException("Datasource '" + this.dataSourceContainer.getName() + "' navigator node not found");
                    }
                    dsNode.initializeNode(monitor, null);
                    dBNNodeArray[0] = navigatorModel.getNodeByPath(monitor, this.project, this.nodePath);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
            DBNNode node = editorNodeResult[0];
            if (node == null) {
                throw new DBException(NLS.bind((String)EditorsMessages.lazy_editor_input_cant_find_node, (Object)this.nodePath));
            }
            if (node instanceof DBNDatabaseNode) {
                DBSObject object = ((DBNDatabaseNode)node).getObject();
                DBSInstance instance = DBUtils.getObjectOwnerInstance((DBSObject)object);
                if (instance instanceof DBSInstanceLazy && !((DBSInstanceLazy)instance).isInstanceConnected()) {
                    ((DBSInstanceLazy)instance).checkInstanceConnection(monitor);
                }
                DatabaseNodeEditorInput realInput = new DatabaseNodeEditorInput((DBNDatabaseNode)node);
                realInput.setDefaultFolderId(this.activeFolderId);
                realInput.setDefaultPageId(this.activePageId);
                return realInput;
            }
            throw new DBException("Database node has bad type: " + node.getClass().getName());
        }
        catch (DBException e) {
            return new ErrorEditorInput(GeneralUtils.makeExceptionStatus((Throwable)e), navigatorModel.getNodeByObject((DBSObject)this.dataSourceContainer));
        }
    }

    @Override
    public boolean canLoadImmediately() {
        return this.canLoadImmediately;
    }

    @Override
    @NotNull
    public ILazyEditorInput unloadInput() {
        return new DatabaseLazyEditorInput(this.nodePath, this.nodeName, this.activePageId, this.activeFolderId, this.connectionColor, this.dataSourceId, this.inputClass, this.project, this.dataSourceContainer, false);
    }

    public String getFactoryId() {
        return DatabaseEditorInputFactory.ID_FACTORY;
    }

    public void saveState(IMemento memento) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.editors.reopen-after-restart")) {
            return;
        }
        if (!CommonUtils.isEmpty((String)this.inputClass)) {
            memento.putString("class", this.inputClass);
        }
        if (this.project != null) {
            memento.putString("project", this.project.getName());
        }
        if (!CommonUtils.isEmpty((String)this.dataSourceId)) {
            memento.putString("data-source", this.dataSourceId);
        }
        if (!CommonUtils.isEmpty((String)this.nodePath)) {
            memento.putString("node", this.nodePath);
        }
        if (!CommonUtils.isEmpty((String)this.nodeName)) {
            memento.putString("node-name", this.nodeName);
        }
        if (!CommonUtils.isEmpty((String)this.activePageId)) {
            memento.putString("page", this.activePageId);
        }
        if (!CommonUtils.isEmpty((String)this.activeFolderId)) {
            memento.putString("folder", this.activeFolderId);
        }
        if (this.connectionColor != null) {
            memento.putString("connection-color", StringConverter.asString((RGB)this.connectionColor.getRGB()));
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.dataSourceContainer != null) {
            return this.dataSourceContainer;
        }
        if (this.project != null && this.project.isRegistryLoaded()) {
            return this.project.getDataSourceRegistry().getDataSource(this.dataSourceId);
        }
        return null;
    }
}

