/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMultiplicativeExpression;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.strings.InefficientStringBuffering;
import net.sourceforge.pmd.symboltable.NameOccurrence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsufficientStringBufferDeclaration
extends AbstractRule {
    private static final Set<Class> blockParents = new HashSet<Class>();

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!"StringBuffer".equals(node.getNameDeclaration().getTypeImage())) {
            return data;
        }
        SimpleNode rootNode = node;
        int anticipatedLength = 0;
        int constructorLength = 16;
        constructorLength = this.getConstructorLength(node, constructorLength);
        anticipatedLength = this.getInitialLength(node);
        List<NameOccurrence> usage = node.getUsages();
        HashMap<Node, Map<Node, Integer>> blocks = new HashMap<Node, Map<Node, Integer>>();
        for (int ix = 0; ix < usage.size(); ++ix) {
            NameOccurrence no = usage.get(ix);
            SimpleNode n = no.getLocation();
            if (!InefficientStringBuffering.isInStringBufferOperation(n, 3, "append")) {
                if (!no.isOnLeftHandSide() && !InefficientStringBuffering.isInStringBufferOperation(n, 3, "setLength")) continue;
                if (constructorLength != -1 && anticipatedLength > constructorLength) {
                    Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength += this.processBlocks(blocks))};
                    this.addViolation(data, (Node)rootNode, param);
                }
                constructorLength = this.getConstructorLength(n, constructorLength);
                rootNode = n;
                anticipatedLength = this.getInitialLength(node);
            }
            ASTPrimaryExpression s = n.getFirstParentOfType(ASTPrimaryExpression.class);
            int numChildren = s.jjtGetNumChildren();
            for (int jx = 0; jx < numChildren; ++jx) {
                SimpleNode sn = (SimpleNode)s.jjtGetChild(jx);
                if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                int thisSize = 0;
                Node block = this.getFirstParentBlock(sn);
                thisSize = this.isAdditive(sn) ? this.processAdditive(sn) : this.processNode(sn);
                if (block != null) {
                    this.storeBlockStatistics(blocks, thisSize, block);
                    continue;
                }
                anticipatedLength += thisSize;
            }
        }
        if (constructorLength != -1 && (anticipatedLength += this.processBlocks(blocks)) > constructorLength) {
            Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength)};
            this.addViolation(data, (Node)rootNode, param);
        }
        return data;
    }

    private void storeBlockStatistics(Map<Node, Map<Node, Integer>> blocks, int thisSize, Node block) {
        Integer x;
        Map<Node, Integer> thisBranch;
        Node statement = block.jjtGetParent();
        if (ASTIfStatement.class.equals(block.jjtGetParent().getClass())) {
            Node possibleStatement = ((SimpleNode)statement).getFirstParentOfType(ASTIfStatement.class);
            while (possibleStatement != null && possibleStatement.getClass().equals(ASTIfStatement.class)) {
                statement = possibleStatement;
                possibleStatement = ((SimpleNode)possibleStatement).getFirstParentOfType(ASTIfStatement.class);
            }
        }
        if ((thisBranch = blocks.get(statement)) == null) {
            thisBranch = new HashMap<Node, Integer>();
            blocks.put(statement, thisBranch);
        }
        if ((x = thisBranch.get(block)) != null) {
            thisSize += x.intValue();
        }
        thisBranch.put(statement, thisSize);
    }

    private int processBlocks(Map<Node, Map<Node, Integer>> blocks) {
        int anticipatedLength = 0;
        int ifLength = 0;
        for (Map.Entry<Node, Map<Node, Integer>> entry : blocks.entrySet()) {
            ifLength = 0;
            for (Map.Entry<Node, Integer> entry2 : entry.getValue().entrySet()) {
                Integer value = entry2.getValue();
                ifLength = Math.max(ifLength, value);
            }
            anticipatedLength += ifLength;
        }
        return anticipatedLength;
    }

    private int processAdditive(SimpleNode sn) {
        ASTAdditiveExpression additive = sn.getFirstChildOfType(ASTAdditiveExpression.class);
        if (additive == null) {
            return 0;
        }
        int anticipatedLength = 0;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            SimpleNode childNode = (SimpleNode)additive.jjtGetChild(ix);
            ASTLiteral literal = childNode.getFirstChildOfType(ASTLiteral.class);
            if (literal == null || literal.getImage() == null) continue;
            anticipatedLength += literal.getImage().length() - 2;
        }
        return anticipatedLength;
    }

    private static final boolean isLiteral(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == '\"' || c == '\'';
    }

    private int processNode(SimpleNode sn) {
        int anticipatedLength = 0;
        ASTPrimaryPrefix xn = sn.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (xn.jjtGetNumChildren() != 0 && xn.jjtGetChild(0).getClass().equals(ASTLiteral.class)) {
            String str = ((SimpleNode)xn.jjtGetChild(0)).getImage();
            anticipatedLength = InsufficientStringBufferDeclaration.isLiteral(str) ? (anticipatedLength += str.length() - 2) : (str.startsWith("0x") ? ++anticipatedLength : (anticipatedLength += str.length()));
        }
        return anticipatedLength;
    }

    private int getConstructorLength(SimpleNode node, int constructorLength) {
        ASTAdditiveExpression exp;
        int iConstructorLength = constructorLength;
        SimpleNode block = node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null) {
            block = node.getFirstParentOfType(ASTFieldDeclaration.class);
        }
        if (block == null && (block = (SimpleNode)node.getFirstParentOfType(ASTFormalParameter.class)) != null) {
            iConstructorLength = -1;
        }
        if ((exp = block.getFirstChildOfType(ASTAdditiveExpression.class)) != null) {
            return 16;
        }
        ASTMultiplicativeExpression mult = block.getFirstChildOfType(ASTMultiplicativeExpression.class);
        if (mult != null) {
            return 16;
        }
        List<ASTLiteral> literal = block.findChildrenOfType(ASTLiteral.class);
        if (literal.isEmpty()) {
            List<ASTName> name = block.findChildrenOfType(ASTName.class);
            if (!name.isEmpty()) {
                iConstructorLength = -1;
            }
        } else {
            String str;
            iConstructorLength = literal.size() == 1 ? ((str = literal.get(0).getImage()) == null ? 0 : (InsufficientStringBufferDeclaration.isLiteral(str) ? 14 + str.length() : Integer.parseInt(str))) : -1;
        }
        if (iConstructorLength == 0) {
            iConstructorLength = 16;
        }
        return iConstructorLength;
    }

    private int getInitialLength(SimpleNode node) {
        String str;
        List<ASTLiteral> literal;
        SimpleNode block = node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null && (block = (SimpleNode)node.getFirstParentOfType(ASTFieldDeclaration.class)) == null) {
            block = node.getFirstParentOfType(ASTFormalParameter.class);
        }
        if ((literal = block.findChildrenOfType(ASTLiteral.class)).size() == 1 && (str = ((SimpleNode)literal.get(0)).getImage()) != null && InsufficientStringBufferDeclaration.isLiteral(str)) {
            return str.length() - 2;
        }
        return 0;
    }

    private boolean isAdditive(SimpleNode n) {
        return n.findChildrenOfType(ASTAdditiveExpression.class).size() >= 1;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !blockParents.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode != null && ASTIfStatement.class.equals(parentNode.getClass())) {
            parentNode = lastNode;
        } else if (parentNode != null && parentNode.getClass().equals(ASTSwitchStatement.class)) {
            parentNode = InsufficientStringBufferDeclaration.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private static Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            if (n.getClass().equals(ASTSwitchLabel.class)) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    static {
        blockParents.add(ASTIfStatement.class);
        blockParents.add(ASTSwitchStatement.class);
    }
}

