/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.database;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import org.dbuml.base.database.QueryTransaction;

public class GenericQueryTransaction
extends QueryTransaction {
    int colCount;
    int rowCounter;

    protected void initializeColumnNames() throws SQLException {
        if (this.resultSet != null) {
            ResultSetMetaData meta = this.resultSet.getMetaData();
            this.colCount = meta.getColumnCount();
            this.colNames = new String[this.colCount];
            for (int i = 1; i <= this.colCount; ++i) {
                this.colNames[i - 1] = meta.getColumnName(i);
            }
        }
    }

    public Vector getRows(Connection conn, String query) throws SQLException {
        this.connection = conn;
        Vector v = null;
        if (this.connection != null) {
            this.statement = this.connection.createStatement();
            this.resultSet = this.statement.executeQuery(query);
            this.initializeColumnNames();
            this.rowCounter = 0;
            v = this.getRows();
        }
        return v;
    }

    private Vector getRows() throws SQLException {
        this.bHasRecords = this.resultSet.next();
        Vector<String[]> rows = new Vector<String[]>();
        while (this.bHasRecords) {
            ++this.rowCounter;
            String[] record = new String[this.colCount];
            for (int i = 0; i < this.colCount; ++i) {
                record[i] = this.resultSet.getString(i + 1);
            }
            rows.addElement(record);
            if (this.rowCounter % this.maxRowCount == 0) break;
            this.bHasRecords = this.resultSet.next();
        }
        return rows;
    }

    public Vector getNextRows() throws SQLException {
        return this.bHasRecords ? this.getRows() : null;
    }

    public boolean hasRecords() {
        return this.bHasRecords;
    }
}

