/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] s_allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                return oracleResultSet;
            }
            case 2: {
                return new UpdatableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 3: {
                return new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 4: {
                ScrollableResultSet scrollableResultSet = new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
                return new UpdatableResultSet(scrollRsetStatement, scrollableResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 5: {
                return new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 6: {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
                return new UpdatableResultSet(scrollRsetStatement, sensitiveScrollableResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
        }
        DBError.check_error(23, null);
        return null;
    }

    static String addIdentifierToSql(String string) throws SQLException {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("select");
        if (n == -1) {
            DBError.throwSqlException(88);
        }
        return "select rowid," + string.substring(n + "select".length());
    }

    static String removeForUpdate(String string) throws SQLException {
        String string2 = string.toLowerCase();
        String string3 = string;
        int n = string3.length();
        int n2 = 0;
        char c = '\u0000';
        int n3 = 0;
        String string4 = null;
        n2 = string2.lastIndexOf("for");
        if (n2 > 0) {
            n3 = n2 + 3;
            while (string3.charAt(n3) != '\uffffffff') {
                c = string3.charAt(n3);
                if (c != ' ') break;
                ++n3;
            }
            string4 = string3.substring(n3, n3 + 6);
            if (n3 < n - 5 && string4.equalsIgnoreCase("update")) {
                string3 = string3.substring(0, n2);
                return string3;
            }
            return string;
        }
        return string;
    }

    static int getScrollType(int n) {
        return s_allRsetTypes[n][0];
    }

    static int getUpdateConcurrency(int n) {
        return s_allRsetTypes[n][1];
    }

    static int getRsetTypeCode(int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < s_allRsetTypes.length) {
            if (s_allRsetTypes[n3][0] == n && s_allRsetTypes[n3][1] == n2) {
                return n3;
            }
            ++n3;
        }
        DBError.throwSqlException(68);
        return 0;
    }

    public static boolean needIdentifier(int n) throws SQLException {
        return n != 1 && n != 3;
    }

    public static boolean needIdentifier(int n, int n2) throws SQLException {
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(n, n2));
    }

    public static boolean needCache(int n) throws SQLException {
        return n >= 3;
    }

    public static boolean needCache(int n, int n2) throws SQLException {
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(n, n2));
    }

    public static boolean supportRefreshRow(int n) throws SQLException {
        return n >= 4;
    }

    public static boolean supportRefreshRow(int n, int n2) throws SQLException {
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(n, n2));
    }
}

