/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.NonPlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class NonPlsqlTTCDataSet
extends TTCDataSet {
    private NonPlsqlTTCColumn[] columns;
    private boolean streaming;

    protected NonPlsqlTTCDataSet(NonPlsqlTTCColumn[] nonPlsqlTTCColumnArray, int n) {
        super(nonPlsqlTTCColumnArray, n);
        this.columns = nonPlsqlTTCColumnArray != null ? nonPlsqlTTCColumnArray : new NonPlsqlTTCColumn[]{};
        this.streaming = false;
    }

    protected void marshalRow() throws SQLException, IOException {
        int n = -1;
        int n2 = 0;
        while (n2 < this.columns.length) {
            if (!this.columns[n2].sizeExceeded()) {
                if (this.columns[n2].type.isStream()) {
                    this.columns[n2].pushStream();
                } else {
                    this.columns[n2].marshal();
                }
            } else if (n != -1) {
                if (this.columns[n2].type.isStream()) {
                    this.columns[n2].pushStream();
                } else {
                    this.columns[n2].marshal();
                }
            } else {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            if (this.columns[n].type.isStream()) {
                this.columns[n].pushStream();
            } else {
                this.columns[n].marshal();
            }
        }
        ++this.marshaledRows;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        this.unmarshaledCols = -1;
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].clearNull();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.streaming = this.columns[n2].unmarshal();
            if (this.streaming) {
                return true;
            }
            this.incrementUnmarshaledcols();
            ++n2;
        }
        if (this.isLastCol()) {
            this.incrementeUnmarshaledRows();
        }
        return false;
    }

    protected boolean unmarshalRow(int n, int n2) throws SQLException, IOException {
        this.streaming = false;
        int n3 = n;
        while (n3 <= n2) {
            if (this.columns[n3].unmarshal()) {
                DBError.check_error(401);
            }
            this.incrementUnmarshaledcols();
            ++n3;
        }
        if (this.isLastCol()) {
            this.incrementeUnmarshaledRows();
        }
        return false;
    }

    public void processIndicator() throws IOException, SQLException {
        this.columns[this.unmarshaledCols].setItemOriginalSize(this.unmarshaledRows);
    }

    protected boolean next() {
        boolean bl = this.columns.length > 0 ? this.columns[0].moreRows() : false;
        return bl;
    }

    protected void print(int n, int n2, int n3) {
        OracleLog.print(this, n, n2, n3, "    ---- Enter: NonPlsqlTTCDataSet.print --- ");
        super.print(n, n2, n3);
        OracleLog.print(this, n, n2, n3, "   unmarshaledCols = " + this.unmarshaledCols);
        OracleLog.print(this, n, n2, n3, "   streaming       = " + this.streaming);
        OracleLog.print(this, n, n2, n3, "    ---- Exit: NonPlsqlTTCDataSet.print --- \n");
    }
}

