/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.NonPlsqlTTCColumn;
import oracle.jdbc.ttc7.NonPlsqlTTCDataSet;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class TTCAdapter {
    private MAREngine meg;

    public TTCAdapter(MAREngine mAREngine) {
        this.meg = mAREngine;
    }

    public PlsqlTTCDataSet createPlsqlTTCDataSet(DBType[] dBTypeArray, DBData[] dBDataArray, DBType[] dBTypeArray2, DBData[] dBDataArray2) throws SQLException, IOException {
        DBType[] dBTypeArray3 = dBTypeArray != null ? dBTypeArray : new DBType[]{};
        DBType[] dBTypeArray4 = dBTypeArray2 != null ? dBTypeArray2 : new DBType[]{};
        DBData[] dBDataArray3 = dBDataArray != null ? dBDataArray : new DBData[]{};
        DBData[] dBDataArray4 = dBDataArray2 != null ? dBDataArray2 : new DBData[]{};
        int n = dBTypeArray3.length > dBTypeArray4.length ? dBTypeArray3.length : dBTypeArray4.length;
        byte[] byArray = new byte[n];
        PlsqlTTCColumn[] plsqlTTCColumnArray = this.createBindColumns(dBTypeArray3, dBDataArray3, dBTypeArray4, dBDataArray4, byArray);
        PlsqlTTCDataSet plsqlTTCDataSet = new PlsqlTTCDataSet(plsqlTTCColumnArray, byArray);
        return plsqlTTCDataSet;
    }

    private PlsqlTTCColumn[] createBindColumns(DBType[] dBTypeArray, DBData[] dBDataArray, DBType[] dBTypeArray2, DBData[] dBDataArray2, byte[] byArray) throws SQLException, IOException {
        PlsqlTTCColumn[] plsqlTTCColumnArray = new PlsqlTTCColumn[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            if (n < dBTypeArray.length && dBTypeArray[n] == null && n < dBTypeArray2.length && dBTypeArray2[n] == null) {
                DBError.check_error(435);
            }
            if (n < dBTypeArray2.length && dBTypeArray2[n] != null) {
                if (dBDataArray2 == null || dBDataArray2[n] == null) {
                    DBError.check_error(435);
                }
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] | 0x10);
                plsqlTTCColumnArray[n] = new PlsqlTTCColumn(this.newTTCType(dBTypeArray2[n]));
            }
            if (n < dBTypeArray.length && dBTypeArray[n] != null) {
                if (dBDataArray[n] == null) {
                    DBError.check_error(435);
                }
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x20);
                if (plsqlTTCColumnArray[n] == null) {
                    plsqlTTCColumnArray[n] = new PlsqlTTCColumn(this.newTTCType(dBTypeArray[n]));
                }
            }
            if ((byArray[n] & 0x10) > 0) {
                plsqlTTCColumnArray[n].setOUT(this.newTTCItem(dBDataArray2[n].getItem(0), dBTypeArray2[n]));
            }
            if ((byArray[n] & 0x20) > 0) {
                plsqlTTCColumnArray[n].setIN(this.newTTCItem(dBDataArray[n].getItem(0), dBTypeArray[n]));
            }
            ++n;
        }
        return plsqlTTCColumnArray;
    }

    public NonPlsqlTTCDataSet createNonPlsqlTTCDataSet(DBType[] dBTypeArray, DBData[] dBDataArray, int n, boolean bl) throws IOException, SQLException {
        DBType[] dBTypeArray2 = dBTypeArray != null ? dBTypeArray : new DBType[]{};
        DBData[] dBDataArray2 = dBDataArray != null ? dBDataArray : new DBData[]{};
        int n2 = dBDataArray2.length == 0 ? 0 : n;
        NonPlsqlTTCDataSet nonPlsqlTTCDataSet = new NonPlsqlTTCDataSet(this.createNonPlsqlTTCColumnArray(dBTypeArray2, dBDataArray2, n2, bl), n2);
        return nonPlsqlTTCDataSet;
    }

    private NonPlsqlTTCColumn[] createNonPlsqlTTCColumnArray(DBType[] dBTypeArray, DBData[] dBDataArray, int n, boolean bl) throws IOException, SQLException {
        int n2 = 0;
        if (dBDataArray != null && dBDataArray.length != 0 && dBTypeArray != null && n != 0) {
            n2 = dBDataArray.length;
        }
        NonPlsqlTTCColumn[] nonPlsqlTTCColumnArray = new NonPlsqlTTCColumn[n2];
        int n3 = 0;
        while (n3 < nonPlsqlTTCColumnArray.length) {
            nonPlsqlTTCColumnArray[n3] = new NonPlsqlTTCColumn(this.newTTCType(dBTypeArray[n3]), n, bl, this.newTTCItemArray(dBDataArray[n3], n, dBTypeArray[n3]));
            ++n3;
        }
        return nonPlsqlTTCColumnArray;
    }

    private TTIoac newTTCType(DBType dBType) throws IOException, SQLException {
        TTIoac tTIoac = (TTIoac)dBType;
        tTIoac.init(dBType);
        return tTIoac;
    }

    private TTCItem[] newTTCItemArray(DBData dBData, int n, DBType dBType) throws SQLException, IOException {
        int n2 = dBData.getNItems() == 0 ? 0 : n;
        TTCItem[] tTCItemArray = new TTCItem[n2];
        int n3 = 0;
        while (n3 < tTCItemArray.length) {
            tTCItemArray[n3] = this.newTTCItem(dBData.getItem(n3), dBType);
            ++n3;
        }
        return tTCItemArray;
    }

    private TTCItem newTTCItem(DBItem dBItem, DBType dBType) throws SQLException, IOException {
        if (dBItem == null || dBType == null) {
            DBError.check_error(440);
        }
        return (TTCItem)dBItem;
    }
}

