/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.RegExUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegExUtilsTest
extends AbstractLangTest {
    @Test
    public void testDotAll() {
        Assertions.assertTrue((boolean)RegExUtils.dotAll((String)"<A>.*</A>").matcher("<A>\nxy\n</A>").matches());
    }

    @Test
    public void testDotAllMatcher() {
        Assertions.assertTrue((boolean)RegExUtils.dotAllMatcher((String)"<A>.*</A>", (String)"<A>\nxy\n</A>").matches());
    }

    @Test
    public void testRemoveAll_StringPattern() {
        Assertions.assertNull((Object)RegExUtils.removeAll(null, (Pattern)Pattern.compile("")));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (Pattern)null));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile("")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile(".*")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile(".+")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (Pattern)Pattern.compile(".?")));
        Assertions.assertEquals((Object)"A\nB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (Pattern)Pattern.compile("<.*>")));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (Pattern)Pattern.compile("(?s)<.*>")));
        Assertions.assertEquals((Object)"ABC123", (Object)RegExUtils.removeAll((String)"ABCabc123abc", (Pattern)Pattern.compile("[a-z]")));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (Pattern)Pattern.compile("<.*>", 32)));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\\n<__>B", (Pattern)Pattern.compile("<.*>")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"<A>x\\ny</A>", (Pattern)Pattern.compile("<A>.*</A>")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"<A>\nxy\n</A>", (Pattern)Pattern.compile("<A>.*</A>", 32)));
    }

    @Test
    public void testRemoveAll_StringString() {
        Assertions.assertNull((Object)RegExUtils.removeAll(null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (String)null));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeAll((String)"any", (String)""));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (String)".*"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (String)".+"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeAll((String)"any", (String)".?"));
        Assertions.assertEquals((Object)"A\nB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removeAll((String)"A<__>\n<__>B", (String)"(?s)<.*>"));
        Assertions.assertEquals((Object)"ABC123", (Object)RegExUtils.removeAll((String)"ABCabc123abc", (String)"[a-z]"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> RegExUtils.removeAll((String)"any", (String)"{badRegexSyntax}"), (String)"RegExUtils.removeAll expecting PatternSyntaxException");
    }

    @Test
    public void testRemoveFirst_StringPattern() {
        Assertions.assertNull((Object)RegExUtils.removeFirst(null, (Pattern)Pattern.compile("")));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (Pattern)null));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (Pattern)Pattern.compile("")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (Pattern)Pattern.compile(".*")));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (Pattern)Pattern.compile(".+")));
        Assertions.assertEquals((Object)"bc", (Object)RegExUtils.removeFirst((String)"abc", (Pattern)Pattern.compile(".?")));
        Assertions.assertEquals((Object)"A\n<__>B", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (Pattern)Pattern.compile("<.*>")));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (Pattern)Pattern.compile("(?s)<.*>")));
        Assertions.assertEquals((Object)"ABCbc123", (Object)RegExUtils.removeFirst((String)"ABCabc123", (Pattern)Pattern.compile("[a-z]")));
        Assertions.assertEquals((Object)"ABC123abc", (Object)RegExUtils.removeFirst((String)"ABCabc123abc", (Pattern)Pattern.compile("[a-z]+")));
    }

    @Test
    public void testRemoveFirst_StringString() {
        Assertions.assertNull((Object)RegExUtils.removeFirst(null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (String)null));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removeFirst((String)"any", (String)""));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (String)".*"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removeFirst((String)"any", (String)".+"));
        Assertions.assertEquals((Object)"bc", (Object)RegExUtils.removeFirst((String)"abc", (String)".?"));
        Assertions.assertEquals((Object)"A\n<__>B", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removeFirst((String)"A<__>\n<__>B", (String)"(?s)<.*>"));
        Assertions.assertEquals((Object)"ABCbc123", (Object)RegExUtils.removeFirst((String)"ABCabc123", (String)"[a-z]"));
        Assertions.assertEquals((Object)"ABC123abc", (Object)RegExUtils.removeFirst((String)"ABCabc123abc", (String)"[a-z]+"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> RegExUtils.removeFirst((String)"any", (String)"{badRegexSyntax}"), (String)"RegExUtils.removeFirst expecting PatternSyntaxException");
    }

    @Test
    public void testRemovePattern_StringString() {
        Assertions.assertNull((Object)RegExUtils.removePattern(null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.removePattern((String)"any", (String)null));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"", (String)".*"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"", (String)".+"));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removePattern((String)"A<__>\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"AB", (Object)RegExUtils.removePattern((String)"A<__>\\n<__>B", (String)"<.*>"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"<A>x\\ny</A>", (String)"<A>.*</A>"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.removePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>"));
        Assertions.assertEquals((Object)"ABC123", (Object)RegExUtils.removePattern((String)"ABCabc123", (String)"[a-z]"));
    }

    @Test
    public void testReplaceAll_StringPatternString() {
        Assertions.assertNull((Object)RegExUtils.replaceAll(null, (Pattern)Pattern.compile(""), (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (Pattern)null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (Pattern)Pattern.compile(""), null));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (Pattern)Pattern.compile(""), (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (Pattern)Pattern.compile(".*"), (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.replaceAll((String)"", (Pattern)Pattern.compile(".+"), (String)"zzz"));
        Assertions.assertEquals((Object)"ZZaZZbZZcZZ", (Object)RegExUtils.replaceAll((String)"abc", (Pattern)Pattern.compile(""), (String)"ZZ"));
        Assertions.assertEquals((Object)"z\nz", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (Pattern)Pattern.compile("<.*>"), (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (Pattern)Pattern.compile("(?s)<.*>"), (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (Pattern)Pattern.compile("<.*>", 32), (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\\n<__>", (Pattern)Pattern.compile("<.*>"), (String)"z"));
        Assertions.assertEquals((Object)"X", (Object)RegExUtils.replaceAll((String)"<A>\nxy\n</A>", (Pattern)Pattern.compile("<A>.*</A>", 32), (String)"X"));
        Assertions.assertEquals((Object)"ABC___123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (Pattern)Pattern.compile("[a-z]"), (String)"_"));
        Assertions.assertEquals((Object)"ABC_123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)"_"));
        Assertions.assertEquals((Object)"ABC123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)RegExUtils.replaceAll((String)"Lorem ipsum  dolor   sit", (Pattern)Pattern.compile("( +)([a-z]+)"), (String)"_$2"));
    }

    @Test
    public void testReplaceAll_StringStringString() {
        Assertions.assertNull((Object)RegExUtils.replaceAll(null, (String)"", (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (String)null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceAll((String)"any", (String)"", null));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (String)"", (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceAll((String)"", (String)".*", (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.replaceAll((String)"", (String)".+", (String)"zzz"));
        Assertions.assertEquals((Object)"ZZaZZbZZcZZ", (Object)RegExUtils.replaceAll((String)"abc", (String)"", (String)"ZZ"));
        Assertions.assertEquals((Object)"z\nz", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replaceAll((String)"<__>\n<__>", (String)"(?s)<.*>", (String)"z"));
        Assertions.assertEquals((Object)"ABC___123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assertions.assertEquals((Object)"ABC_123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)"_"));
        Assertions.assertEquals((Object)"ABC123", (Object)RegExUtils.replaceAll((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)RegExUtils.replaceAll((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> RegExUtils.replaceAll((String)"any", (String)"{badRegexSyntax}", (String)""), (String)"RegExUtils.replaceAll expecting PatternSyntaxException");
    }

    @Test
    public void testReplaceFirst_StringPatternString() {
        Assertions.assertNull((Object)RegExUtils.replaceFirst(null, (Pattern)Pattern.compile(""), (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (Pattern)null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (Pattern)Pattern.compile(""), null));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (Pattern)Pattern.compile(""), (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (Pattern)Pattern.compile(".*"), (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.replaceFirst((String)"", (Pattern)Pattern.compile(".+"), (String)"zzz"));
        Assertions.assertEquals((Object)"ZZabc", (Object)RegExUtils.replaceFirst((String)"abc", (Pattern)Pattern.compile(""), (String)"ZZ"));
        Assertions.assertEquals((Object)"z\n<__>", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (Pattern)Pattern.compile("<.*>"), (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (Pattern)Pattern.compile("(?s)<.*>"), (String)"z"));
        Assertions.assertEquals((Object)"ABC_bc123", (Object)RegExUtils.replaceFirst((String)"ABCabc123", (Pattern)Pattern.compile("[a-z]"), (String)"_"));
        Assertions.assertEquals((Object)"ABC_123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)"_"));
        Assertions.assertEquals((Object)"ABC123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (Pattern)Pattern.compile("[^A-Z0-9]+"), (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum  dolor   sit", (Object)RegExUtils.replaceFirst((String)"Lorem ipsum  dolor   sit", (Pattern)Pattern.compile("( +)([a-z]+)"), (String)"_$2"));
    }

    @Test
    public void testReplaceFirst_StringStringString() {
        Assertions.assertNull((Object)RegExUtils.replaceFirst(null, (String)"", (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (String)null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replaceFirst((String)"any", (String)"", null));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (String)"", (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replaceFirst((String)"", (String)".*", (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.replaceFirst((String)"", (String)".+", (String)"zzz"));
        Assertions.assertEquals((Object)"ZZabc", (Object)RegExUtils.replaceFirst((String)"abc", (String)"", (String)"ZZ"));
        Assertions.assertEquals((Object)"z\n<__>", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replaceFirst((String)"<__>\n<__>", (String)"(?s)<.*>", (String)"z"));
        Assertions.assertEquals((Object)"ABC_bc123", (Object)RegExUtils.replaceFirst((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assertions.assertEquals((Object)"ABC_123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (String)"[^A-Z0-9]+", (String)"_"));
        Assertions.assertEquals((Object)"ABC123abc", (Object)RegExUtils.replaceFirst((String)"ABCabc123abc", (String)"[^A-Z0-9]+", (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum  dolor   sit", (Object)RegExUtils.replaceFirst((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
        Assertions.assertThrows(PatternSyntaxException.class, () -> RegExUtils.replaceFirst((String)"any", (String)"{badRegexSyntax}", (String)""), (String)"RegExUtils.replaceFirst expecting PatternSyntaxException");
    }

    @Test
    public void testReplacePattern_StringStringString() {
        Assertions.assertNull((Object)RegExUtils.replacePattern(null, (String)"", (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replacePattern((String)"any", (String)null, (String)""));
        Assertions.assertEquals((Object)"any", (Object)RegExUtils.replacePattern((String)"any", (String)"", null));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replacePattern((String)"", (String)"", (String)"zzz"));
        Assertions.assertEquals((Object)"zzz", (Object)RegExUtils.replacePattern((String)"", (String)".*", (String)"zzz"));
        Assertions.assertEquals((Object)"", (Object)RegExUtils.replacePattern((String)"", (String)".+", (String)"zzz"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replacePattern((String)"<__>\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"z", (Object)RegExUtils.replacePattern((String)"<__>\\n<__>", (String)"<.*>", (String)"z"));
        Assertions.assertEquals((Object)"X", (Object)RegExUtils.replacePattern((String)"<A>\nxy\n</A>", (String)"<A>.*</A>", (String)"X"));
        Assertions.assertEquals((Object)"ABC___123", (Object)RegExUtils.replacePattern((String)"ABCabc123", (String)"[a-z]", (String)"_"));
        Assertions.assertEquals((Object)"ABC_123", (Object)RegExUtils.replacePattern((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)"_"));
        Assertions.assertEquals((Object)"ABC123", (Object)RegExUtils.replacePattern((String)"ABCabc123", (String)"[^A-Z0-9]+", (String)""));
        Assertions.assertEquals((Object)"Lorem_ipsum_dolor_sit", (Object)RegExUtils.replacePattern((String)"Lorem ipsum  dolor   sit", (String)"( +)([a-z]+)", (String)"_$2"));
    }
}

