/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.FastDateFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FastDatePrinterTimeZonesTest
extends AbstractLangTest {
    private static final String PATTERN = "h:mma z";

    public static Stream<TimeZone> data() {
        return Stream.of(TimeZone.getAvailableIDs()).map(TimeZone::getTimeZone);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCalendarTimezoneRespected(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN);
        sdf.setTimeZone(timeZone);
        String expectedValue = sdf.format(cal.getTime());
        String actualValue = FastDateFormat.getInstance((String)PATTERN, (TimeZone)timeZone).format(cal);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue);
    }
}

