#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Cisco and/or its affiliates.
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for nxos_hsrp_interfaces
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


DOCUMENTATION = """
module: nxos_hsrp_interfaces
short_description: HSRP interfaces resource module
description: Manages Hot Standby Router Protocol (HSRP) interface attributes.
version_added: 1.0.0
author: Chris Van Heuveln (@chrisvanheuveln)
notes:
- Tested against NX-OS 7.0(3)I5(1).
- Feature bfd should be enabled for this module.
- Unsupported for Cisco MDS
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the NX-OS device
      by executing the command B(show running-config | section '^interface').
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: The provided configuration
    type: list
    elements: dict
    suboptions:
      name:
        type: str
        description: The name of the interface.
      bfd:
        type: str
        description:
        - Enable/Disable HSRP Bidirectional Forwarding Detection (BFD) on the interface.
        choices:
        - enable
        - disable
  state:
    description:
    - The state the configuration should be left in
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged

"""
EXAMPLES = """
# Using deleted

- name: Configure hsrp attributes on interfaces
  cisco.nxos.nxos_hsrp_interfaces:
    config:
      - name: Ethernet1/1
      - name: Ethernet1/2
    operation: deleted


# Using merged

- name: Configure hsrp attributes on interfaces
  cisco.nxos.nxos_hsrp_interfaces:
    config:
      - name: Ethernet1/1
        bfd: enable
      - name: Ethernet1/2
        bfd: disable
    operation: merged


# Using overridden

- name: Configure hsrp attributes on interfaces
  cisco.nxos.nxos_hsrp_interfaces:
    config:
      - name: Ethernet1/1
        bfd: enable
      - name: Ethernet1/2
        bfd: disable
    operation: overridden


# Using replaced

- name: Configure hsrp attributes on interfaces
  cisco.nxos.nxos_hsrp_interfaces:
    config:
      - name: Ethernet1/1
        bfd: enable
      - name: Ethernet1/2
        bfd: disable
    operation: replaced

# Using rendered

- name: Use rendered state to convert task input to device specific commands
  cisco.nxos.nxos_hsrp_interfaces:
    config:
      - name: Ethernet1/800
        bfd: enable
      - name: Ethernet1/801
        bfd: enable
    state: rendered

# Task Output (redacted)
# -----------------------

# rendered:
#   - "interface Ethernet1/800"
#   - "hsrp bfd"
#   - "interface Ethernet1/801"
#   - "hsrp bfd"

# Using parsed

# parsed.cfg
# ------------
# interface Ethernet1/800
#   no switchport
#   hsrp bfd
# interface Ethernet1/801
#   no switchport
#   hsrp bfd

- name: Use parsed state to convert externally supplied config to structured format
  cisco.nxos.nxos_hsrp_interfaces:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Task output (redacted)
# -----------------------

# parsed:
#   - name: Ethernet1/800
#     bfd: enable
#   - name: Ethernet1/801
#     bfd: enable

# Using gathered

# Existing device config state
# -------------------------------

# interface Ethernet1/1
#   no switchport
#   hsrp bfd
# interface Ethernet1/2
#   no switchport
#   hsrp bfd
# interface Ethernet1/3
#   no switchport

- name: Gather hsrp_interfaces facts from the device using nxos_hsrp_interfaces
  cisco.nxos.nxos_hsrp_interfaces:
    state: gathered

# Task output (redacted)
# -----------------------

# gathered:
#   - name: Ethernet1/1
#     bfd: enable
#   - name: Ethernet1/2
#     bfd: enable
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['interface Ethernet1/1', 'hsrp bfd']
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.cisco.nxos.plugins.module_utils.network.nxos.argspec.hsrp_interfaces.hsrp_interfaces import (
    Hsrp_interfacesArgs,
)
from ansible_collections.cisco.nxos.plugins.module_utils.network.nxos.config.hsrp_interfaces.hsrp_interfaces import (
    Hsrp_interfaces,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=Hsrp_interfacesArgs.argument_spec,
        required_if=required_if,
        mutually_exclusive=mutually_exclusive,
        supports_check_mode=True,
    )

    result = Hsrp_interfaces(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
