---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab api`

Make an authenticated request to the GitLab API.

## Synopsis

Makes an authenticated HTTP request to the GitLab API, and prints the response.
The endpoint argument should either be a path of a GitLab API v4 endpoint, or
"graphql" to access the GitLab GraphQL API.

- [GitLab REST API documentation](https://docs.gitlab.com/api/)
- [GitLab GraphQL documentation](https://docs.gitlab.com/api/graphql/)

If the current directory is a Git directory, uses the GitLab authenticated host in the current
directory. Otherwise, `gitlab.com` will be used.
To override the GitLab hostname, use '--hostname'.

These placeholder values, when used in the endpoint argument, are
replaced with values from the repository of the current directory:

- `:branch`
- `:fullpath`
- `:group`
- `:id`
- `:namespace`
- `:repo`
- `:user`
- `:username`

Methods: the default HTTP request method is "GET", if no parameters are added, and "POST" otherwise. Override the method with '--method'.

Pass one or more '--raw-field' values in "key=value" format to add
JSON-encoded string parameters to the POST body.

The '--field' flag behaves like '--raw-field' with magic type conversion based
on the format of the value:

- Literal values "true", "false", "null", and integer numbers are converted to
  appropriate JSON types.
- Placeholder values ":namespace", ":repo", and ":branch" are populated with values
  from the repository of the current directory.
- If the value starts with "@", the rest of the value is interpreted as a
  filename to read the value from. Pass "-" to read from standard input.

For GraphQL requests, all fields other than "query" and "operationName" are
interpreted as GraphQL variables.

Raw request body can be passed from the outside via a file specified by '--input'.
Pass "-" to read from standard input. In this mode, parameters specified with
'--field' flags are serialized into URL query parameters.

In '--paginate' mode, all pages of results are requested sequentially until
no more pages of results remain. For GraphQL requests:

- The original query must accept an '$endCursor: String' variable.
- The query must fetch the 'pageInfo{ hasNextPage, endCursor }' set of fields from a collection.

```plaintext
glab api <endpoint> [flags]
```

## Examples

```console
- glab api projects/:fullpath/releases

- glab api projects/gitlab-com%2Fwww-gitlab-com/issues

- glab api issues --paginate

$ glab api graphql -f query="query { currentUser { username } }"

$ glab api graphql -f query='
  query {
    project(fullPath: "gitlab-org/gitlab-docs") {
      name
      forksCount
      statistics {
        wikiSize
      }
      issuesEnabled
      boards {
        nodes {
          id
          name
        }
      }
    }
  }
'

$ glab api graphql --paginate -f query='
  query($endCursor: String) {
    project(fullPath: "gitlab-org/graphql-sandbox") {
      name
      issues(first: 2, after: $endCursor) {
        edges {
          node {
            title
          }
        }
        pageInfo {
          endCursor
          hasNextPage
        }
      }
    }
  }'

```

## Options

```plaintext
  -F, --field stringArray       Add a parameter of inferred type. Changes the default HTTP method to "POST".
  -H, --header stringArray      Add an additional HTTP request header.
      --hostname string         The GitLab hostname for the request. Defaults to "gitlab.com", or the authenticated host in the current Git directory.
  -i, --include                 Include HTTP response headers in the output.
      --input string            The file to use as the body for the HTTP request.
  -X, --method string           The HTTP method for the request. (default "GET")
      --paginate                Make additional HTTP requests to fetch all pages of results.
  -f, --raw-field stringArray   Add a string parameter.
      --silent                  Do not print the response body.
```

## Options inherited from parent commands

```plaintext
  -h, --help   Show help for this command.
```
