// Copyright 2020 ConsenSys AG
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package fptower

import "github.com/consensys/gnark-crypto/ecc/bw6-756/fp"

var _frobA = fp.Element{
	4513305906938863657,
	16223881110415437916,
	2594807996890465129,
	12027263585750947831,
	4394688080420790544,
	16545365607090591069,
	17206939158340345469,
	16693218895653628888,
	12341936222077983834,
	15961798706098381578,
	6325965824540199947,
	854909948470066,
}
var _frobB = fp.Element{
	13933438166770692198,
	9936849508207988643,
	15731274946730933551,
	17453539207763286666,
	9211229669332609391,
	16304457798847396452,
	9530634072302290725,
	16589137634438497937,
	3757329544587311773,
	6048657743386074056,
	539268601340212626,
	3128351770947469,
}
var _frobC = fp.Element{
	4513305906938859419,
	12241098542315434076,
	17754824365858099600,
	5821813791745674579,
	7115107423905013045,
	2898523548767316962,
	7403683460125356932,
	16613279480632639560,
	14397298621774850312,
	623298467364696769,
	15794181680107729725,
	1224261424482813,
}
var _frobAC = fp.Element{
	4239,
	7713986544913874944,
	18326082943621398681,
	11034058719804682881,
	13605917749753399936,
	14403079332228435905,
	8290829156933084579,
	14835612456382575210,
	16099265766665295608,
	3563712375774904018,
	6865234425880412574,
	3983261719417535,
}
var _frobBC = fp.Element{
	13933438166770687960,
	5954066940107984803,
	12444547241989016406,
	11248089413758013415,
	11931649012816831892,
	2657615740524122345,
	18174122447796853804,
	16509198219417508608,
	5812691944284178251,
	9156901578361940863,
	10007484456907742403,
	3497703246960216,
}

// Frobenius set z in E6 to Frobenius(x), return z
func (z *E6) Frobenius(x *E6) *E6 {

	z.B0.A0 = x.B0.A0
	z.B0.A1.Mul(&x.B0.A1, &_frobA)
	z.B0.A2.Mul(&x.B0.A2, &_frobB)

	z.B1.A0.Mul(&x.B1.A0, &_frobC)
	z.B1.A1.Mul(&x.B1.A1, &_frobAC)
	z.B1.A2.Mul(&x.B1.A2, &_frobBC)

	return z
}
