// Copyright 2020 Consensys Software Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package bw6761

import (
	"github.com/consensys/gnark-crypto/ecc/bw6-761/fp"

	"math/big"
)

//Note: This only works for simple extensions

func g2IsogenyXNumerator(dst *fp.Element, x *fp.Element) {
	g2EvalPolynomial(dst,
		false,
		[]fp.Element{
			{12120151397272746438, 6715807288640120941, 13740540477958069538, 17908543739706519130, 15332154715954971328, 4921926842942650601, 17531294760873246539, 771101385322412632, 7770156070699652756, 9570568704127498961, 16900530880690347559, 20240513618144944},
			{1611913309784575017, 17152065330768631731, 14520961758296898026, 3282179416901712869, 2690062313728770939, 17027279524706274446, 17719390496270362113, 10894239657955058495, 435149341752653148, 14845073721004590239, 7835861936711174798, 72556703371091440},
			{7806361234633154692, 14572935319633759305, 8712717244336303829, 8620689537460611468, 13937403119775867118, 14838700944919467370, 11496208500265050653, 16623400435058632849, 12878221183356155022, 9033467566284160957, 12249447369649396607, 47741570956694076},
			{15114469094227772399, 4176715117561391953, 2482465971688306218, 12404035987913746729, 15008326048199531534, 8183819013962016997, 7922709748193335774, 18381248223764744054, 9416010618422283539, 10037076471563225590, 5929810381948996170, 49961126619304290},
			{16896489121400383873, 499634775055860103, 6353072003433664039, 11538474919762524373, 15065100135820962887, 4604007316183574411, 6127789083426573151, 718539871524434689, 18335138450229520513, 8434856007629970639, 3819857541542066958, 17653129946801069},
			{2698859718175696977, 11601893395085638405, 12872140761552100822, 13150566323903364975, 7818814911607168431, 827700363459868437, 7969147269575017213, 12449763598196854444, 803059432240159393, 14485657941055036447, 10961477501715145708, 5782045042215181},
			{9080327947498836094, 12136567972200566537, 1756876725653599816, 18332696138428674093, 8790189705125768967, 1555185842167648546, 6055750370798714820, 8897353215561231560, 5583963415928966950, 16789428368979997731, 7932418691967214900, 51603019503428567},
			{9653786999465610409, 11333442690721346729, 8278331325949756851, 3034417612133227644, 5043274768526795629, 16258873574915447536, 7564192860287499867, 1271360982380131960, 6121640489447266701, 3223482172793776390, 13076400907083929034, 20728626969713864},
			{16354369221614892337, 12622883646755328457, 4806741983648648214, 5543408821139816714, 335054654810479385, 1725245699780730639, 14838258118841304315, 18080786328575394168, 5551126928125337476, 7125850023703804524, 1902531454441625574, 55193252546882102},
			{327721756275744164, 3438326309972751775, 14701023121221727766, 12418812707603477727, 18138495741508991945, 17990935519264755825, 18232419304523956202, 5529182668546837318, 9710261746073473348, 7224058994919920143, 9921097170168457948, 5490203139305888},
			{3750953474259678676, 10637094688983271767, 14686560620330903374, 16121302412994041480, 12767426546400280877, 3375229084983979764, 1565889157321132242, 5097367794429617612, 1045204340571383960, 8886295812141313876, 10659234751215465802, 15776111288142706},
			{6256090421704260719, 16404962110517687846, 3797661205571363477, 15361428955492299841, 12343870411627225820, 17598042816825108514, 15393014716644204061, 5572006657780141291, 6913293368951841351, 18338069668539928111, 7544296011114353639, 20715406661468925},
			{16741185691232202561, 10527587850053793018, 16797373410745796103, 9118266949744695978, 10480684926043647203, 17820512589950006599, 4987919540239666259, 5180132996825223442, 12341792468792641516, 3590013143698420947, 17546454267966459864, 615480370108893},
			{11793588016403943576, 5624443706047526297, 9782560381369780226, 5609771771624363136, 5302708741497203869, 9155134504233694106, 11937257793919780362, 3452817137544546993, 13876669961181787953, 9844173543449889482, 5874763275707579418, 67423317076615338},
			{17357196524906793198, 5031395602403897707, 1420167237647120623, 4289808539867747492, 16597103169516433273, 11223671637318228160, 692459729894979961, 1619130617949086340, 15050586669864457806, 16740752066963134010, 16789029089624198162, 18001919516317513},
			{4177100641377926905, 588650200814331678, 351038988427829022, 6529509091053623493, 14167807254673699802, 12229246898186762906, 11237559278911564438, 4035977114354398247, 8029826725537249367, 18414220068154548023, 2266029878054093477, 35875101782014748},
			{7630468390808938479, 5865318481018422528, 14191161503430452116, 8737915447097724590, 16553759362587769610, 5614946431670062423, 7850464921324253752, 16098103376089432214, 1690314891817535506, 16046827515833677672, 621958057791653961, 64952306092833011},
			{10161872830130948459, 3799333501123176281, 7646926408600017047, 3717727554284008517, 5322520655044491922, 16146994457433058293, 5584125491351018856, 993255992669238157, 10042796538069137643, 3670682952547201957, 17696951077973291834, 14102807722214596},
			{17017328956519786504, 10647178419009365031, 4346186403924906688, 4835885808361029971, 4752394454944373534, 5469970431743307869, 7044803496096272853, 17320804767571060196, 5795120763001973059, 7491257379655223979, 6057035019614200360, 22438204470415596},
			{512986582812427354, 5913550825554524828, 11391630796088684915, 2707471823052887089, 13681742373864569502, 10322962470196172186, 2008570293345844181, 3836881678319422784, 14702676938949932159, 8858283935122652451, 621009993074595017, 60190280463642336},
			{7844755833746476096, 11096949580469189074, 9822392506442862422, 794853479755477183, 16643481776479612204, 15976575705503237430, 3232794125254523004, 14588198062606512836, 4717471548131850960, 945446294662007648, 5112491542255781279, 75621256536233658},
			{14793066811059219993, 12204120881173914693, 14863881084799756425, 8360397323070765827, 1918259565411657185, 7802643816134930420, 11751006554544415135, 8216054861996343494, 1908687536118582689, 966926834180432532, 13315229656711701172, 26364839437592958},
			{17521021892952586660, 15779864078966795806, 12490431083915404914, 11755970517745133393, 16992617687646694724, 10381133224904897452, 13530061570320384761, 10970176976804320416, 6570703354048298905, 9314175712427316301, 10260457865914239575, 45344299619547120},
			{14168064136739007245, 8531621513077268685, 12665675318531393747, 6593332428810476345, 17312264776582182392, 15592794558193772069, 4509841697213025627, 16163363234611594534, 11064986031602615137, 16504263565037838422, 10464094855955758323, 11662616493849144},
			{3441757320840809656, 572176315525809871, 3063379886230828964, 18163113959683338003, 4795263963715500056, 13574503943714391617, 7283374229517849390, 7632955856566401620, 1145072197291211444, 3953829556637275749, 4488872553617981871, 60952725986747492},
			{9587696157142479157, 12003808982039009294, 11731385423264354538, 5369346290511052793, 16557479999409793628, 8041685507163714799, 11671354057584915767, 11725592437930629128, 8737485734794352314, 7647324753409953716, 12419838395415924717, 24018206236008031},
			{9333881015436579794, 12456035217764425408, 14781752420365089739, 15111203652488391109, 3404182805627459325, 8573713412192973847, 16731072560718317101, 955831044653836052, 14995740987347665066, 2344964382832179676, 8408955644566573299, 21006805746708397},
			{2721125810561560605, 14377450926588448710, 5748686901392620195, 5927117001502777211, 9043463630273591277, 15787489105269073893, 8679731512840189435, 7727373372850373228, 5635921033015832487, 1259470579086936288, 16800750822217413561, 11600626586562593},
			{10077107057266031085, 3521638543978151787, 4610316563222565940, 16107208142443822409, 17618007202108263438, 9157099097462017253, 4656232088273325163, 13352891503896419942, 7755981688173402403, 9389286565478029249, 597159044274273465, 69816406323529759},
			{15535813238269914840, 6320475163767940565, 9814747045687725975, 14738994286489414766, 11888148940703493560, 9425177580369583400, 15847930303954301708, 14848812859276068285, 13516111574866334846, 12087463919679106975, 12691972626422506651, 4007280177318098},
			{6358570409406581693, 8745119916379516408, 10241062623385876343, 2525780554425309949, 16943440613105344575, 14443656038724426767, 16584908024428075542, 11342831863774648800, 8697079902843392473, 13201726766536722544, 2820504344491864970, 25455365855429264},
			{16512053905803220967, 9531105659195717299, 4175969659283335508, 9832855009408241580, 10482692698011556627, 10601265083201581020, 3838820360180781616, 16633702776559615229, 159871613778202854, 6243186750971453251, 3022087498047088828, 8167628477296636},
			{15026483893018423879, 5739706314254028200, 11224820458303288712, 16334699673770736870, 1668096596101447187, 15961380154008283266, 2592306670278095265, 7770668896515131841, 12845109625788321325, 15684347077793399769, 15637582217740882601, 47899327133925213},
			{15857527824457409323, 15675859760141257993, 2514433839334207107, 18156930448080795418, 8698492041551384184, 8236841693507265590, 8244216531009716346, 15587651224725414075, 6260089329688303368, 3514966923377765282, 2633634543477366502, 25593166554289191},
			{10542191127817310224, 12205611478722843036, 17846269642235472924, 15097681081063116514, 17194898732771312393, 8044795647879249272, 17993057471889610632, 13426332695231665597, 13785302845651736865, 11427333045726670461, 10805301900747035562, 35958086846305380},
			{15811534613089848705, 15998322357836305319, 16831973861799781106, 6002212917742854604, 3292672896866883971, 3094134078755325445, 275269126613926314, 11739466144556045991, 3182684304742277912, 282648545445101575, 7087222051781044815, 45185367451832357},
			{7214620200569377985, 3058061838782898330, 3168883320262352778, 2416219421506622389, 4432173459867745881, 9569040108330342570, 12000176648522827359, 6766605583565672824, 1669077857337544159, 7425253405937656612, 13088452547388282371, 36739558259394768},
			{7400649881422048662, 10325623896702355497, 3429416132468711391, 4019846222145941118, 4388535951465307810, 10138700893509897592, 14296210806827563244, 2235456450135710357, 10673962638466829444, 5656064363870144290, 14593618993797886569, 77712983218315624},
		},
		x)
}

func g2IsogenyXDenominator(dst *fp.Element, x *fp.Element) {
	g2EvalPolynomial(dst,
		true,
		[]fp.Element{
			{4034089381130901657, 14483268041211219587, 4451441384711481103, 15289995952322762790, 2450717769600693102, 4939066300415644795, 17665818208237350352, 1445019538784972335, 7986751941135971859, 18255525212220872509, 15476577744850668494, 73322210825993170},
			{16877478592361177111, 10833452848258573432, 9926383012507540824, 5521390539194443013, 5205497704963021779, 15457440771346998896, 10413486627577379259, 63686222350309181, 11191524218108038929, 17233645404316949919, 8383509538417596624, 15356296300706402},
			{10885928983318699584, 16212284689502690189, 15770232216516049059, 8888013189339548559, 18004832203339077943, 9010447128969815869, 114240654647327888, 16121923159885548800, 11213744310889955555, 9264196641944654564, 14605869656664313329, 75680034030532513},
			{16027320773627738440, 4582196340337860112, 1659794208854522307, 9806316597282278249, 10324949132694519951, 217200962903624790, 6590159423697667862, 17444771178228832824, 1093665253158947154, 4137510875620305328, 3936593568646750730, 57372676670557752},
			{11620879268401676137, 15912796108939169755, 3432082086971509396, 10083345213315663224, 10065624280784400335, 2314531141793906852, 12405448366615340330, 1896260875202321235, 7015016690367163608, 9825467118580503373, 15181110088876217490, 58890311221713886},
			{7054913046289481512, 16426165114078125042, 1131453354745698488, 6044090647785061292, 17053667466966815793, 14450949245495515201, 16887488160528486499, 781115028099033479, 11433780412163190746, 10789468577908750930, 14676050652187098146, 67806592027916800},
			{817988376997625018, 13851995948401834969, 4491054637803705140, 6913840813172078746, 15269266025677559051, 8996767429205543815, 17694738491609746413, 7562457726994989764, 1144602565078433051, 11236220820071522465, 1568162565033920184, 10461164098129874},
			{14930364553222831191, 15625107824672416561, 10458305060070611590, 16848739140853603512, 18369697560622342217, 7825176625812796084, 13719869465899119525, 7675881395385479947, 6593839078335051058, 10841635232104644413, 10506440741777684070, 69154826943646881},
			{9281379408381299575, 8732579043406090026, 18329212793725379715, 7064440300883071064, 13884838478945276814, 18016994348080788160, 15879532812382521741, 5110897321305355314, 17637395577670432126, 5144968370129765543, 9798888327797201234, 28159402934334972},
			{786758149318016233, 9552921270088398038, 17054419493981854920, 9722812397342118614, 15554925920599122582, 10594933253457096307, 8764683122152108410, 13753494948368318795, 5227785290580430959, 7024450023561965396, 5228137164013108430, 25255059890580210},
			{4239874243671064215, 9869543172803174787, 11523576823298241559, 7975585086285899054, 12914427138145784790, 517418902118962787, 14204340181830900461, 1392241133371982497, 5610160462975562536, 1586485301359886088, 14767674906813265413, 56969354764560808},
			{4204520846013633613, 15781787639350773300, 3527174176546611518, 11903579223911601267, 9560038492810528107, 2758073173086660976, 9270770358205506390, 13809684600989557621, 5852862004029577821, 15795113025503181804, 5902646153712794960, 136447428147432},
			{17011961340286177278, 12960746040412439244, 18154972089851163021, 5897061197259326696, 7813678167726110797, 12068198246784311038, 17842534937477860840, 13027224128878374680, 16951763844746213343, 5804376268483644491, 901961782228725938, 14405640427790274},
			{9964160211637024828, 4229257053326732584, 15138800584067967332, 6632221682428683445, 10067875380752319533, 11983640166989208899, 6328573403271184690, 11307822371975441382, 3780539403112375567, 4417541261691493906, 5082562749115058728, 55193732267307156},
			{7529326280646209081, 3773704600168289111, 7739608040219151988, 2445473645931617011, 14921146208627465287, 17368514720729431442, 104319775372793166, 10813639211563670556, 6344685081291620693, 7887308295180422014, 15326574693048076216, 11101260456568638},
			{8638727502487968355, 8793811873840131199, 18421754579426027217, 11302423465945334943, 701852840020548206, 6347141771831649940, 12505502196758118844, 14298275549745160131, 3139963809546792381, 15774415613160613666, 8524196205264500835, 34396655367337732},
			{17528027284921747585, 13157024343858126920, 12584404954156444740, 12916304766692275320, 12205246555196763624, 8125765188623143906, 3726501292428983050, 2360714360014001180, 12944506389821957282, 4326012094622131069, 3187910832089726928, 57477919114509506},
			{8981942604854470500, 11270334066191729275, 4216741627648981541, 5594277714971908791, 1046853099297711197, 4594249616701902254, 187474096403381372, 12609892831123952796, 10235651258842472144, 5094004652269912404, 14454523278602070633, 49732959548995050},
			{1440245581350220722, 8096098811930158748, 15498810886953945105, 17026238898644982788, 7316571624520087206, 12283634286759428592, 8284104939005573081, 17157461073544490502, 17442545303372882247, 16920167904518372584, 4801623123793233489, 45319283453332211},
			{13012290252856915589, 15357958529322406882, 10052755548077331824, 1436561035088554923, 9397532528212116510, 13899060375350362807, 9072013937537302901, 4831822301894376381, 16766085457074548228, 1525520911794566841, 16112602698663096732, 57933610361696240},
			{440413730529244091, 11453483240646462754, 5665762073091138711, 10677891192783409763, 2980389219270684592, 4505871576479429613, 5173751643415804549, 8707535726470096669, 14762624435790976790, 18406426459329174035, 1512063340667375880, 66634567945400485},
			{8433424666278323277, 8273878801512704526, 12862053577433547099, 2420689085014093647, 7207839850278509252, 2185695873739444340, 7257528354806730816, 16500745028258522318, 1705530245362093314, 2972496320996260159, 1844583957379061294, 30925615336361191},
			{8691036474958053808, 10355868253840171432, 10924637488789510807, 14736097610573403866, 235702808403159457, 537783449250127611, 10772847678741733097, 17737069787452147232, 8389164095052562577, 7881082481774682742, 6034369000077175810, 2586612491526127},
			{15025184520847617089, 13262552705760722458, 2069549947723666656, 2658847925265477340, 8312396350294794519, 7307410044437367064, 8024209774442045371, 17549121217792057225, 15906024980413439691, 5787686948761349190, 16517256572249208010, 40632385685489516},
			{13513357329208697565, 1838326212725580686, 4959793103641054037, 12159047954592572177, 396429859638052096, 11083931215815324417, 6286853000796859163, 18139162019024136832, 3388086360418087393, 11129522434411208996, 18382727229393028961, 16838259470959242},
			{1642039008777335180, 6485769662887454727, 5021879162356861574, 15269668983720556352, 6705434572743500407, 3653290154899942230, 15108287157273895706, 16625860524523501041, 16834957293415265963, 5692547493738313847, 12525666732473893730, 78107487730931712},
			{11488477618841670723, 8191053612920828929, 9616312978367459530, 9040191195547711124, 17484186202019513943, 6308522627768284912, 16027556850375401423, 1234819722356370934, 9815945347880068032, 2426979951430631862, 11453875433128332040, 12620528207614541},
			{3769656673177618110, 17620443808637121139, 7208582342684743725, 16433979006588884929, 7448644785651225687, 12611752702255971224, 18371451135763989603, 16065050431293020455, 2740503177206050818, 10583089214685853874, 16952459494407837995, 5179813055331836},
			{16744867974451387273, 651792595892708668, 10789459941568951360, 1448840155196012926, 17743404305915027530, 13957965503576086498, 18011343587536379052, 6381439390771233696, 16560574461330081725, 3514447416932655456, 12536657917881435335, 27482759256736442},
			{2267519959817516351, 16742599431305713757, 11037900572744757864, 2090650273933182986, 7178411200786962215, 16523263519882437117, 13564529993337215207, 8916786095804625573, 16399015619018820086, 5806893380741901078, 2783169248537652470, 12404166756926683},
			{1441976267895364749, 11036313951804941568, 2533042626229443350, 15059360656017349454, 324288258879468221, 7876885753480545979, 8961743374450280660, 8678292114849043747, 9826389634422216728, 16544152621924495449, 9771475077633483496, 77970757489069053},
			{18400748081580733738, 5908125482655638306, 12350570995474287727, 7181208350674039397, 11127602956061025462, 13948898987105922762, 825153742203962288, 8527719241127964335, 3882095797868393295, 3075235511995114999, 13769165584053171021, 5899503638160699},
			{14049583932958966033, 7387618327332905036, 1820670628296981787, 9239079818304462206, 4380138902890628360, 2192703724298249696, 2977925928342400251, 7940032068864945964, 1057830082965650106, 15038784144407899316, 16308609510743847664, 9766435099647163},
			{11890208010863195961, 13137538946584792300, 16525629865546299838, 5435177957456564136, 9626653396581660084, 11948627937511269876, 11330522397417279904, 867632960532672192, 12763178569610173784, 14740156351864500729, 13290814892025806840, 76667808362619137},
			{15461596232012228981, 1570973904648821144, 13525492356120632859, 14011422994777575398, 800400673631112836, 4199633375282825172, 6781269992987822137, 5156749444656095579, 9317018199279020003, 10981372066340617570, 8569492241895916312, 77727039045680286},
			{13531613221209583287, 17496690562264866698, 5298070019410660297, 4514101414290874579, 15409885623584547042, 8702587404713623025, 8201892240140408818, 7212022143789276211, 17970696651069906569, 18211076716316524809, 14685173593431869377, 20300144793908776},
		},
		x)
}

func g2IsogenyYNumerator(dst *fp.Element, x *fp.Element, y *fp.Element) {
	var _dst fp.Element
	g2EvalPolynomial(&_dst,
		false,
		[]fp.Element{
			{7112614505573573772, 17387890417215255726, 7429005326865055742, 16935673335820079183, 16359984292900221375, 12062738262419508873, 3641231435958710415, 12856965635105930833, 8217398095442563912, 5316210013779110770, 7272429583051458483, 9852133169069218},
			{17444044964529060746, 14468313734017774920, 15281959520703379056, 3109283988971478005, 13739366483145116037, 16845069907198621634, 17200085909639247419, 3467005466836706776, 7277475257808742342, 13306406531258729920, 8416198141261442369, 5544577748678334},
			{17566068576396964050, 10828812807330791414, 5779980465168305415, 2346469868637625184, 7396144884221458616, 5855051009311483589, 6310784456433934208, 14758307310680505167, 11494918644281124936, 5346851448024620186, 9833009067421468474, 7625452450524903},
			{6247089440969985611, 5072463750634624892, 4512867008694732867, 3082514776534573217, 16863636463495860716, 10354673328257078387, 10099117221917015881, 15349370021716308309, 5236071212546197626, 9609073653856647291, 882980486291782827, 30123556216137634},
			{3405620762126614946, 2456302036623679257, 16801017954534211815, 624959144826881375, 15972187298405491279, 12445651549865443032, 11453130432941499929, 7864060685757026596, 12002994367922861872, 16437578572851069738, 8542787499654724263, 41760973142900962},
			{7068173681710192396, 16136550637897078782, 687254229272694627, 9464355881286138455, 8163411556719531426, 17053914998347323951, 9887472679974909795, 15412523041487792022, 9933753914789465091, 10277564471646741220, 18097955065871213172, 23184071650085220},
			{16825178780847911400, 11105744691543219159, 17450277686142756814, 985225555618681683, 1125356671580662730, 1516658411947809849, 7259120262003456013, 15549454288913350161, 8853745922514573414, 17500907575763743734, 15740311159860602523, 67258297648828703},
			{2997151005631412143, 18395290250295424418, 15325899360995185574, 856500721560165666, 18059340295582133146, 11046446926587665724, 12992166141267208695, 16177511777598250692, 5427444266930385740, 4417087296308817647, 3558535094730832997, 35283977647796635},
			{8093640466571301117, 10438877682409301089, 8304724042746658940, 17563621545957973085, 18053869242685263150, 10657902634887824006, 9839611402197087901, 12154853714597806114, 9388533023072470378, 2725009771863050363, 8750803172523746055, 28742563956608690},
			{9981674676537072411, 15526749920467521350, 6817900010612293729, 17213832527126036572, 1857460867919706704, 16290631751113030186, 18380697786446085569, 16427460975742889853, 17848654833298055970, 9031058510316883838, 11744712317425326212, 32017399988801089},
			{13640227656810195671, 9609552450531828654, 3948196484664455347, 7909511758909753942, 14797207263704619461, 9268264865048478796, 6955555592612046854, 8065553722312382000, 7937634919501068873, 17901801923360704791, 15453527723321840442, 37205125293687092},
			{596485848645867408, 4058546621830887908, 574137662573891822, 10081686824746142144, 15237605771209013656, 13397889755509721976, 14566397743568143990, 3666031840483343323, 6150793529233006167, 13240288794524732920, 5037511339412925931, 38405508588928098},
			{16521712982958817179, 1863782290968165260, 12223286729550146940, 1495518900223582462, 455593870917573893, 10231250271872948758, 3752075577364856018, 17278739438965701870, 9595349236375064723, 12484931037039115049, 10357408205127530315, 30708790841789176},
			{3322987589964366525, 10521424268077982806, 9832993341058067466, 11688534476904006839, 2895334161424280277, 11677083272635855574, 9077851711320801831, 12090395105079237600, 18391783127822554174, 13846464232531132404, 13753054151837903390, 65015725437960281},
			{12905573474697177104, 16375186819156958286, 17622289801371915377, 13904753304255645148, 5965859248891787016, 11264186450720692311, 8229091605443872498, 9786496974217073127, 18279933768953363942, 5782044103904278311, 9953866136069836334, 59414653533557851},
			{6630250607727715029, 15344238363552223716, 3401876497831785587, 4256745958307431825, 13578196653339376900, 3414914439233173511, 14062437187395824304, 12619128234921080217, 2019506571858457628, 5323817360906489154, 16145203458700124601, 42668244128478291},
			{3689514901376175640, 10101087809085874506, 11192788801565770777, 2550382525737197129, 412199108695898390, 3482401564918407421, 6230455099113267, 5772786511956234924, 5443936093750700349, 17667068613566872870, 378716873830307515, 71110677399003837},
			{15716387663461173868, 17622397427743670298, 3149571681863041339, 11392517696509487392, 1608619488694131866, 11082322053828670704, 140059343520795520, 4598271200561100517, 3418788102110332492, 4732843030065691692, 5912716818817624887, 2941888864670609},
			{8507463254434729022, 16774442690731236429, 16534546889832581612, 9799356094744606813, 3608131923340573876, 567494194509215594, 6269449472142754880, 18264677002179580701, 9809087749177250823, 12507447522809209670, 10901251689561735591, 9047565427141410},
			{2385857811306103427, 12327613920082830493, 16168113594272982028, 18272455443386858334, 16413922144047539440, 18074972613826663681, 14787965252840764879, 16937496253805400197, 15113066430405987925, 18353889876026165847, 6748636029140508691, 62597677607588307},
			{8688880384801293444, 18200893993178100188, 13629406182026122387, 2397700765112835732, 7268639105350288279, 16813331271693696990, 2899222647845765771, 9602767682532721916, 13628192395481796620, 1065646701193734961, 11720157683380318339, 81558452236258620},
			{9158221681373114041, 10339580062873336278, 8523856976899418049, 10660302988308026769, 16954180819274844245, 9469037509301621448, 15022877958665460342, 12954421450926657853, 10427885093579704327, 16661005701560362735, 14456871770440912527, 55444853017428037},
			{6342906352603466097, 9198745996971301639, 4860410905706563185, 11004598112366596805, 15328668537849861076, 9036188025322812651, 3554852993653274521, 8445113904320894472, 16677838606809035074, 15250070322794386020, 6086844598135969172, 51402929183305896},
			{7681446776489876353, 14013955255856540877, 8307061885725787344, 11793660802188144853, 9655203250269093434, 6331383642040051986, 10505920180159787788, 14437599567439562897, 7242996229816598733, 7354408562408950097, 16945154858716351338, 15382188258943265},
			{12342849739035698687, 7167806439227415580, 9474439333925145875, 987669037209619243, 10152100505525602404, 4976075824406506930, 12043176908157436790, 12679301757996039782, 1254281518876270242, 18134343754528003991, 16314518358365223299, 32141328532722449},
			{12615846162634828162, 9282890644231708132, 3444835303600954955, 12084526737186246368, 3020730918176495722, 9046543646981973890, 14660001245741093645, 1126913514990293425, 15619893772049886342, 12744359881659990976, 13673921053755592576, 33286265099462643},
			{7403145996564568026, 15169485192660961846, 5159860730413942254, 14498925607980960410, 405583809555925156, 8486660100837137356, 6832163156291364541, 15718320696868450227, 40327943241581668, 6420956084472233408, 5456117699307713722, 60456959910113988},
			{5393425838225824491, 13469338857078863119, 1410632484314255500, 2171912466751391286, 14935361539482816930, 5980823908688389316, 5918656090703958717, 2684916495192977694, 13139172686946986246, 12378320928168479447, 8652851160424771627, 67193351133348340},
			{4863732733474800246, 18401188185491863152, 14815745260262093335, 2136073857045437578, 7354446871656297119, 15953262948563973879, 347782093180537883, 11463460989503057337, 13347416597170949687, 15578140143865966702, 4851482330807537816, 3052700084107117},
			{7046945260822493641, 948840521190674217, 1764504458963211823, 4920873883283192352, 15945389120103240342, 1475056772737024443, 882315471279471995, 8750260259564659667, 8377305483029118839, 2213807668633108619, 4956588048314526400, 57733629107004372},
			{12465024431621595999, 7081714547490995142, 5805768214358229554, 7901559029849007584, 2153327731889569251, 12393216063822162688, 15284793280634484848, 3402999010595550360, 16292830623146514995, 13818360276244691533, 10099601241887537386, 58009957821609927},
			{12993993948428701444, 2858317162193531960, 13615197199014104086, 230351046757523613, 4415762655578834386, 17567305587324971494, 11030852421954632198, 17821109711912400361, 4926288900394404153, 14518000008967605247, 18327586493492031347, 2026502675591293},
			{5278533551118576696, 17175128171636206744, 17998684636384812213, 9758611677634289230, 3355850949161309423, 5002378919173362777, 865791527951723053, 17009812696570216826, 4152922884778889438, 11229755272773000796, 8681078813221376917, 24839832223482812},
			{9256321254309521323, 1582144595351535846, 16978917317847674439, 16851930829034907017, 11876554559080422853, 1654213409992158116, 1090343544545012453, 16159341025163303814, 18375071706320157733, 13257256202995862322, 9082523614307861884, 75032705498872554},
			{18411803374176875661, 16157902965445478576, 9822041252956261157, 9553878157127453686, 18188748176202977155, 17209073789172139322, 16658692762173918115, 15138143261116204234, 10902748448993247022, 17607221419770525235, 12483744499990579220, 14890289446740249},
			{12009835643290131144, 6551649419194502871, 2852563892096653632, 16867672755323924547, 9114172414837039245, 3937649716778980345, 7049040061000661677, 2449742517395550292, 7941132780203196886, 9584676380780538681, 1430214655269380581, 60194227922694348},
			{7320028312658467180, 7091582506632109342, 5433750417615090249, 6709142223123266453, 9302547970748091901, 16586531627682592911, 9998473331212210242, 12573448488783237343, 13155154110115434952, 5582948635818083941, 3962100974753207885, 31589922066008365},
			{16064356912313441201, 229587054659930979, 11823827490956070152, 4042670786428512862, 9817134544225277723, 13847703664502895982, 18280896187340486161, 4851035356529168768, 5949314736975049081, 3783053969413173694, 10469982831028599003, 55998333968878238},
			{8755369872415960205, 15868460661258077385, 6746512272200856558, 2812553653266536443, 2158751089500167868, 12472145906478820906, 5133898118092534037, 758981268319283139, 12771728784503405211, 1170609045908199593, 1843740889979725160, 79972024788001040},
			{955094662074407880, 17337740123712299760, 5797071286999796644, 4374727053892761038, 13432501956834174660, 8910570921059778779, 10857499375538487433, 3340715020898029851, 15401281297779478340, 2633167604995435511, 7277227228011983321, 26795154572804501},
			{15205120623746801869, 9145764108985355180, 1960190997921921716, 16666315554907267150, 2001985279412720394, 11575668695494002846, 2255254411522632614, 6626695415676380165, 9209224573760845326, 2875882070705562268, 814647984139403022, 58061666317399111},
			{11022443378060681697, 2266100175075526369, 16179844751235813262, 6523538875238342060, 14983682887709307963, 2402351449614599244, 16988633310676276521, 4221300516553886191, 15304750625662003147, 7036546309103285369, 8515162265983416564, 6668747496653550},
			{9276746002521599392, 268836709236546347, 18349895766543270073, 18089223546880845614, 14873672806567627008, 14855661405076609299, 17142934707908337460, 13733766174906673486, 11183874352213224563, 10775677560089821897, 14481726277440526846, 71170832192665744},
			{2247323934488785519, 6070204811093256619, 929659923436911494, 6514839986538367093, 16999531498754996253, 11828878313758656673, 4424139234662392045, 389694224949611092, 12322551500326419904, 3430156628512563956, 15376076574498080754, 67732243240063003},
			{8716643130885743531, 16228797283259102748, 1275494042780304698, 10013710337081458578, 2233822495620829511, 14719252090946821049, 2865137843661290216, 791323909760550966, 14897542107083926301, 15960516227432058399, 2036870631986638514, 11465393278340982},
			{984166467017986370, 5032726470730104056, 6742650024960257927, 12065540855287442564, 5167810106821532358, 13489548697595184761, 6008812869035030974, 768984321990256717, 4949538023285618887, 5868835173520200588, 16448438526770509508, 21698508193074186},
			{13359364287922490398, 9512038613791872920, 315582911336527720, 12870388174217134376, 12110076377780921795, 13908489236627939473, 11082448394902226648, 17339837515389563313, 3548601305325100486, 7744491950830685922, 2930574826431616977, 43623277398584928},
			{8396608986145700722, 15774593575091064206, 2173945182660481537, 9076194200920786261, 13338239260943895251, 2725137347385122298, 1081300825429000061, 15635530775270071536, 17213068420905058186, 18336028284655037092, 11175943920233302462, 6583464081697255},
			{12818472471450628853, 16982568722029875540, 2646087688357376790, 121222269220584641, 8241747187411735031, 6682586638884177253, 6467004056815430563, 18235847175243813438, 440832632748013656, 10319357930916215769, 9168858203515717520, 23149429850058981},
			{13248844600378056136, 1117592797443083840, 11724577322142316631, 13160789890745282787, 2216788650286545833, 14455247225769604548, 1271416317472928824, 17623413792214459255, 12814963398424940254, 14540875238156310952, 3454895845746193134, 10311812536490481},
			{16129253410013180873, 13215610869973209361, 5327882888445975374, 16106603940586740317, 2941323278109633791, 7625325384383167236, 11882785624978274418, 372905111805339482, 13773293871399530622, 3723360816715343375, 3284017953544442080, 66395732279924744},
			{2820952583412975985, 5174860860979474468, 4557189665959191282, 13590527859484872544, 13255332927700513943, 1080948932695940298, 10480551920105566279, 9204398111772714286, 15072346751681095668, 9557181260282724694, 14955174377801330563, 5307491454957844},
			{1993820821411218652, 16914157580458718416, 4289030558138737509, 1203036226692825911, 5610766216973229156, 18334889918429924159, 10003272465707294487, 359064641797995947, 14274683764321936343, 9251316611686707268, 4594998516872625813, 76392150647100842},
			{2757372384928704719, 4490455312342931451, 2908787859348479917, 3065687104959530715, 7438575038246053966, 14382157166629375270, 14289601483889162511, 4009704878210750269, 1079140006987657541, 1567601784540135468, 15104027989968458666, 29152613436960634},
			{7423015408621128732, 17540351087154700243, 5042698470388953525, 7223639800108209563, 17629244503623486068, 14168085454261172020, 14099638289084950690, 17978263308087521500, 18215882834796925821, 945616097071052005, 6790086883133147916, 77344178427451439},
		},
		x)

	dst.Mul(&_dst, y)
}

func g2IsogenyYDenominator(dst *fp.Element, x *fp.Element) {
	g2EvalPolynomial(dst,
		true,
		[]fp.Element{
			{15352945671569580611, 2193851617865193660, 18196598416328555184, 17275132829270017942, 4890939054800637279, 15081695818496033794, 5748861378547866694, 1073935720284132832, 11983257218807282771, 18156724836980600077, 2062913630182313572, 50299209337535394},
			{389648733566547757, 16385476581597616123, 3065904522266520025, 5745615171355137864, 3587664266522186794, 3955798634888371109, 2036703773404352148, 14922667782455613664, 2201098992510818655, 2313571427319169190, 11896733634764823145, 76477532806344474},
			{16191272656322618927, 15157148397823895327, 121085193423483420, 2600747229928203879, 17937690349120749050, 14715909178520116857, 2427679217954835636, 7487426876212173329, 10727265426917552313, 15727918402269807194, 6296464053189313537, 35953712190541458},
			{8028290268190971547, 870357351498848681, 14470989172389361015, 15103567277958912675, 8935030055962388181, 10649317844542544508, 2155598219855587562, 8806806658670691461, 11679985719695057966, 13778844652428297431, 3910792454337934524, 79077263419426545},
			{17958334940516139759, 10313168760671509861, 1706072914060716174, 217860690797775546, 7043030980933313940, 5121201576735590711, 14592948320130260175, 9203081628869026802, 11273745817644174341, 17139045281431472040, 5633018707652841131, 53706544738632570},
			{13821487800808194032, 11247476311350702566, 8561690398535905380, 13958356324038764834, 7766508383048012995, 12760935818314532303, 18401557521044834942, 11564693333930401932, 4955839093736069694, 12285896028272820692, 15854737672282948123, 843007441223388},
			{2591143556511109764, 3845479455680379536, 16129368911909699474, 1709611269674074933, 11534577437533610444, 7695518235122088199, 18269032563068393742, 3090249947430837382, 15636241978379730311, 17716979399362563296, 17302268857308565945, 65993659659151140},
			{7470253392920991020, 13383989558703550307, 13807121089397637357, 2483721490930261444, 881810811713722904, 3230923670071048309, 11557536637885815450, 10658846872965514299, 8064611610573558292, 4846718841616774749, 785913122589158392, 33652722691860423},
			{9980877239151974083, 17215229297498249095, 13687836102216907559, 1071812658436511661, 5366932239338842980, 6619753091821866980, 5253433935876453160, 4318265448053795825, 8325843985453987647, 363014720913963148, 18314190045282875882, 25984131951585597},
			{17366724877955396482, 1565708205748291471, 9539437640573196109, 17705586489124110219, 17996783789531705669, 10483158879983556220, 2877736869928568437, 11109326245953107875, 8642007171255563606, 6143659449456445866, 17029842763615935623, 72486607116144068},
			{7780655086577668128, 16754688307792523088, 16777553322927371080, 4148314713918870874, 6378814829824799270, 1127093230230892743, 3658978075969622036, 12972891068445602704, 15716995367830336595, 14348277148129300258, 18281131700583550779, 14018457066986867},
			{4905331512832326840, 6883395104906355001, 676735823080439441, 16015088521218092929, 1367364798184974539, 10687972180665875557, 3572425323722445427, 18100498134794252900, 7758486463541321173, 1653167119932360130, 3016054492263016798, 35231363300490146},
			{13093560093307770594, 10412419557593627918, 14843328646332544767, 9003179974180746417, 10132910573126486683, 16213489543162864271, 17659308722901226279, 9179841748155476203, 5543075050539250547, 17774027011680072109, 8048307417105396952, 18458308366409961},
			{17139004960425355652, 17553973090091723625, 4121023740042283991, 3542162120986453115, 6359214792038438511, 14113458746350343345, 5960132641227610830, 4055283336335013091, 14664486150819759906, 15466119993313920138, 16889453859556346984, 49044579193992925},
			{1493068096507913449, 3224136459495761549, 16392267583814126232, 9637824831556253210, 9451001030448000111, 12423683940269302123, 9260754944567695520, 7474711975578793240, 6625253427016137109, 3090570248896200435, 5248375517073789097, 41422893088276144},
			{3139953034609656197, 3737181869076881686, 12210488969159248434, 11091090932979439811, 1289569277317361407, 3164001435721110203, 13726591245744335349, 7584413074828782154, 16347822078008112650, 5357460233106638476, 12839906667241287382, 43169620996292942},
			{3145888645047846760, 6106615558329072652, 1301007599719144830, 7265945014494234651, 12105835766428902336, 11393173289756539476, 13516555840865497168, 17846510820514530133, 7054113960029080898, 2147161361078464280, 13066123931776185546, 69848274644730384},
			{15470839807676426458, 3285072362954118138, 1218938215061036370, 109656234411722491, 6206594886838402118, 16376311753954746758, 3943240987807789876, 7820780709673385940, 6653361874484381198, 3225068510690782788, 6262830209224563614, 23188606569365902},
			{12953062684493857681, 12614023627035991551, 7250680794171274487, 14665902728065348210, 8840516914519903963, 16528711177081313126, 6685300616241674105, 4897919576256935680, 3715117532806830417, 4541536777452071575, 17817715623155981754, 24478803752779549},
			{1379566154082346104, 13300549802483786502, 15055408824796898293, 8115903096799870285, 18125584629109827655, 15368987092151078859, 7156991327400151243, 17993100081054634210, 14746838865400644108, 17440904723152147331, 13738299337579750542, 29824028604210516},
			{7092702527869281358, 12324955866098878655, 3007923394460738430, 12188106466833114065, 18342493947237816281, 6730265836657749076, 14053686569012181356, 14562264771510618173, 8911462600990272603, 7628275411839932340, 10192632719254647901, 16028230668940736},
			{2187388544398789188, 6968741084985789407, 255385146171851770, 5129383198562951111, 783310702295738744, 558470666858131990, 15271799902217469087, 1462122009433706310, 13141544500687010269, 12452220581102026516, 16245494100126972328, 80421442248676230},
			{13130701806849521601, 8522944325662337014, 3013447996730118963, 10721815006044068740, 11662008336436500207, 1253395642239297503, 17219572800522082128, 16279058375340405566, 3552372137383129936, 4752448333113672528, 237004133471144382, 53930958380401347},
			{7633750964277192287, 11156171285789745605, 11311863857890847072, 10233141787452270304, 10314725181794381440, 14273588547057294667, 7840596548461806332, 6047652389387777395, 17039183846775567214, 15871188921254153600, 191842359404842843, 861365611052318},
			{17218077321232020058, 6253601890457253410, 11830680517825007765, 18277535530185254113, 4543573841039293087, 4624204188852346537, 2715513311014798715, 17477119562252376801, 11583309584903190115, 10227177260743314371, 6412630077571002695, 52709269942632325},
			{7937062059603120140, 7202211810453946753, 4665736464900394747, 14817771393072824628, 16439541138804884773, 15883443455746586764, 10624480594745883522, 3469867609346225279, 15969102534404496639, 2493221615668426085, 8504347560449543846, 70867163869565308},
			{51218898597092707, 3991228630502864456, 7421587398004222217, 5862417269953051140, 5882487400510422936, 16706784374765647780, 12057559834003068005, 10932010217105162943, 15857288000968539353, 1700402055354691841, 12497968593795802739, 3823737344241615},
			{8005246360157307301, 8314785729351433883, 12933735122870813436, 2531780817977405195, 9717826153646119694, 8895258669589108634, 3690605436485081836, 13734211415439785833, 1254702430386841233, 18356385523655415843, 16654485898324416815, 79794457042200988},
			{11613731819157702591, 11608738153805509311, 10591068135776900947, 4046783333783911982, 17257210721259147846, 12258417797050289582, 2746449487499369701, 17853183579479067404, 12945972843244603403, 95176115883496875, 17724094961091641789, 5391557768385299},
			{4556679796981384541, 7098128442816933714, 16546458142743430358, 16490342912870722534, 14163449535140222560, 12981735206718205900, 4538569123178788711, 16162638563236275080, 9074039145180304828, 12459152606782009204, 10847630998694759437, 42466751823426512},
			{9316912503532037114, 1500463403760070937, 7714893606127237444, 16853985467937007591, 17805055034967068285, 568391204560766424, 3070508713252956746, 1893924981425975223, 17236299505607492081, 4678684122314754491, 13501880978693956759, 55987595538089925},
			{1385317238581422578, 14996219161052578950, 36113637184546041, 14144263881122096377, 2117167523608137710, 14136595741248223573, 16425632887998463268, 18238750375610295803, 15416747526988726127, 6250324514799947977, 2798940973572445278, 20932799401740173},
			{1933595706157777861, 10032301274132928363, 12339624866382245993, 2434169019262740750, 15937416915751749853, 14909525615033917160, 8650096029068201454, 12279188644655705560, 12000607615058474909, 10107807121692649544, 12817266211101970783, 69923651274833519},
			{4224860683915433701, 958268778277968244, 15811796690087695749, 17708027161340446961, 7676490327544522380, 12146956953325068488, 17136100075974456414, 15847007262970909874, 941246694776752476, 17331530239339710789, 3646289618513204890, 43388828229109793},
			{8457907263903683747, 7736836339527638451, 14387571226855655615, 18005405109628790766, 6440637281102287859, 18160240233681389966, 14038638704804738412, 13064126341917559585, 7496578389634703384, 13050912345078672527, 16618162173832168021, 21961038843865323},
			{10507012853450595662, 1986056155893747557, 8500929148500415211, 2413215660915540285, 1094350483594377721, 1160164158885756762, 13564323827127862199, 12478155216325567767, 4904807408065639004, 11841402881929401245, 11423559125533656603, 44770705994711388},
			{8572689347111670893, 15146204870769510610, 16150703690694839883, 17552898049721681875, 11686229158085423521, 5512707738231694645, 15437298925144365321, 14141710840268101870, 18437859473583976830, 17298144091486552921, 7908484816971905415, 68714808223668683},
			{1940726943563209102, 10075246209249571281, 3649167332396911746, 8755119901285815046, 14943464777716535902, 2895279400248600300, 3801722031778133515, 6782868554500174897, 15669178246863815828, 18172433149167695555, 3843945528797107126, 62362371401479298},
			{629678096221699936, 16651102884973908021, 16216174528504345067, 3068565252434825808, 6613829499358696441, 5902832052676564286, 12597276907926898757, 17054480803395600618, 16819882257433064743, 17776366874688844558, 6489819890232943129, 15295360552282095},
			{9377976794097267007, 15119970307680918249, 6510915296532229075, 4381131227447477257, 15574301573221857715, 14302469628659254869, 13063259447373884395, 16581280936384537857, 14846762895212532299, 15376395245673652944, 9040238936599495821, 68434081898622106},
			{595816493793857614, 13499724253837431052, 14189048707837205282, 15389354588996467069, 3547404103650965280, 10909608777998812300, 17696330402894875197, 18398104121539889481, 13012048716535109352, 2286338735819533781, 18058370901745575229, 77187811263036109},
			{3654519676072801464, 13865775425217257691, 1939354330957250958, 7485344344923952519, 7597226276403230085, 13690176655314747142, 4456724942107738790, 3534929391430615676, 2906644060271059719, 13625348313652153951, 1991210462421154408, 17463590705889343},
			{18242311187911659508, 8308740380360444778, 16120712477191683457, 10286422887556095900, 1391515279733643229, 13683197410474143076, 6519892266916542888, 491059090042186544, 5494757803396491795, 5147346213503168908, 7140132527619692588, 73522311462221609},
			{18056312371584353172, 13690936081373963422, 7513492438399189548, 1025217077925019594, 3311418906168048280, 9259212576603667183, 12152778839352941276, 15498822217444334989, 16809810458569997478, 6698250781267087811, 4423900574815805414, 60830241231936027},
			{8556704869573795799, 10637161075745578262, 5038520220436392413, 377303925557318359, 4010077829733960045, 11213702745772429727, 16600985964381068502, 3981464230565479499, 18131489312629592535, 7503636817861264625, 17181439517924370818, 59709238520722038},
			{10228338383775470792, 3392293219289565260, 1087596920574271034, 6265291814265180419, 12907374151239354510, 2250418006484971015, 8267026277699910455, 7247778858570071711, 9889864213770192020, 10078649619671172262, 14014474425595754102, 7911771856140440},
			{6644693354503572005, 3965959451360397752, 16330473199607765522, 12989144711965356108, 13573347269204732630, 11518182726440335915, 13290356799041197196, 13372184130251092546, 12783071055809245899, 4053020188661658022, 8830116122159340469, 80504880551543856},
			{13574078475397492308, 10440936231159833549, 15572032956112661281, 18333512652895815956, 6485610610108185152, 1423775795085039095, 7766488587494096515, 2148270303013061874, 520626559669527330, 13569631588603847753, 11565494002920419320, 9633497780096588},
			{4651026501971446407, 8376269394739566772, 243196826255852424, 7696147443258332243, 12090004444013876124, 2540847875934442122, 16618319865721571676, 11676885148924326991, 4974055981099856761, 16848782834942747096, 13614513365120342500, 52527124675893200},
			{8888428672804377243, 6196300894848420349, 16710273896097828990, 16594219079043574606, 7934388800247084874, 9754332999408879649, 17074455434241987685, 16790373398494817873, 6695281025877439817, 13777671795904165565, 7400629548500266907, 40475182212968032},
			{3367234301504805996, 2521342697132667329, 2798031187369625276, 3833902812528745153, 1790873897273191450, 3585324562325681797, 17854104642807565351, 6626262857555421837, 15940580594930317052, 10047712079430752051, 8387280358497486155, 68508693992288095},
			{12828878256139070093, 1207089534994798081, 4800948775485306525, 15135214903729724981, 8328092507507781793, 3696324725355200719, 15276572038379455254, 14870292744004997959, 16188159346259154031, 7904268264017349484, 4291249925852158700, 3804345011796800},
			{16412637639263205218, 8964044197943840951, 6194050764468414393, 2990792437265279627, 4797662439121832803, 1593663384117388133, 565766238174920340, 17503941611932570479, 15467329331053007327, 18076916943110711047, 14650032082343012160, 70356293035891060},
			{10663798016403818072, 16105356328999268241, 17964936165323056074, 12270200515908593080, 17993789180998701290, 17901131403791874994, 12440019476374697325, 14870660574525120217, 2258650930838777070, 6317187859838084307, 11130145092729015106, 71391711582001218},
		},
		x)
}

func g2Isogeny(p *G2Affine) {

	den := make([]fp.Element, 2)

	g2IsogenyYDenominator(&den[1], &p.X)
	g2IsogenyXDenominator(&den[0], &p.X)

	g2IsogenyYNumerator(&p.Y, &p.X, &p.Y)
	g2IsogenyXNumerator(&p.X, &p.X)

	den = fp.BatchInvert(den)

	p.X.Mul(&p.X, &den[0])
	p.Y.Mul(&p.Y, &den[1])
}

// g2SqrtRatio computes the square root of u/v and returns 0 iff u/v was indeed a quadratic residue
// if not, we get sqrt(Z * u / v). Recall that Z is non-residue
// If v = 0, u/v is meaningless and the output is unspecified, without raising an error.
// The main idea is that since the computation of the square root involves taking large powers of u/v, the inversion of v can be avoided
func g2SqrtRatio(z *fp.Element, u *fp.Element, v *fp.Element) uint64 {
	// https://www.ietf.org/archive/id/draft-irtf-cfrg-hash-to-curve-16.html#name-optimized-sqrt_ratio-for-q- (3 mod 4)
	var tv1 fp.Element
	tv1.Square(v) // 1. tv1 = v²
	var tv2 fp.Element
	tv2.Mul(u, v)       // 2. tv2 = u * v
	tv1.Mul(&tv1, &tv2) // 3. tv1 = tv1 * tv2

	var y1 fp.Element
	{
		var c1 big.Int
		// c1 = 1722862596078933134849197420568914385619917228134037527378447540052405855560872934021920795822352921910216141938446653362790439780138561939837377924781325399737901274844627212593135907855899198987974925107492278210691228279767074
		c1.SetBytes([]byte{72, 186, 9, 62, 224, 243, 130, 180, 97, 242, 80, 1, 62, 191, 207, 174, 73, 134, 26, 160, 116, 81, 162, 20, 160, 157, 123, 224, 33, 239, 144, 92, 30, 233, 142, 57, 97, 58, 70, 64, 243, 174, 191, 201, 109, 8, 193, 33, 162, 114, 59, 68, 190, 127, 100, 28, 119, 52, 247, 28, 250, 255, 203, 166, 40, 69, 176, 149, 153, 234, 62, 5, 131, 62, 43, 186, 188, 41, 13, 249, 164, 79, 154, 28, 0, 0, 32, 189, 39, 64, 0, 0, 0, 0, 34}) // c1 = (q - 3) / 4     # Integer arithmetic

		y1.Exp(tv1, &c1) // 4. y1 = tv1ᶜ¹
	}

	y1.Mul(&y1, &tv2) // 5. y1 = y1 * tv2

	var y2 fp.Element
	// c2 = sqrt(-Z)
	tv3 := fp.Element{10751254254539175147, 9766094991671066833, 2332062865126794245, 278658983607570155, 16958907618386923993, 3828006658569666757, 13622760089646566549, 10723972911493525927, 12307000153990793747, 14543371959135298146, 6497680552248674778, 41056765998425020}
	y2.Mul(&y1, &tv3)              // 6. y2 = y1 * c2
	tv3.Square(&y1)                // 7. tv3 = y1²
	tv3.Mul(&tv3, v)               // 8. tv3 = tv3 * v
	isQNr := tv3.NotEqual(u)       // 9. isQR = tv3 == u
	z.Select(int(isQNr), &y1, &y2) // 10. y = CMOV(y2, y1, isQR)
	return isQNr
}

// g2MulByZ multiplies x by [11] and stores the result in z
func g2MulByZ(z *fp.Element, x *fp.Element) {

	res := *x

	res.Double(&res)
	res.Double(&res)
	res.Add(&res, x)
	res.Double(&res)
	res.Add(&res, x)

	*z = res
}

// https://www.ietf.org/archive/id/draft-irtf-cfrg-hash-to-curve-16.html#name-simplified-swu-method
// MapToCurve2 implements the SSWU map
// No cofactor clearing or isogeny
func MapToCurve2(u *fp.Element) G2Affine {

	var sswuIsoCurveCoeffA = fp.Element{13704010396169241312, 14330175345318364589, 4449492585807198633, 9884564993510771995, 16507506367033405761, 12171409358426895620, 3759742122315801393, 6972450370136308820, 13649992927502603798, 15742083997009939515, 4062268800652448528, 42571325818609943}
	var sswuIsoCurveCoeffB = fp.Element{17251063859315847117, 13422534455279952781, 15626212001505409941, 8548929388122544483, 12216093319907597521, 15761783579263790289, 10925761432004348632, 8228665107915194054, 13147767302058909808, 5735540302608306489, 5152863309501448410, 45595036249636616}

	var tv1 fp.Element
	tv1.Square(u) // 1.  tv1 = u²

	//mul tv1 by Z
	g2MulByZ(&tv1, &tv1) // 2.  tv1 = Z * tv1

	var tv2 fp.Element
	tv2.Square(&tv1)    // 3.  tv2 = tv1²
	tv2.Add(&tv2, &tv1) // 4.  tv2 = tv2 + tv1

	var tv3 fp.Element
	var tv4 fp.Element
	tv4.SetOne()
	tv3.Add(&tv2, &tv4)                // 5.  tv3 = tv2 + 1
	tv3.Mul(&tv3, &sswuIsoCurveCoeffB) // 6.  tv3 = B * tv3

	tv2NZero := g2NotZero(&tv2)

	// tv4 = Z
	tv4 = fp.Element{4056054414400208518, 3320816571827031140, 10263935383895698150, 11003897938091601562, 15597443347325643510, 13135057492086854609, 2659919018052618801, 3683105852685266909, 6137961753831301777, 15077955943918945393, 14961510259660508891, 8138608324875079}

	tv2.Neg(&tv2)
	tv4.Select(int(tv2NZero), &tv4, &tv2) // 7.  tv4 = CMOV(Z, -tv2, tv2 != 0)
	tv4.Mul(&tv4, &sswuIsoCurveCoeffA)    // 8.  tv4 = A * tv4

	tv2.Square(&tv3) // 9.  tv2 = tv3²

	var tv6 fp.Element
	tv6.Square(&tv4) // 10. tv6 = tv4²

	var tv5 fp.Element
	tv5.Mul(&tv6, &sswuIsoCurveCoeffA) // 11. tv5 = A * tv6

	tv2.Add(&tv2, &tv5) // 12. tv2 = tv2 + tv5
	tv2.Mul(&tv2, &tv3) // 13. tv2 = tv2 * tv3
	tv6.Mul(&tv6, &tv4) // 14. tv6 = tv6 * tv4

	tv5.Mul(&tv6, &sswuIsoCurveCoeffB) // 15. tv5 = B * tv6
	tv2.Add(&tv2, &tv5)                // 16. tv2 = tv2 + tv5

	var x fp.Element
	x.Mul(&tv1, &tv3) // 17.   x = tv1 * tv3

	var y1 fp.Element
	gx1NSquare := g2SqrtRatio(&y1, &tv2, &tv6) // 18. (is_gx1_square, y1) = sqrt_ratio(tv2, tv6)

	var y fp.Element
	y.Mul(&tv1, u) // 19.   y = tv1 * u

	y.Mul(&y, &y1) // 20.   y = y * y1

	x.Select(int(gx1NSquare), &tv3, &x) // 21.   x = CMOV(x, tv3, is_gx1_square)
	y.Select(int(gx1NSquare), &y1, &y)  // 22.   y = CMOV(y, y1, is_gx1_square)

	y1.Neg(&y)
	y.Select(int(g2Sgn0(u)^g2Sgn0(&y)), &y, &y1)

	// 23.  e1 = sgn0(u) == sgn0(y)
	// 24.   y = CMOV(-y, y, e1)

	x.Div(&x, &tv4) // 25.   x = x / tv4

	return G2Affine{x, y}
}

func g2EvalPolynomial(z *fp.Element, monic bool, coefficients []fp.Element, x *fp.Element) {
	dst := coefficients[len(coefficients)-1]

	if monic {
		dst.Add(&dst, x)
	}

	for i := len(coefficients) - 2; i >= 0; i-- {
		dst.Mul(&dst, x)
		dst.Add(&dst, &coefficients[i])
	}

	z.Set(&dst)
}

// g2Sgn0 is an algebraic substitute for the notion of sign in ordered fields
// Namely, every non-zero quadratic residue in a finite field of characteristic =/= 2 has exactly two square roots, one of each sign
// https://www.ietf.org/archive/id/draft-irtf-cfrg-hash-to-curve-16.html#name-the-sgn0-function
// The sign of an element is not obviously related to that of its Montgomery form
func g2Sgn0(z *fp.Element) uint64 {

	nonMont := z.Bits()

	// m == 1
	return nonMont[0] % 2

}

// MapToG2 invokes the SSWU map, and guarantees that the result is in g2
func MapToG2(u fp.Element) G2Affine {
	res := MapToCurve2(&u)
	//this is in an isogenous curve
	g2Isogeny(&res)
	res.ClearCofactor(&res)
	return res
}

// EncodeToG2 hashes a message to a point on the G2 curve using the SSWU map.
// It is faster than HashToG2, but the result is not uniformly distributed. Unsuitable as a random oracle.
// dst stands for "domain separation tag", a string unique to the construction using the hash function
// https://www.ietf.org/archive/id/draft-irtf-cfrg-hash-to-curve-16.html#roadmap
func EncodeToG2(msg, dst []byte) (G2Affine, error) {

	var res G2Affine
	u, err := fp.Hash(msg, dst, 1)
	if err != nil {
		return res, err
	}

	res = MapToCurve2(&u[0])

	//this is in an isogenous curve
	g2Isogeny(&res)
	res.ClearCofactor(&res)
	return res, nil
}

// HashToG2 hashes a message to a point on the G2 curve using the SSWU map.
// Slower than EncodeToG2, but usable as a random oracle.
// dst stands for "domain separation tag", a string unique to the construction using the hash function
// https://www.ietf.org/archive/id/draft-irtf-cfrg-hash-to-curve-16.html#roadmap
func HashToG2(msg, dst []byte) (G2Affine, error) {
	u, err := fp.Hash(msg, dst, 2*1)
	if err != nil {
		return G2Affine{}, err
	}

	Q0 := MapToCurve2(&u[0])
	Q1 := MapToCurve2(&u[1])

	//TODO (perf): Add in E' first, then apply isogeny
	g2Isogeny(&Q0)
	g2Isogeny(&Q1)

	var _Q0, _Q1 G2Jac
	_Q0.FromAffine(&Q0)
	_Q1.FromAffine(&Q1).AddAssign(&_Q0)

	_Q1.ClearCofactor(&_Q1)

	Q1.FromJacobian(&_Q1)
	return Q1, nil
}

func g2NotZero(x *fp.Element) uint64 {

	return x[0] | x[1] | x[2] | x[3] | x[4] | x[5] | x[6] | x[7] | x[8] | x[9] | x[10] | x[11]

}
