// Copyright 2020 ConsenSys Software Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fr

// expBySqrtExp is equivalent to z.Exp(x, 1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4bd19a06c82)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expBySqrtExp(x Element) *Element {
	// addition chain:
	//
	//	_10       = 2*1
	//	_11       = 1 + _10
	//	_101      = _10 + _11
	//	_111      = _10 + _101
	//	_1001     = _10 + _111
	//	_1011     = _10 + _1001
	//	_1101     = _10 + _1011
	//	_1111     = _10 + _1101
	//	_1111000  = _1111 << 3
	//	_1111111  = _111 + _1111000
	//	_11111110 = 2*_1111111
	//	_11111111 = 1 + _11111110
	//	i21       = _11111111 << 7
	//	x15       = _1111111 + i21
	//	i30       = i21 << 8
	//	x23       = x15 + i30
	//	x31       = i30 << 8 + x23
	//	x32       = 2*x31 + 1
	//	x64       = x32 << 32 + x32
	//	x96       = x64 << 32 + x32
	//	x127      = x96 << 31 + x31
	//	i154      = ((x127 << 5 + _1011) << 3 + _101) << 4
	//	i166      = ((_101 + i154) << 4 + _111) << 5 + _1101
	//	i181      = ((i166 << 2 + _11) << 5 + _111) << 6
	//	i193      = ((_1101 + i181) << 5 + _1011) << 4 + _1101
	//	i214      = ((i193 << 3 + 1) << 6 + _101) << 10
	//	i230      = ((_111 + i214) << 4 + _111) << 9 + _11111111
	//	i247      = ((i230 << 5 + _1001) << 6 + _1011) << 4
	//	i261      = ((_1101 + i247) << 5 + _11) << 6 + _1101
	//	i283      = ((i261 << 10 + _1101) << 4 + _1001) << 6
	//	return      2*(1 + i283)
	//
	// Operations: 246 squares 39 multiplies

	// Allocate Temporaries.
	var (
		t0 = new(Element)
		t1 = new(Element)
		t2 = new(Element)
		t3 = new(Element)
		t4 = new(Element)
		t5 = new(Element)
		t6 = new(Element)
		t7 = new(Element)
		t8 = new(Element)
	)

	// var t0,t1,t2,t3,t4,t5,t6,t7,t8 Element
	// Step 1: t3 = x^0x2
	t3.Square(&x)

	// Step 2: t1 = x^0x3
	t1.Mul(&x, t3)

	// Step 3: t5 = x^0x5
	t5.Mul(t3, t1)

	// Step 4: t4 = x^0x7
	t4.Mul(t3, t5)

	// Step 5: z = x^0x9
	z.Mul(t3, t4)

	// Step 6: t2 = x^0xb
	t2.Mul(t3, z)

	// Step 7: t0 = x^0xd
	t0.Mul(t3, t2)

	// Step 8: t3 = x^0xf
	t3.Mul(t3, t0)

	// Step 11: t3 = x^0x78
	for s := 0; s < 3; s++ {
		t3.Square(t3)
	}

	// Step 12: t6 = x^0x7f
	t6.Mul(t4, t3)

	// Step 13: t3 = x^0xfe
	t3.Square(t6)

	// Step 14: t3 = x^0xff
	t3.Mul(&x, t3)

	// Step 21: t7 = x^0x7f80
	t7.Square(t3)
	for s := 1; s < 7; s++ {
		t7.Square(t7)
	}

	// Step 22: t6 = x^0x7fff
	t6.Mul(t6, t7)

	// Step 30: t7 = x^0x7f8000
	for s := 0; s < 8; s++ {
		t7.Square(t7)
	}

	// Step 31: t6 = x^0x7fffff
	t6.Mul(t6, t7)

	// Step 39: t7 = x^0x7f800000
	for s := 0; s < 8; s++ {
		t7.Square(t7)
	}

	// Step 40: t6 = x^0x7fffffff
	t6.Mul(t6, t7)

	// Step 41: t7 = x^0xfffffffe
	t7.Square(t6)

	// Step 42: t7 = x^0xffffffff
	t7.Mul(&x, t7)

	// Step 74: t8 = x^0xffffffff00000000
	t8.Square(t7)
	for s := 1; s < 32; s++ {
		t8.Square(t8)
	}

	// Step 75: t8 = x^0xffffffffffffffff
	t8.Mul(t7, t8)

	// Step 107: t8 = x^0xffffffffffffffff00000000
	for s := 0; s < 32; s++ {
		t8.Square(t8)
	}

	// Step 108: t7 = x^0xffffffffffffffffffffffff
	t7.Mul(t7, t8)

	// Step 139: t7 = x^0x7fffffffffffffffffffffff80000000
	for s := 0; s < 31; s++ {
		t7.Square(t7)
	}

	// Step 140: t6 = x^0x7fffffffffffffffffffffffffffffff
	t6.Mul(t6, t7)

	// Step 145: t6 = x^0xfffffffffffffffffffffffffffffffe0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 146: t6 = x^0xfffffffffffffffffffffffffffffffeb
	t6.Mul(t2, t6)

	// Step 149: t6 = x^0x7fffffffffffffffffffffffffffffff58
	for s := 0; s < 3; s++ {
		t6.Square(t6)
	}

	// Step 150: t6 = x^0x7fffffffffffffffffffffffffffffff5d
	t6.Mul(t5, t6)

	// Step 154: t6 = x^0x7fffffffffffffffffffffffffffffff5d0
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 155: t6 = x^0x7fffffffffffffffffffffffffffffff5d5
	t6.Mul(t5, t6)

	// Step 159: t6 = x^0x7fffffffffffffffffffffffffffffff5d50
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 160: t6 = x^0x7fffffffffffffffffffffffffffffff5d57
	t6.Mul(t4, t6)

	// Step 165: t6 = x^0xfffffffffffffffffffffffffffffffebaae0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 166: t6 = x^0xfffffffffffffffffffffffffffffffebaaed
	t6.Mul(t0, t6)

	// Step 168: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb4
	for s := 0; s < 2; s++ {
		t6.Square(t6)
	}

	// Step 169: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb7
	t6.Mul(t1, t6)

	// Step 174: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 175: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e7
	t6.Mul(t4, t6)

	// Step 181: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9c0
	for s := 0; s < 6; s++ {
		t6.Square(t6)
	}

	// Step 182: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd
	t6.Mul(t0, t6)

	// Step 187: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739a0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 188: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739ab
	t6.Mul(t2, t6)

	// Step 192: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739ab0
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 193: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd
	t6.Mul(t0, t6)

	// Step 196: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e8
	for s := 0; s < 3; s++ {
		t6.Square(t6)
	}

	// Step 197: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9
	t6.Mul(&x, t6)

	// Step 203: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a40
	for s := 0; s < 6; s++ {
		t6.Square(t6)
	}

	// Step 204: t5 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a45
	t5.Mul(t5, t6)

	// Step 214: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e91400
	for s := 0; s < 10; s++ {
		t5.Square(t5)
	}

	// Step 215: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e91407
	t5.Mul(t4, t5)

	// Step 219: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e914070
	for s := 0; s < 4; s++ {
		t5.Square(t5)
	}

	// Step 220: t4 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e914077
	t4.Mul(t4, t5)

	// Step 229: t4 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280ee00
	for s := 0; s < 9; s++ {
		t4.Square(t4)
	}

	// Step 230: t3 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff
	t3.Mul(t3, t4)

	// Step 235: t3 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe0
	for s := 0; s < 5; s++ {
		t3.Square(t3)
	}

	// Step 236: t3 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe9
	t3.Mul(z, t3)

	// Step 242: t3 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa40
	for s := 0; s < 6; s++ {
		t3.Square(t3)
	}

	// Step 243: t2 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4b
	t2.Mul(t2, t3)

	// Step 247: t2 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4b0
	for s := 0; s < 4; s++ {
		t2.Square(t2)
	}

	// Step 248: t2 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4bd
	t2.Mul(t0, t2)

	// Step 253: t2 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a0
	for s := 0; s < 5; s++ {
		t2.Square(t2)
	}

	// Step 254: t1 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3
	t1.Mul(t1, t2)

	// Step 260: t1 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8c0
	for s := 0; s < 6; s++ {
		t1.Square(t1)
	}

	// Step 261: t1 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd
	t1.Mul(t0, t1)

	// Step 271: t1 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a33400
	for s := 0; s < 10; s++ {
		t1.Square(t1)
	}

	// Step 272: t0 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d
	t0.Mul(t0, t1)

	// Step 276: t0 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d0
	for s := 0; s < 4; s++ {
		t0.Square(t0)
	}

	// Step 277: z = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d9
	z.Mul(z, t0)

	// Step 283: z = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd03640
	for s := 0; s < 6; s++ {
		z.Square(z)
	}

	// Step 284: z = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd03641
	z.Mul(&x, z)

	// Step 285: z = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4bd19a06c82
	z.Square(z)

	return z
}

// expByLegendreExp is equivalent to z.Exp(x, 7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe92f46681b20a0)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expByLegendreExp(x Element) *Element {
	// addition chain:
	//
	//	_10       = 2*1
	//	_11       = 1 + _10
	//	_101      = _10 + _11
	//	_111      = _10 + _101
	//	_1001     = _10 + _111
	//	_1011     = _10 + _1001
	//	_1101     = _10 + _1011
	//	_1111     = _10 + _1101
	//	_1111000  = _1111 << 3
	//	_1111111  = _111 + _1111000
	//	_11111110 = 2*_1111111
	//	_11111111 = 1 + _11111110
	//	i21       = _11111111 << 7
	//	x15       = _1111111 + i21
	//	i30       = i21 << 8
	//	x23       = x15 + i30
	//	x31       = i30 << 8 + x23
	//	x32       = 2*x31 + 1
	//	x64       = x32 << 32 + x32
	//	x96       = x64 << 32 + x32
	//	x127      = x96 << 31 + x31
	//	i154      = ((x127 << 5 + _1011) << 3 + _101) << 4
	//	i166      = ((_101 + i154) << 4 + _111) << 5 + _1101
	//	i181      = ((i166 << 2 + _11) << 5 + _111) << 6
	//	i193      = ((_1101 + i181) << 5 + _1011) << 4 + _1101
	//	i214      = ((i193 << 3 + 1) << 6 + _101) << 10
	//	i230      = ((_111 + i214) << 4 + _111) << 9 + _11111111
	//	i247      = ((i230 << 5 + _1001) << 6 + _1011) << 4
	//	i261      = ((_1101 + i247) << 5 + _11) << 6 + _1101
	//	i285      = ((i261 << 10 + _1101) << 4 + _1001) << 8
	//	return      (_101 + i285) << 5
	//
	// Operations: 252 squares 39 multiplies

	// Allocate Temporaries.
	var (
		t0 = new(Element)
		t1 = new(Element)
		t2 = new(Element)
		t3 = new(Element)
		t4 = new(Element)
		t5 = new(Element)
		t6 = new(Element)
		t7 = new(Element)
		t8 = new(Element)
	)

	// var t0,t1,t2,t3,t4,t5,t6,t7,t8 Element
	// Step 1: t4 = x^0x2
	t4.Square(&x)

	// Step 2: t2 = x^0x3
	t2.Mul(&x, t4)

	// Step 3: z = x^0x5
	z.Mul(t4, t2)

	// Step 4: t5 = x^0x7
	t5.Mul(t4, z)

	// Step 5: t0 = x^0x9
	t0.Mul(t4, t5)

	// Step 6: t3 = x^0xb
	t3.Mul(t4, t0)

	// Step 7: t1 = x^0xd
	t1.Mul(t4, t3)

	// Step 8: t4 = x^0xf
	t4.Mul(t4, t1)

	// Step 11: t4 = x^0x78
	for s := 0; s < 3; s++ {
		t4.Square(t4)
	}

	// Step 12: t6 = x^0x7f
	t6.Mul(t5, t4)

	// Step 13: t4 = x^0xfe
	t4.Square(t6)

	// Step 14: t4 = x^0xff
	t4.Mul(&x, t4)

	// Step 21: t7 = x^0x7f80
	t7.Square(t4)
	for s := 1; s < 7; s++ {
		t7.Square(t7)
	}

	// Step 22: t6 = x^0x7fff
	t6.Mul(t6, t7)

	// Step 30: t7 = x^0x7f8000
	for s := 0; s < 8; s++ {
		t7.Square(t7)
	}

	// Step 31: t6 = x^0x7fffff
	t6.Mul(t6, t7)

	// Step 39: t7 = x^0x7f800000
	for s := 0; s < 8; s++ {
		t7.Square(t7)
	}

	// Step 40: t6 = x^0x7fffffff
	t6.Mul(t6, t7)

	// Step 41: t7 = x^0xfffffffe
	t7.Square(t6)

	// Step 42: t7 = x^0xffffffff
	t7.Mul(&x, t7)

	// Step 74: t8 = x^0xffffffff00000000
	t8.Square(t7)
	for s := 1; s < 32; s++ {
		t8.Square(t8)
	}

	// Step 75: t8 = x^0xffffffffffffffff
	t8.Mul(t7, t8)

	// Step 107: t8 = x^0xffffffffffffffff00000000
	for s := 0; s < 32; s++ {
		t8.Square(t8)
	}

	// Step 108: t7 = x^0xffffffffffffffffffffffff
	t7.Mul(t7, t8)

	// Step 139: t7 = x^0x7fffffffffffffffffffffff80000000
	for s := 0; s < 31; s++ {
		t7.Square(t7)
	}

	// Step 140: t6 = x^0x7fffffffffffffffffffffffffffffff
	t6.Mul(t6, t7)

	// Step 145: t6 = x^0xfffffffffffffffffffffffffffffffe0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 146: t6 = x^0xfffffffffffffffffffffffffffffffeb
	t6.Mul(t3, t6)

	// Step 149: t6 = x^0x7fffffffffffffffffffffffffffffff58
	for s := 0; s < 3; s++ {
		t6.Square(t6)
	}

	// Step 150: t6 = x^0x7fffffffffffffffffffffffffffffff5d
	t6.Mul(z, t6)

	// Step 154: t6 = x^0x7fffffffffffffffffffffffffffffff5d0
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 155: t6 = x^0x7fffffffffffffffffffffffffffffff5d5
	t6.Mul(z, t6)

	// Step 159: t6 = x^0x7fffffffffffffffffffffffffffffff5d50
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 160: t6 = x^0x7fffffffffffffffffffffffffffffff5d57
	t6.Mul(t5, t6)

	// Step 165: t6 = x^0xfffffffffffffffffffffffffffffffebaae0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 166: t6 = x^0xfffffffffffffffffffffffffffffffebaaed
	t6.Mul(t1, t6)

	// Step 168: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb4
	for s := 0; s < 2; s++ {
		t6.Square(t6)
	}

	// Step 169: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb7
	t6.Mul(t2, t6)

	// Step 174: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 175: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e7
	t6.Mul(t5, t6)

	// Step 181: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9c0
	for s := 0; s < 6; s++ {
		t6.Square(t6)
	}

	// Step 182: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd
	t6.Mul(t1, t6)

	// Step 187: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739a0
	for s := 0; s < 5; s++ {
		t6.Square(t6)
	}

	// Step 188: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739ab
	t6.Mul(t3, t6)

	// Step 192: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739ab0
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 193: t6 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd
	t6.Mul(t1, t6)

	// Step 196: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e8
	for s := 0; s < 3; s++ {
		t6.Square(t6)
	}

	// Step 197: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9
	t6.Mul(&x, t6)

	// Step 203: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a40
	for s := 0; s < 6; s++ {
		t6.Square(t6)
	}

	// Step 204: t6 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a45
	t6.Mul(z, t6)

	// Step 214: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e91400
	for s := 0; s < 10; s++ {
		t6.Square(t6)
	}

	// Step 215: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e91407
	t6.Mul(t5, t6)

	// Step 219: t6 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e914070
	for s := 0; s < 4; s++ {
		t6.Square(t6)
	}

	// Step 220: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e914077
	t5.Mul(t5, t6)

	// Step 229: t5 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280ee00
	for s := 0; s < 9; s++ {
		t5.Square(t5)
	}

	// Step 230: t4 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff
	t4.Mul(t4, t5)

	// Step 235: t4 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe0
	for s := 0; s < 5; s++ {
		t4.Square(t4)
	}

	// Step 236: t4 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe9
	t4.Mul(t0, t4)

	// Step 242: t4 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa40
	for s := 0; s < 6; s++ {
		t4.Square(t4)
	}

	// Step 243: t3 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4b
	t3.Mul(t3, t4)

	// Step 247: t3 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4b0
	for s := 0; s < 4; s++ {
		t3.Square(t3)
	}

	// Step 248: t3 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4bd
	t3.Mul(t1, t3)

	// Step 253: t3 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a0
	for s := 0; s < 5; s++ {
		t3.Square(t3)
	}

	// Step 254: t2 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3
	t2.Mul(t2, t3)

	// Step 260: t2 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8c0
	for s := 0; s < 6; s++ {
		t2.Square(t2)
	}

	// Step 261: t2 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd
	t2.Mul(t1, t2)

	// Step 271: t2 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a33400
	for s := 0; s < 10; s++ {
		t2.Square(t2)
	}

	// Step 272: t1 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d
	t1.Mul(t1, t2)

	// Step 276: t1 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d0
	for s := 0; s < 4; s++ {
		t1.Square(t1)
	}

	// Step 277: t0 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d9
	t0.Mul(t0, t1)

	// Step 285: t0 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d900
	for s := 0; s < 8; s++ {
		t0.Square(t0)
	}

	// Step 286: z = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d905
	z.Mul(z, t0)

	// Step 291: z = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe92f46681b20a0
	for s := 0; s < 5; s++ {
		z.Square(z)
	}

	return z
}
