// Copyright 2020 ConsenSys Software Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fp

// expBySqrtExp is equivalent to z.Exp(x, 400000000000008)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expBySqrtExp(x Element) *Element {
	// addition chain:
	//
	//	return  (1 << 55 + 1) << 3
	//
	// Operations: 58 squares 1 multiplies

	// Allocate Temporaries.
	var ()

	// var
	// Step 55: z = x^0x80000000000000
	z.Square(&x)
	for s := 1; s < 55; s++ {
		z.Square(z)
	}

	// Step 56: z = x^0x80000000000001
	z.Mul(&x, z)

	// Step 59: z = x^0x400000000000008
	for s := 0; s < 3; s++ {
		z.Square(z)
	}

	return z
}

// expByLegendreExp is equivalent to z.Exp(x, 400000000000008800000000000000000000000000000000000000000000000)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expByLegendreExp(x Element) *Element {
	// addition chain:
	//
	//	return  ((1 << 55 + 1) << 4 + 1) << 191
	//
	// Operations: 250 squares 2 multiplies

	// Allocate Temporaries.
	var ()

	// var
	// Step 55: z = x^0x80000000000000
	z.Square(&x)
	for s := 1; s < 55; s++ {
		z.Square(z)
	}

	// Step 56: z = x^0x80000000000001
	z.Mul(&x, z)

	// Step 60: z = x^0x800000000000010
	for s := 0; s < 4; s++ {
		z.Square(z)
	}

	// Step 61: z = x^0x800000000000011
	z.Mul(&x, z)

	// Step 252: z = x^0x400000000000008800000000000000000000000000000000000000000000000
	for s := 0; s < 191; s++ {
		z.Square(z)
	}

	return z
}
