/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersJvmKt;
import kotlinx.io.RealSink;
import kotlinx.io.Sink;
import kotlinx.io.Utf8Kt;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\u0012\u0010\f\u001a\u00020\b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u00a8\u0006\u0011"}, d2={"writeString", "", "Lkotlinx/io/Sink;", "string", "", "charset", "Ljava/nio/charset/Charset;", "startIndex", "", "endIndex", "asOutputStream", "Ljava/io/OutputStream;", "write", "source", "Ljava/nio/ByteBuffer;", "asByteChannel", "Ljava/nio/channels/WritableByteChannel;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nSinksJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinksJvm.kt\nkotlinx/io/SinksJvmKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,133:1\n38#2:134\n*S KotlinDebug\n*F\n+ 1 SinksJvm.kt\nkotlinx/io/SinksJvmKt\n*L\n46#1:134\n*E\n"})
public final class SinksJvmKt {
    public static final void writeString(@NotNull Sink $this$writeString, @NotNull String string, @NotNull Charset charset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        int size$iv = string.length();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        if (Intrinsics.areEqual((Object)charset, (Object)Charsets.UTF_8)) {
            Utf8Kt.writeString($this$writeString, string, startIndex, endIndex);
            return;
        }
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] data = byArray;
        $this$writeString.write(data, 0, data.length);
    }

    public static /* synthetic */ void writeString$default(Sink sink, String string, Charset charset, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = string.length();
        }
        SinksJvmKt.writeString(sink, string, charset, n, n2);
    }

    @NotNull
    public static final OutputStream asOutputStream(@NotNull Sink $this$asOutputStream) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)$this$asOutputStream, (String)"<this>");
        Sink sink = $this$asOutputStream;
        if (sink instanceof RealSink) {
            function0 = (Function0)new MutablePropertyReference0Impl($this$asOutputStream){

                public Object get() {
                    return ((RealSink)this.receiver).closed;
                }

                public void set(Object value) {
                    ((RealSink)this.receiver).closed = (Boolean)value;
                }
            };
        } else if (sink instanceof Buffer) {
            function0 = SinksJvmKt::asOutputStream$lambda$0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0 isClosed2 = function0;
        return new OutputStream((Function0<Boolean>)isClosed2, $this$asOutputStream){
            final /* synthetic */ Function0<Boolean> $isClosed;
            final /* synthetic */ Sink $this_asOutputStream;
            {
                this.$isClosed = $isClosed;
                this.$this_asOutputStream = $receiver;
            }

            public void write(int n) {
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying sink is closed.");
                }
                Sink $this$writeToInternalBuffer$iv = this.$this_asOutputStream;
                boolean $i$f$writeToInternalBuffer = false;
                Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
                boolean bl = false;
                it.writeByte((byte)n);
                $this$writeToInternalBuffer$iv.hintEmit();
            }

            public void write(byte[] data, int offset, int byteCount) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying sink is closed.");
                }
                Sink $this$writeToInternalBuffer$iv = this.$this_asOutputStream;
                boolean $i$f$writeToInternalBuffer = false;
                Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
                boolean bl = false;
                it.write(data, offset, offset + byteCount);
                $this$writeToInternalBuffer$iv.hintEmit();
            }

            public void flush() {
                if (!((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    this.$this_asOutputStream.flush();
                }
            }

            public void close() {
                this.$this_asOutputStream.close();
            }

            public String toString() {
                return this.$this_asOutputStream + ".asOutputStream()";
            }
        };
    }

    public static final int write(@NotNull Sink $this$write, @NotNull ByteBuffer source) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long sizeBefore = $this$write.getBuffer().getSize();
        BuffersJvmKt.transferFrom($this$write.getBuffer(), source);
        long bytesRead = $this$write.getBuffer().getSize() - sizeBefore;
        $this$write.hintEmit();
        return (int)bytesRead;
    }

    @NotNull
    public static final WritableByteChannel asByteChannel(@NotNull Sink $this$asByteChannel) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)$this$asByteChannel, (String)"<this>");
        Sink sink = $this$asByteChannel;
        if (sink instanceof RealSink) {
            function0 = (Function0)new MutablePropertyReference0Impl($this$asByteChannel){

                public Object get() {
                    return ((RealSink)this.receiver).closed;
                }

                public void set(Object value) {
                    ((RealSink)this.receiver).closed = (Boolean)value;
                }
            };
        } else if (sink instanceof Buffer) {
            function0 = SinksJvmKt::asByteChannel$lambda$1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0 isClosed2 = function0;
        return new WritableByteChannel($this$asByteChannel, (Function0<Boolean>)isClosed2){
            final /* synthetic */ Sink $this_asByteChannel;
            final /* synthetic */ Function0<Boolean> $isClosed;
            {
                this.$this_asByteChannel = $receiver;
                this.$isClosed = $isClosed;
            }

            public void close() {
                this.$this_asByteChannel.close();
            }

            public boolean isOpen() {
                return (Boolean)this.$isClosed.invoke() == false;
            }

            public int write(ByteBuffer source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                if (!((Boolean)this.$isClosed.invoke() == false)) {
                    boolean bl = false;
                    String string = "Underlying sink is closed.";
                    throw new IllegalStateException(string.toString());
                }
                return SinksJvmKt.write(this.$this_asByteChannel, source);
            }
        };
    }

    private static final boolean asOutputStream$lambda$0() {
        return false;
    }

    private static final boolean asByteChannel$lambda$1() {
        return false;
    }
}

