/** \file debug_actions_dialog.cpp */

// Copyright (C) 2020-2025 Sanford Rockowitz <rockowitz@minsoft.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include <assert.h>
#include <QtCore/QDebug>
#include <QtWidgets/QCheckBox>

#include "base/ddcui_core.h"
#include "help/help_dialog.h"
#include "help/help_browser.h"

#include "action_dialogs/debug_actions_dialog.h"

#include "ui_debug_actions_dialog.h"    // generated by UIC from debug_actions_dialog.ui


DebugActionsDialog::DebugActionsDialog(QWidget *parent)
    :  QDialog(parent)
    ,  _ui(new Ui::DebugActionsDialog)
{
    bool debug = false;
    _cls = metaObject()->className();
    TRACECF(debug, "Constructor starting");
    _ui->setupUi(this);
    setWindowTitle("ddcui - Debugging Actions");
    //  setWindowFlag(Qt::CustomizeWindowHint, true);      // not needed
    setWindowFlag(Qt::WindowContextHelpButtonHint, false);
    // setWindowFlag(Qt::WindowMinimizeButtonHint, false);   // no effect
    // setWindowFlag(Qt::WindowMinMaxButtonsHint, false);    // no effect
    QPushButton* okButton = _ui->actionButtonBox->button(QDialogButtonBox::Ok);
    okButton->setText("Close");

    connect(_ui->resetStats_pushButton, &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionResetStatsButton_clicked);
    connect(_ui->all_pushButton,     &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionAllStatsButton_clicked);
    connect(_ui->calls_pushButton,   &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionCallsStatsButton_clicked);
    connect(_ui->tries_pushButton,   &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionTriesStatsButton_clicked);
    connect(_ui->errors_pushButton,  &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionErrorsStatsButton_clicked);
    connect(_ui->elapsed_pushButton, &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionElapsedStatsButton_clicked);
    connect(_ui->api_pushButton, &QPushButton::clicked,
            this,                    &DebugActionsDialog::for_actionApiStatsButton_clicked);
    connect(_ui->extendedStats_checkBox,
                                     &QCheckBox::stateChanged,
             this   ,                 &DebugActionsDialog::for_actionExtendedStatsCheckBox_stateChanged);
    TRACECF(debug, "Constructor done. _cls = %s", _cls);
}


DebugActionsDialog::~DebugActionsDialog()
{
    delete _ui;
}


//
// QButtonBox actions
//

void DebugActionsDialog::on_actionButtonBox_accepted()
{
    bool debugFunc = false;

    // not needed, automatically emitted when dialog accepted, by accept() or done()
    // emit userInterfaceDialog_accepted(_state);  // probably not needed

    TRACECF(debugFunc, "Before calling accept()");
    accept();  // causes accepted() to be emitted
}


void DebugActionsDialog::on_actionButtonBox_helpRequested()
{

    // TRACE();
#ifdef OLD
    QString fn(":/docs/uioptions.html");   // -> debug_actions.html
    QFile f(fn);
    f.open(QFile::ReadOnly | QFile::Text);
    QTextStream in(&f);

    QString htmlText = in.readAll();

    // qDebug() << htmlText;

    // doesn't show dialog box
    // HelpDialog2("ddcui Help - Other Options", htmlText, this);

    HelpDialog2* hd = new HelpDialog2(this);
    hd->setText(htmlText);
    hd->setWindowTitle("ddcui Help - Debugging Actions");
    hd->show();
#endif
    // viewHelp("actions_debug.html", "ddcui Help - Execution Statistics", this);
    // HelpBrowser::showPage("qrc:/docs/help_actions_debug.html", false);
    HelpBrowser * browser = new HelpBrowser("qrc:/docs/help_actions_debug.html", false);

    // browser->setMinimumSize(1000,400);
    browser->resize(500,400);
    browser->show();

}


//
// Actions for stats buttons
//

void DebugActionsDialog::for_actionAllStatsButton_clicked(bool onoff) {
   bool debug = false;
   TRACECF(debug, "Executing");
   bool isChecked =  _ui->extendedStats_checkBox->isChecked();
   emit reportStats_triggered(DDCA_STATS_ALL, isChecked );
}

void DebugActionsDialog::for_actionCallsStatsButton_clicked(bool onoff) {
   bool debug = false;
   TRACECF(debug, "Executing");
   bool isChecked =  _ui->extendedStats_checkBox->isChecked();
   emit reportStats_triggered(DDCA_STATS_CALLS, isChecked );
}

void DebugActionsDialog::for_actionErrorsStatsButton_clicked(bool onoff) {
   bool debug = false;
   TRACECF(debug, "Executing");
   bool isChecked =  _ui->extendedStats_checkBox->isChecked();
   emit reportStats_triggered(DDCA_STATS_ERRORS, isChecked );
}

void DebugActionsDialog::for_actionTriesStatsButton_clicked(bool onoff) {
   bool debug = false;
   TRACECF(debug, "Executing");
   bool isChecked =  _ui->extendedStats_checkBox->isChecked();
   emit reportStats_triggered(DDCA_STATS_TRIES, isChecked );
}

void DebugActionsDialog::for_actionElapsedStatsButton_clicked(bool onoff) {
   bool debug = false;
   //  printf("_cls = %s\n", _cls);
   // printf("Z ");
   // fflush(stdout);SA
   TRACECF(debug, "Executing");
   bool isChecked =  _ui->extendedStats_checkBox->isChecked();
   emit reportStats_triggered(DDCA_STATS_ELAPSED, isChecked );
}

void DebugActionsDialog::for_actionApiStatsButton_clicked(bool onoff) {
   bool debug = false;
   TRACECF(debug, "Executing");
   bool isChecked =  _ui->extendedStats_checkBox->isChecked();
   emit reportStats_triggered(DDCA_STATS_API, isChecked );
}

void DebugActionsDialog::for_actionExtendedStatsCheckBox_stateChanged(int newState) {
   bool debug = false;
      bool checked =  _ui->extendedStats_checkBox->isChecked() ;
   TRACECF(debug, "Executing. checked = %s, newState x = %d",  SBOOL( checked), newState  );
}


void DebugActionsDialog::for_actionResetStatsButton_clicked(bool onoff)
{
   bool debug = false;
   TRACECF(debug, "Executing");
   emit resetStats_triggered();
}

