/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v2 "k8s.io/api/autoscaling/v2"
	autoscalingv2 "k8s.io/client-go/applyconfigurations/autoscaling/v2"
	gentype "k8s.io/client-go/gentype"
	typedautoscalingv2 "k8s.io/client-go/kubernetes/typed/autoscaling/v2"
)

// fakeHorizontalPodAutoscalers implements HorizontalPodAutoscalerInterface
type fakeHorizontalPodAutoscalers struct {
	*gentype.FakeClientWithListAndApply[*v2.HorizontalPodAutoscaler, *v2.HorizontalPodAutoscalerList, *autoscalingv2.HorizontalPodAutoscalerApplyConfiguration]
	Fake *FakeAutoscalingV2
}

func newFakeHorizontalPodAutoscalers(fake *FakeAutoscalingV2, namespace string) typedautoscalingv2.HorizontalPodAutoscalerInterface {
	return &fakeHorizontalPodAutoscalers{
		gentype.NewFakeClientWithListAndApply[*v2.HorizontalPodAutoscaler, *v2.HorizontalPodAutoscalerList, *autoscalingv2.HorizontalPodAutoscalerApplyConfiguration](
			fake.Fake,
			namespace,
			v2.SchemeGroupVersion.WithResource("horizontalpodautoscalers"),
			v2.SchemeGroupVersion.WithKind("HorizontalPodAutoscaler"),
			func() *v2.HorizontalPodAutoscaler { return &v2.HorizontalPodAutoscaler{} },
			func() *v2.HorizontalPodAutoscalerList { return &v2.HorizontalPodAutoscalerList{} },
			func(dst, src *v2.HorizontalPodAutoscalerList) { dst.ListMeta = src.ListMeta },
			func(list *v2.HorizontalPodAutoscalerList) []*v2.HorizontalPodAutoscaler {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v2.HorizontalPodAutoscalerList, items []*v2.HorizontalPodAutoscaler) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
