UWSM-APP(1)

# NAME

*uwsm-app* - Application-to-unit launcher using UWSM's app daemon.

# SYNOPSIS

*uwsm-app* [-h] [-s {*a*,*b*,*s*,_custom_.slice}] [-t {scope,service}]
\[-a _app_name_] [-u _unit_name_] [-d _unit_description_]
\[-S ] [-T] -- _application_ [_args_ ...]

# DESCRIPTION

Application-to-unit launcher with Desktop Entry support. Analogous to *uwsm app*
command and uses the same arguments, since argument parsing is done on the app
daemon's side with the same parser.

# OPTIONS

|[ *-s* {*a*,*b*,*s*,_custom_.slice}
:< Slice selector (default: *a*):
| 
:     *a* - *app-graphical.slice*
| 
:     *b* - *background-graphical.slice*
| 
:     *s* - *session-graphical.slice*
| 
:     any slice by full name
|  *-t* {*scope*,*service*}
:  Type of unit to launch (default: *scope*, can be preset by
   *UWSM_APP_UNIT_TYPE* env var).
|  *-a* _app_name_
:  Override app name (a substring in unit name).
|  *-u* _unit_name_
:  Override the whole autogenerated unit name.
|  *-d* _unit_description_
:  Unit Description.
|  *-S* {*out*,*err*,*both*}
:  Silence stdout, stderr, or both.
|  *-T*
:  Launch app in a terminal. Allows command to be empty to just launch a
   terminal.

Application can be provided as a command with optional arguments, or a Desktop
Entry ID, optionally suffixed with "*:*"-delimited Action ID. If Desktop Entry
is being launched, arguments should be compatible with it.

Always use "*--*" to disambiguate dashed arguments intended for application
itself.

Special arguments that are passed through to app daemon:

- *ping*	check app daemon, it should return "*pong*"\n
- *stop*	stop app daemon\n

# OPERATION

*uwsm-app* client sends arguments to uwsm's app daemon via a pipe. Upon
receiving arguments, app daemon returns shell code to *uwsm-app* which it
natively executes. Single commands are prepended with *exec*, iterated commands
are assembled with trailing *&* each, followed by *wait*.

The purpose of all this is to skip all the expensive Python startup and import
routines that slow things down every time "*uwsm app*" is called. Instead the
daemon does it once and then listens for requests, while a simple shell script
may dump arguments to one pipe and run the code received from another via eval,
which is much faster.

# SEE ALSO

*uwsm*(1), *systemd-run*(1)
