// Source: https://github.com/atlassian/react-beautiful-dnd

import { canScrollScrollable } from './can-scroll';
import getScroll from './get-scroll';
export default (({
  scrollable,
  center,
  dragStartTime,
  shouldUseTimeDampening
}) => {
  const scroll = getScroll({
    dragStartTime,
    container: scrollable.container,
    center,
    shouldUseTimeDampening
  });
  return scroll && canScrollScrollable(scrollable, scroll) ? scroll : null;
});