/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ElementType, type ReactNode } from 'react';
import type { AlignItems, BasePrimitiveProps, Direction, GapToken, JustifyContent, Wrap } from './types';
export type FlexProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Flex. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol' | 'li' | 'dl';
    /**
     * Used to align children along the main axis.
     */
    justifyContent?: JustifyContent;
    /**
     * Used to align children along the cross axis.
     */
    alignItems?: AlignItems;
    /**
     * Represents the space between each child.
     */
    columnGap?: GapToken;
    /**
     * Represents the space between each child.
     */
    gap?: GapToken;
    /**
     * Represents the space between each child.
     */
    rowGap?: GapToken;
    /**
     * Represents the flex direction property of CSS flexbox.
     */
    direction?: Direction;
    /**
     * Represents the flex wrap property of CSS flexbox.
     */
    wrap?: Wrap;
    /**
     * Elements to be rendered inside the Flex.
     */
    children: ReactNode;
    /**
     * Forwarded ref element.
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
/**
 * __Flex__
 *
 * `Flex` is a primitive component that implements the CSS Flexbox API.
 *
 * - [Examples](https://atlassian.design/components/primitives/flex/examples)
 * - [Code](https://atlassian.design/components/primitives/flex/code)
 *
 * @example
 * ```tsx
 * import { Flex, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Flex direction="column">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Flex>
 * )
 * ```
 */
declare const Flex: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Omit<FlexProps<ElementType>, "ref"> & import("react").RefAttributes<any>>>;
export default Flex;
