"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var ENDS_WITH_DOT = /\.$/;
function matchEvent(matcher, name) {
  if (matcher === '*' || name === undefined) {
    return true;
  }
  if (typeof matcher === 'string') {
    if (ENDS_WITH_DOT.test(matcher)) {
      return name.substr(0, matcher.length) === matcher;
    }
    return name === matcher;
  }
  if (typeof matcher === 'function') {
    return matcher(name);
  }
  return matcher.test(name);
}
var _default = exports.default = matchEvent;