"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdProvider = void 0;
exports.useId = useId;
exports.useIdSeed = useIdSeed;
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _react = _interopRequireWildcard(require("react"));
var _reactUid = require("react-uid");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _React$useId;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Type copied from https://github.com/thearnica/react-uid/blob/0f507fbbdb1ab84acf477ec32698afe3d2191e49/src/hooks.ts#L12
// Copied rather than inferred to make the type transparent

// @ts-ignore - useId is not accessible in React 16
var react18UseId = (_React$useId = _react.default.useId) !== null && _React$useId !== void 0 ? _React$useId : undefined;

/**
 * Returns a unique id
 *
 * React 18 SSR and Concurrent modes are supported when the `platform-dst-react-18-use-id` flag is enabled.
 * This is an interop function that supports React 16 and 18.
 *
 * If migrating from `useUID` in the `react-uid` package, then `useId` is a direct replacement.
 *
 * @return string
 * @see {@link useIdSeed}
 * @see https://github.com/thearnica/react-uid#hooks-168
 * @private We intend to deprecate and replace with `useId()` directly
 * @example
 * const id = useUID();
 * id == "r1"; // for example
 *
 * Parts of the above are from: https://github.com/thearnica/react-uid/blob/0f507fbbdb1ab84acf477ec32698afe3d2191e49/src/hooks.ts#L41C1-L49C4
 */
function useId() {
  if (react18UseId && (0, _platformFeatureFlags.fg)('platform-dst-react-18-use-id')) {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return react18UseId();
  }

  // eslint-disable-next-line react-hooks/rules-of-hooks
  return "uid".concat((0, _reactUid.useUID)());
}
/**
 * A wrapper component that allows access to an id generated by useId within a class component.
 *
 * This component is only intended for class components,
 * functional components should use the useId hook directly.
 *
 * @component
 * @param {IdProviderProps} props
 * @private We intend to deprecate and replace with `useId()` directly
 * @example
 * Child as function
 * ```jsx
 * class Example extends React.Component {
 *   render() {
 *     return (
 *       <IdProvider>
 *         {({ id }) => (<div id={id}>Hello</div>)}
 *       </IdProvider>
 *     );
 *   }
 * }
 * ```
 *
 * @example
 * Ref object
 * ```jsx
 * class Example extends React.Component {
 *   readonly useIdRef = React.createRef<string>();
 *   render() {
 *     return (
 *       <IdProvider ref={this.useIdRef}>
 *         <div id={this.useIdRef.current}>Hello</div>
 *       </IdProvider>
 *     );
 *   }
 * }
 *
 * @example
 * Ref as callback
 * ```jsx
 * class Example extends React.Component {
 *   id = '';
 *   setId = (id: string) => {
 *     this.id = id;
 *   };
 *   render() {
 *     return (
 *       <IdProvider ref={this.setId}>
 *         <div id={this.id}>Hello</div>
 *       </IdProvider>
 *     );
 *   }
 * }
 * ```
 */
var IdProvider = exports.IdProvider = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    _ref$postfix = _ref.postfix,
    postfix = _ref$postfix === void 0 ? '' : _ref$postfix,
    _ref$prefix = _ref.prefix,
    prefix = _ref$prefix === void 0 ? '' : _ref$prefix;
  var id = "".concat(prefix).concat(useId()).concat(postfix);
  (0, _react.useEffect)(function () {
    if (!ref) {
      return;
    }
    switch ((0, _typeof2.default)(ref)) {
      case 'function':
        ref(id);
        break;
      case 'object':
        ref.current = id;
        break;
      default:
        throw new Error("Unreachable case for unsupported type of ref \"".concat((0, _typeof2.default)(ref), "\""));
    }
  }, [id, ref]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof children === 'function' ? children({
    id: id
  }) : children);
});

/**
 * Returns an id generator
 *
 * React 18 SSR and Concurrent modes are supported when the `platform-dst-react-18-use-id` flag is enabled.
 * This is an interop function that supports React 16 and 18.
 *
 * If migrating from `useUIDSeed` in the `react-uid` package, then `useIdSeed` is a direct replacement.
 *
 * "If you need to give IDs to multiple related elements, you can call useId to generate a shared prefix for them" - From React
 * This function will help to implement the above.
 * @return (id: any) => string
 * @see https://react.dev/reference/react/useId#generating-ids-for-several-related-elements
 * @see https://github.com/thearnica/react-uid#hooks-168
 * @private We intend to deprecate and replace with `useId()` directly
 * @example
 * import { useIdSeed } from '@atlaskit/ds-lib/use-id';
 *
 * export default function Form() {
 * 	 const idSeed = useIdSeed();
 *   return (
 *     <form>
 *       <label htmlFor={idSeed('firstName')}>First Name:</label>
 *       <input id={idSeed('firstName')} type="text" />
 *       <hr />
 *       <label htmlFor={idSeed('lastName')}>Last Name:</label>
 *       <input id={idSeed('lastName')} type="text" />
 *     </form>
 *   );
 * }
 */
function useIdSeed() {
  if (react18UseId && (0, _platformFeatureFlags.fg)('platform-dst-react-18-use-id')) {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    var uid = react18UseId();
    return function (id) {
      return "".concat(uid, "-").concat(id.toString());
    };
  }

  // eslint-disable-next-line react-hooks/rules-of-hooks
  return (0, _reactUid.useUIDSeed)();
}