/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ElementType, type ReactNode } from 'react';
import { type FlexProps } from './flex';
import type { AlignBlock, AlignInline, BasePrimitiveProps, Grow, Spread } from './types';
export type StackProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Stack. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol';
    /**
     * Used to align children along the block axis (typically vertical).
     */
    alignBlock?: Exclude<AlignBlock, 'baseline'>;
    /**
     * Used to align children along the inline axis (typically horizontal).
     */
    alignInline?: AlignInline;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: Spread;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow;
    /**
     * Represents the space between each child.
     */
    space?: FlexProps['gap'];
    /**
     * Elements to be rendered inside the Stack.
     */
    children: ReactNode;
    /**
     * Forwarded ref element.
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
declare const Stack: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Omit<StackProps<ElementType>, "ref"> & import("react").RefAttributes<any>>>;
export default Stack;
