/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ComponentPropsWithRef, type ElementType, type ReactNode } from 'react';
import { type StrictXCSSProp } from '@atlaskit/css';
import type { BasePrimitiveProps, FontSize, FontWeight, TextAlign, TextColor } from './types';
declare const asAllowlist: readonly ["span", "p", "strong", "em"];
type AsElement = (typeof asAllowlist)[number];
type TextPropsBase<T extends ElementType = 'span'> = {
    /**
     * HTML tag to be rendered. Defaults to `span`.
     */
    as?: AsElement;
    /**
     * Elements rendered within the Text element.
     */
    children: ReactNode;
    /**
     * Token representing text color with a built-in fallback value.
     * Will apply inverse text color automatically if placed within a Box with bold background color.
     * Defaults to `color.text` if not nested in other Text components.
     */
    color?: TextColor | 'inherit';
    /**
     * The [HTML `id` attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/id).
     */
    id?: string;
    /**
     * The number of lines to limit the provided text to. Text will be truncated with an ellipsis.
     *
     * When `maxLines={1}`, `wordBreak` defaults to `break-all` to match the behaviour of `text-overflow: ellipsis`.
     */
    maxLines?: number;
    /**
     * Text alignment.
     */
    align?: TextAlign;
    /**
     * Text size.
     */
    size?: FontSize;
    /**
     * The [HTML `font-weight` attribute](https://developer.mozilla.org/en-US/docs/Web/CSS/font-weight).
     */
    weight?: FontWeight;
    /**
     * Bounded style overrides.
     */
    xcss?: StrictXCSSProp<'overflowWrap' | 'textDecorationLine', never>;
    /**
     * Forwarded ref.
     */
    ref?: ComponentPropsWithRef<T>['ref'];
};
export type TextProps<T extends ElementType = 'span'> = TextPropsBase<T> & Omit<BasePrimitiveProps, 'xcss'>;
export declare const inverseColorMap: {
    readonly 'color.background.neutral.bold': "color.text.inverse";
    readonly 'color.background.neutral.bold.hovered': "color.text.inverse";
    readonly 'color.background.neutral.bold.pressed': "color.text.inverse";
    readonly 'color.background.selected.bold': "color.text.inverse";
    readonly 'color.background.selected.bold.hovered': "color.text.inverse";
    readonly 'color.background.selected.bold.pressed': "color.text.inverse";
    readonly 'color.background.brand.bold': "color.text.inverse";
    readonly 'color.background.brand.bold.hovered': "color.text.inverse";
    readonly 'color.background.brand.bold.pressed': "color.text.inverse";
    readonly 'color.background.brand.boldest': "color.text.inverse";
    readonly 'color.background.brand.boldest.hovered': "color.text.inverse";
    readonly 'color.background.brand.boldest.pressed': "color.text.inverse";
    readonly 'color.background.danger.bold': "color.text.inverse";
    readonly 'color.background.danger.bold.hovered': "color.text.inverse";
    readonly 'color.background.danger.bold.pressed': "color.text.inverse";
    readonly 'color.background.warning.bold': "color.text.warning.inverse";
    readonly 'color.background.warning.bold.hovered': "color.text.warning.inverse";
    readonly 'color.background.warning.bold.pressed': "color.text.warning.inverse";
    readonly 'color.background.success.bold': "color.text.inverse";
    readonly 'color.background.success.bold.hovered': "color.text.inverse";
    readonly 'color.background.success.bold.pressed': "color.text.inverse";
    readonly 'color.background.discovery.bold': "color.text.inverse";
    readonly 'color.background.discovery.bold.hovered': "color.text.inverse";
    readonly 'color.background.discovery.bold.pressed': "color.text.inverse";
    readonly 'color.background.information.bold': "color.text.inverse";
    readonly 'color.background.information.bold.hovered': "color.text.inverse";
    readonly 'color.background.information.bold.pressed': "color.text.inverse";
};
/**
 * __Text__
 *
 * Text is a primitive component that has the Atlassian Design System's design guidelines baked in.
 * This includes considerations for text attributes such as color, font size, font weight, and line height.
 * It renders a `span` by default.
 *
 * @internal
 */
declare const Text: import("react").ForwardRefExoticComponent<Omit<TextProps<ElementType>, "ref"> & import("react").RefAttributes<any>>;
export default Text;
