/* Copyright © Triad National Security, LLC, and others.

   Environment variable handling. */

#define _GNU_SOURCE
#pragma once

#include "core.h"
#include "misc.h"


/** Types **/

struct env_file {
   char *path;
   char delim;
   bool expand;
};

struct env_var {
   char *name;
   char *value;
};

/** Disallowed functions **/

#define getenv FN_BLOCKED
#define setenv FN_BLOCKED
#define unsetenv FN_BLOCKED


/** Function prototypes **/

struct env_var *env_file_read(const char *path, int delim);
char *env_get(const char *name, char *value_default);
struct env_var env_parse(const char *line, const char *path, size_t lineno);
void env_set(const char *name, const char *value, const bool expand);
void env_unset(const char *name);
void envs_hook_set_file(struct container *c, void *d);
void envs_hook_set(struct container *c, void *d);
void envs_hook_unset(struct container *c, void *d);
void envs_set(const struct env_var *envs, const bool expand);
void envs_unset(const char *glob);
