// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v3.15.6
// source: stacks.proto

package stacks

import (
	context "context"
	terraform1 "github.com/hashicorp/terraform/internal/rpcapi/terraform1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ResourceMode int32

const (
	ResourceMode_UNKNOWN ResourceMode = 0
	ResourceMode_MANAGED ResourceMode = 1
	ResourceMode_DATA    ResourceMode = 2
)

// Enum value maps for ResourceMode.
var (
	ResourceMode_name = map[int32]string{
		0: "UNKNOWN",
		1: "MANAGED",
		2: "DATA",
	}
	ResourceMode_value = map[string]int32{
		"UNKNOWN": 0,
		"MANAGED": 1,
		"DATA":    2,
	}
)

func (x ResourceMode) Enum() *ResourceMode {
	p := new(ResourceMode)
	*p = x
	return p
}

func (x ResourceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[0].Descriptor()
}

func (ResourceMode) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[0]
}

func (x ResourceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceMode.Descriptor instead.
func (ResourceMode) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{0}
}

type PlanMode int32

const (
	PlanMode_NORMAL       PlanMode = 0
	PlanMode_REFRESH_ONLY PlanMode = 1
	PlanMode_DESTROY      PlanMode = 2
)

// Enum value maps for PlanMode.
var (
	PlanMode_name = map[int32]string{
		0: "NORMAL",
		1: "REFRESH_ONLY",
		2: "DESTROY",
	}
	PlanMode_value = map[string]int32{
		"NORMAL":       0,
		"REFRESH_ONLY": 1,
		"DESTROY":      2,
	}
)

func (x PlanMode) Enum() *PlanMode {
	p := new(PlanMode)
	*p = x
	return p
}

func (x PlanMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PlanMode) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[1].Descriptor()
}

func (PlanMode) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[1]
}

func (x PlanMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PlanMode.Descriptor instead.
func (PlanMode) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{1}
}

type ChangeType int32

const (
	ChangeType_NOOP   ChangeType = 0
	ChangeType_READ   ChangeType = 1
	ChangeType_CREATE ChangeType = 2
	ChangeType_UPDATE ChangeType = 3
	ChangeType_DELETE ChangeType = 4
	ChangeType_FORGET ChangeType = 5
)

// Enum value maps for ChangeType.
var (
	ChangeType_name = map[int32]string{
		0: "NOOP",
		1: "READ",
		2: "CREATE",
		3: "UPDATE",
		4: "DELETE",
		5: "FORGET",
	}
	ChangeType_value = map[string]int32{
		"NOOP":   0,
		"READ":   1,
		"CREATE": 2,
		"UPDATE": 3,
		"DELETE": 4,
		"FORGET": 5,
	}
)

func (x ChangeType) Enum() *ChangeType {
	p := new(ChangeType)
	*p = x
	return p
}

func (x ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[2].Descriptor()
}

func (ChangeType) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[2]
}

func (x ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeType.Descriptor instead.
func (ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{2}
}

type FindStackConfigurationComponents_Instances int32

const (
	FindStackConfigurationComponents_SINGLE   FindStackConfigurationComponents_Instances = 0
	FindStackConfigurationComponents_COUNT    FindStackConfigurationComponents_Instances = 1
	FindStackConfigurationComponents_FOR_EACH FindStackConfigurationComponents_Instances = 2
)

// Enum value maps for FindStackConfigurationComponents_Instances.
var (
	FindStackConfigurationComponents_Instances_name = map[int32]string{
		0: "SINGLE",
		1: "COUNT",
		2: "FOR_EACH",
	}
	FindStackConfigurationComponents_Instances_value = map[string]int32{
		"SINGLE":   0,
		"COUNT":    1,
		"FOR_EACH": 2,
	}
)

func (x FindStackConfigurationComponents_Instances) Enum() *FindStackConfigurationComponents_Instances {
	p := new(FindStackConfigurationComponents_Instances)
	*p = x
	return p
}

func (x FindStackConfigurationComponents_Instances) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FindStackConfigurationComponents_Instances) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[3].Descriptor()
}

func (FindStackConfigurationComponents_Instances) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[3]
}

func (x FindStackConfigurationComponents_Instances) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FindStackConfigurationComponents_Instances.Descriptor instead.
func (FindStackConfigurationComponents_Instances) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 0}
}

// Reason describes the reason why a resource instance change was
// deferred.
type Deferred_Reason int32

const (
	Deferred_INVALID                 Deferred_Reason = 0
	Deferred_INSTANCE_COUNT_UNKNOWN  Deferred_Reason = 1
	Deferred_RESOURCE_CONFIG_UNKNOWN Deferred_Reason = 2
	Deferred_PROVIDER_CONFIG_UNKNOWN Deferred_Reason = 3
	Deferred_ABSENT_PREREQ           Deferred_Reason = 4
	Deferred_DEFERRED_PREREQ         Deferred_Reason = 5
)

// Enum value maps for Deferred_Reason.
var (
	Deferred_Reason_name = map[int32]string{
		0: "INVALID",
		1: "INSTANCE_COUNT_UNKNOWN",
		2: "RESOURCE_CONFIG_UNKNOWN",
		3: "PROVIDER_CONFIG_UNKNOWN",
		4: "ABSENT_PREREQ",
		5: "DEFERRED_PREREQ",
	}
	Deferred_Reason_value = map[string]int32{
		"INVALID":                 0,
		"INSTANCE_COUNT_UNKNOWN":  1,
		"RESOURCE_CONFIG_UNKNOWN": 2,
		"PROVIDER_CONFIG_UNKNOWN": 3,
		"ABSENT_PREREQ":           4,
		"DEFERRED_PREREQ":         5,
	}
)

func (x Deferred_Reason) Enum() *Deferred_Reason {
	p := new(Deferred_Reason)
	*p = x
	return p
}

func (x Deferred_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deferred_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[4].Descriptor()
}

func (Deferred_Reason) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[4]
}

func (x Deferred_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deferred_Reason.Descriptor instead.
func (Deferred_Reason) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{23, 0}
}

type StackChangeProgress_ComponentInstanceStatus_Status int32

const (
	StackChangeProgress_ComponentInstanceStatus_INVALID  StackChangeProgress_ComponentInstanceStatus_Status = 0
	StackChangeProgress_ComponentInstanceStatus_PENDING  StackChangeProgress_ComponentInstanceStatus_Status = 1
	StackChangeProgress_ComponentInstanceStatus_PLANNING StackChangeProgress_ComponentInstanceStatus_Status = 2
	StackChangeProgress_ComponentInstanceStatus_PLANNED  StackChangeProgress_ComponentInstanceStatus_Status = 3
	StackChangeProgress_ComponentInstanceStatus_APPLYING StackChangeProgress_ComponentInstanceStatus_Status = 4
	StackChangeProgress_ComponentInstanceStatus_APPLIED  StackChangeProgress_ComponentInstanceStatus_Status = 5
	StackChangeProgress_ComponentInstanceStatus_ERRORED  StackChangeProgress_ComponentInstanceStatus_Status = 6
	StackChangeProgress_ComponentInstanceStatus_DEFERRED StackChangeProgress_ComponentInstanceStatus_Status = 7
)

// Enum value maps for StackChangeProgress_ComponentInstanceStatus_Status.
var (
	StackChangeProgress_ComponentInstanceStatus_Status_name = map[int32]string{
		0: "INVALID",
		1: "PENDING",
		2: "PLANNING",
		3: "PLANNED",
		4: "APPLYING",
		5: "APPLIED",
		6: "ERRORED",
		7: "DEFERRED",
	}
	StackChangeProgress_ComponentInstanceStatus_Status_value = map[string]int32{
		"INVALID":  0,
		"PENDING":  1,
		"PLANNING": 2,
		"PLANNED":  3,
		"APPLYING": 4,
		"APPLIED":  5,
		"ERRORED":  6,
		"DEFERRED": 7,
	}
)

func (x StackChangeProgress_ComponentInstanceStatus_Status) Enum() *StackChangeProgress_ComponentInstanceStatus_Status {
	p := new(StackChangeProgress_ComponentInstanceStatus_Status)
	*p = x
	return p
}

func (x StackChangeProgress_ComponentInstanceStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StackChangeProgress_ComponentInstanceStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[5].Descriptor()
}

func (StackChangeProgress_ComponentInstanceStatus_Status) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[5]
}

func (x StackChangeProgress_ComponentInstanceStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StackChangeProgress_ComponentInstanceStatus_Status.Descriptor instead.
func (StackChangeProgress_ComponentInstanceStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 0, 0}
}

type StackChangeProgress_ResourceInstanceStatus_Status int32

const (
	StackChangeProgress_ResourceInstanceStatus_INVALID    StackChangeProgress_ResourceInstanceStatus_Status = 0
	StackChangeProgress_ResourceInstanceStatus_PENDING    StackChangeProgress_ResourceInstanceStatus_Status = 1
	StackChangeProgress_ResourceInstanceStatus_REFRESHING StackChangeProgress_ResourceInstanceStatus_Status = 2
	StackChangeProgress_ResourceInstanceStatus_REFRESHED  StackChangeProgress_ResourceInstanceStatus_Status = 3
	StackChangeProgress_ResourceInstanceStatus_PLANNING   StackChangeProgress_ResourceInstanceStatus_Status = 4
	StackChangeProgress_ResourceInstanceStatus_PLANNED    StackChangeProgress_ResourceInstanceStatus_Status = 5
	StackChangeProgress_ResourceInstanceStatus_APPLYING   StackChangeProgress_ResourceInstanceStatus_Status = 6
	StackChangeProgress_ResourceInstanceStatus_APPLIED    StackChangeProgress_ResourceInstanceStatus_Status = 7
	StackChangeProgress_ResourceInstanceStatus_ERRORED    StackChangeProgress_ResourceInstanceStatus_Status = 8
)

// Enum value maps for StackChangeProgress_ResourceInstanceStatus_Status.
var (
	StackChangeProgress_ResourceInstanceStatus_Status_name = map[int32]string{
		0: "INVALID",
		1: "PENDING",
		2: "REFRESHING",
		3: "REFRESHED",
		4: "PLANNING",
		5: "PLANNED",
		6: "APPLYING",
		7: "APPLIED",
		8: "ERRORED",
	}
	StackChangeProgress_ResourceInstanceStatus_Status_value = map[string]int32{
		"INVALID":    0,
		"PENDING":    1,
		"REFRESHING": 2,
		"REFRESHED":  3,
		"PLANNING":   4,
		"PLANNED":    5,
		"APPLYING":   6,
		"APPLIED":    7,
		"ERRORED":    8,
	}
)

func (x StackChangeProgress_ResourceInstanceStatus_Status) Enum() *StackChangeProgress_ResourceInstanceStatus_Status {
	p := new(StackChangeProgress_ResourceInstanceStatus_Status)
	*p = x
	return p
}

func (x StackChangeProgress_ResourceInstanceStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StackChangeProgress_ResourceInstanceStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[6].Descriptor()
}

func (StackChangeProgress_ResourceInstanceStatus_Status) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[6]
}

func (x StackChangeProgress_ResourceInstanceStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StackChangeProgress_ResourceInstanceStatus_Status.Descriptor instead.
func (StackChangeProgress_ResourceInstanceStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 1, 0}
}

type StackChangeProgress_ProvisionerStatus_Status int32

const (
	StackChangeProgress_ProvisionerStatus_INVALID      StackChangeProgress_ProvisionerStatus_Status = 0
	StackChangeProgress_ProvisionerStatus_PROVISIONING StackChangeProgress_ProvisionerStatus_Status = 1
	StackChangeProgress_ProvisionerStatus_PROVISIONED  StackChangeProgress_ProvisionerStatus_Status = 2
	StackChangeProgress_ProvisionerStatus_ERRORED      StackChangeProgress_ProvisionerStatus_Status = 3
)

// Enum value maps for StackChangeProgress_ProvisionerStatus_Status.
var (
	StackChangeProgress_ProvisionerStatus_Status_name = map[int32]string{
		0: "INVALID",
		1: "PROVISIONING",
		2: "PROVISIONED",
		3: "ERRORED",
	}
	StackChangeProgress_ProvisionerStatus_Status_value = map[string]int32{
		"INVALID":      0,
		"PROVISIONING": 1,
		"PROVISIONED":  2,
		"ERRORED":      3,
	}
)

func (x StackChangeProgress_ProvisionerStatus_Status) Enum() *StackChangeProgress_ProvisionerStatus_Status {
	p := new(StackChangeProgress_ProvisionerStatus_Status)
	*p = x
	return p
}

func (x StackChangeProgress_ProvisionerStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StackChangeProgress_ProvisionerStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_stacks_proto_enumTypes[7].Descriptor()
}

func (StackChangeProgress_ProvisionerStatus_Status) Type() protoreflect.EnumType {
	return &file_stacks_proto_enumTypes[7]
}

func (x StackChangeProgress_ProvisionerStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StackChangeProgress_ProvisionerStatus_Status.Descriptor instead.
func (StackChangeProgress_ProvisionerStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 4, 0}
}

// OpenTerraformState opens a previously-saved Terraform state, returning a
// handle that can be used with other operations. This is distinct from
// OpenState because it means core state rather than stack state.
type OpenTerraformState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenTerraformState) Reset() {
	*x = OpenTerraformState{}
	mi := &file_stacks_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenTerraformState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenTerraformState) ProtoMessage() {}

func (x *OpenTerraformState) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenTerraformState.ProtoReflect.Descriptor instead.
func (*OpenTerraformState) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{0}
}

// CloseTerraformState closes a previously-opened Terraform state using its
// handle.
type CloseTerraformState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseTerraformState) Reset() {
	*x = CloseTerraformState{}
	mi := &file_stacks_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseTerraformState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseTerraformState) ProtoMessage() {}

func (x *CloseTerraformState) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseTerraformState.ProtoReflect.Descriptor instead.
func (*CloseTerraformState) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{1}
}

// MigrateTerraformState migrates a Terraform state into Stacks state using
// a mapping of addresses.
//
// Only resources and modules from the root module should be specified. All
// resources in nested modules maintain their nested structure within the new
// components the base modules were moved into.
type MigrateTerraformState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MigrateTerraformState) Reset() {
	*x = MigrateTerraformState{}
	mi := &file_stacks_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrateTerraformState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateTerraformState) ProtoMessage() {}

func (x *MigrateTerraformState) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateTerraformState.ProtoReflect.Descriptor instead.
func (*MigrateTerraformState) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{2}
}

type OpenStackConfiguration struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackConfiguration) Reset() {
	*x = OpenStackConfiguration{}
	mi := &file_stacks_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackConfiguration) ProtoMessage() {}

func (x *OpenStackConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackConfiguration.ProtoReflect.Descriptor instead.
func (*OpenStackConfiguration) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{3}
}

type CloseStackConfiguration struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackConfiguration) Reset() {
	*x = CloseStackConfiguration{}
	mi := &file_stacks_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackConfiguration) ProtoMessage() {}

func (x *CloseStackConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackConfiguration.ProtoReflect.Descriptor instead.
func (*CloseStackConfiguration) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{4}
}

type ValidateStackConfiguration struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateStackConfiguration) Reset() {
	*x = ValidateStackConfiguration{}
	mi := &file_stacks_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateStackConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateStackConfiguration) ProtoMessage() {}

func (x *ValidateStackConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateStackConfiguration.ProtoReflect.Descriptor instead.
func (*ValidateStackConfiguration) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{5}
}

type FindStackConfigurationComponents struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents) Reset() {
	*x = FindStackConfigurationComponents{}
	mi := &file_stacks_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents) ProtoMessage() {}

func (x *FindStackConfigurationComponents) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6}
}

type OpenStackState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackState) Reset() {
	*x = OpenStackState{}
	mi := &file_stacks_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackState) ProtoMessage() {}

func (x *OpenStackState) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackState.ProtoReflect.Descriptor instead.
func (*OpenStackState) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{7}
}

type CloseStackState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackState) Reset() {
	*x = CloseStackState{}
	mi := &file_stacks_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackState) ProtoMessage() {}

func (x *CloseStackState) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackState.ProtoReflect.Descriptor instead.
func (*CloseStackState) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{8}
}

type PlanStackChanges struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanStackChanges) Reset() {
	*x = PlanStackChanges{}
	mi := &file_stacks_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanStackChanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanStackChanges) ProtoMessage() {}

func (x *PlanStackChanges) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanStackChanges.ProtoReflect.Descriptor instead.
func (*PlanStackChanges) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{9}
}

type OpenStackPlan struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackPlan) Reset() {
	*x = OpenStackPlan{}
	mi := &file_stacks_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackPlan) ProtoMessage() {}

func (x *OpenStackPlan) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackPlan.ProtoReflect.Descriptor instead.
func (*OpenStackPlan) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{10}
}

type CloseStackPlan struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackPlan) Reset() {
	*x = CloseStackPlan{}
	mi := &file_stacks_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackPlan) ProtoMessage() {}

func (x *CloseStackPlan) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackPlan.ProtoReflect.Descriptor instead.
func (*CloseStackPlan) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{11}
}

type ApplyStackChanges struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyStackChanges) Reset() {
	*x = ApplyStackChanges{}
	mi := &file_stacks_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyStackChanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyStackChanges) ProtoMessage() {}

func (x *ApplyStackChanges) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyStackChanges.ProtoReflect.Descriptor instead.
func (*ApplyStackChanges) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{12}
}

type OpenStackInspector struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackInspector) Reset() {
	*x = OpenStackInspector{}
	mi := &file_stacks_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackInspector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackInspector) ProtoMessage() {}

func (x *OpenStackInspector) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackInspector.ProtoReflect.Descriptor instead.
func (*OpenStackInspector) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{13}
}

type InspectExpressionResult struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InspectExpressionResult) Reset() {
	*x = InspectExpressionResult{}
	mi := &file_stacks_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InspectExpressionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectExpressionResult) ProtoMessage() {}

func (x *InspectExpressionResult) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectExpressionResult.ProtoReflect.Descriptor instead.
func (*InspectExpressionResult) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{14}
}

// Represents dynamically-typed data from within the Terraform language.
// Typically only one of the available serialization formats will be populated,
// depending on what serializations are appropriate for a particular context
// and what capabilities the client and the server negotiated during Handshake.
type DynamicValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Msgpack       []byte                 `protobuf:"bytes,1,opt,name=msgpack,proto3" json:"msgpack,omitempty"`     // The default serialization format
	Sensitive     []*AttributePath       `protobuf:"bytes,2,rep,name=sensitive,proto3" json:"sensitive,omitempty"` // Paths to any sensitive-marked values.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DynamicValue) Reset() {
	*x = DynamicValue{}
	mi := &file_stacks_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValue) ProtoMessage() {}

func (x *DynamicValue) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValue.ProtoReflect.Descriptor instead.
func (*DynamicValue) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{15}
}

func (x *DynamicValue) GetMsgpack() []byte {
	if x != nil {
		return x.Msgpack
	}
	return nil
}

func (x *DynamicValue) GetSensitive() []*AttributePath {
	if x != nil {
		return x.Sensitive
	}
	return nil
}

// Represents a change of some object from one dynamic value to another.
type DynamicValueChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Old           *DynamicValue          `protobuf:"bytes,1,opt,name=old,proto3" json:"old,omitempty"`
	New           *DynamicValue          `protobuf:"bytes,2,opt,name=new,proto3" json:"new,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DynamicValueChange) Reset() {
	*x = DynamicValueChange{}
	mi := &file_stacks_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValueChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValueChange) ProtoMessage() {}

func (x *DynamicValueChange) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValueChange.ProtoReflect.Descriptor instead.
func (*DynamicValueChange) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{16}
}

func (x *DynamicValueChange) GetOld() *DynamicValue {
	if x != nil {
		return x.Old
	}
	return nil
}

func (x *DynamicValueChange) GetNew() *DynamicValue {
	if x != nil {
		return x.New
	}
	return nil
}

// Represents a DynamicValue accompanied by a source location where it was
// presumably defined, for values that originated in configuration files for
// situations such as returning error messages.
type DynamicValueWithSource struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	Value         *DynamicValue           `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	SourceRange   *terraform1.SourceRange `protobuf:"bytes,2,opt,name=source_range,json=sourceRange,proto3" json:"source_range,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DynamicValueWithSource) Reset() {
	*x = DynamicValueWithSource{}
	mi := &file_stacks_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValueWithSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValueWithSource) ProtoMessage() {}

func (x *DynamicValueWithSource) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValueWithSource.ProtoReflect.Descriptor instead.
func (*DynamicValueWithSource) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{17}
}

func (x *DynamicValueWithSource) GetValue() *DynamicValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *DynamicValueWithSource) GetSourceRange() *terraform1.SourceRange {
	if x != nil {
		return x.SourceRange
	}
	return nil
}

type AttributePath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Steps         []*AttributePath_Step  `protobuf:"bytes,1,rep,name=steps,proto3" json:"steps,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath) Reset() {
	*x = AttributePath{}
	mi := &file_stacks_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath) ProtoMessage() {}

func (x *AttributePath) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath.ProtoReflect.Descriptor instead.
func (*AttributePath) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{18}
}

func (x *AttributePath) GetSteps() []*AttributePath_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

// Represents the address of a specific component instance within a stack.
type ComponentInstanceInStackAddr struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address of the static component that this is an instance of.
	ComponentAddr string `protobuf:"bytes,1,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	// The address of the instance that's being announced. For
	// multi-instance components this could have any combination of
	// instance keys on the component itself or instance keys on any
	// of the containing embedded stacks.
	ComponentInstanceAddr string `protobuf:"bytes,2,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ComponentInstanceInStackAddr) Reset() {
	*x = ComponentInstanceInStackAddr{}
	mi := &file_stacks_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComponentInstanceInStackAddr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComponentInstanceInStackAddr) ProtoMessage() {}

func (x *ComponentInstanceInStackAddr) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComponentInstanceInStackAddr.ProtoReflect.Descriptor instead.
func (*ComponentInstanceInStackAddr) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{19}
}

func (x *ComponentInstanceInStackAddr) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

func (x *ComponentInstanceInStackAddr) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

// Represents the address of a specific resource instance inside a specific
// component instance within the containing stack.
type ResourceInstanceInStackAddr struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique address of the component instance that this resource instance
	// belongs to. This is comparable with
	ComponentInstanceAddr string `protobuf:"bytes,1,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	// Unique address of the resource instance within the given component
	// instance. Each component instance has a separate namespace of
	// resource instance addresses, so callers must take both fields together
	// to produce a key that's unique throughout the entire plan.
	ResourceInstanceAddr string `protobuf:"bytes,2,opt,name=resource_instance_addr,json=resourceInstanceAddr,proto3" json:"resource_instance_addr,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ResourceInstanceInStackAddr) Reset() {
	*x = ResourceInstanceInStackAddr{}
	mi := &file_stacks_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceInstanceInStackAddr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceInstanceInStackAddr) ProtoMessage() {}

func (x *ResourceInstanceInStackAddr) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceInstanceInStackAddr.ProtoReflect.Descriptor instead.
func (*ResourceInstanceInStackAddr) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{20}
}

func (x *ResourceInstanceInStackAddr) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

func (x *ResourceInstanceInStackAddr) GetResourceInstanceAddr() string {
	if x != nil {
		return x.ResourceInstanceAddr
	}
	return ""
}

// Represents the address of a specific resource instance object inside a
// specific component instance within the containing stack.
type ResourceInstanceObjectInStackAddr struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique address of the component instance that this resource instance
	// belongs to. This is comparable with
	ComponentInstanceAddr string `protobuf:"bytes,1,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	// Unique address of the resource instance within the given component
	// instance. Each component instance has a separate namespace of
	// resource instance addresses, so callers must take both fields together
	// to produce a key that's unique throughout the entire plan.
	ResourceInstanceAddr string `protobuf:"bytes,2,opt,name=resource_instance_addr,json=resourceInstanceAddr,proto3" json:"resource_instance_addr,omitempty"`
	// Optional "deposed key" populated only for non-current (deposed) objects,
	// which can appear for "create before destroy" replacements where the
	// create succeeds but then the destroy fails, leaving us with two different
	// objects to track for the same resource instance.
	DeposedKey    string `protobuf:"bytes,3,opt,name=deposed_key,json=deposedKey,proto3" json:"deposed_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceInstanceObjectInStackAddr) Reset() {
	*x = ResourceInstanceObjectInStackAddr{}
	mi := &file_stacks_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceInstanceObjectInStackAddr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceInstanceObjectInStackAddr) ProtoMessage() {}

func (x *ResourceInstanceObjectInStackAddr) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceInstanceObjectInStackAddr.ProtoReflect.Descriptor instead.
func (*ResourceInstanceObjectInStackAddr) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{21}
}

func (x *ResourceInstanceObjectInStackAddr) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

func (x *ResourceInstanceObjectInStackAddr) GetResourceInstanceAddr() string {
	if x != nil {
		return x.ResourceInstanceAddr
	}
	return ""
}

func (x *ResourceInstanceObjectInStackAddr) GetDeposedKey() string {
	if x != nil {
		return x.DeposedKey
	}
	return ""
}

// Describes one item in a stack plan. The overall plan is the concatentation
// of all messages of this type emitted as events during the plan; splitting
// this information over multiple messages just allows the individual events
// to double as progress notifications for an interactive UI.
type PlannedChange struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Terraform Core's internal representation(s) of this change. Callers
	// must provide the messages in this field, if any, verbatim to the
	// ApplyStackChanges RPC in order to apply this change, and must not
	// attempt to decode or analyze the contents because they are subject
	// to change in future versions of Terraform Core.
	//
	// This might be unpopulated if this message represents only information
	// for the caller and Terraform Core doesn't actually need to recall this
	// information during the apply step. Callers must append each raw item
	// to the raw plan in the order specified, and provide them all together
	// in the same order to ApplyStackChanges.
	Raw []*anypb.Any `protobuf:"bytes,1,rep,name=raw,proto3" json:"raw,omitempty"`
	// Caller-facing descriptions of this change, to use for presenting
	// information to end-users in the UI and for other subsystems such as
	// imposing policy rules on the resulting plan.
	//
	// There can be zero or more description objects associated with each
	// change. More than one is not common, but should be supported by clients
	// by treating them the same way as if each description had arrived in
	// a separate PlannedChange message. Clients should not treat the grouping
	// or not-grouping of change description objects as meaningful information,
	// since it's subject to change in future Terraform Core versions.
	//
	// DO NOT attempt to use this to surgically filter particular changes
	// from a larger plan. Although external descriptions often match with
	// the raw representations in field "raw", that is not guaranteed and
	// Terraform Core assumes that it will always be provided with the full
	// set of raw messages -- in the same order they were emitted -- during
	// the apply step. For example, some raw messages might omit information
	// that is implied by earlier raw messages and would therefore be
	// incomplete if isolated.
	Descriptions  []*PlannedChange_ChangeDescription `protobuf:"bytes,2,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlannedChange) Reset() {
	*x = PlannedChange{}
	mi := &file_stacks_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange) ProtoMessage() {}

func (x *PlannedChange) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange.ProtoReflect.Descriptor instead.
func (*PlannedChange) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22}
}

func (x *PlannedChange) GetRaw() []*anypb.Any {
	if x != nil {
		return x.Raw
	}
	return nil
}

func (x *PlannedChange) GetDescriptions() []*PlannedChange_ChangeDescription {
	if x != nil {
		return x.Descriptions
	}
	return nil
}

// Deferred contains all the metadata about a the deferral of a resource
// instance change.
type Deferred struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Reason        Deferred_Reason        `protobuf:"varint,1,opt,name=reason,proto3,enum=terraform1.stacks.Deferred_Reason" json:"reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Deferred) Reset() {
	*x = Deferred{}
	mi := &file_stacks_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Deferred) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deferred) ProtoMessage() {}

func (x *Deferred) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deferred.ProtoReflect.Descriptor instead.
func (*Deferred) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{23}
}

func (x *Deferred) GetReason() Deferred_Reason {
	if x != nil {
		return x.Reason
	}
	return Deferred_INVALID
}

// Describes a change made during a Stacks.ApplyStackChanges call.
//
// All of the events of this type taken together represent a sort of "patch"
// modifying the two data structures that the caller must maintain: the
// raw state map, and the description map. Callers must apply these changes
// in the order of the emission of the messages and then retain the entirety
// of both data structures to populate fields in the next PlanStackChanges call.
type AppliedChange struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Terraform Core's internal representation of the change, presented as
	// a sequence of modifications to the raw state data structure.
	//
	// For each element, in order:
	//   - If both key and value are set and the key matches an element
	//     already in the raw state map, the new value replaces the existing one.
	//   - If both key and value are set but the key does not match an
	//     element in the raw state map, this represents inserting a new element
	//     into the map.
	//   - If key is set and value is not, this represents removing any existing
	//     element from the raw state map which has the given key, or a no-op
	//     if no such element exists.
	//   - No other situation is legal.
	//
	// This sequence can potentially be zero-length if a particular event only
	// has a external-facing "description" component and no raw equivalent. In
	// that case the raw state map is unmodified.
	Raw []*AppliedChange_RawChange `protobuf:"bytes,1,rep,name=raw,proto3" json:"raw,omitempty"`
	// Caller-facing description of this change, to use for presenting
	// information to end-users in the UI and for other subsystems such as
	// billing.
	//
	// Callers are expected to maintain a map of description objects that
	// gets updated piecemeal by messages in this field. Callers must treat
	// the keys as entirely opaque and thus treat the resulting data structure
	// as if it were an unsorted set of ChangeDescription objects; the keys
	// exist only to allow patching the data structure over time.
	//
	// For each element, in order:
	//   - If both key and description are set and the key matches an element
	//     from the previous apply's description map, the new value replaces
	//     the existing one.
	//   - If both key and value are set but the key does not match an
	//     element in the previous apply's description map, this represents
	//     inserting a new element into the map.
	//   - If key is set and description is "deleted", this represents removing
	//     any existing element from the previous apply's description map which
	//     has the given key, or a no-op if no such element exists.
	//   - If a description field is set that the caller doesn't understand,
	//     the caller should still write it to the updated description map
	//     but ignore it in further processing.
	//   - No other situation is legal.
	//
	// Callers MUST preserve the verbatim description message in the
	// description map, even if it contains fields that are not present in
	// the caller's current protobuf stubs. In other words, callers must use
	// a protocol buffers implementation that is able to preserve unknown
	// fields and store them so that future versions of the caller might
	// use an updated set of stubs to interact with the previously-stored
	// description.
	//
	// DO NOT attempt to use this to surgically filter particular raw state
	// updates from a larger plan. Although external descriptions often match
	// with the raw representations in field "raw", that is not guaranteed and
	// Terraform Core assumes that it will always be provided with the full
	// raw state map during the next plan step.
	Descriptions  []*AppliedChange_ChangeDescription `protobuf:"bytes,2,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange) Reset() {
	*x = AppliedChange{}
	mi := &file_stacks_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange) ProtoMessage() {}

func (x *AppliedChange) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange.ProtoReflect.Descriptor instead.
func (*AppliedChange) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24}
}

func (x *AppliedChange) GetRaw() []*AppliedChange_RawChange {
	if x != nil {
		return x.Raw
	}
	return nil
}

func (x *AppliedChange) GetDescriptions() []*AppliedChange_ChangeDescription {
	if x != nil {
		return x.Descriptions
	}
	return nil
}

// A container for "progress report" events in both Stacks.PlanStackChanges
// and Stacks.ApplyStackChanges, which share this message type to allow
// clients to share event-handling code between the two phases.
type StackChangeProgress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Some event types are relevant only to one of the two operations, while
	// others are common across both but will include different status codes,
	// etc in different phases.
	//
	// Types that are valid to be assigned to Event:
	//
	//	*StackChangeProgress_ComponentInstanceStatus_
	//	*StackChangeProgress_ResourceInstanceStatus_
	//	*StackChangeProgress_ResourceInstancePlannedChange_
	//	*StackChangeProgress_ProvisionerStatus_
	//	*StackChangeProgress_ProvisionerOutput_
	//	*StackChangeProgress_ComponentInstanceChanges_
	//	*StackChangeProgress_ComponentInstances_
	//	*StackChangeProgress_DeferredResourceInstancePlannedChange_
	Event         isStackChangeProgress_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress) Reset() {
	*x = StackChangeProgress{}
	mi := &file_stacks_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress) ProtoMessage() {}

func (x *StackChangeProgress) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress.ProtoReflect.Descriptor instead.
func (*StackChangeProgress) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25}
}

func (x *StackChangeProgress) GetEvent() isStackChangeProgress_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *StackChangeProgress) GetComponentInstanceStatus() *StackChangeProgress_ComponentInstanceStatus {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ComponentInstanceStatus_); ok {
			return x.ComponentInstanceStatus
		}
	}
	return nil
}

func (x *StackChangeProgress) GetResourceInstanceStatus() *StackChangeProgress_ResourceInstanceStatus {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ResourceInstanceStatus_); ok {
			return x.ResourceInstanceStatus
		}
	}
	return nil
}

func (x *StackChangeProgress) GetResourceInstancePlannedChange() *StackChangeProgress_ResourceInstancePlannedChange {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ResourceInstancePlannedChange_); ok {
			return x.ResourceInstancePlannedChange
		}
	}
	return nil
}

func (x *StackChangeProgress) GetProvisionerStatus() *StackChangeProgress_ProvisionerStatus {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ProvisionerStatus_); ok {
			return x.ProvisionerStatus
		}
	}
	return nil
}

func (x *StackChangeProgress) GetProvisionerOutput() *StackChangeProgress_ProvisionerOutput {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ProvisionerOutput_); ok {
			return x.ProvisionerOutput
		}
	}
	return nil
}

func (x *StackChangeProgress) GetComponentInstanceChanges() *StackChangeProgress_ComponentInstanceChanges {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ComponentInstanceChanges_); ok {
			return x.ComponentInstanceChanges
		}
	}
	return nil
}

func (x *StackChangeProgress) GetComponentInstances() *StackChangeProgress_ComponentInstances {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_ComponentInstances_); ok {
			return x.ComponentInstances
		}
	}
	return nil
}

func (x *StackChangeProgress) GetDeferredResourceInstancePlannedChange() *StackChangeProgress_DeferredResourceInstancePlannedChange {
	if x != nil {
		if x, ok := x.Event.(*StackChangeProgress_DeferredResourceInstancePlannedChange_); ok {
			return x.DeferredResourceInstancePlannedChange
		}
	}
	return nil
}

type isStackChangeProgress_Event interface {
	isStackChangeProgress_Event()
}

type StackChangeProgress_ComponentInstanceStatus_ struct {
	ComponentInstanceStatus *StackChangeProgress_ComponentInstanceStatus `protobuf:"bytes,1,opt,name=component_instance_status,json=componentInstanceStatus,proto3,oneof"`
}

type StackChangeProgress_ResourceInstanceStatus_ struct {
	ResourceInstanceStatus *StackChangeProgress_ResourceInstanceStatus `protobuf:"bytes,2,opt,name=resource_instance_status,json=resourceInstanceStatus,proto3,oneof"`
}

type StackChangeProgress_ResourceInstancePlannedChange_ struct {
	ResourceInstancePlannedChange *StackChangeProgress_ResourceInstancePlannedChange `protobuf:"bytes,3,opt,name=resource_instance_planned_change,json=resourceInstancePlannedChange,proto3,oneof"`
}

type StackChangeProgress_ProvisionerStatus_ struct {
	ProvisionerStatus *StackChangeProgress_ProvisionerStatus `protobuf:"bytes,4,opt,name=provisioner_status,json=provisionerStatus,proto3,oneof"`
}

type StackChangeProgress_ProvisionerOutput_ struct {
	ProvisionerOutput *StackChangeProgress_ProvisionerOutput `protobuf:"bytes,5,opt,name=provisioner_output,json=provisionerOutput,proto3,oneof"`
}

type StackChangeProgress_ComponentInstanceChanges_ struct {
	ComponentInstanceChanges *StackChangeProgress_ComponentInstanceChanges `protobuf:"bytes,6,opt,name=component_instance_changes,json=componentInstanceChanges,proto3,oneof"`
}

type StackChangeProgress_ComponentInstances_ struct {
	ComponentInstances *StackChangeProgress_ComponentInstances `protobuf:"bytes,7,opt,name=component_instances,json=componentInstances,proto3,oneof"`
}

type StackChangeProgress_DeferredResourceInstancePlannedChange_ struct {
	DeferredResourceInstancePlannedChange *StackChangeProgress_DeferredResourceInstancePlannedChange `protobuf:"bytes,8,opt,name=deferred_resource_instance_planned_change,json=deferredResourceInstancePlannedChange,proto3,oneof"`
}

func (*StackChangeProgress_ComponentInstanceStatus_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_ResourceInstanceStatus_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_ResourceInstancePlannedChange_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_ProvisionerStatus_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_ProvisionerOutput_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_ComponentInstanceChanges_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_ComponentInstances_) isStackChangeProgress_Event() {}

func (*StackChangeProgress_DeferredResourceInstancePlannedChange_) isStackChangeProgress_Event() {}

type ListResourceIdentities struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResourceIdentities) Reset() {
	*x = ListResourceIdentities{}
	mi := &file_stacks_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResourceIdentities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceIdentities) ProtoMessage() {}

func (x *ListResourceIdentities) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceIdentities.ProtoReflect.Descriptor instead.
func (*ListResourceIdentities) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{26}
}

type OpenTerraformState_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to State:
	//
	//	*OpenTerraformState_Request_ConfigPath
	//	*OpenTerraformState_Request_Raw
	State         isOpenTerraformState_Request_State `protobuf_oneof:"state"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenTerraformState_Request) Reset() {
	*x = OpenTerraformState_Request{}
	mi := &file_stacks_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenTerraformState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenTerraformState_Request) ProtoMessage() {}

func (x *OpenTerraformState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenTerraformState_Request.ProtoReflect.Descriptor instead.
func (*OpenTerraformState_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{0, 0}
}

func (x *OpenTerraformState_Request) GetState() isOpenTerraformState_Request_State {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *OpenTerraformState_Request) GetConfigPath() string {
	if x != nil {
		if x, ok := x.State.(*OpenTerraformState_Request_ConfigPath); ok {
			return x.ConfigPath
		}
	}
	return ""
}

func (x *OpenTerraformState_Request) GetRaw() []byte {
	if x != nil {
		if x, ok := x.State.(*OpenTerraformState_Request_Raw); ok {
			return x.Raw
		}
	}
	return nil
}

type isOpenTerraformState_Request_State interface {
	isOpenTerraformState_Request_State()
}

type OpenTerraformState_Request_ConfigPath struct {
	// We can open a state based on configuration that has been initialized.
	ConfigPath string `protobuf:"bytes,1,opt,name=config_path,json=configPath,proto3,oneof"`
}

type OpenTerraformState_Request_Raw struct {
	// Or a state file based on raw bytes.
	Raw []byte `protobuf:"bytes,2,opt,name=raw,proto3,oneof"`
}

func (*OpenTerraformState_Request_ConfigPath) isOpenTerraformState_Request_State() {}

func (*OpenTerraformState_Request_Raw) isOpenTerraformState_Request_State() {}

type OpenTerraformState_Response struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	StateHandle   int64                    `protobuf:"varint,1,opt,name=state_handle,json=stateHandle,proto3" json:"state_handle,omitempty"`
	Diagnostics   []*terraform1.Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenTerraformState_Response) Reset() {
	*x = OpenTerraformState_Response{}
	mi := &file_stacks_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenTerraformState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenTerraformState_Response) ProtoMessage() {}

func (x *OpenTerraformState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenTerraformState_Response.ProtoReflect.Descriptor instead.
func (*OpenTerraformState_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{0, 1}
}

func (x *OpenTerraformState_Response) GetStateHandle() int64 {
	if x != nil {
		return x.StateHandle
	}
	return 0
}

func (x *OpenTerraformState_Response) GetDiagnostics() []*terraform1.Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type CloseTerraformState_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StateHandle   int64                  `protobuf:"varint,1,opt,name=state_handle,json=stateHandle,proto3" json:"state_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseTerraformState_Request) Reset() {
	*x = CloseTerraformState_Request{}
	mi := &file_stacks_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseTerraformState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseTerraformState_Request) ProtoMessage() {}

func (x *CloseTerraformState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseTerraformState_Request.ProtoReflect.Descriptor instead.
func (*CloseTerraformState_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CloseTerraformState_Request) GetStateHandle() int64 {
	if x != nil {
		return x.StateHandle
	}
	return 0
}

type CloseTerraformState_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseTerraformState_Response) Reset() {
	*x = CloseTerraformState_Response{}
	mi := &file_stacks_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseTerraformState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseTerraformState_Response) ProtoMessage() {}

func (x *CloseTerraformState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseTerraformState_Response.ProtoReflect.Descriptor instead.
func (*CloseTerraformState_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{1, 1}
}

type MigrateTerraformState_Request struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	StateHandle           int64                  `protobuf:"varint,1,opt,name=state_handle,json=stateHandle,proto3" json:"state_handle,omitempty"`    // previously opened Terraform state
	ConfigHandle          int64                  `protobuf:"varint,2,opt,name=config_handle,json=configHandle,proto3" json:"config_handle,omitempty"` // new stacks configuration
	DependencyLocksHandle int64                  `protobuf:"varint,3,opt,name=dependency_locks_handle,json=dependencyLocksHandle,proto3" json:"dependency_locks_handle,omitempty"`
	ProviderCacheHandle   int64                  `protobuf:"varint,4,opt,name=provider_cache_handle,json=providerCacheHandle,proto3" json:"provider_cache_handle,omitempty"`
	// Types that are valid to be assigned to Mapping:
	//
	//	*MigrateTerraformState_Request_Simple
	Mapping       isMigrateTerraformState_Request_Mapping `protobuf_oneof:"mapping"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MigrateTerraformState_Request) Reset() {
	*x = MigrateTerraformState_Request{}
	mi := &file_stacks_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrateTerraformState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateTerraformState_Request) ProtoMessage() {}

func (x *MigrateTerraformState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateTerraformState_Request.ProtoReflect.Descriptor instead.
func (*MigrateTerraformState_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{2, 0}
}

func (x *MigrateTerraformState_Request) GetStateHandle() int64 {
	if x != nil {
		return x.StateHandle
	}
	return 0
}

func (x *MigrateTerraformState_Request) GetConfigHandle() int64 {
	if x != nil {
		return x.ConfigHandle
	}
	return 0
}

func (x *MigrateTerraformState_Request) GetDependencyLocksHandle() int64 {
	if x != nil {
		return x.DependencyLocksHandle
	}
	return 0
}

func (x *MigrateTerraformState_Request) GetProviderCacheHandle() int64 {
	if x != nil {
		return x.ProviderCacheHandle
	}
	return 0
}

func (x *MigrateTerraformState_Request) GetMapping() isMigrateTerraformState_Request_Mapping {
	if x != nil {
		return x.Mapping
	}
	return nil
}

func (x *MigrateTerraformState_Request) GetSimple() *MigrateTerraformState_Request_Mapping {
	if x != nil {
		if x, ok := x.Mapping.(*MigrateTerraformState_Request_Simple); ok {
			return x.Simple
		}
	}
	return nil
}

type isMigrateTerraformState_Request_Mapping interface {
	isMigrateTerraformState_Request_Mapping()
}

type MigrateTerraformState_Request_Simple struct {
	// simple is a simple mapping of Terraform addresses to stack components
	Simple *MigrateTerraformState_Request_Mapping `protobuf:"bytes,5,opt,name=simple,proto3,oneof"`
}

func (*MigrateTerraformState_Request_Simple) isMigrateTerraformState_Request_Mapping() {}

type MigrateTerraformState_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Result:
	//
	//	*MigrateTerraformState_Event_Diagnostic
	//	*MigrateTerraformState_Event_AppliedChange
	Result        isMigrateTerraformState_Event_Result `protobuf_oneof:"result"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MigrateTerraformState_Event) Reset() {
	*x = MigrateTerraformState_Event{}
	mi := &file_stacks_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrateTerraformState_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateTerraformState_Event) ProtoMessage() {}

func (x *MigrateTerraformState_Event) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateTerraformState_Event.ProtoReflect.Descriptor instead.
func (*MigrateTerraformState_Event) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{2, 1}
}

func (x *MigrateTerraformState_Event) GetResult() isMigrateTerraformState_Event_Result {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *MigrateTerraformState_Event) GetDiagnostic() *terraform1.Diagnostic {
	if x != nil {
		if x, ok := x.Result.(*MigrateTerraformState_Event_Diagnostic); ok {
			return x.Diagnostic
		}
	}
	return nil
}

func (x *MigrateTerraformState_Event) GetAppliedChange() *AppliedChange {
	if x != nil {
		if x, ok := x.Result.(*MigrateTerraformState_Event_AppliedChange); ok {
			return x.AppliedChange
		}
	}
	return nil
}

type isMigrateTerraformState_Event_Result interface {
	isMigrateTerraformState_Event_Result()
}

type MigrateTerraformState_Event_Diagnostic struct {
	Diagnostic *terraform1.Diagnostic `protobuf:"bytes,1,opt,name=diagnostic,proto3,oneof"`
}

type MigrateTerraformState_Event_AppliedChange struct {
	AppliedChange *AppliedChange `protobuf:"bytes,2,opt,name=applied_change,json=appliedChange,proto3,oneof"`
}

func (*MigrateTerraformState_Event_Diagnostic) isMigrateTerraformState_Event_Result() {}

func (*MigrateTerraformState_Event_AppliedChange) isMigrateTerraformState_Event_Result() {}

// Mapping of terraform constructs to stack components.
type MigrateTerraformState_Request_Mapping struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// resource_address_map maps resources in the root module to their new
	// components. The keys are the addresses of the resources in the Terraform
	// state, and the values are the names of the new components.
	//
	// eg. resource_type.resource_name -> component_name
	ResourceAddressMap map[string]string `protobuf:"bytes,1,rep,name=resource_address_map,json=resourceAddressMap,proto3" json:"resource_address_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// module_address_map maps modules in the root module to their new
	// components. The keys are the module names in the Terraform state, and
	// the values are the names of the new components.
	//
	// eg. module_name -> component_name
	ModuleAddressMap map[string]string `protobuf:"bytes,2,rep,name=module_address_map,json=moduleAddressMap,proto3" json:"module_address_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *MigrateTerraformState_Request_Mapping) Reset() {
	*x = MigrateTerraformState_Request_Mapping{}
	mi := &file_stacks_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrateTerraformState_Request_Mapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrateTerraformState_Request_Mapping) ProtoMessage() {}

func (x *MigrateTerraformState_Request_Mapping) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrateTerraformState_Request_Mapping.ProtoReflect.Descriptor instead.
func (*MigrateTerraformState_Request_Mapping) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *MigrateTerraformState_Request_Mapping) GetResourceAddressMap() map[string]string {
	if x != nil {
		return x.ResourceAddressMap
	}
	return nil
}

func (x *MigrateTerraformState_Request_Mapping) GetModuleAddressMap() map[string]string {
	if x != nil {
		return x.ModuleAddressMap
	}
	return nil
}

type OpenStackConfiguration_Request struct {
	state              protoimpl.MessageState    `protogen:"open.v1"`
	SourceBundleHandle int64                     `protobuf:"varint,1,opt,name=source_bundle_handle,json=sourceBundleHandle,proto3" json:"source_bundle_handle,omitempty"`
	SourceAddress      *terraform1.SourceAddress `protobuf:"bytes,2,opt,name=source_address,json=sourceAddress,proto3" json:"source_address,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *OpenStackConfiguration_Request) Reset() {
	*x = OpenStackConfiguration_Request{}
	mi := &file_stacks_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackConfiguration_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackConfiguration_Request) ProtoMessage() {}

func (x *OpenStackConfiguration_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackConfiguration_Request.ProtoReflect.Descriptor instead.
func (*OpenStackConfiguration_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{3, 0}
}

func (x *OpenStackConfiguration_Request) GetSourceBundleHandle() int64 {
	if x != nil {
		return x.SourceBundleHandle
	}
	return 0
}

func (x *OpenStackConfiguration_Request) GetSourceAddress() *terraform1.SourceAddress {
	if x != nil {
		return x.SourceAddress
	}
	return nil
}

type OpenStackConfiguration_Response struct {
	state             protoimpl.MessageState   `protogen:"open.v1"`
	StackConfigHandle int64                    `protobuf:"varint,1,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	Diagnostics       []*terraform1.Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *OpenStackConfiguration_Response) Reset() {
	*x = OpenStackConfiguration_Response{}
	mi := &file_stacks_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackConfiguration_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackConfiguration_Response) ProtoMessage() {}

func (x *OpenStackConfiguration_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackConfiguration_Response.ProtoReflect.Descriptor instead.
func (*OpenStackConfiguration_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{3, 1}
}

func (x *OpenStackConfiguration_Response) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

func (x *OpenStackConfiguration_Response) GetDiagnostics() []*terraform1.Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type CloseStackConfiguration_Request struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	StackConfigHandle int64                  `protobuf:"varint,1,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CloseStackConfiguration_Request) Reset() {
	*x = CloseStackConfiguration_Request{}
	mi := &file_stacks_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackConfiguration_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackConfiguration_Request) ProtoMessage() {}

func (x *CloseStackConfiguration_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackConfiguration_Request.ProtoReflect.Descriptor instead.
func (*CloseStackConfiguration_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{4, 0}
}

func (x *CloseStackConfiguration_Request) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

type CloseStackConfiguration_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackConfiguration_Response) Reset() {
	*x = CloseStackConfiguration_Response{}
	mi := &file_stacks_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackConfiguration_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackConfiguration_Response) ProtoMessage() {}

func (x *CloseStackConfiguration_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackConfiguration_Response.ProtoReflect.Descriptor instead.
func (*CloseStackConfiguration_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{4, 1}
}

type ValidateStackConfiguration_Request struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	StackConfigHandle     int64                  `protobuf:"varint,1,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	DependencyLocksHandle int64                  `protobuf:"varint,2,opt,name=dependency_locks_handle,json=dependencyLocksHandle,proto3" json:"dependency_locks_handle,omitempty"`
	ProviderCacheHandle   int64                  `protobuf:"varint,3,opt,name=provider_cache_handle,json=providerCacheHandle,proto3" json:"provider_cache_handle,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ValidateStackConfiguration_Request) Reset() {
	*x = ValidateStackConfiguration_Request{}
	mi := &file_stacks_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateStackConfiguration_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateStackConfiguration_Request) ProtoMessage() {}

func (x *ValidateStackConfiguration_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateStackConfiguration_Request.ProtoReflect.Descriptor instead.
func (*ValidateStackConfiguration_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ValidateStackConfiguration_Request) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

func (x *ValidateStackConfiguration_Request) GetDependencyLocksHandle() int64 {
	if x != nil {
		return x.DependencyLocksHandle
	}
	return 0
}

func (x *ValidateStackConfiguration_Request) GetProviderCacheHandle() int64 {
	if x != nil {
		return x.ProviderCacheHandle
	}
	return 0
}

type ValidateStackConfiguration_Response struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Diagnostics   []*terraform1.Diagnostic `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateStackConfiguration_Response) Reset() {
	*x = ValidateStackConfiguration_Response{}
	mi := &file_stacks_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateStackConfiguration_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateStackConfiguration_Response) ProtoMessage() {}

func (x *ValidateStackConfiguration_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateStackConfiguration_Response.ProtoReflect.Descriptor instead.
func (*ValidateStackConfiguration_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{5, 1}
}

func (x *ValidateStackConfiguration_Response) GetDiagnostics() []*terraform1.Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type FindStackConfigurationComponents_Request struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	StackConfigHandle int64                  `protobuf:"varint,1,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_Request) Reset() {
	*x = FindStackConfigurationComponents_Request{}
	mi := &file_stacks_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_Request) ProtoMessage() {}

func (x *FindStackConfigurationComponents_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_Request.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 0}
}

func (x *FindStackConfigurationComponents_Request) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

type FindStackConfigurationComponents_Response struct {
	state         protoimpl.MessageState                        `protogen:"open.v1"`
	Config        *FindStackConfigurationComponents_StackConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_Response) Reset() {
	*x = FindStackConfigurationComponents_Response{}
	mi := &file_stacks_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_Response) ProtoMessage() {}

func (x *FindStackConfigurationComponents_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_Response.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 1}
}

func (x *FindStackConfigurationComponents_Response) GetConfig() *FindStackConfigurationComponents_StackConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type FindStackConfigurationComponents_StackConfig struct {
	state          protoimpl.MessageState                                     `protogen:"open.v1"`
	Components     map[string]*FindStackConfigurationComponents_Component     `protobuf:"bytes,1,rep,name=components,proto3" json:"components,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	EmbeddedStacks map[string]*FindStackConfigurationComponents_EmbeddedStack `protobuf:"bytes,2,rep,name=embedded_stacks,json=embeddedStacks,proto3" json:"embedded_stacks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	InputVariables map[string]*FindStackConfigurationComponents_InputVariable `protobuf:"bytes,3,rep,name=input_variables,json=inputVariables,proto3" json:"input_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	OutputValues   map[string]*FindStackConfigurationComponents_OutputValue   `protobuf:"bytes,4,rep,name=output_values,json=outputValues,proto3" json:"output_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Removed        map[string]*FindStackConfigurationComponents_Removed       `protobuf:"bytes,5,rep,name=removed,proto3" json:"removed,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_StackConfig) Reset() {
	*x = FindStackConfigurationComponents_StackConfig{}
	mi := &file_stacks_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_StackConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_StackConfig) ProtoMessage() {}

func (x *FindStackConfigurationComponents_StackConfig) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_StackConfig.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_StackConfig) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 2}
}

func (x *FindStackConfigurationComponents_StackConfig) GetComponents() map[string]*FindStackConfigurationComponents_Component {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *FindStackConfigurationComponents_StackConfig) GetEmbeddedStacks() map[string]*FindStackConfigurationComponents_EmbeddedStack {
	if x != nil {
		return x.EmbeddedStacks
	}
	return nil
}

func (x *FindStackConfigurationComponents_StackConfig) GetInputVariables() map[string]*FindStackConfigurationComponents_InputVariable {
	if x != nil {
		return x.InputVariables
	}
	return nil
}

func (x *FindStackConfigurationComponents_StackConfig) GetOutputValues() map[string]*FindStackConfigurationComponents_OutputValue {
	if x != nil {
		return x.OutputValues
	}
	return nil
}

func (x *FindStackConfigurationComponents_StackConfig) GetRemoved() map[string]*FindStackConfigurationComponents_Removed {
	if x != nil {
		return x.Removed
	}
	return nil
}

type FindStackConfigurationComponents_EmbeddedStack struct {
	state         protoimpl.MessageState                        `protogen:"open.v1"`
	SourceAddr    string                                        `protobuf:"bytes,1,opt,name=source_addr,json=sourceAddr,proto3" json:"source_addr,omitempty"`
	Instances     FindStackConfigurationComponents_Instances    `protobuf:"varint,2,opt,name=instances,proto3,enum=terraform1.stacks.FindStackConfigurationComponents_Instances" json:"instances,omitempty"`
	Config        *FindStackConfigurationComponents_StackConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_EmbeddedStack) Reset() {
	*x = FindStackConfigurationComponents_EmbeddedStack{}
	mi := &file_stacks_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_EmbeddedStack) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_EmbeddedStack) ProtoMessage() {}

func (x *FindStackConfigurationComponents_EmbeddedStack) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_EmbeddedStack.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_EmbeddedStack) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 3}
}

func (x *FindStackConfigurationComponents_EmbeddedStack) GetSourceAddr() string {
	if x != nil {
		return x.SourceAddr
	}
	return ""
}

func (x *FindStackConfigurationComponents_EmbeddedStack) GetInstances() FindStackConfigurationComponents_Instances {
	if x != nil {
		return x.Instances
	}
	return FindStackConfigurationComponents_SINGLE
}

func (x *FindStackConfigurationComponents_EmbeddedStack) GetConfig() *FindStackConfigurationComponents_StackConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type FindStackConfigurationComponents_Component struct {
	state         protoimpl.MessageState                     `protogen:"open.v1"`
	SourceAddr    string                                     `protobuf:"bytes,1,opt,name=source_addr,json=sourceAddr,proto3" json:"source_addr,omitempty"`
	Instances     FindStackConfigurationComponents_Instances `protobuf:"varint,2,opt,name=instances,proto3,enum=terraform1.stacks.FindStackConfigurationComponents_Instances" json:"instances,omitempty"`
	ComponentAddr string                                     `protobuf:"bytes,3,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_Component) Reset() {
	*x = FindStackConfigurationComponents_Component{}
	mi := &file_stacks_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_Component) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_Component) ProtoMessage() {}

func (x *FindStackConfigurationComponents_Component) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_Component.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_Component) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 4}
}

func (x *FindStackConfigurationComponents_Component) GetSourceAddr() string {
	if x != nil {
		return x.SourceAddr
	}
	return ""
}

func (x *FindStackConfigurationComponents_Component) GetInstances() FindStackConfigurationComponents_Instances {
	if x != nil {
		return x.Instances
	}
	return FindStackConfigurationComponents_SINGLE
}

func (x *FindStackConfigurationComponents_Component) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

type FindStackConfigurationComponents_Removed struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Deprecated: Marked as deprecated in stacks.proto.
	SourceAddr string `protobuf:"bytes,1,opt,name=source_addr,json=sourceAddr,proto3" json:"source_addr,omitempty"`
	// Deprecated: Marked as deprecated in stacks.proto.
	Instances FindStackConfigurationComponents_Instances `protobuf:"varint,2,opt,name=instances,proto3,enum=terraform1.stacks.FindStackConfigurationComponents_Instances" json:"instances,omitempty"`
	// Deprecated: Marked as deprecated in stacks.proto.
	ComponentAddr string `protobuf:"bytes,3,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	// Deprecated: Marked as deprecated in stacks.proto.
	Destroy       bool                                              `protobuf:"varint,4,opt,name=destroy,proto3" json:"destroy,omitempty"`
	Blocks        []*FindStackConfigurationComponents_Removed_Block `protobuf:"bytes,5,rep,name=blocks,proto3" json:"blocks,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_Removed) Reset() {
	*x = FindStackConfigurationComponents_Removed{}
	mi := &file_stacks_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_Removed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_Removed) ProtoMessage() {}

func (x *FindStackConfigurationComponents_Removed) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_Removed.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_Removed) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 5}
}

// Deprecated: Marked as deprecated in stacks.proto.
func (x *FindStackConfigurationComponents_Removed) GetSourceAddr() string {
	if x != nil {
		return x.SourceAddr
	}
	return ""
}

// Deprecated: Marked as deprecated in stacks.proto.
func (x *FindStackConfigurationComponents_Removed) GetInstances() FindStackConfigurationComponents_Instances {
	if x != nil {
		return x.Instances
	}
	return FindStackConfigurationComponents_SINGLE
}

// Deprecated: Marked as deprecated in stacks.proto.
func (x *FindStackConfigurationComponents_Removed) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

// Deprecated: Marked as deprecated in stacks.proto.
func (x *FindStackConfigurationComponents_Removed) GetDestroy() bool {
	if x != nil {
		return x.Destroy
	}
	return false
}

func (x *FindStackConfigurationComponents_Removed) GetBlocks() []*FindStackConfigurationComponents_Removed_Block {
	if x != nil {
		return x.Blocks
	}
	return nil
}

type FindStackConfigurationComponents_InputVariable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Optional      bool                   `protobuf:"varint,1,opt,name=optional,proto3" json:"optional,omitempty"`
	Sensitive     bool                   `protobuf:"varint,2,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	Ephemeral     bool                   `protobuf:"varint,3,opt,name=ephemeral,proto3" json:"ephemeral,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_InputVariable) Reset() {
	*x = FindStackConfigurationComponents_InputVariable{}
	mi := &file_stacks_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_InputVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_InputVariable) ProtoMessage() {}

func (x *FindStackConfigurationComponents_InputVariable) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_InputVariable.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_InputVariable) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 6}
}

func (x *FindStackConfigurationComponents_InputVariable) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

func (x *FindStackConfigurationComponents_InputVariable) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *FindStackConfigurationComponents_InputVariable) GetEphemeral() bool {
	if x != nil {
		return x.Ephemeral
	}
	return false
}

type FindStackConfigurationComponents_OutputValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Sensitive     bool                   `protobuf:"varint,1,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	Ephemeral     bool                   `protobuf:"varint,2,opt,name=ephemeral,proto3" json:"ephemeral,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_OutputValue) Reset() {
	*x = FindStackConfigurationComponents_OutputValue{}
	mi := &file_stacks_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_OutputValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_OutputValue) ProtoMessage() {}

func (x *FindStackConfigurationComponents_OutputValue) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_OutputValue.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_OutputValue) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 7}
}

func (x *FindStackConfigurationComponents_OutputValue) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *FindStackConfigurationComponents_OutputValue) GetEphemeral() bool {
	if x != nil {
		return x.Ephemeral
	}
	return false
}

type FindStackConfigurationComponents_Removed_Block struct {
	state         protoimpl.MessageState                     `protogen:"open.v1"`
	SourceAddr    string                                     `protobuf:"bytes,1,opt,name=source_addr,json=sourceAddr,proto3" json:"source_addr,omitempty"`
	Instances     FindStackConfigurationComponents_Instances `protobuf:"varint,2,opt,name=instances,proto3,enum=terraform1.stacks.FindStackConfigurationComponents_Instances" json:"instances,omitempty"`
	ComponentAddr string                                     `protobuf:"bytes,3,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	Destroy       bool                                       `protobuf:"varint,4,opt,name=destroy,proto3" json:"destroy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FindStackConfigurationComponents_Removed_Block) Reset() {
	*x = FindStackConfigurationComponents_Removed_Block{}
	mi := &file_stacks_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindStackConfigurationComponents_Removed_Block) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindStackConfigurationComponents_Removed_Block) ProtoMessage() {}

func (x *FindStackConfigurationComponents_Removed_Block) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindStackConfigurationComponents_Removed_Block.ProtoReflect.Descriptor instead.
func (*FindStackConfigurationComponents_Removed_Block) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{6, 5, 0}
}

func (x *FindStackConfigurationComponents_Removed_Block) GetSourceAddr() string {
	if x != nil {
		return x.SourceAddr
	}
	return ""
}

func (x *FindStackConfigurationComponents_Removed_Block) GetInstances() FindStackConfigurationComponents_Instances {
	if x != nil {
		return x.Instances
	}
	return FindStackConfigurationComponents_SINGLE
}

func (x *FindStackConfigurationComponents_Removed_Block) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

func (x *FindStackConfigurationComponents_Removed_Block) GetDestroy() bool {
	if x != nil {
		return x.Destroy
	}
	return false
}

type OpenStackState_RequestItem struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Raw           *AppliedChange_RawChange `protobuf:"bytes,1,opt,name=raw,proto3" json:"raw,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackState_RequestItem) Reset() {
	*x = OpenStackState_RequestItem{}
	mi := &file_stacks_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackState_RequestItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackState_RequestItem) ProtoMessage() {}

func (x *OpenStackState_RequestItem) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackState_RequestItem.ProtoReflect.Descriptor instead.
func (*OpenStackState_RequestItem) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{7, 0}
}

func (x *OpenStackState_RequestItem) GetRaw() *AppliedChange_RawChange {
	if x != nil {
		return x.Raw
	}
	return nil
}

type OpenStackState_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StateHandle   int64                  `protobuf:"varint,1,opt,name=state_handle,json=stateHandle,proto3" json:"state_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackState_Response) Reset() {
	*x = OpenStackState_Response{}
	mi := &file_stacks_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackState_Response) ProtoMessage() {}

func (x *OpenStackState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackState_Response.ProtoReflect.Descriptor instead.
func (*OpenStackState_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{7, 1}
}

func (x *OpenStackState_Response) GetStateHandle() int64 {
	if x != nil {
		return x.StateHandle
	}
	return 0
}

type CloseStackState_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StateHandle   int64                  `protobuf:"varint,1,opt,name=state_handle,json=stateHandle,proto3" json:"state_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackState_Request) Reset() {
	*x = CloseStackState_Request{}
	mi := &file_stacks_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackState_Request) ProtoMessage() {}

func (x *CloseStackState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackState_Request.ProtoReflect.Descriptor instead.
func (*CloseStackState_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{8, 0}
}

func (x *CloseStackState_Request) GetStateHandle() int64 {
	if x != nil {
		return x.StateHandle
	}
	return 0
}

type CloseStackState_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackState_Response) Reset() {
	*x = CloseStackState_Response{}
	mi := &file_stacks_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackState_Response) ProtoMessage() {}

func (x *CloseStackState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackState_Response.ProtoReflect.Descriptor instead.
func (*CloseStackState_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{8, 1}
}

type PlanStackChanges_Request struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	PlanMode            PlanMode               `protobuf:"varint,1,opt,name=plan_mode,json=planMode,proto3,enum=terraform1.stacks.PlanMode" json:"plan_mode,omitempty"`
	StackConfigHandle   int64                  `protobuf:"varint,2,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	PreviousStateHandle int64                  `protobuf:"varint,7,opt,name=previous_state_handle,json=previousStateHandle,proto3" json:"previous_state_handle,omitempty"`
	// Deprecated: Marked as deprecated in stacks.proto.
	PreviousState         map[string]*anypb.Any              `protobuf:"bytes,3,rep,name=previous_state,json=previousState,proto3" json:"previous_state,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	DependencyLocksHandle int64                              `protobuf:"varint,4,opt,name=dependency_locks_handle,json=dependencyLocksHandle,proto3" json:"dependency_locks_handle,omitempty"`
	ProviderCacheHandle   int64                              `protobuf:"varint,5,opt,name=provider_cache_handle,json=providerCacheHandle,proto3" json:"provider_cache_handle,omitempty"`
	InputValues           map[string]*DynamicValueWithSource `protobuf:"bytes,6,rep,name=input_values,json=inputValues,proto3" json:"input_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"` // TODO: Various other planning options
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *PlanStackChanges_Request) Reset() {
	*x = PlanStackChanges_Request{}
	mi := &file_stacks_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanStackChanges_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanStackChanges_Request) ProtoMessage() {}

func (x *PlanStackChanges_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanStackChanges_Request.ProtoReflect.Descriptor instead.
func (*PlanStackChanges_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{9, 0}
}

func (x *PlanStackChanges_Request) GetPlanMode() PlanMode {
	if x != nil {
		return x.PlanMode
	}
	return PlanMode_NORMAL
}

func (x *PlanStackChanges_Request) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

func (x *PlanStackChanges_Request) GetPreviousStateHandle() int64 {
	if x != nil {
		return x.PreviousStateHandle
	}
	return 0
}

// Deprecated: Marked as deprecated in stacks.proto.
func (x *PlanStackChanges_Request) GetPreviousState() map[string]*anypb.Any {
	if x != nil {
		return x.PreviousState
	}
	return nil
}

func (x *PlanStackChanges_Request) GetDependencyLocksHandle() int64 {
	if x != nil {
		return x.DependencyLocksHandle
	}
	return 0
}

func (x *PlanStackChanges_Request) GetProviderCacheHandle() int64 {
	if x != nil {
		return x.ProviderCacheHandle
	}
	return 0
}

func (x *PlanStackChanges_Request) GetInputValues() map[string]*DynamicValueWithSource {
	if x != nil {
		return x.InputValues
	}
	return nil
}

type PlanStackChanges_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*PlanStackChanges_Event_PlannedChange
	//	*PlanStackChanges_Event_Diagnostic
	//	*PlanStackChanges_Event_Progress
	Event         isPlanStackChanges_Event_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanStackChanges_Event) Reset() {
	*x = PlanStackChanges_Event{}
	mi := &file_stacks_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanStackChanges_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanStackChanges_Event) ProtoMessage() {}

func (x *PlanStackChanges_Event) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanStackChanges_Event.ProtoReflect.Descriptor instead.
func (*PlanStackChanges_Event) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{9, 1}
}

func (x *PlanStackChanges_Event) GetEvent() isPlanStackChanges_Event_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *PlanStackChanges_Event) GetPlannedChange() *PlannedChange {
	if x != nil {
		if x, ok := x.Event.(*PlanStackChanges_Event_PlannedChange); ok {
			return x.PlannedChange
		}
	}
	return nil
}

func (x *PlanStackChanges_Event) GetDiagnostic() *terraform1.Diagnostic {
	if x != nil {
		if x, ok := x.Event.(*PlanStackChanges_Event_Diagnostic); ok {
			return x.Diagnostic
		}
	}
	return nil
}

func (x *PlanStackChanges_Event) GetProgress() *StackChangeProgress {
	if x != nil {
		if x, ok := x.Event.(*PlanStackChanges_Event_Progress); ok {
			return x.Progress
		}
	}
	return nil
}

type isPlanStackChanges_Event_Event interface {
	isPlanStackChanges_Event_Event()
}

type PlanStackChanges_Event_PlannedChange struct {
	PlannedChange *PlannedChange `protobuf:"bytes,1,opt,name=planned_change,json=plannedChange,proto3,oneof"`
}

type PlanStackChanges_Event_Diagnostic struct {
	Diagnostic *terraform1.Diagnostic `protobuf:"bytes,2,opt,name=diagnostic,proto3,oneof"`
}

type PlanStackChanges_Event_Progress struct {
	Progress *StackChangeProgress `protobuf:"bytes,10,opt,name=progress,proto3,oneof"`
}

func (*PlanStackChanges_Event_PlannedChange) isPlanStackChanges_Event_Event() {}

func (*PlanStackChanges_Event_Diagnostic) isPlanStackChanges_Event_Event() {}

func (*PlanStackChanges_Event_Progress) isPlanStackChanges_Event_Event() {}

type OpenStackPlan_RequestItem struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Raw           *anypb.Any             `protobuf:"bytes,1,opt,name=raw,proto3" json:"raw,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackPlan_RequestItem) Reset() {
	*x = OpenStackPlan_RequestItem{}
	mi := &file_stacks_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackPlan_RequestItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackPlan_RequestItem) ProtoMessage() {}

func (x *OpenStackPlan_RequestItem) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackPlan_RequestItem.ProtoReflect.Descriptor instead.
func (*OpenStackPlan_RequestItem) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{10, 0}
}

func (x *OpenStackPlan_RequestItem) GetRaw() *anypb.Any {
	if x != nil {
		return x.Raw
	}
	return nil
}

type OpenStackPlan_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PlanHandle    int64                  `protobuf:"varint,1,opt,name=plan_handle,json=planHandle,proto3" json:"plan_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenStackPlan_Response) Reset() {
	*x = OpenStackPlan_Response{}
	mi := &file_stacks_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackPlan_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackPlan_Response) ProtoMessage() {}

func (x *OpenStackPlan_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackPlan_Response.ProtoReflect.Descriptor instead.
func (*OpenStackPlan_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{10, 1}
}

func (x *OpenStackPlan_Response) GetPlanHandle() int64 {
	if x != nil {
		return x.PlanHandle
	}
	return 0
}

type CloseStackPlan_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PlanHandle    int64                  `protobuf:"varint,1,opt,name=plan_handle,json=planHandle,proto3" json:"plan_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackPlan_Request) Reset() {
	*x = CloseStackPlan_Request{}
	mi := &file_stacks_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackPlan_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackPlan_Request) ProtoMessage() {}

func (x *CloseStackPlan_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackPlan_Request.ProtoReflect.Descriptor instead.
func (*CloseStackPlan_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{11, 0}
}

func (x *CloseStackPlan_Request) GetPlanHandle() int64 {
	if x != nil {
		return x.PlanHandle
	}
	return 0
}

type CloseStackPlan_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseStackPlan_Response) Reset() {
	*x = CloseStackPlan_Response{}
	mi := &file_stacks_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseStackPlan_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStackPlan_Response) ProtoMessage() {}

func (x *CloseStackPlan_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStackPlan_Response.ProtoReflect.Descriptor instead.
func (*CloseStackPlan_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{11, 1}
}

type ApplyStackChanges_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This must refer to exactly the same configuration that was
	// passed to PlanStackChanges when creating this plan, or the
	// results will be unpredictable.
	StackConfigHandle int64 `protobuf:"varint,1,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	// The caller should send all of the keys present in the previous
	// apply's description map. Terraform Core will use this for
	// situations such as updating existing descriptions to newer
	// formats even if no change is being made to the corresponding
	// real objects.
	KnownDescriptionKeys []string `protobuf:"bytes,3,rep,name=known_description_keys,json=knownDescriptionKeys,proto3" json:"known_description_keys,omitempty"`
	// The handle for a saved plan previously loaded using the
	// Stacks.OpenPlan function.
	// Applying a plan immediately invalidates it, so the handle will
	// be automatically closed.
	PlanHandle int64 `protobuf:"varint,8,opt,name=plan_handle,json=planHandle,proto3" json:"plan_handle,omitempty"`
	// This must include all of the "raw" values emitted through
	// PlannedChange events during the PlanStackChanges operation
	// that created this plan, concatenated together in the same
	// order they were written to the PlanStackChanges event stream.
	//
	// Use plan_handle instead. This will be removed in future.
	//
	// Deprecated: Marked as deprecated in stacks.proto.
	PlannedChanges []*anypb.Any `protobuf:"bytes,4,rep,name=planned_changes,json=plannedChanges,proto3" json:"planned_changes,omitempty"`
	// This must be equivalent to the argument of the same name
	// passed to PlanStackChanges when creating this plan.
	DependencyLocksHandle int64 `protobuf:"varint,5,opt,name=dependency_locks_handle,json=dependencyLocksHandle,proto3" json:"dependency_locks_handle,omitempty"`
	// This must be equivalent to the argument of the same name
	// passed to PlanStackChanges when creating this plan.
	ProviderCacheHandle int64 `protobuf:"varint,6,opt,name=provider_cache_handle,json=providerCacheHandle,proto3" json:"provider_cache_handle,omitempty"`
	// Any input variables identified as an "apply-time input variable"
	// in the plan must have values provided here.
	//
	// Callers may also optionally include values for other declared input
	// variables, but if so their values must exactly match those used when
	// creating the plan.
	InputValues   map[string]*DynamicValueWithSource `protobuf:"bytes,7,rep,name=input_values,json=inputValues,proto3" json:"input_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyStackChanges_Request) Reset() {
	*x = ApplyStackChanges_Request{}
	mi := &file_stacks_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyStackChanges_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyStackChanges_Request) ProtoMessage() {}

func (x *ApplyStackChanges_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyStackChanges_Request.ProtoReflect.Descriptor instead.
func (*ApplyStackChanges_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{12, 0}
}

func (x *ApplyStackChanges_Request) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

func (x *ApplyStackChanges_Request) GetKnownDescriptionKeys() []string {
	if x != nil {
		return x.KnownDescriptionKeys
	}
	return nil
}

func (x *ApplyStackChanges_Request) GetPlanHandle() int64 {
	if x != nil {
		return x.PlanHandle
	}
	return 0
}

// Deprecated: Marked as deprecated in stacks.proto.
func (x *ApplyStackChanges_Request) GetPlannedChanges() []*anypb.Any {
	if x != nil {
		return x.PlannedChanges
	}
	return nil
}

func (x *ApplyStackChanges_Request) GetDependencyLocksHandle() int64 {
	if x != nil {
		return x.DependencyLocksHandle
	}
	return 0
}

func (x *ApplyStackChanges_Request) GetProviderCacheHandle() int64 {
	if x != nil {
		return x.ProviderCacheHandle
	}
	return 0
}

func (x *ApplyStackChanges_Request) GetInputValues() map[string]*DynamicValueWithSource {
	if x != nil {
		return x.InputValues
	}
	return nil
}

type ApplyStackChanges_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*ApplyStackChanges_Event_AppliedChange
	//	*ApplyStackChanges_Event_Diagnostic
	//	*ApplyStackChanges_Event_Progress
	Event         isApplyStackChanges_Event_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyStackChanges_Event) Reset() {
	*x = ApplyStackChanges_Event{}
	mi := &file_stacks_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyStackChanges_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyStackChanges_Event) ProtoMessage() {}

func (x *ApplyStackChanges_Event) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyStackChanges_Event.ProtoReflect.Descriptor instead.
func (*ApplyStackChanges_Event) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{12, 1}
}

func (x *ApplyStackChanges_Event) GetEvent() isApplyStackChanges_Event_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *ApplyStackChanges_Event) GetAppliedChange() *AppliedChange {
	if x != nil {
		if x, ok := x.Event.(*ApplyStackChanges_Event_AppliedChange); ok {
			return x.AppliedChange
		}
	}
	return nil
}

func (x *ApplyStackChanges_Event) GetDiagnostic() *terraform1.Diagnostic {
	if x != nil {
		if x, ok := x.Event.(*ApplyStackChanges_Event_Diagnostic); ok {
			return x.Diagnostic
		}
	}
	return nil
}

func (x *ApplyStackChanges_Event) GetProgress() *StackChangeProgress {
	if x != nil {
		if x, ok := x.Event.(*ApplyStackChanges_Event_Progress); ok {
			return x.Progress
		}
	}
	return nil
}

type isApplyStackChanges_Event_Event interface {
	isApplyStackChanges_Event_Event()
}

type ApplyStackChanges_Event_AppliedChange struct {
	AppliedChange *AppliedChange `protobuf:"bytes,1,opt,name=applied_change,json=appliedChange,proto3,oneof"`
}

type ApplyStackChanges_Event_Diagnostic struct {
	Diagnostic *terraform1.Diagnostic `protobuf:"bytes,2,opt,name=diagnostic,proto3,oneof"`
}

type ApplyStackChanges_Event_Progress struct {
	Progress *StackChangeProgress `protobuf:"bytes,3,opt,name=progress,proto3,oneof"`
}

func (*ApplyStackChanges_Event_AppliedChange) isApplyStackChanges_Event_Event() {}

func (*ApplyStackChanges_Event_Diagnostic) isApplyStackChanges_Event_Event() {}

func (*ApplyStackChanges_Event_Progress) isApplyStackChanges_Event_Event() {}

type OpenStackInspector_Request struct {
	state                 protoimpl.MessageState             `protogen:"open.v1"`
	StackConfigHandle     int64                              `protobuf:"varint,1,opt,name=stack_config_handle,json=stackConfigHandle,proto3" json:"stack_config_handle,omitempty"`
	State                 map[string]*anypb.Any              `protobuf:"bytes,2,rep,name=state,proto3" json:"state,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	DependencyLocksHandle int64                              `protobuf:"varint,3,opt,name=dependency_locks_handle,json=dependencyLocksHandle,proto3" json:"dependency_locks_handle,omitempty"`
	ProviderCacheHandle   int64                              `protobuf:"varint,4,opt,name=provider_cache_handle,json=providerCacheHandle,proto3" json:"provider_cache_handle,omitempty"`
	InputValues           map[string]*DynamicValueWithSource `protobuf:"bytes,5,rep,name=input_values,json=inputValues,proto3" json:"input_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *OpenStackInspector_Request) Reset() {
	*x = OpenStackInspector_Request{}
	mi := &file_stacks_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackInspector_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackInspector_Request) ProtoMessage() {}

func (x *OpenStackInspector_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackInspector_Request.ProtoReflect.Descriptor instead.
func (*OpenStackInspector_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{13, 0}
}

func (x *OpenStackInspector_Request) GetStackConfigHandle() int64 {
	if x != nil {
		return x.StackConfigHandle
	}
	return 0
}

func (x *OpenStackInspector_Request) GetState() map[string]*anypb.Any {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *OpenStackInspector_Request) GetDependencyLocksHandle() int64 {
	if x != nil {
		return x.DependencyLocksHandle
	}
	return 0
}

func (x *OpenStackInspector_Request) GetProviderCacheHandle() int64 {
	if x != nil {
		return x.ProviderCacheHandle
	}
	return 0
}

func (x *OpenStackInspector_Request) GetInputValues() map[string]*DynamicValueWithSource {
	if x != nil {
		return x.InputValues
	}
	return nil
}

type OpenStackInspector_Response struct {
	state                protoimpl.MessageState   `protogen:"open.v1"`
	StackInspectorHandle int64                    `protobuf:"varint,1,opt,name=stack_inspector_handle,json=stackInspectorHandle,proto3" json:"stack_inspector_handle,omitempty"`
	Diagnostics          []*terraform1.Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *OpenStackInspector_Response) Reset() {
	*x = OpenStackInspector_Response{}
	mi := &file_stacks_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenStackInspector_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenStackInspector_Response) ProtoMessage() {}

func (x *OpenStackInspector_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenStackInspector_Response.ProtoReflect.Descriptor instead.
func (*OpenStackInspector_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{13, 1}
}

func (x *OpenStackInspector_Response) GetStackInspectorHandle() int64 {
	if x != nil {
		return x.StackInspectorHandle
	}
	return 0
}

func (x *OpenStackInspector_Response) GetDiagnostics() []*terraform1.Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type InspectExpressionResult_Request struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	StackInspectorHandle int64                  `protobuf:"varint,1,opt,name=stack_inspector_handle,json=stackInspectorHandle,proto3" json:"stack_inspector_handle,omitempty"`
	ExpressionSrc        []byte                 `protobuf:"bytes,2,opt,name=expression_src,json=expressionSrc,proto3" json:"expression_src,omitempty"`
	StackAddr            string                 `protobuf:"bytes,3,opt,name=stack_addr,json=stackAddr,proto3" json:"stack_addr,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *InspectExpressionResult_Request) Reset() {
	*x = InspectExpressionResult_Request{}
	mi := &file_stacks_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InspectExpressionResult_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectExpressionResult_Request) ProtoMessage() {}

func (x *InspectExpressionResult_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectExpressionResult_Request.ProtoReflect.Descriptor instead.
func (*InspectExpressionResult_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{14, 0}
}

func (x *InspectExpressionResult_Request) GetStackInspectorHandle() int64 {
	if x != nil {
		return x.StackInspectorHandle
	}
	return 0
}

func (x *InspectExpressionResult_Request) GetExpressionSrc() []byte {
	if x != nil {
		return x.ExpressionSrc
	}
	return nil
}

func (x *InspectExpressionResult_Request) GetStackAddr() string {
	if x != nil {
		return x.StackAddr
	}
	return ""
}

type InspectExpressionResult_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The result of evaluating the expression, if successful enough to
	// produce a result. Unpopulated if the expression was too invalid
	// to produce a result, with the problem then described in the
	// associated diagnostics.
	//
	// Uses a MessagePack encoding with in-band type information.
	Result        *DynamicValue            `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	Diagnostics   []*terraform1.Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InspectExpressionResult_Response) Reset() {
	*x = InspectExpressionResult_Response{}
	mi := &file_stacks_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InspectExpressionResult_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectExpressionResult_Response) ProtoMessage() {}

func (x *InspectExpressionResult_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectExpressionResult_Response.ProtoReflect.Descriptor instead.
func (*InspectExpressionResult_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{14, 1}
}

func (x *InspectExpressionResult_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *InspectExpressionResult_Response) GetDiagnostics() []*terraform1.Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type AttributePath_Step struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Selector:
	//
	//	*AttributePath_Step_AttributeName
	//	*AttributePath_Step_ElementKeyString
	//	*AttributePath_Step_ElementKeyInt
	Selector      isAttributePath_Step_Selector `protobuf_oneof:"selector"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath_Step) Reset() {
	*x = AttributePath_Step{}
	mi := &file_stacks_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath_Step) ProtoMessage() {}

func (x *AttributePath_Step) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath_Step.ProtoReflect.Descriptor instead.
func (*AttributePath_Step) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{18, 0}
}

func (x *AttributePath_Step) GetSelector() isAttributePath_Step_Selector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *AttributePath_Step) GetAttributeName() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_AttributeName); ok {
			return x.AttributeName
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyString() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyString); ok {
			return x.ElementKeyString
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyInt() int64 {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyInt); ok {
			return x.ElementKeyInt
		}
	}
	return 0
}

type isAttributePath_Step_Selector interface {
	isAttributePath_Step_Selector()
}

type AttributePath_Step_AttributeName struct {
	// Set "attribute_name" to represent looking up an attribute
	// in the current object value.
	AttributeName string `protobuf:"bytes,1,opt,name=attribute_name,json=attributeName,proto3,oneof"`
}

type AttributePath_Step_ElementKeyString struct {
	// Set "element_key_*" to represent looking up an element in
	// an indexable collection type.
	ElementKeyString string `protobuf:"bytes,2,opt,name=element_key_string,json=elementKeyString,proto3,oneof"`
}

type AttributePath_Step_ElementKeyInt struct {
	ElementKeyInt int64 `protobuf:"varint,3,opt,name=element_key_int,json=elementKeyInt,proto3,oneof"`
}

func (*AttributePath_Step_AttributeName) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyString) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyInt) isAttributePath_Step_Selector() {}

// Represents a single caller-facing description of a change, to use for
// presenting information to end users in the UI and for other subsystems
// such as imposing policy rules on the resulting plan.
//
// New description types might be added in future versions of Terraform
// Core, and so clients should tolerate description messages that appear
// to have none of the oneof fields set, and should just ignore those
// messages entirely.
type PlannedChange_ChangeDescription struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Description:
	//
	//	*PlannedChange_ChangeDescription_ComponentInstancePlanned
	//	*PlannedChange_ChangeDescription_ResourceInstancePlanned
	//	*PlannedChange_ChangeDescription_OutputValuePlanned
	//	*PlannedChange_ChangeDescription_PlanApplyable
	//	*PlannedChange_ChangeDescription_ResourceInstanceDeferred
	//	*PlannedChange_ChangeDescription_InputVariablePlanned
	Description   isPlannedChange_ChangeDescription_Description `protobuf_oneof:"description"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlannedChange_ChangeDescription) Reset() {
	*x = PlannedChange_ChangeDescription{}
	mi := &file_stacks_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ChangeDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ChangeDescription) ProtoMessage() {}

func (x *PlannedChange_ChangeDescription) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ChangeDescription.ProtoReflect.Descriptor instead.
func (*PlannedChange_ChangeDescription) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 0}
}

func (x *PlannedChange_ChangeDescription) GetDescription() isPlannedChange_ChangeDescription_Description {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *PlannedChange_ChangeDescription) GetComponentInstancePlanned() *PlannedChange_ComponentInstance {
	if x != nil {
		if x, ok := x.Description.(*PlannedChange_ChangeDescription_ComponentInstancePlanned); ok {
			return x.ComponentInstancePlanned
		}
	}
	return nil
}

func (x *PlannedChange_ChangeDescription) GetResourceInstancePlanned() *PlannedChange_ResourceInstance {
	if x != nil {
		if x, ok := x.Description.(*PlannedChange_ChangeDescription_ResourceInstancePlanned); ok {
			return x.ResourceInstancePlanned
		}
	}
	return nil
}

func (x *PlannedChange_ChangeDescription) GetOutputValuePlanned() *PlannedChange_OutputValue {
	if x != nil {
		if x, ok := x.Description.(*PlannedChange_ChangeDescription_OutputValuePlanned); ok {
			return x.OutputValuePlanned
		}
	}
	return nil
}

func (x *PlannedChange_ChangeDescription) GetPlanApplyable() bool {
	if x != nil {
		if x, ok := x.Description.(*PlannedChange_ChangeDescription_PlanApplyable); ok {
			return x.PlanApplyable
		}
	}
	return false
}

func (x *PlannedChange_ChangeDescription) GetResourceInstanceDeferred() *PlannedChange_ResourceInstanceDeferred {
	if x != nil {
		if x, ok := x.Description.(*PlannedChange_ChangeDescription_ResourceInstanceDeferred); ok {
			return x.ResourceInstanceDeferred
		}
	}
	return nil
}

func (x *PlannedChange_ChangeDescription) GetInputVariablePlanned() *PlannedChange_InputVariable {
	if x != nil {
		if x, ok := x.Description.(*PlannedChange_ChangeDescription_InputVariablePlanned); ok {
			return x.InputVariablePlanned
		}
	}
	return nil
}

type isPlannedChange_ChangeDescription_Description interface {
	isPlannedChange_ChangeDescription_Description()
}

type PlannedChange_ChangeDescription_ComponentInstancePlanned struct {
	ComponentInstancePlanned *PlannedChange_ComponentInstance `protobuf:"bytes,1,opt,name=component_instance_planned,json=componentInstancePlanned,proto3,oneof"`
}

type PlannedChange_ChangeDescription_ResourceInstancePlanned struct {
	ResourceInstancePlanned *PlannedChange_ResourceInstance `protobuf:"bytes,2,opt,name=resource_instance_planned,json=resourceInstancePlanned,proto3,oneof"`
}

type PlannedChange_ChangeDescription_OutputValuePlanned struct {
	OutputValuePlanned *PlannedChange_OutputValue `protobuf:"bytes,3,opt,name=output_value_planned,json=outputValuePlanned,proto3,oneof"`
}

type PlannedChange_ChangeDescription_PlanApplyable struct {
	PlanApplyable bool `protobuf:"varint,4,opt,name=plan_applyable,json=planApplyable,proto3,oneof"`
}

type PlannedChange_ChangeDescription_ResourceInstanceDeferred struct {
	ResourceInstanceDeferred *PlannedChange_ResourceInstanceDeferred `protobuf:"bytes,5,opt,name=resource_instance_deferred,json=resourceInstanceDeferred,proto3,oneof"`
}

type PlannedChange_ChangeDescription_InputVariablePlanned struct {
	InputVariablePlanned *PlannedChange_InputVariable `protobuf:"bytes,6,opt,name=input_variable_planned,json=inputVariablePlanned,proto3,oneof"`
}

func (*PlannedChange_ChangeDescription_ComponentInstancePlanned) isPlannedChange_ChangeDescription_Description() {
}

func (*PlannedChange_ChangeDescription_ResourceInstancePlanned) isPlannedChange_ChangeDescription_Description() {
}

func (*PlannedChange_ChangeDescription_OutputValuePlanned) isPlannedChange_ChangeDescription_Description() {
}

func (*PlannedChange_ChangeDescription_PlanApplyable) isPlannedChange_ChangeDescription_Description() {
}

func (*PlannedChange_ChangeDescription_ResourceInstanceDeferred) isPlannedChange_ChangeDescription_Description() {
}

func (*PlannedChange_ChangeDescription_InputVariablePlanned) isPlannedChange_ChangeDescription_Description() {
}

// Reports the existence of a particular instance of a component,
// once Terraform has resolved arguments such as "for_each" that
// might make the set of instances dynamic.
type PlannedChange_ComponentInstance struct {
	state protoimpl.MessageState        `protogen:"open.v1"`
	Addr  *ComponentInstanceInStackAddr `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	// The changes to the existence of this instance relative to the
	// prior state. This only considers the component instance directly,
	// and doesn't take into account what actions are planned for any
	// resource instances inside.
	Actions []ChangeType `protobuf:"varint,2,rep,packed,name=actions,proto3,enum=terraform1.stacks.ChangeType" json:"actions,omitempty"`
	// A flag for whether applying this plan is expected to cause the
	// desired state and actual state to become converged.
	//
	// If this field is false, that means Terraform expects that at least
	// one more plan/apply round will be needed to reach convergence.
	//
	// If this field is true then Terraform hopes to be able to converge
	// after this plan is applied, but callers should ideally still check
	// anyway by running one more plan to confirm that there aren't any
	// unexpected differences caused by such situations as contradictory
	// configuration or provider bugs.
	PlanComplete  bool `protobuf:"varint,3,opt,name=plan_complete,json=planComplete,proto3" json:"plan_complete,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlannedChange_ComponentInstance) Reset() {
	*x = PlannedChange_ComponentInstance{}
	mi := &file_stacks_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ComponentInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ComponentInstance) ProtoMessage() {}

func (x *PlannedChange_ComponentInstance) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ComponentInstance.ProtoReflect.Descriptor instead.
func (*PlannedChange_ComponentInstance) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 1}
}

func (x *PlannedChange_ComponentInstance) GetAddr() *ComponentInstanceInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *PlannedChange_ComponentInstance) GetActions() []ChangeType {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *PlannedChange_ComponentInstance) GetPlanComplete() bool {
	if x != nil {
		return x.PlanComplete
	}
	return false
}

type PlannedChange_ResourceInstance struct {
	state        protoimpl.MessageState                   `protogen:"open.v1"`
	Addr         *ResourceInstanceObjectInStackAddr       `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Actions      []ChangeType                             `protobuf:"varint,2,rep,packed,name=actions,proto3,enum=terraform1.stacks.ChangeType" json:"actions,omitempty"`
	Values       *DynamicValueChange                      `protobuf:"bytes,3,opt,name=values,proto3" json:"values,omitempty"`
	Moved        *PlannedChange_ResourceInstance_Moved    `protobuf:"bytes,4,opt,name=moved,proto3" json:"moved,omitempty"`
	Imported     *PlannedChange_ResourceInstance_Imported `protobuf:"bytes,5,opt,name=imported,proto3" json:"imported,omitempty"`
	ResourceMode ResourceMode                             `protobuf:"varint,6,opt,name=resource_mode,json=resourceMode,proto3,enum=terraform1.stacks.ResourceMode" json:"resource_mode,omitempty"`
	ResourceType string                                   `protobuf:"bytes,7,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	ProviderAddr string                                   `protobuf:"bytes,8,opt,name=provider_addr,json=providerAddr,proto3" json:"provider_addr,omitempty"`
	// previous_run_value is included only if it would be
	// different from values.old, which typically means that
	// Terraform detected some changes made outside of Terraform
	// since the previous run. In that case, this field is
	// the un-refreshed (but still upgraded) value from
	// the previous run and values.old is the refreshed version.
	//
	// If this isn't set then values.old should be used as the
	// previous run value, if needed.
	PreviousRunValue *DynamicValue `protobuf:"bytes,9,opt,name=previous_run_value,json=previousRunValue,proto3" json:"previous_run_value,omitempty"`
	// This flag is set if Terraform Core considers the difference
	// between previous_run_value and values.old to be "notable",
	// which is a heuristic subject to change over time but is
	// broadly intended to mean that it would be worth mentioning
	// the difference between the two in the UI as a
	// "change outside of Terraform". If this isn't set then the
	// difference is probably not worth mentioning to the user
	// by default, although it could still be shown behind an
	// optional disclosure in UI contexts where such things are possible.
	NotableChangeOutside bool                                  `protobuf:"varint,10,opt,name=notable_change_outside,json=notableChangeOutside,proto3" json:"notable_change_outside,omitempty"`
	ReplacePaths         []*AttributePath                      `protobuf:"bytes,11,rep,name=replace_paths,json=replacePaths,proto3" json:"replace_paths,omitempty"`
	ResourceName         string                                `protobuf:"bytes,12,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	Index                *PlannedChange_ResourceInstance_Index `protobuf:"bytes,13,opt,name=index,proto3" json:"index,omitempty"`
	ModuleAddr           string                                `protobuf:"bytes,14,opt,name=module_addr,json=moduleAddr,proto3" json:"module_addr,omitempty"`
	ActionReason         string                                `protobuf:"bytes,15,opt,name=action_reason,json=actionReason,proto3" json:"action_reason,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *PlannedChange_ResourceInstance) Reset() {
	*x = PlannedChange_ResourceInstance{}
	mi := &file_stacks_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ResourceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ResourceInstance) ProtoMessage() {}

func (x *PlannedChange_ResourceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ResourceInstance.ProtoReflect.Descriptor instead.
func (*PlannedChange_ResourceInstance) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 2}
}

func (x *PlannedChange_ResourceInstance) GetAddr() *ResourceInstanceObjectInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetActions() []ChangeType {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetValues() *DynamicValueChange {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetMoved() *PlannedChange_ResourceInstance_Moved {
	if x != nil {
		return x.Moved
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetImported() *PlannedChange_ResourceInstance_Imported {
	if x != nil {
		return x.Imported
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetResourceMode() ResourceMode {
	if x != nil {
		return x.ResourceMode
	}
	return ResourceMode_UNKNOWN
}

func (x *PlannedChange_ResourceInstance) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *PlannedChange_ResourceInstance) GetProviderAddr() string {
	if x != nil {
		return x.ProviderAddr
	}
	return ""
}

func (x *PlannedChange_ResourceInstance) GetPreviousRunValue() *DynamicValue {
	if x != nil {
		return x.PreviousRunValue
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetNotableChangeOutside() bool {
	if x != nil {
		return x.NotableChangeOutside
	}
	return false
}

func (x *PlannedChange_ResourceInstance) GetReplacePaths() []*AttributePath {
	if x != nil {
		return x.ReplacePaths
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *PlannedChange_ResourceInstance) GetIndex() *PlannedChange_ResourceInstance_Index {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *PlannedChange_ResourceInstance) GetModuleAddr() string {
	if x != nil {
		return x.ModuleAddr
	}
	return ""
}

func (x *PlannedChange_ResourceInstance) GetActionReason() string {
	if x != nil {
		return x.ActionReason
	}
	return ""
}

// Note: this is only for output values from the topmost
// stack configuration, because all other output values are
// internal to the configuration and not part of its public API.
type PlannedChange_OutputValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Actions       []ChangeType           `protobuf:"varint,2,rep,packed,name=actions,proto3,enum=terraform1.stacks.ChangeType" json:"actions,omitempty"`
	Values        *DynamicValueChange    `protobuf:"bytes,3,opt,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlannedChange_OutputValue) Reset() {
	*x = PlannedChange_OutputValue{}
	mi := &file_stacks_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_OutputValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_OutputValue) ProtoMessage() {}

func (x *PlannedChange_OutputValue) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_OutputValue.ProtoReflect.Descriptor instead.
func (*PlannedChange_OutputValue) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 3}
}

func (x *PlannedChange_OutputValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlannedChange_OutputValue) GetActions() []ChangeType {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *PlannedChange_OutputValue) GetValues() *DynamicValueChange {
	if x != nil {
		return x.Values
	}
	return nil
}

type PlannedChange_ResourceInstanceDeferred struct {
	state            protoimpl.MessageState          `protogen:"open.v1"`
	ResourceInstance *PlannedChange_ResourceInstance `protobuf:"bytes,1,opt,name=resource_instance,json=resourceInstance,proto3" json:"resource_instance,omitempty"`
	Deferred         *Deferred                       `protobuf:"bytes,2,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PlannedChange_ResourceInstanceDeferred) Reset() {
	*x = PlannedChange_ResourceInstanceDeferred{}
	mi := &file_stacks_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ResourceInstanceDeferred) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ResourceInstanceDeferred) ProtoMessage() {}

func (x *PlannedChange_ResourceInstanceDeferred) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ResourceInstanceDeferred.ProtoReflect.Descriptor instead.
func (*PlannedChange_ResourceInstanceDeferred) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 4}
}

func (x *PlannedChange_ResourceInstanceDeferred) GetResourceInstance() *PlannedChange_ResourceInstance {
	if x != nil {
		return x.ResourceInstance
	}
	return nil
}

func (x *PlannedChange_ResourceInstanceDeferred) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

// Note: this is only for input variables from the topmost
// stack configuration, because all other input variables are
// internal to the configuration and not part of its public API.
type PlannedChange_InputVariable struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Name                string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Actions             []ChangeType           `protobuf:"varint,2,rep,packed,name=actions,proto3,enum=terraform1.stacks.ChangeType" json:"actions,omitempty"`
	Values              *DynamicValueChange    `protobuf:"bytes,3,opt,name=values,proto3" json:"values,omitempty"`
	RequiredDuringApply bool                   `protobuf:"varint,4,opt,name=required_during_apply,json=requiredDuringApply,proto3" json:"required_during_apply,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *PlannedChange_InputVariable) Reset() {
	*x = PlannedChange_InputVariable{}
	mi := &file_stacks_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_InputVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_InputVariable) ProtoMessage() {}

func (x *PlannedChange_InputVariable) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_InputVariable.ProtoReflect.Descriptor instead.
func (*PlannedChange_InputVariable) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 5}
}

func (x *PlannedChange_InputVariable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlannedChange_InputVariable) GetActions() []ChangeType {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *PlannedChange_InputVariable) GetValues() *DynamicValueChange {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *PlannedChange_InputVariable) GetRequiredDuringApply() bool {
	if x != nil {
		return x.RequiredDuringApply
	}
	return false
}

type PlannedChange_ResourceInstance_Index struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         *DynamicValue          `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Unknown       bool                   `protobuf:"varint,2,opt,name=unknown,proto3" json:"unknown,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlannedChange_ResourceInstance_Index) Reset() {
	*x = PlannedChange_ResourceInstance_Index{}
	mi := &file_stacks_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ResourceInstance_Index) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ResourceInstance_Index) ProtoMessage() {}

func (x *PlannedChange_ResourceInstance_Index) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ResourceInstance_Index.ProtoReflect.Descriptor instead.
func (*PlannedChange_ResourceInstance_Index) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 2, 0}
}

func (x *PlannedChange_ResourceInstance_Index) GetValue() *DynamicValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PlannedChange_ResourceInstance_Index) GetUnknown() bool {
	if x != nil {
		return x.Unknown
	}
	return false
}

type PlannedChange_ResourceInstance_Moved struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	PrevAddr      *ResourceInstanceInStackAddr `protobuf:"bytes,1,opt,name=prev_addr,json=prevAddr,proto3" json:"prev_addr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlannedChange_ResourceInstance_Moved) Reset() {
	*x = PlannedChange_ResourceInstance_Moved{}
	mi := &file_stacks_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ResourceInstance_Moved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ResourceInstance_Moved) ProtoMessage() {}

func (x *PlannedChange_ResourceInstance_Moved) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ResourceInstance_Moved.ProtoReflect.Descriptor instead.
func (*PlannedChange_ResourceInstance_Moved) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 2, 1}
}

func (x *PlannedChange_ResourceInstance_Moved) GetPrevAddr() *ResourceInstanceInStackAddr {
	if x != nil {
		return x.PrevAddr
	}
	return nil
}

type PlannedChange_ResourceInstance_Imported struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	ImportId        string                 `protobuf:"bytes,1,opt,name=import_id,json=importId,proto3" json:"import_id,omitempty"`
	Unknown         bool                   `protobuf:"varint,2,opt,name=unknown,proto3" json:"unknown,omitempty"`
	GeneratedConfig string                 `protobuf:"bytes,3,opt,name=generated_config,json=generatedConfig,proto3" json:"generated_config,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PlannedChange_ResourceInstance_Imported) Reset() {
	*x = PlannedChange_ResourceInstance_Imported{}
	mi := &file_stacks_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlannedChange_ResourceInstance_Imported) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlannedChange_ResourceInstance_Imported) ProtoMessage() {}

func (x *PlannedChange_ResourceInstance_Imported) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlannedChange_ResourceInstance_Imported.ProtoReflect.Descriptor instead.
func (*PlannedChange_ResourceInstance_Imported) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{22, 2, 2}
}

func (x *PlannedChange_ResourceInstance_Imported) GetImportId() string {
	if x != nil {
		return x.ImportId
	}
	return ""
}

func (x *PlannedChange_ResourceInstance_Imported) GetUnknown() bool {
	if x != nil {
		return x.Unknown
	}
	return false
}

func (x *PlannedChange_ResourceInstance_Imported) GetGeneratedConfig() string {
	if x != nil {
		return x.GeneratedConfig
	}
	return ""
}

type AppliedChange_RawChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         *anypb.Any             `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange_RawChange) Reset() {
	*x = AppliedChange_RawChange{}
	mi := &file_stacks_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_RawChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_RawChange) ProtoMessage() {}

func (x *AppliedChange_RawChange) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_RawChange.ProtoReflect.Descriptor instead.
func (*AppliedChange_RawChange) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 0}
}

func (x *AppliedChange_RawChange) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AppliedChange_RawChange) GetValue() *anypb.Any {
	if x != nil {
		return x.Value
	}
	return nil
}

type AppliedChange_ChangeDescription struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Key   string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Types that are valid to be assigned to Description:
	//
	//	*AppliedChange_ChangeDescription_Deleted
	//	*AppliedChange_ChangeDescription_Moved
	//	*AppliedChange_ChangeDescription_ResourceInstance
	//	*AppliedChange_ChangeDescription_OutputValue
	//	*AppliedChange_ChangeDescription_InputVariable
	//	*AppliedChange_ChangeDescription_ComponentInstance
	Description   isAppliedChange_ChangeDescription_Description `protobuf_oneof:"description"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange_ChangeDescription) Reset() {
	*x = AppliedChange_ChangeDescription{}
	mi := &file_stacks_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_ChangeDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_ChangeDescription) ProtoMessage() {}

func (x *AppliedChange_ChangeDescription) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_ChangeDescription.ProtoReflect.Descriptor instead.
func (*AppliedChange_ChangeDescription) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 1}
}

func (x *AppliedChange_ChangeDescription) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AppliedChange_ChangeDescription) GetDescription() isAppliedChange_ChangeDescription_Description {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *AppliedChange_ChangeDescription) GetDeleted() *AppliedChange_Nothing {
	if x != nil {
		if x, ok := x.Description.(*AppliedChange_ChangeDescription_Deleted); ok {
			return x.Deleted
		}
	}
	return nil
}

func (x *AppliedChange_ChangeDescription) GetMoved() *AppliedChange_Nothing {
	if x != nil {
		if x, ok := x.Description.(*AppliedChange_ChangeDescription_Moved); ok {
			return x.Moved
		}
	}
	return nil
}

func (x *AppliedChange_ChangeDescription) GetResourceInstance() *AppliedChange_ResourceInstance {
	if x != nil {
		if x, ok := x.Description.(*AppliedChange_ChangeDescription_ResourceInstance); ok {
			return x.ResourceInstance
		}
	}
	return nil
}

func (x *AppliedChange_ChangeDescription) GetOutputValue() *AppliedChange_OutputValue {
	if x != nil {
		if x, ok := x.Description.(*AppliedChange_ChangeDescription_OutputValue); ok {
			return x.OutputValue
		}
	}
	return nil
}

func (x *AppliedChange_ChangeDescription) GetInputVariable() *AppliedChange_InputVariable {
	if x != nil {
		if x, ok := x.Description.(*AppliedChange_ChangeDescription_InputVariable); ok {
			return x.InputVariable
		}
	}
	return nil
}

func (x *AppliedChange_ChangeDescription) GetComponentInstance() *AppliedChange_ComponentInstance {
	if x != nil {
		if x, ok := x.Description.(*AppliedChange_ChangeDescription_ComponentInstance); ok {
			return x.ComponentInstance
		}
	}
	return nil
}

type isAppliedChange_ChangeDescription_Description interface {
	isAppliedChange_ChangeDescription_Description()
}

type AppliedChange_ChangeDescription_Deleted struct {
	Deleted *AppliedChange_Nothing `protobuf:"bytes,4,opt,name=deleted,proto3,oneof"` // explicitly represents the absence of a description
}

type AppliedChange_ChangeDescription_Moved struct {
	Moved *AppliedChange_Nothing `protobuf:"bytes,6,opt,name=moved,proto3,oneof"` // explicitly represents the absence of a description
}

type AppliedChange_ChangeDescription_ResourceInstance struct {
	ResourceInstance *AppliedChange_ResourceInstance `protobuf:"bytes,2,opt,name=resource_instance,json=resourceInstance,proto3,oneof"`
}

type AppliedChange_ChangeDescription_OutputValue struct {
	OutputValue *AppliedChange_OutputValue `protobuf:"bytes,3,opt,name=output_value,json=outputValue,proto3,oneof"`
}

type AppliedChange_ChangeDescription_InputVariable struct {
	InputVariable *AppliedChange_InputVariable `protobuf:"bytes,7,opt,name=input_variable,json=inputVariable,proto3,oneof"`
}

type AppliedChange_ChangeDescription_ComponentInstance struct {
	ComponentInstance *AppliedChange_ComponentInstance `protobuf:"bytes,5,opt,name=component_instance,json=componentInstance,proto3,oneof"`
}

func (*AppliedChange_ChangeDescription_Deleted) isAppliedChange_ChangeDescription_Description() {}

func (*AppliedChange_ChangeDescription_Moved) isAppliedChange_ChangeDescription_Description() {}

func (*AppliedChange_ChangeDescription_ResourceInstance) isAppliedChange_ChangeDescription_Description() {
}

func (*AppliedChange_ChangeDescription_OutputValue) isAppliedChange_ChangeDescription_Description() {}

func (*AppliedChange_ChangeDescription_InputVariable) isAppliedChange_ChangeDescription_Description() {
}

func (*AppliedChange_ChangeDescription_ComponentInstance) isAppliedChange_ChangeDescription_Description() {
}

type AppliedChange_ResourceInstance struct {
	state        protoimpl.MessageState             `protogen:"open.v1"`
	Addr         *ResourceInstanceObjectInStackAddr `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	NewValue     *DynamicValue                      `protobuf:"bytes,2,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
	ResourceMode ResourceMode                       `protobuf:"varint,4,opt,name=resource_mode,json=resourceMode,proto3,enum=terraform1.stacks.ResourceMode" json:"resource_mode,omitempty"`
	ResourceType string                             `protobuf:"bytes,5,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	ProviderAddr string                             `protobuf:"bytes,6,opt,name=provider_addr,json=providerAddr,proto3" json:"provider_addr,omitempty"`
	// Sometimes Terraform needs to make changes to a resource in
	// multiple steps during the apply phase, with each step
	// changing something about the state. This flag will be set
	// for such interim updates, and left unset for whatever
	// description Terraform Core considers to be "final", at
	// which point the new value should be converged with the
	// desired state.
	//
	// The intended use for this is when presenting updated values
	// to users in the UI, where it might be best to ignore or
	// present differently interim updates to avoid creating
	// confusion by showing the not-yet-converged intermediate
	// states.
	//
	// If Terraform encounters a problem during the apply phase
	// and needs to stop partway through then a "final" change
	// description might never arrive. In that case, callers
	// should save the most recent interim object as the final
	// description, since it would represent the most accurate
	// description of the state the remote system has been left
	// in.
	Interim       bool `protobuf:"varint,3,opt,name=interim,proto3" json:"interim,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange_ResourceInstance) Reset() {
	*x = AppliedChange_ResourceInstance{}
	mi := &file_stacks_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_ResourceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_ResourceInstance) ProtoMessage() {}

func (x *AppliedChange_ResourceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_ResourceInstance.ProtoReflect.Descriptor instead.
func (*AppliedChange_ResourceInstance) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 2}
}

func (x *AppliedChange_ResourceInstance) GetAddr() *ResourceInstanceObjectInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *AppliedChange_ResourceInstance) GetNewValue() *DynamicValue {
	if x != nil {
		return x.NewValue
	}
	return nil
}

func (x *AppliedChange_ResourceInstance) GetResourceMode() ResourceMode {
	if x != nil {
		return x.ResourceMode
	}
	return ResourceMode_UNKNOWN
}

func (x *AppliedChange_ResourceInstance) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *AppliedChange_ResourceInstance) GetProviderAddr() string {
	if x != nil {
		return x.ProviderAddr
	}
	return ""
}

func (x *AppliedChange_ResourceInstance) GetInterim() bool {
	if x != nil {
		return x.Interim
	}
	return false
}

type AppliedChange_ComponentInstance struct {
	state                 protoimpl.MessageState   `protogen:"open.v1"`
	ComponentAddr         string                   `protobuf:"bytes,3,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	ComponentInstanceAddr string                   `protobuf:"bytes,1,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	OutputValues          map[string]*DynamicValue `protobuf:"bytes,2,rep,name=output_values,json=outputValues,proto3" json:"output_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *AppliedChange_ComponentInstance) Reset() {
	*x = AppliedChange_ComponentInstance{}
	mi := &file_stacks_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_ComponentInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_ComponentInstance) ProtoMessage() {}

func (x *AppliedChange_ComponentInstance) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_ComponentInstance.ProtoReflect.Descriptor instead.
func (*AppliedChange_ComponentInstance) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 3}
}

func (x *AppliedChange_ComponentInstance) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

func (x *AppliedChange_ComponentInstance) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

func (x *AppliedChange_ComponentInstance) GetOutputValues() map[string]*DynamicValue {
	if x != nil {
		return x.OutputValues
	}
	return nil
}

type AppliedChange_OutputValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	NewValue      *DynamicValue          `protobuf:"bytes,2,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange_OutputValue) Reset() {
	*x = AppliedChange_OutputValue{}
	mi := &file_stacks_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_OutputValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_OutputValue) ProtoMessage() {}

func (x *AppliedChange_OutputValue) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_OutputValue.ProtoReflect.Descriptor instead.
func (*AppliedChange_OutputValue) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 4}
}

func (x *AppliedChange_OutputValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AppliedChange_OutputValue) GetNewValue() *DynamicValue {
	if x != nil {
		return x.NewValue
	}
	return nil
}

type AppliedChange_InputVariable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	NewValue      *DynamicValue          `protobuf:"bytes,2,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange_InputVariable) Reset() {
	*x = AppliedChange_InputVariable{}
	mi := &file_stacks_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_InputVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_InputVariable) ProtoMessage() {}

func (x *AppliedChange_InputVariable) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_InputVariable.ProtoReflect.Descriptor instead.
func (*AppliedChange_InputVariable) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 5}
}

func (x *AppliedChange_InputVariable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AppliedChange_InputVariable) GetNewValue() *DynamicValue {
	if x != nil {
		return x.NewValue
	}
	return nil
}

type AppliedChange_Nothing struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AppliedChange_Nothing) Reset() {
	*x = AppliedChange_Nothing{}
	mi := &file_stacks_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedChange_Nothing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedChange_Nothing) ProtoMessage() {}

func (x *AppliedChange_Nothing) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedChange_Nothing.ProtoReflect.Descriptor instead.
func (*AppliedChange_Nothing) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{24, 6}
}

// ComponentInstanceStatus describes the current status of a component instance
// undergoing a plan or apply operation.
type StackChangeProgress_ComponentInstanceStatus struct {
	state         protoimpl.MessageState                             `protogen:"open.v1"`
	Addr          *ComponentInstanceInStackAddr                      `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Status        StackChangeProgress_ComponentInstanceStatus_Status `protobuf:"varint,2,opt,name=status,proto3,enum=terraform1.stacks.StackChangeProgress_ComponentInstanceStatus_Status" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ComponentInstanceStatus) Reset() {
	*x = StackChangeProgress_ComponentInstanceStatus{}
	mi := &file_stacks_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ComponentInstanceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ComponentInstanceStatus) ProtoMessage() {}

func (x *StackChangeProgress_ComponentInstanceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ComponentInstanceStatus.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ComponentInstanceStatus) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 0}
}

func (x *StackChangeProgress_ComponentInstanceStatus) GetAddr() *ComponentInstanceInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *StackChangeProgress_ComponentInstanceStatus) GetStatus() StackChangeProgress_ComponentInstanceStatus_Status {
	if x != nil {
		return x.Status
	}
	return StackChangeProgress_ComponentInstanceStatus_INVALID
}

// ComponentInstanceStatus describes the current status of a resource instance
// undergoing a plan or apply operation.
type StackChangeProgress_ResourceInstanceStatus struct {
	state         protoimpl.MessageState                            `protogen:"open.v1"`
	Addr          *ResourceInstanceObjectInStackAddr                `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Status        StackChangeProgress_ResourceInstanceStatus_Status `protobuf:"varint,2,opt,name=status,proto3,enum=terraform1.stacks.StackChangeProgress_ResourceInstanceStatus_Status" json:"status,omitempty"`
	ProviderAddr  string                                            `protobuf:"bytes,3,opt,name=provider_addr,json=providerAddr,proto3" json:"provider_addr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ResourceInstanceStatus) Reset() {
	*x = StackChangeProgress_ResourceInstanceStatus{}
	mi := &file_stacks_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ResourceInstanceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ResourceInstanceStatus) ProtoMessage() {}

func (x *StackChangeProgress_ResourceInstanceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ResourceInstanceStatus.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ResourceInstanceStatus) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 1}
}

func (x *StackChangeProgress_ResourceInstanceStatus) GetAddr() *ResourceInstanceObjectInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *StackChangeProgress_ResourceInstanceStatus) GetStatus() StackChangeProgress_ResourceInstanceStatus_Status {
	if x != nil {
		return x.Status
	}
	return StackChangeProgress_ResourceInstanceStatus_INVALID
}

func (x *StackChangeProgress_ResourceInstanceStatus) GetProviderAddr() string {
	if x != nil {
		return x.ProviderAddr
	}
	return ""
}

// ResourceInstancePlannedChange describes summary information about a planned
// change for a resource instance. This does not include the full object change,
// which is described in PlannedChange.ResourceChange. The information in this
// message is intended for the event stream and need not include the instance's
// full object values.
type StackChangeProgress_ResourceInstancePlannedChange struct {
	state         protoimpl.MessageState                                      `protogen:"open.v1"`
	Addr          *ResourceInstanceObjectInStackAddr                          `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Actions       []ChangeType                                                `protobuf:"varint,2,rep,packed,name=actions,proto3,enum=terraform1.stacks.ChangeType" json:"actions,omitempty"`
	Moved         *StackChangeProgress_ResourceInstancePlannedChange_Moved    `protobuf:"bytes,3,opt,name=moved,proto3" json:"moved,omitempty"`
	Imported      *StackChangeProgress_ResourceInstancePlannedChange_Imported `protobuf:"bytes,4,opt,name=imported,proto3" json:"imported,omitempty"`
	ProviderAddr  string                                                      `protobuf:"bytes,5,opt,name=provider_addr,json=providerAddr,proto3" json:"provider_addr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) Reset() {
	*x = StackChangeProgress_ResourceInstancePlannedChange{}
	mi := &file_stacks_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ResourceInstancePlannedChange) ProtoMessage() {}

func (x *StackChangeProgress_ResourceInstancePlannedChange) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ResourceInstancePlannedChange.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ResourceInstancePlannedChange) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 2}
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) GetAddr() *ResourceInstanceObjectInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) GetActions() []ChangeType {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) GetMoved() *StackChangeProgress_ResourceInstancePlannedChange_Moved {
	if x != nil {
		return x.Moved
	}
	return nil
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) GetImported() *StackChangeProgress_ResourceInstancePlannedChange_Imported {
	if x != nil {
		return x.Imported
	}
	return nil
}

func (x *StackChangeProgress_ResourceInstancePlannedChange) GetProviderAddr() string {
	if x != nil {
		return x.ProviderAddr
	}
	return ""
}

// DeferredResourceInstancePlannedChange represents a planned change for a
// resource instance that is deferred due to the reason provided.
type StackChangeProgress_DeferredResourceInstancePlannedChange struct {
	state         protoimpl.MessageState                             `protogen:"open.v1"`
	Deferred      *Deferred                                          `protobuf:"bytes,1,opt,name=deferred,proto3" json:"deferred,omitempty"`
	Change        *StackChangeProgress_ResourceInstancePlannedChange `protobuf:"bytes,2,opt,name=change,proto3" json:"change,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_DeferredResourceInstancePlannedChange) Reset() {
	*x = StackChangeProgress_DeferredResourceInstancePlannedChange{}
	mi := &file_stacks_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_DeferredResourceInstancePlannedChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_DeferredResourceInstancePlannedChange) ProtoMessage() {}

func (x *StackChangeProgress_DeferredResourceInstancePlannedChange) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_DeferredResourceInstancePlannedChange.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_DeferredResourceInstancePlannedChange) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 3}
}

func (x *StackChangeProgress_DeferredResourceInstancePlannedChange) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *StackChangeProgress_DeferredResourceInstancePlannedChange) GetChange() *StackChangeProgress_ResourceInstancePlannedChange {
	if x != nil {
		return x.Change
	}
	return nil
}

// ProvisionerStatus represents the progress of a given provisioner during its
// resource instance's apply operation.
type StackChangeProgress_ProvisionerStatus struct {
	state         protoimpl.MessageState                 `protogen:"open.v1"`
	Addr          *ResourceInstanceObjectInStackAddr     `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Name          string                                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Status        *StackChangeProgress_ProvisionerStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ProvisionerStatus) Reset() {
	*x = StackChangeProgress_ProvisionerStatus{}
	mi := &file_stacks_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ProvisionerStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ProvisionerStatus) ProtoMessage() {}

func (x *StackChangeProgress_ProvisionerStatus) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ProvisionerStatus.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ProvisionerStatus) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 4}
}

func (x *StackChangeProgress_ProvisionerStatus) GetAddr() *ResourceInstanceObjectInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *StackChangeProgress_ProvisionerStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StackChangeProgress_ProvisionerStatus) GetStatus() *StackChangeProgress_ProvisionerStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

// ProvisionerOutput represents recorded output data emitted by a provisioner
// during a resource instance's apply operation.
type StackChangeProgress_ProvisionerOutput struct {
	state         protoimpl.MessageState             `protogen:"open.v1"`
	Addr          *ResourceInstanceObjectInStackAddr `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Name          string                             `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Output        string                             `protobuf:"bytes,3,opt,name=output,proto3" json:"output,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ProvisionerOutput) Reset() {
	*x = StackChangeProgress_ProvisionerOutput{}
	mi := &file_stacks_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ProvisionerOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ProvisionerOutput) ProtoMessage() {}

func (x *StackChangeProgress_ProvisionerOutput) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ProvisionerOutput.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ProvisionerOutput) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 5}
}

func (x *StackChangeProgress_ProvisionerOutput) GetAddr() *ResourceInstanceObjectInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *StackChangeProgress_ProvisionerOutput) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StackChangeProgress_ProvisionerOutput) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

// ComponentInstanceChanges represents a roll-up of change counts for a
// component instance plan or apply operation.
type StackChangeProgress_ComponentInstanceChanges struct {
	state protoimpl.MessageState        `protogen:"open.v1"`
	Addr  *ComponentInstanceInStackAddr `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	// total is the sum of all of the other count fields.
	//
	// Clients should sum all of the other count fields they know about
	// and compare to total. If the sum is less than total then the
	// difference should be treated as an "other change types" category,
	// for forward-compatibility when the Terraform Core RPC server is
	// using a newer version of this protocol than the client.
	Total         int32 `protobuf:"varint,2,opt,name=total,proto3" json:"total,omitempty"`
	Add           int32 `protobuf:"varint,3,opt,name=add,proto3" json:"add,omitempty"`
	Change        int32 `protobuf:"varint,4,opt,name=change,proto3" json:"change,omitempty"`
	Import        int32 `protobuf:"varint,5,opt,name=import,proto3" json:"import,omitempty"`
	Remove        int32 `protobuf:"varint,6,opt,name=remove,proto3" json:"remove,omitempty"`
	Defer         int32 `protobuf:"varint,7,opt,name=defer,proto3" json:"defer,omitempty"`
	Move          int32 `protobuf:"varint,8,opt,name=move,proto3" json:"move,omitempty"`
	Forget        int32 `protobuf:"varint,9,opt,name=forget,proto3" json:"forget,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ComponentInstanceChanges) Reset() {
	*x = StackChangeProgress_ComponentInstanceChanges{}
	mi := &file_stacks_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ComponentInstanceChanges) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ComponentInstanceChanges) ProtoMessage() {}

func (x *StackChangeProgress_ComponentInstanceChanges) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ComponentInstanceChanges.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ComponentInstanceChanges) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 6}
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetAddr() *ComponentInstanceInStackAddr {
	if x != nil {
		return x.Addr
	}
	return nil
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetTotal() int32 {
	if x != nil {
		return x.Total
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetAdd() int32 {
	if x != nil {
		return x.Add
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetChange() int32 {
	if x != nil {
		return x.Change
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetImport() int32 {
	if x != nil {
		return x.Import
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetRemove() int32 {
	if x != nil {
		return x.Remove
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetDefer() int32 {
	if x != nil {
		return x.Defer
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetMove() int32 {
	if x != nil {
		return x.Move
	}
	return 0
}

func (x *StackChangeProgress_ComponentInstanceChanges) GetForget() int32 {
	if x != nil {
		return x.Forget
	}
	return 0
}

// ComponentInstances represents the result of expanding a component into zero
// or more instances.
type StackChangeProgress_ComponentInstances struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ComponentAddr string                 `protobuf:"bytes,1,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	InstanceAddrs []string               `protobuf:"bytes,2,rep,name=instance_addrs,json=instanceAddrs,proto3" json:"instance_addrs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ComponentInstances) Reset() {
	*x = StackChangeProgress_ComponentInstances{}
	mi := &file_stacks_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ComponentInstances) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ComponentInstances) ProtoMessage() {}

func (x *StackChangeProgress_ComponentInstances) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ComponentInstances.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ComponentInstances) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 7}
}

func (x *StackChangeProgress_ComponentInstances) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

func (x *StackChangeProgress_ComponentInstances) GetInstanceAddrs() []string {
	if x != nil {
		return x.InstanceAddrs
	}
	return nil
}

type StackChangeProgress_ResourceInstancePlannedChange_Moved struct {
	state         protoimpl.MessageState       `protogen:"open.v1"`
	PrevAddr      *ResourceInstanceInStackAddr `protobuf:"bytes,1,opt,name=prev_addr,json=prevAddr,proto3" json:"prev_addr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Moved) Reset() {
	*x = StackChangeProgress_ResourceInstancePlannedChange_Moved{}
	mi := &file_stacks_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Moved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ResourceInstancePlannedChange_Moved) ProtoMessage() {}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Moved) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ResourceInstancePlannedChange_Moved.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ResourceInstancePlannedChange_Moved) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 2, 0}
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Moved) GetPrevAddr() *ResourceInstanceInStackAddr {
	if x != nil {
		return x.PrevAddr
	}
	return nil
}

type StackChangeProgress_ResourceInstancePlannedChange_Imported struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ImportId      string                 `protobuf:"bytes,1,opt,name=import_id,json=importId,proto3" json:"import_id,omitempty"`
	Unknown       bool                   `protobuf:"varint,2,opt,name=unknown,proto3" json:"unknown,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Imported) Reset() {
	*x = StackChangeProgress_ResourceInstancePlannedChange_Imported{}
	mi := &file_stacks_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Imported) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackChangeProgress_ResourceInstancePlannedChange_Imported) ProtoMessage() {}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Imported) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackChangeProgress_ResourceInstancePlannedChange_Imported.ProtoReflect.Descriptor instead.
func (*StackChangeProgress_ResourceInstancePlannedChange_Imported) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{25, 2, 1}
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Imported) GetImportId() string {
	if x != nil {
		return x.ImportId
	}
	return ""
}

func (x *StackChangeProgress_ResourceInstancePlannedChange_Imported) GetUnknown() bool {
	if x != nil {
		return x.Unknown
	}
	return false
}

type ListResourceIdentities_Request struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	StateHandle           int64                  `protobuf:"varint,1,opt,name=state_handle,json=stateHandle,proto3" json:"state_handle,omitempty"`
	DependencyLocksHandle int64                  `protobuf:"varint,2,opt,name=dependency_locks_handle,json=dependencyLocksHandle,proto3" json:"dependency_locks_handle,omitempty"`
	ProviderCacheHandle   int64                  `protobuf:"varint,3,opt,name=provider_cache_handle,json=providerCacheHandle,proto3" json:"provider_cache_handle,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ListResourceIdentities_Request) Reset() {
	*x = ListResourceIdentities_Request{}
	mi := &file_stacks_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResourceIdentities_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceIdentities_Request) ProtoMessage() {}

func (x *ListResourceIdentities_Request) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceIdentities_Request.ProtoReflect.Descriptor instead.
func (*ListResourceIdentities_Request) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{26, 0}
}

func (x *ListResourceIdentities_Request) GetStateHandle() int64 {
	if x != nil {
		return x.StateHandle
	}
	return 0
}

func (x *ListResourceIdentities_Request) GetDependencyLocksHandle() int64 {
	if x != nil {
		return x.DependencyLocksHandle
	}
	return 0
}

func (x *ListResourceIdentities_Request) GetProviderCacheHandle() int64 {
	if x != nil {
		return x.ProviderCacheHandle
	}
	return 0
}

type ListResourceIdentities_Response struct {
	state         protoimpl.MessageState             `protogen:"open.v1"`
	Resource      []*ListResourceIdentities_Resource `protobuf:"bytes,1,rep,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResourceIdentities_Response) Reset() {
	*x = ListResourceIdentities_Response{}
	mi := &file_stacks_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResourceIdentities_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceIdentities_Response) ProtoMessage() {}

func (x *ListResourceIdentities_Response) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceIdentities_Response.ProtoReflect.Descriptor instead.
func (*ListResourceIdentities_Response) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{26, 1}
}

func (x *ListResourceIdentities_Response) GetResource() []*ListResourceIdentities_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

type ListResourceIdentities_Resource struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	ComponentAddr         string                 `protobuf:"bytes,1,opt,name=component_addr,json=componentAddr,proto3" json:"component_addr,omitempty"`
	ComponentInstanceAddr string                 `protobuf:"bytes,2,opt,name=component_instance_addr,json=componentInstanceAddr,proto3" json:"component_instance_addr,omitempty"`
	// Unique address of the resource instance within the given component
	// instance. Each component instance has a separate namespace of
	// resource instance addresses, so callers must take both fields together
	// to produce a key that's unique throughout the entire plan.
	ResourceInstanceAddr string        `protobuf:"bytes,3,opt,name=resource_instance_addr,json=resourceInstanceAddr,proto3" json:"resource_instance_addr,omitempty"`
	ResourceIdentity     *DynamicValue `protobuf:"bytes,4,opt,name=resource_identity,json=resourceIdentity,proto3" json:"resource_identity,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListResourceIdentities_Resource) Reset() {
	*x = ListResourceIdentities_Resource{}
	mi := &file_stacks_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResourceIdentities_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceIdentities_Resource) ProtoMessage() {}

func (x *ListResourceIdentities_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_stacks_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceIdentities_Resource.ProtoReflect.Descriptor instead.
func (*ListResourceIdentities_Resource) Descriptor() ([]byte, []int) {
	return file_stacks_proto_rawDescGZIP(), []int{26, 2}
}

func (x *ListResourceIdentities_Resource) GetComponentAddr() string {
	if x != nil {
		return x.ComponentAddr
	}
	return ""
}

func (x *ListResourceIdentities_Resource) GetComponentInstanceAddr() string {
	if x != nil {
		return x.ComponentInstanceAddr
	}
	return ""
}

func (x *ListResourceIdentities_Resource) GetResourceInstanceAddr() string {
	if x != nil {
		return x.ResourceInstanceAddr
	}
	return ""
}

func (x *ListResourceIdentities_Resource) GetResourceIdentity() *DynamicValue {
	if x != nil {
		return x.ResourceIdentity
	}
	return nil
}

var File_stacks_proto protoreflect.FileDescriptor

var file_stacks_proto_rawDesc = string([]byte{
	0x0a, 0x0c, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x10, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc8,
	0x01, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x6e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x49, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x03, 0x72, 0x61, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x48, 0x00, 0x52, 0x03, 0x72, 0x61, 0x77, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x1a, 0x67, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12,
	0x38, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0x4f, 0x0a, 0x13, 0x43, 0x6c, 0x6f,
	0x73, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x1a, 0x2c, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x1a, 0x0a,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xea, 0x06, 0x0a, 0x15, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x1a, 0xb7, 0x05, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x12, 0x32, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x12, 0x52, 0x0a, 0x06, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x48, 0x00,
	0x52, 0x06, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x98, 0x03, 0x0a, 0x07, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x12, 0x82, 0x01, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31,
	0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x12, 0x7c, 0x0a, 0x12, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x1a, 0x45, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x43,
	0x0a, 0x15, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d,
	0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a, 0x96,
	0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x12, 0x49, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x08, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x8d, 0x02, 0x0a, 0x16, 0x4f, 0x70, 0x65, 0x6e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x7d, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30, 0x0a,
	0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12,
	0x40, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x1a, 0x74, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a,
	0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x38, 0x0a,
	0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0x60, 0x0a, 0x17, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a,
	0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x1a, 0x0a, 0x0a,
	0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8a, 0x02, 0x0a, 0x1a, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa5, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x79, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x15,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x1a, 0x44, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b,
	0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x44,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xa8, 0x14, 0x0a, 0x20, 0x46, 0x69, 0x6e, 0x64, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x39, 0x0a, 0x07, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x1a, 0x63, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x57, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xe2, 0x09, 0x0a, 0x0b,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x0a, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x0f,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x65, 0x6d, 0x62, 0x65,
	0x64, 0x64, 0x65, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x7c, 0x0a, 0x0f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31,
	0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x76, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x12, 0x66, 0x0a, 0x07, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4c, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x07, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x1a, 0x7c, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x53, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x84, 0x01, 0x0a, 0x13, 0x45, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x65, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x57, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x84, 0x01,
	0x0a, 0x13, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x57, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x80, 0x01, 0x0a, 0x11, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x55, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x77, 0x0a, 0x0c, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x51, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e,
	0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0xe6, 0x01, 0x0a, 0x0d, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41,
	0x64, 0x64, 0x72, 0x12, 0x5b, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x57, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xb0, 0x01, 0x0a, 0x09, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x5b, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x1a, 0xfc, 0x03, 0x0a,
	0x07, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x5f, 0x0a,
	0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x29,
	0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x12, 0x1c, 0x0a, 0x07, 0x64, 0x65, 0x73,
	0x74, 0x72, 0x6f, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07,
	0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x12, 0x59, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x64, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x1a, 0xc6, 0x01, 0x0a, 0x05, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x5b, 0x0a,
	0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x1a, 0x67, 0x0a, 0x0d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65,
	0x72, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x65, 0x70, 0x68, 0x65, 0x6d,
	0x65, 0x72, 0x61, 0x6c, 0x1a, 0x49, 0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x22,
	0x30, 0x0a, 0x09, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x0a, 0x0a, 0x06,
	0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x4f, 0x52, 0x5f, 0x45, 0x41, 0x43, 0x48, 0x10,
	0x02, 0x22, 0x8c, 0x01, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x1a, 0x4b, 0x0a, 0x0b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x74, 0x65, 0x6d, 0x12, 0x3c, 0x0a, 0x03, 0x72, 0x61, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x52, 0x61, 0x77, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x03, 0x72, 0x61,
	0x77, 0x1a, 0x2d, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x22, 0x4b, 0x0a, 0x0f, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x1a, 0x2c, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21,
	0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x1a, 0x0a, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9b, 0x07,
	0x0a, 0x10, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x1a, 0xa2, 0x05, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38,
	0x0a, 0x09, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1b, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08,
	0x70, 0x6c, 0x61, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x6f, 0x75, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x69, 0x0a, 0x0e,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f,
	0x75, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12,
	0x32, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68,
	0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x12, 0x5f, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c,
	0x61, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x1a, 0x56, 0x0a, 0x12, 0x50, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x69, 0x0a, 0x10,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x57, 0x69, 0x74, 0x68, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xe1, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x49, 0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c,
	0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x70,
	0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x0a,
	0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x44, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x12, 0x44, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x07, 0x0a, 0x05,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x0a, 0x22, 0x73, 0x0a, 0x0d, 0x4f,
	0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x6c, 0x61, 0x6e, 0x1a, 0x35, 0x0a, 0x0b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x26, 0x0a, 0x03, 0x72,
	0x61, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x03,
	0x72, 0x61, 0x77, 0x1a, 0x2b, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x6c, 0x61, 0x6e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x22, 0x48, 0x0a, 0x0e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x6c,
	0x61, 0x6e, 0x1a, 0x2a, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x70, 0x6c, 0x61, 0x6e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x1a, 0x0a,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x86, 0x06, 0x0a, 0x11, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x1a, 0x92, 0x04, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x13,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x6b, 0x6e,
	0x6f, 0x77, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x6c, 0x61, 0x6e, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x12, 0x41, 0x0a, 0x0f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32,
	0x0a, 0x15, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x12, 0x60, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x79, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x1a, 0x69, 0x0a, 0x10, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x57, 0x69, 0x74, 0x68, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x4a,
	0x04, 0x08, 0x02, 0x10, 0x03, 0x1a, 0xdb, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x49, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x0a, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x12, 0x44, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x22, 0xa6, 0x05, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x93, 0x04, 0x0a, 0x07, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32,
	0x0a, 0x15, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x12, 0x61, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x4e, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x69, 0x0a, 0x10, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x57, 0x69, 0x74, 0x68, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x7a, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52,
	0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xa0, 0x02, 0x0a,
	0x17, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x85, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x72, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x72,
	0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72,
	0x1a, 0x7d, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73,
	0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22,
	0x68, 0x0a, 0x0c, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x73, 0x67, 0x70, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x07, 0x6d, 0x73, 0x67, 0x70, 0x61, 0x63, 0x6b, 0x12, 0x3e, 0x0a, 0x09, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x52, 0x09,
	0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0x7a, 0x0a, 0x12, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x31, 0x0a, 0x03, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x6f,
	0x6c, 0x64, 0x12, 0x31, 0x0a, 0x03, 0x6e, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x03, 0x6e, 0x65, 0x77, 0x22, 0x8b, 0x01, 0x0a, 0x16, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x57, 0x69, 0x74, 0x68, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x35, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3a, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x22, 0xe4, 0x01, 0x0a, 0x0d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x3b, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65,
	0x70, 0x73, 0x1a, 0x95, 0x01, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x27, 0x0a, 0x0e, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x10, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x0d, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x74, 0x42, 0x0a,
	0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x7d, 0x0a, 0x1c, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x22, 0x8b, 0x01, 0x0a, 0x1b, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x22, 0xb2, 0x01, 0x0a, 0x21, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x12, 0x36, 0x0a,
	0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x65, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x65, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x22, 0x9c, 0x15, 0x0a,
	0x0d, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x26,
	0x0a, 0x03, 0x72, 0x61, 0x77, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x03, 0x72, 0x61, 0x77, 0x12, 0x56, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xf5,
	0x04, 0x0a, 0x11, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x18,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x12, 0x6f, 0x0a, 0x19, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x17, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x14, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0e, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x79, 0x0a, 0x1a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x66, 0x65, 0x72,
	0x72, 0x65, 0x64, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12,
	0x66, 0x0a, 0x16, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x14, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb6, 0x01, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x04,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x04, 0x61, 0x64, 0x64,
	0x72, 0x12, 0x37, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6c,
	0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x1a,
	0xaf, 0x09, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x37,
	0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x05, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x52, 0x05,
	0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x56, 0x0a, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x44, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x12, 0x4d, 0x0a,
	0x12, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x6f, 0x75, 0x73, 0x52, 0x75, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6f,
	0x75, 0x74, 0x73, 0x69, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x6e, 0x6f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x73, 0x69,
	0x64, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0c, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d,
	0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x23,
	0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x1a, 0x58, 0x0a, 0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x35, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x1a, 0x54, 0x0a,
	0x05, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x76, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x08, 0x70, 0x72, 0x65, 0x76, 0x41,
	0x64, 0x64, 0x72, 0x1a, 0x6c, 0x0a, 0x08, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x75,
	0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x1a, 0x99, 0x01, 0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xb3, 0x01,
	0x0a, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12, 0x5e, 0x0a, 0x11, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x64, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72,
	0x72, 0x65, 0x64, 0x1a, 0xcf, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x75,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x13, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x44, 0x75, 0x72, 0x69, 0x6e, 0x67,
	0x41, 0x70, 0x70, 0x6c, 0x79, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x07, 0x22, 0xdc, 0x01, 0x0a, 0x08,
	0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12, 0x3a, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x64, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45,
	0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x42, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x52, 0x45,
	0x52, 0x45, 0x51, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45,
	0x44, 0x5f, 0x50, 0x52, 0x45, 0x52, 0x45, 0x51, 0x10, 0x05, 0x22, 0x84, 0x0d, 0x0a, 0x0d, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x3c, 0x0a, 0x03,
	0x72, 0x61, 0x77, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x61, 0x77, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x03, 0x72, 0x61, 0x77, 0x12, 0x56, 0x0a, 0x0c, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x49, 0x0a, 0x09, 0x52, 0x61, 0x77, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x2a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xb9, 0x04,
	0x0a, 0x11, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x44, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x4e, 0x6f, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x48, 0x00, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x05, 0x6d,
	0x6f, 0x76, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x4e, 0x6f, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x05, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x60, 0x0a,
	0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x10, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x51, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x63, 0x0a, 0x12, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x11, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x08, 0x08, 0xa0, 0x9c, 0x01, 0x10, 0xa1, 0x9c, 0x01, 0x1a, 0xc4, 0x02, 0x0a, 0x10, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x48,
	0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64,
	0x64, 0x72, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x3c, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e, 0x65,
	0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6d,
	0x1a, 0xbf, 0x02, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x12, 0x36, 0x0a,
	0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x69, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x1a, 0x60, 0x0a, 0x11, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x35, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x5f, 0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x61, 0x0a, 0x0d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e, 0x65,
	0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x09, 0x0a, 0x07, 0x4e, 0x6f, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x22, 0xbf, 0x19, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x7c, 0x0a, 0x19, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x17,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x79, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x1d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x69, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x11, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x69, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x7f, 0x0a, 0x1a, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x6c, 0x0a, 0x13, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xa8, 0x01, 0x0a, 0x29, 0x64, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x25, 0x64,
	0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x1a, 0xb2, 0x02, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x43, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52,
	0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x5d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0x73, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b,
	0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4c, 0x41, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x4c, 0x41, 0x4e, 0x4e, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x10,
	0x04, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b,
	0x0a, 0x07, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x10, 0x07, 0x1a, 0xec, 0x02, 0x0a, 0x16, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x48, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x5c,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x41, 0x64, 0x64,
	0x72, 0x22, 0x84, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53,
	0x48, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53,
	0x48, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4c, 0x41, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x4c, 0x41, 0x4e, 0x4e, 0x45, 0x44, 0x10, 0x05,
	0x12, 0x0c, 0x0a, 0x08, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0b,
	0x0a, 0x07, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x08, 0x1a, 0xad, 0x04, 0x0a, 0x1d, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x61, 0x64,
	0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x04,
	0x61, 0x64, 0x64, 0x72, 0x12, 0x37, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a,
	0x05, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x52, 0x05, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12,
	0x69, 0x0a, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x1a,
	0x54, 0x0a, 0x05, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x76,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x08, 0x70, 0x72, 0x65,
	0x76, 0x41, 0x64, 0x64, 0x72, 0x1a, 0x41, 0x0a, 0x08, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12, 0x18,
	0x0a, 0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x1a, 0xbe, 0x01, 0x0a, 0x25, 0x44, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65,
	0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12, 0x5c, 0x0a, 0x06, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0x8a, 0x02, 0x0a, 0x11, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x48, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41,
	0x64, 0x64, 0x72, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x45, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x45, 0x44, 0x10, 0x03, 0x1a, 0x89, 0x01, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x48, 0x0a, 0x04,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72,
	0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x1a, 0x91, 0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x43, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x52, 0x04,
	0x61, 0x64, 0x64, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x64,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x61, 0x64, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x72, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x65, 0x66, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x64, 0x65, 0x66, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f,
	0x76, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6d, 0x6f, 0x76, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x6f, 0x72, 0x67, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x66, 0x6f, 0x72, 0x67, 0x65, 0x74, 0x1a, 0x62, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x22, 0xff, 0x03, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x98,
	0x01, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x36, 0x0a,
	0x17, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x1a, 0x5a, 0x0a, 0x08, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0xed, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x64,
	0x72, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x12, 0x4c, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2a, 0x32, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x41, 0x10, 0x02, 0x2a, 0x35, 0x0a, 0x08, 0x50, 0x6c, 0x61,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x53, 0x54, 0x52, 0x4f, 0x59, 0x10, 0x02,
	0x2a, 0x50, 0x0a, 0x0a, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x4f, 0x4f, 0x50, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x45, 0x41, 0x44,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x4f, 0x52, 0x47, 0x45, 0x54,
	0x10, 0x05, 0x32, 0x9c, 0x0f, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x7f, 0x0a,
	0x16, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f,
	0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x82,
	0x01, 0x0a, 0x17, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x1a, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x9d, 0x01, 0x0a, 0x20, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3b, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31,
	0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x68, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x1a, 0x2a, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x12, 0x65, 0x0a, 0x0a, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x2e, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x6c,
	0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x6c, 0x0a, 0x10, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x2b, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31,
	0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x30, 0x01,
	0x12, 0x65, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x6e, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2c, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x1a, 0x29, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f,
	0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x12, 0x62, 0x0a, 0x09, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x12, 0x29, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x6c,
	0x61, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x11, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x2c, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x30, 0x01, 0x12, 0x73, 0x0a, 0x12,
	0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x2d, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x82, 0x01, 0x0a, 0x17, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x32, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x6e, 0x54, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x13, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x2e, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x7b, 0x0a, 0x15, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x30, 0x2e, 0x74,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x73, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x30, 0x01,
	0x12, 0x7f, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x31, 0x2e, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_stacks_proto_rawDescOnce sync.Once
	file_stacks_proto_rawDescData []byte
)

func file_stacks_proto_rawDescGZIP() []byte {
	file_stacks_proto_rawDescOnce.Do(func() {
		file_stacks_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_stacks_proto_rawDesc), len(file_stacks_proto_rawDesc)))
	})
	return file_stacks_proto_rawDescData
}

var file_stacks_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_stacks_proto_msgTypes = make([]protoimpl.MessageInfo, 108)
var file_stacks_proto_goTypes = []any{
	(ResourceMode)(0), // 0: terraform1.stacks.ResourceMode
	(PlanMode)(0),     // 1: terraform1.stacks.PlanMode
	(ChangeType)(0),   // 2: terraform1.stacks.ChangeType
	(FindStackConfigurationComponents_Instances)(0),         // 3: terraform1.stacks.FindStackConfigurationComponents.Instances
	(Deferred_Reason)(0),                                    // 4: terraform1.stacks.Deferred.Reason
	(StackChangeProgress_ComponentInstanceStatus_Status)(0), // 5: terraform1.stacks.StackChangeProgress.ComponentInstanceStatus.Status
	(StackChangeProgress_ResourceInstanceStatus_Status)(0),  // 6: terraform1.stacks.StackChangeProgress.ResourceInstanceStatus.Status
	(StackChangeProgress_ProvisionerStatus_Status)(0),       // 7: terraform1.stacks.StackChangeProgress.ProvisionerStatus.Status
	(*OpenTerraformState)(nil),                              // 8: terraform1.stacks.OpenTerraformState
	(*CloseTerraformState)(nil),                             // 9: terraform1.stacks.CloseTerraformState
	(*MigrateTerraformState)(nil),                           // 10: terraform1.stacks.MigrateTerraformState
	(*OpenStackConfiguration)(nil),                          // 11: terraform1.stacks.OpenStackConfiguration
	(*CloseStackConfiguration)(nil),                         // 12: terraform1.stacks.CloseStackConfiguration
	(*ValidateStackConfiguration)(nil),                      // 13: terraform1.stacks.ValidateStackConfiguration
	(*FindStackConfigurationComponents)(nil),                // 14: terraform1.stacks.FindStackConfigurationComponents
	(*OpenStackState)(nil),                                  // 15: terraform1.stacks.OpenStackState
	(*CloseStackState)(nil),                                 // 16: terraform1.stacks.CloseStackState
	(*PlanStackChanges)(nil),                                // 17: terraform1.stacks.PlanStackChanges
	(*OpenStackPlan)(nil),                                   // 18: terraform1.stacks.OpenStackPlan
	(*CloseStackPlan)(nil),                                  // 19: terraform1.stacks.CloseStackPlan
	(*ApplyStackChanges)(nil),                               // 20: terraform1.stacks.ApplyStackChanges
	(*OpenStackInspector)(nil),                              // 21: terraform1.stacks.OpenStackInspector
	(*InspectExpressionResult)(nil),                         // 22: terraform1.stacks.InspectExpressionResult
	(*DynamicValue)(nil),                                    // 23: terraform1.stacks.DynamicValue
	(*DynamicValueChange)(nil),                              // 24: terraform1.stacks.DynamicValueChange
	(*DynamicValueWithSource)(nil),                          // 25: terraform1.stacks.DynamicValueWithSource
	(*AttributePath)(nil),                                   // 26: terraform1.stacks.AttributePath
	(*ComponentInstanceInStackAddr)(nil),                    // 27: terraform1.stacks.ComponentInstanceInStackAddr
	(*ResourceInstanceInStackAddr)(nil),                     // 28: terraform1.stacks.ResourceInstanceInStackAddr
	(*ResourceInstanceObjectInStackAddr)(nil),               // 29: terraform1.stacks.ResourceInstanceObjectInStackAddr
	(*PlannedChange)(nil),                                   // 30: terraform1.stacks.PlannedChange
	(*Deferred)(nil),                                        // 31: terraform1.stacks.Deferred
	(*AppliedChange)(nil),                                   // 32: terraform1.stacks.AppliedChange
	(*StackChangeProgress)(nil),                             // 33: terraform1.stacks.StackChangeProgress
	(*ListResourceIdentities)(nil),                          // 34: terraform1.stacks.ListResourceIdentities
	(*OpenTerraformState_Request)(nil),                      // 35: terraform1.stacks.OpenTerraformState.Request
	(*OpenTerraformState_Response)(nil),                     // 36: terraform1.stacks.OpenTerraformState.Response
	(*CloseTerraformState_Request)(nil),                     // 37: terraform1.stacks.CloseTerraformState.Request
	(*CloseTerraformState_Response)(nil),                    // 38: terraform1.stacks.CloseTerraformState.Response
	(*MigrateTerraformState_Request)(nil),                   // 39: terraform1.stacks.MigrateTerraformState.Request
	(*MigrateTerraformState_Event)(nil),                     // 40: terraform1.stacks.MigrateTerraformState.Event
	(*MigrateTerraformState_Request_Mapping)(nil),           // 41: terraform1.stacks.MigrateTerraformState.Request.Mapping
	nil,                                      // 42: terraform1.stacks.MigrateTerraformState.Request.Mapping.ResourceAddressMapEntry
	nil,                                      // 43: terraform1.stacks.MigrateTerraformState.Request.Mapping.ModuleAddressMapEntry
	(*OpenStackConfiguration_Request)(nil),   // 44: terraform1.stacks.OpenStackConfiguration.Request
	(*OpenStackConfiguration_Response)(nil),  // 45: terraform1.stacks.OpenStackConfiguration.Response
	(*CloseStackConfiguration_Request)(nil),  // 46: terraform1.stacks.CloseStackConfiguration.Request
	(*CloseStackConfiguration_Response)(nil), // 47: terraform1.stacks.CloseStackConfiguration.Response
	(*ValidateStackConfiguration_Request)(nil),             // 48: terraform1.stacks.ValidateStackConfiguration.Request
	(*ValidateStackConfiguration_Response)(nil),            // 49: terraform1.stacks.ValidateStackConfiguration.Response
	(*FindStackConfigurationComponents_Request)(nil),       // 50: terraform1.stacks.FindStackConfigurationComponents.Request
	(*FindStackConfigurationComponents_Response)(nil),      // 51: terraform1.stacks.FindStackConfigurationComponents.Response
	(*FindStackConfigurationComponents_StackConfig)(nil),   // 52: terraform1.stacks.FindStackConfigurationComponents.StackConfig
	(*FindStackConfigurationComponents_EmbeddedStack)(nil), // 53: terraform1.stacks.FindStackConfigurationComponents.EmbeddedStack
	(*FindStackConfigurationComponents_Component)(nil),     // 54: terraform1.stacks.FindStackConfigurationComponents.Component
	(*FindStackConfigurationComponents_Removed)(nil),       // 55: terraform1.stacks.FindStackConfigurationComponents.Removed
	(*FindStackConfigurationComponents_InputVariable)(nil), // 56: terraform1.stacks.FindStackConfigurationComponents.InputVariable
	(*FindStackConfigurationComponents_OutputValue)(nil),   // 57: terraform1.stacks.FindStackConfigurationComponents.OutputValue
	nil, // 58: terraform1.stacks.FindStackConfigurationComponents.StackConfig.ComponentsEntry
	nil, // 59: terraform1.stacks.FindStackConfigurationComponents.StackConfig.EmbeddedStacksEntry
	nil, // 60: terraform1.stacks.FindStackConfigurationComponents.StackConfig.InputVariablesEntry
	nil, // 61: terraform1.stacks.FindStackConfigurationComponents.StackConfig.OutputValuesEntry
	nil, // 62: terraform1.stacks.FindStackConfigurationComponents.StackConfig.RemovedEntry
	(*FindStackConfigurationComponents_Removed_Block)(nil),    // 63: terraform1.stacks.FindStackConfigurationComponents.Removed.Block
	(*OpenStackState_RequestItem)(nil),                        // 64: terraform1.stacks.OpenStackState.RequestItem
	(*OpenStackState_Response)(nil),                           // 65: terraform1.stacks.OpenStackState.Response
	(*CloseStackState_Request)(nil),                           // 66: terraform1.stacks.CloseStackState.Request
	(*CloseStackState_Response)(nil),                          // 67: terraform1.stacks.CloseStackState.Response
	(*PlanStackChanges_Request)(nil),                          // 68: terraform1.stacks.PlanStackChanges.Request
	(*PlanStackChanges_Event)(nil),                            // 69: terraform1.stacks.PlanStackChanges.Event
	nil,                                                       // 70: terraform1.stacks.PlanStackChanges.Request.PreviousStateEntry
	nil,                                                       // 71: terraform1.stacks.PlanStackChanges.Request.InputValuesEntry
	(*OpenStackPlan_RequestItem)(nil),                         // 72: terraform1.stacks.OpenStackPlan.RequestItem
	(*OpenStackPlan_Response)(nil),                            // 73: terraform1.stacks.OpenStackPlan.Response
	(*CloseStackPlan_Request)(nil),                            // 74: terraform1.stacks.CloseStackPlan.Request
	(*CloseStackPlan_Response)(nil),                           // 75: terraform1.stacks.CloseStackPlan.Response
	(*ApplyStackChanges_Request)(nil),                         // 76: terraform1.stacks.ApplyStackChanges.Request
	(*ApplyStackChanges_Event)(nil),                           // 77: terraform1.stacks.ApplyStackChanges.Event
	nil,                                                       // 78: terraform1.stacks.ApplyStackChanges.Request.InputValuesEntry
	(*OpenStackInspector_Request)(nil),                        // 79: terraform1.stacks.OpenStackInspector.Request
	(*OpenStackInspector_Response)(nil),                       // 80: terraform1.stacks.OpenStackInspector.Response
	nil,                                                       // 81: terraform1.stacks.OpenStackInspector.Request.StateEntry
	nil,                                                       // 82: terraform1.stacks.OpenStackInspector.Request.InputValuesEntry
	(*InspectExpressionResult_Request)(nil),                   // 83: terraform1.stacks.InspectExpressionResult.Request
	(*InspectExpressionResult_Response)(nil),                  // 84: terraform1.stacks.InspectExpressionResult.Response
	(*AttributePath_Step)(nil),                                // 85: terraform1.stacks.AttributePath.Step
	(*PlannedChange_ChangeDescription)(nil),                   // 86: terraform1.stacks.PlannedChange.ChangeDescription
	(*PlannedChange_ComponentInstance)(nil),                   // 87: terraform1.stacks.PlannedChange.ComponentInstance
	(*PlannedChange_ResourceInstance)(nil),                    // 88: terraform1.stacks.PlannedChange.ResourceInstance
	(*PlannedChange_OutputValue)(nil),                         // 89: terraform1.stacks.PlannedChange.OutputValue
	(*PlannedChange_ResourceInstanceDeferred)(nil),            // 90: terraform1.stacks.PlannedChange.ResourceInstanceDeferred
	(*PlannedChange_InputVariable)(nil),                       // 91: terraform1.stacks.PlannedChange.InputVariable
	(*PlannedChange_ResourceInstance_Index)(nil),              // 92: terraform1.stacks.PlannedChange.ResourceInstance.Index
	(*PlannedChange_ResourceInstance_Moved)(nil),              // 93: terraform1.stacks.PlannedChange.ResourceInstance.Moved
	(*PlannedChange_ResourceInstance_Imported)(nil),           // 94: terraform1.stacks.PlannedChange.ResourceInstance.Imported
	(*AppliedChange_RawChange)(nil),                           // 95: terraform1.stacks.AppliedChange.RawChange
	(*AppliedChange_ChangeDescription)(nil),                   // 96: terraform1.stacks.AppliedChange.ChangeDescription
	(*AppliedChange_ResourceInstance)(nil),                    // 97: terraform1.stacks.AppliedChange.ResourceInstance
	(*AppliedChange_ComponentInstance)(nil),                   // 98: terraform1.stacks.AppliedChange.ComponentInstance
	(*AppliedChange_OutputValue)(nil),                         // 99: terraform1.stacks.AppliedChange.OutputValue
	(*AppliedChange_InputVariable)(nil),                       // 100: terraform1.stacks.AppliedChange.InputVariable
	(*AppliedChange_Nothing)(nil),                             // 101: terraform1.stacks.AppliedChange.Nothing
	nil,                                                       // 102: terraform1.stacks.AppliedChange.ComponentInstance.OutputValuesEntry
	(*StackChangeProgress_ComponentInstanceStatus)(nil),       // 103: terraform1.stacks.StackChangeProgress.ComponentInstanceStatus
	(*StackChangeProgress_ResourceInstanceStatus)(nil),        // 104: terraform1.stacks.StackChangeProgress.ResourceInstanceStatus
	(*StackChangeProgress_ResourceInstancePlannedChange)(nil), // 105: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange
	(*StackChangeProgress_DeferredResourceInstancePlannedChange)(nil),  // 106: terraform1.stacks.StackChangeProgress.DeferredResourceInstancePlannedChange
	(*StackChangeProgress_ProvisionerStatus)(nil),                      // 107: terraform1.stacks.StackChangeProgress.ProvisionerStatus
	(*StackChangeProgress_ProvisionerOutput)(nil),                      // 108: terraform1.stacks.StackChangeProgress.ProvisionerOutput
	(*StackChangeProgress_ComponentInstanceChanges)(nil),               // 109: terraform1.stacks.StackChangeProgress.ComponentInstanceChanges
	(*StackChangeProgress_ComponentInstances)(nil),                     // 110: terraform1.stacks.StackChangeProgress.ComponentInstances
	(*StackChangeProgress_ResourceInstancePlannedChange_Moved)(nil),    // 111: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.Moved
	(*StackChangeProgress_ResourceInstancePlannedChange_Imported)(nil), // 112: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.Imported
	(*ListResourceIdentities_Request)(nil),                             // 113: terraform1.stacks.ListResourceIdentities.Request
	(*ListResourceIdentities_Response)(nil),                            // 114: terraform1.stacks.ListResourceIdentities.Response
	(*ListResourceIdentities_Resource)(nil),                            // 115: terraform1.stacks.ListResourceIdentities.Resource
	(*terraform1.SourceRange)(nil),                                     // 116: terraform1.SourceRange
	(*anypb.Any)(nil),                                                  // 117: google.protobuf.Any
	(*terraform1.Diagnostic)(nil),                                      // 118: terraform1.Diagnostic
	(*terraform1.SourceAddress)(nil),                                   // 119: terraform1.SourceAddress
}
var file_stacks_proto_depIdxs = []int32{
	26,  // 0: terraform1.stacks.DynamicValue.sensitive:type_name -> terraform1.stacks.AttributePath
	23,  // 1: terraform1.stacks.DynamicValueChange.old:type_name -> terraform1.stacks.DynamicValue
	23,  // 2: terraform1.stacks.DynamicValueChange.new:type_name -> terraform1.stacks.DynamicValue
	23,  // 3: terraform1.stacks.DynamicValueWithSource.value:type_name -> terraform1.stacks.DynamicValue
	116, // 4: terraform1.stacks.DynamicValueWithSource.source_range:type_name -> terraform1.SourceRange
	85,  // 5: terraform1.stacks.AttributePath.steps:type_name -> terraform1.stacks.AttributePath.Step
	117, // 6: terraform1.stacks.PlannedChange.raw:type_name -> google.protobuf.Any
	86,  // 7: terraform1.stacks.PlannedChange.descriptions:type_name -> terraform1.stacks.PlannedChange.ChangeDescription
	4,   // 8: terraform1.stacks.Deferred.reason:type_name -> terraform1.stacks.Deferred.Reason
	95,  // 9: terraform1.stacks.AppliedChange.raw:type_name -> terraform1.stacks.AppliedChange.RawChange
	96,  // 10: terraform1.stacks.AppliedChange.descriptions:type_name -> terraform1.stacks.AppliedChange.ChangeDescription
	103, // 11: terraform1.stacks.StackChangeProgress.component_instance_status:type_name -> terraform1.stacks.StackChangeProgress.ComponentInstanceStatus
	104, // 12: terraform1.stacks.StackChangeProgress.resource_instance_status:type_name -> terraform1.stacks.StackChangeProgress.ResourceInstanceStatus
	105, // 13: terraform1.stacks.StackChangeProgress.resource_instance_planned_change:type_name -> terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange
	107, // 14: terraform1.stacks.StackChangeProgress.provisioner_status:type_name -> terraform1.stacks.StackChangeProgress.ProvisionerStatus
	108, // 15: terraform1.stacks.StackChangeProgress.provisioner_output:type_name -> terraform1.stacks.StackChangeProgress.ProvisionerOutput
	109, // 16: terraform1.stacks.StackChangeProgress.component_instance_changes:type_name -> terraform1.stacks.StackChangeProgress.ComponentInstanceChanges
	110, // 17: terraform1.stacks.StackChangeProgress.component_instances:type_name -> terraform1.stacks.StackChangeProgress.ComponentInstances
	106, // 18: terraform1.stacks.StackChangeProgress.deferred_resource_instance_planned_change:type_name -> terraform1.stacks.StackChangeProgress.DeferredResourceInstancePlannedChange
	118, // 19: terraform1.stacks.OpenTerraformState.Response.diagnostics:type_name -> terraform1.Diagnostic
	41,  // 20: terraform1.stacks.MigrateTerraformState.Request.simple:type_name -> terraform1.stacks.MigrateTerraformState.Request.Mapping
	118, // 21: terraform1.stacks.MigrateTerraformState.Event.diagnostic:type_name -> terraform1.Diagnostic
	32,  // 22: terraform1.stacks.MigrateTerraformState.Event.applied_change:type_name -> terraform1.stacks.AppliedChange
	42,  // 23: terraform1.stacks.MigrateTerraformState.Request.Mapping.resource_address_map:type_name -> terraform1.stacks.MigrateTerraformState.Request.Mapping.ResourceAddressMapEntry
	43,  // 24: terraform1.stacks.MigrateTerraformState.Request.Mapping.module_address_map:type_name -> terraform1.stacks.MigrateTerraformState.Request.Mapping.ModuleAddressMapEntry
	119, // 25: terraform1.stacks.OpenStackConfiguration.Request.source_address:type_name -> terraform1.SourceAddress
	118, // 26: terraform1.stacks.OpenStackConfiguration.Response.diagnostics:type_name -> terraform1.Diagnostic
	118, // 27: terraform1.stacks.ValidateStackConfiguration.Response.diagnostics:type_name -> terraform1.Diagnostic
	52,  // 28: terraform1.stacks.FindStackConfigurationComponents.Response.config:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig
	58,  // 29: terraform1.stacks.FindStackConfigurationComponents.StackConfig.components:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig.ComponentsEntry
	59,  // 30: terraform1.stacks.FindStackConfigurationComponents.StackConfig.embedded_stacks:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig.EmbeddedStacksEntry
	60,  // 31: terraform1.stacks.FindStackConfigurationComponents.StackConfig.input_variables:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig.InputVariablesEntry
	61,  // 32: terraform1.stacks.FindStackConfigurationComponents.StackConfig.output_values:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig.OutputValuesEntry
	62,  // 33: terraform1.stacks.FindStackConfigurationComponents.StackConfig.removed:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig.RemovedEntry
	3,   // 34: terraform1.stacks.FindStackConfigurationComponents.EmbeddedStack.instances:type_name -> terraform1.stacks.FindStackConfigurationComponents.Instances
	52,  // 35: terraform1.stacks.FindStackConfigurationComponents.EmbeddedStack.config:type_name -> terraform1.stacks.FindStackConfigurationComponents.StackConfig
	3,   // 36: terraform1.stacks.FindStackConfigurationComponents.Component.instances:type_name -> terraform1.stacks.FindStackConfigurationComponents.Instances
	3,   // 37: terraform1.stacks.FindStackConfigurationComponents.Removed.instances:type_name -> terraform1.stacks.FindStackConfigurationComponents.Instances
	63,  // 38: terraform1.stacks.FindStackConfigurationComponents.Removed.blocks:type_name -> terraform1.stacks.FindStackConfigurationComponents.Removed.Block
	54,  // 39: terraform1.stacks.FindStackConfigurationComponents.StackConfig.ComponentsEntry.value:type_name -> terraform1.stacks.FindStackConfigurationComponents.Component
	53,  // 40: terraform1.stacks.FindStackConfigurationComponents.StackConfig.EmbeddedStacksEntry.value:type_name -> terraform1.stacks.FindStackConfigurationComponents.EmbeddedStack
	56,  // 41: terraform1.stacks.FindStackConfigurationComponents.StackConfig.InputVariablesEntry.value:type_name -> terraform1.stacks.FindStackConfigurationComponents.InputVariable
	57,  // 42: terraform1.stacks.FindStackConfigurationComponents.StackConfig.OutputValuesEntry.value:type_name -> terraform1.stacks.FindStackConfigurationComponents.OutputValue
	55,  // 43: terraform1.stacks.FindStackConfigurationComponents.StackConfig.RemovedEntry.value:type_name -> terraform1.stacks.FindStackConfigurationComponents.Removed
	3,   // 44: terraform1.stacks.FindStackConfigurationComponents.Removed.Block.instances:type_name -> terraform1.stacks.FindStackConfigurationComponents.Instances
	95,  // 45: terraform1.stacks.OpenStackState.RequestItem.raw:type_name -> terraform1.stacks.AppliedChange.RawChange
	1,   // 46: terraform1.stacks.PlanStackChanges.Request.plan_mode:type_name -> terraform1.stacks.PlanMode
	70,  // 47: terraform1.stacks.PlanStackChanges.Request.previous_state:type_name -> terraform1.stacks.PlanStackChanges.Request.PreviousStateEntry
	71,  // 48: terraform1.stacks.PlanStackChanges.Request.input_values:type_name -> terraform1.stacks.PlanStackChanges.Request.InputValuesEntry
	30,  // 49: terraform1.stacks.PlanStackChanges.Event.planned_change:type_name -> terraform1.stacks.PlannedChange
	118, // 50: terraform1.stacks.PlanStackChanges.Event.diagnostic:type_name -> terraform1.Diagnostic
	33,  // 51: terraform1.stacks.PlanStackChanges.Event.progress:type_name -> terraform1.stacks.StackChangeProgress
	117, // 52: terraform1.stacks.PlanStackChanges.Request.PreviousStateEntry.value:type_name -> google.protobuf.Any
	25,  // 53: terraform1.stacks.PlanStackChanges.Request.InputValuesEntry.value:type_name -> terraform1.stacks.DynamicValueWithSource
	117, // 54: terraform1.stacks.OpenStackPlan.RequestItem.raw:type_name -> google.protobuf.Any
	117, // 55: terraform1.stacks.ApplyStackChanges.Request.planned_changes:type_name -> google.protobuf.Any
	78,  // 56: terraform1.stacks.ApplyStackChanges.Request.input_values:type_name -> terraform1.stacks.ApplyStackChanges.Request.InputValuesEntry
	32,  // 57: terraform1.stacks.ApplyStackChanges.Event.applied_change:type_name -> terraform1.stacks.AppliedChange
	118, // 58: terraform1.stacks.ApplyStackChanges.Event.diagnostic:type_name -> terraform1.Diagnostic
	33,  // 59: terraform1.stacks.ApplyStackChanges.Event.progress:type_name -> terraform1.stacks.StackChangeProgress
	25,  // 60: terraform1.stacks.ApplyStackChanges.Request.InputValuesEntry.value:type_name -> terraform1.stacks.DynamicValueWithSource
	81,  // 61: terraform1.stacks.OpenStackInspector.Request.state:type_name -> terraform1.stacks.OpenStackInspector.Request.StateEntry
	82,  // 62: terraform1.stacks.OpenStackInspector.Request.input_values:type_name -> terraform1.stacks.OpenStackInspector.Request.InputValuesEntry
	118, // 63: terraform1.stacks.OpenStackInspector.Response.diagnostics:type_name -> terraform1.Diagnostic
	117, // 64: terraform1.stacks.OpenStackInspector.Request.StateEntry.value:type_name -> google.protobuf.Any
	25,  // 65: terraform1.stacks.OpenStackInspector.Request.InputValuesEntry.value:type_name -> terraform1.stacks.DynamicValueWithSource
	23,  // 66: terraform1.stacks.InspectExpressionResult.Response.result:type_name -> terraform1.stacks.DynamicValue
	118, // 67: terraform1.stacks.InspectExpressionResult.Response.diagnostics:type_name -> terraform1.Diagnostic
	87,  // 68: terraform1.stacks.PlannedChange.ChangeDescription.component_instance_planned:type_name -> terraform1.stacks.PlannedChange.ComponentInstance
	88,  // 69: terraform1.stacks.PlannedChange.ChangeDescription.resource_instance_planned:type_name -> terraform1.stacks.PlannedChange.ResourceInstance
	89,  // 70: terraform1.stacks.PlannedChange.ChangeDescription.output_value_planned:type_name -> terraform1.stacks.PlannedChange.OutputValue
	90,  // 71: terraform1.stacks.PlannedChange.ChangeDescription.resource_instance_deferred:type_name -> terraform1.stacks.PlannedChange.ResourceInstanceDeferred
	91,  // 72: terraform1.stacks.PlannedChange.ChangeDescription.input_variable_planned:type_name -> terraform1.stacks.PlannedChange.InputVariable
	27,  // 73: terraform1.stacks.PlannedChange.ComponentInstance.addr:type_name -> terraform1.stacks.ComponentInstanceInStackAddr
	2,   // 74: terraform1.stacks.PlannedChange.ComponentInstance.actions:type_name -> terraform1.stacks.ChangeType
	29,  // 75: terraform1.stacks.PlannedChange.ResourceInstance.addr:type_name -> terraform1.stacks.ResourceInstanceObjectInStackAddr
	2,   // 76: terraform1.stacks.PlannedChange.ResourceInstance.actions:type_name -> terraform1.stacks.ChangeType
	24,  // 77: terraform1.stacks.PlannedChange.ResourceInstance.values:type_name -> terraform1.stacks.DynamicValueChange
	93,  // 78: terraform1.stacks.PlannedChange.ResourceInstance.moved:type_name -> terraform1.stacks.PlannedChange.ResourceInstance.Moved
	94,  // 79: terraform1.stacks.PlannedChange.ResourceInstance.imported:type_name -> terraform1.stacks.PlannedChange.ResourceInstance.Imported
	0,   // 80: terraform1.stacks.PlannedChange.ResourceInstance.resource_mode:type_name -> terraform1.stacks.ResourceMode
	23,  // 81: terraform1.stacks.PlannedChange.ResourceInstance.previous_run_value:type_name -> terraform1.stacks.DynamicValue
	26,  // 82: terraform1.stacks.PlannedChange.ResourceInstance.replace_paths:type_name -> terraform1.stacks.AttributePath
	92,  // 83: terraform1.stacks.PlannedChange.ResourceInstance.index:type_name -> terraform1.stacks.PlannedChange.ResourceInstance.Index
	2,   // 84: terraform1.stacks.PlannedChange.OutputValue.actions:type_name -> terraform1.stacks.ChangeType
	24,  // 85: terraform1.stacks.PlannedChange.OutputValue.values:type_name -> terraform1.stacks.DynamicValueChange
	88,  // 86: terraform1.stacks.PlannedChange.ResourceInstanceDeferred.resource_instance:type_name -> terraform1.stacks.PlannedChange.ResourceInstance
	31,  // 87: terraform1.stacks.PlannedChange.ResourceInstanceDeferred.deferred:type_name -> terraform1.stacks.Deferred
	2,   // 88: terraform1.stacks.PlannedChange.InputVariable.actions:type_name -> terraform1.stacks.ChangeType
	24,  // 89: terraform1.stacks.PlannedChange.InputVariable.values:type_name -> terraform1.stacks.DynamicValueChange
	23,  // 90: terraform1.stacks.PlannedChange.ResourceInstance.Index.value:type_name -> terraform1.stacks.DynamicValue
	28,  // 91: terraform1.stacks.PlannedChange.ResourceInstance.Moved.prev_addr:type_name -> terraform1.stacks.ResourceInstanceInStackAddr
	117, // 92: terraform1.stacks.AppliedChange.RawChange.value:type_name -> google.protobuf.Any
	101, // 93: terraform1.stacks.AppliedChange.ChangeDescription.deleted:type_name -> terraform1.stacks.AppliedChange.Nothing
	101, // 94: terraform1.stacks.AppliedChange.ChangeDescription.moved:type_name -> terraform1.stacks.AppliedChange.Nothing
	97,  // 95: terraform1.stacks.AppliedChange.ChangeDescription.resource_instance:type_name -> terraform1.stacks.AppliedChange.ResourceInstance
	99,  // 96: terraform1.stacks.AppliedChange.ChangeDescription.output_value:type_name -> terraform1.stacks.AppliedChange.OutputValue
	100, // 97: terraform1.stacks.AppliedChange.ChangeDescription.input_variable:type_name -> terraform1.stacks.AppliedChange.InputVariable
	98,  // 98: terraform1.stacks.AppliedChange.ChangeDescription.component_instance:type_name -> terraform1.stacks.AppliedChange.ComponentInstance
	29,  // 99: terraform1.stacks.AppliedChange.ResourceInstance.addr:type_name -> terraform1.stacks.ResourceInstanceObjectInStackAddr
	23,  // 100: terraform1.stacks.AppliedChange.ResourceInstance.new_value:type_name -> terraform1.stacks.DynamicValue
	0,   // 101: terraform1.stacks.AppliedChange.ResourceInstance.resource_mode:type_name -> terraform1.stacks.ResourceMode
	102, // 102: terraform1.stacks.AppliedChange.ComponentInstance.output_values:type_name -> terraform1.stacks.AppliedChange.ComponentInstance.OutputValuesEntry
	23,  // 103: terraform1.stacks.AppliedChange.OutputValue.new_value:type_name -> terraform1.stacks.DynamicValue
	23,  // 104: terraform1.stacks.AppliedChange.InputVariable.new_value:type_name -> terraform1.stacks.DynamicValue
	23,  // 105: terraform1.stacks.AppliedChange.ComponentInstance.OutputValuesEntry.value:type_name -> terraform1.stacks.DynamicValue
	27,  // 106: terraform1.stacks.StackChangeProgress.ComponentInstanceStatus.addr:type_name -> terraform1.stacks.ComponentInstanceInStackAddr
	5,   // 107: terraform1.stacks.StackChangeProgress.ComponentInstanceStatus.status:type_name -> terraform1.stacks.StackChangeProgress.ComponentInstanceStatus.Status
	29,  // 108: terraform1.stacks.StackChangeProgress.ResourceInstanceStatus.addr:type_name -> terraform1.stacks.ResourceInstanceObjectInStackAddr
	6,   // 109: terraform1.stacks.StackChangeProgress.ResourceInstanceStatus.status:type_name -> terraform1.stacks.StackChangeProgress.ResourceInstanceStatus.Status
	29,  // 110: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.addr:type_name -> terraform1.stacks.ResourceInstanceObjectInStackAddr
	2,   // 111: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.actions:type_name -> terraform1.stacks.ChangeType
	111, // 112: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.moved:type_name -> terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.Moved
	112, // 113: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.imported:type_name -> terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.Imported
	31,  // 114: terraform1.stacks.StackChangeProgress.DeferredResourceInstancePlannedChange.deferred:type_name -> terraform1.stacks.Deferred
	105, // 115: terraform1.stacks.StackChangeProgress.DeferredResourceInstancePlannedChange.change:type_name -> terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange
	29,  // 116: terraform1.stacks.StackChangeProgress.ProvisionerStatus.addr:type_name -> terraform1.stacks.ResourceInstanceObjectInStackAddr
	107, // 117: terraform1.stacks.StackChangeProgress.ProvisionerStatus.status:type_name -> terraform1.stacks.StackChangeProgress.ProvisionerStatus
	29,  // 118: terraform1.stacks.StackChangeProgress.ProvisionerOutput.addr:type_name -> terraform1.stacks.ResourceInstanceObjectInStackAddr
	27,  // 119: terraform1.stacks.StackChangeProgress.ComponentInstanceChanges.addr:type_name -> terraform1.stacks.ComponentInstanceInStackAddr
	28,  // 120: terraform1.stacks.StackChangeProgress.ResourceInstancePlannedChange.Moved.prev_addr:type_name -> terraform1.stacks.ResourceInstanceInStackAddr
	115, // 121: terraform1.stacks.ListResourceIdentities.Response.resource:type_name -> terraform1.stacks.ListResourceIdentities.Resource
	23,  // 122: terraform1.stacks.ListResourceIdentities.Resource.resource_identity:type_name -> terraform1.stacks.DynamicValue
	44,  // 123: terraform1.stacks.Stacks.OpenStackConfiguration:input_type -> terraform1.stacks.OpenStackConfiguration.Request
	46,  // 124: terraform1.stacks.Stacks.CloseStackConfiguration:input_type -> terraform1.stacks.CloseStackConfiguration.Request
	48,  // 125: terraform1.stacks.Stacks.ValidateStackConfiguration:input_type -> terraform1.stacks.ValidateStackConfiguration.Request
	50,  // 126: terraform1.stacks.Stacks.FindStackConfigurationComponents:input_type -> terraform1.stacks.FindStackConfigurationComponents.Request
	64,  // 127: terraform1.stacks.Stacks.OpenState:input_type -> terraform1.stacks.OpenStackState.RequestItem
	66,  // 128: terraform1.stacks.Stacks.CloseState:input_type -> terraform1.stacks.CloseStackState.Request
	68,  // 129: terraform1.stacks.Stacks.PlanStackChanges:input_type -> terraform1.stacks.PlanStackChanges.Request
	72,  // 130: terraform1.stacks.Stacks.OpenPlan:input_type -> terraform1.stacks.OpenStackPlan.RequestItem
	74,  // 131: terraform1.stacks.Stacks.ClosePlan:input_type -> terraform1.stacks.CloseStackPlan.Request
	76,  // 132: terraform1.stacks.Stacks.ApplyStackChanges:input_type -> terraform1.stacks.ApplyStackChanges.Request
	79,  // 133: terraform1.stacks.Stacks.OpenStackInspector:input_type -> terraform1.stacks.OpenStackInspector.Request
	83,  // 134: terraform1.stacks.Stacks.InspectExpressionResult:input_type -> terraform1.stacks.InspectExpressionResult.Request
	35,  // 135: terraform1.stacks.Stacks.OpenTerraformState:input_type -> terraform1.stacks.OpenTerraformState.Request
	37,  // 136: terraform1.stacks.Stacks.CloseTerraformState:input_type -> terraform1.stacks.CloseTerraformState.Request
	39,  // 137: terraform1.stacks.Stacks.MigrateTerraformState:input_type -> terraform1.stacks.MigrateTerraformState.Request
	113, // 138: terraform1.stacks.Stacks.ListResourceIdentities:input_type -> terraform1.stacks.ListResourceIdentities.Request
	45,  // 139: terraform1.stacks.Stacks.OpenStackConfiguration:output_type -> terraform1.stacks.OpenStackConfiguration.Response
	47,  // 140: terraform1.stacks.Stacks.CloseStackConfiguration:output_type -> terraform1.stacks.CloseStackConfiguration.Response
	49,  // 141: terraform1.stacks.Stacks.ValidateStackConfiguration:output_type -> terraform1.stacks.ValidateStackConfiguration.Response
	51,  // 142: terraform1.stacks.Stacks.FindStackConfigurationComponents:output_type -> terraform1.stacks.FindStackConfigurationComponents.Response
	65,  // 143: terraform1.stacks.Stacks.OpenState:output_type -> terraform1.stacks.OpenStackState.Response
	67,  // 144: terraform1.stacks.Stacks.CloseState:output_type -> terraform1.stacks.CloseStackState.Response
	69,  // 145: terraform1.stacks.Stacks.PlanStackChanges:output_type -> terraform1.stacks.PlanStackChanges.Event
	73,  // 146: terraform1.stacks.Stacks.OpenPlan:output_type -> terraform1.stacks.OpenStackPlan.Response
	75,  // 147: terraform1.stacks.Stacks.ClosePlan:output_type -> terraform1.stacks.CloseStackPlan.Response
	77,  // 148: terraform1.stacks.Stacks.ApplyStackChanges:output_type -> terraform1.stacks.ApplyStackChanges.Event
	80,  // 149: terraform1.stacks.Stacks.OpenStackInspector:output_type -> terraform1.stacks.OpenStackInspector.Response
	84,  // 150: terraform1.stacks.Stacks.InspectExpressionResult:output_type -> terraform1.stacks.InspectExpressionResult.Response
	36,  // 151: terraform1.stacks.Stacks.OpenTerraformState:output_type -> terraform1.stacks.OpenTerraformState.Response
	38,  // 152: terraform1.stacks.Stacks.CloseTerraformState:output_type -> terraform1.stacks.CloseTerraformState.Response
	40,  // 153: terraform1.stacks.Stacks.MigrateTerraformState:output_type -> terraform1.stacks.MigrateTerraformState.Event
	114, // 154: terraform1.stacks.Stacks.ListResourceIdentities:output_type -> terraform1.stacks.ListResourceIdentities.Response
	139, // [139:155] is the sub-list for method output_type
	123, // [123:139] is the sub-list for method input_type
	123, // [123:123] is the sub-list for extension type_name
	123, // [123:123] is the sub-list for extension extendee
	0,   // [0:123] is the sub-list for field type_name
}

func init() { file_stacks_proto_init() }
func file_stacks_proto_init() {
	if File_stacks_proto != nil {
		return
	}
	file_stacks_proto_msgTypes[25].OneofWrappers = []any{
		(*StackChangeProgress_ComponentInstanceStatus_)(nil),
		(*StackChangeProgress_ResourceInstanceStatus_)(nil),
		(*StackChangeProgress_ResourceInstancePlannedChange_)(nil),
		(*StackChangeProgress_ProvisionerStatus_)(nil),
		(*StackChangeProgress_ProvisionerOutput_)(nil),
		(*StackChangeProgress_ComponentInstanceChanges_)(nil),
		(*StackChangeProgress_ComponentInstances_)(nil),
		(*StackChangeProgress_DeferredResourceInstancePlannedChange_)(nil),
	}
	file_stacks_proto_msgTypes[27].OneofWrappers = []any{
		(*OpenTerraformState_Request_ConfigPath)(nil),
		(*OpenTerraformState_Request_Raw)(nil),
	}
	file_stacks_proto_msgTypes[31].OneofWrappers = []any{
		(*MigrateTerraformState_Request_Simple)(nil),
	}
	file_stacks_proto_msgTypes[32].OneofWrappers = []any{
		(*MigrateTerraformState_Event_Diagnostic)(nil),
		(*MigrateTerraformState_Event_AppliedChange)(nil),
	}
	file_stacks_proto_msgTypes[61].OneofWrappers = []any{
		(*PlanStackChanges_Event_PlannedChange)(nil),
		(*PlanStackChanges_Event_Diagnostic)(nil),
		(*PlanStackChanges_Event_Progress)(nil),
	}
	file_stacks_proto_msgTypes[69].OneofWrappers = []any{
		(*ApplyStackChanges_Event_AppliedChange)(nil),
		(*ApplyStackChanges_Event_Diagnostic)(nil),
		(*ApplyStackChanges_Event_Progress)(nil),
	}
	file_stacks_proto_msgTypes[77].OneofWrappers = []any{
		(*AttributePath_Step_AttributeName)(nil),
		(*AttributePath_Step_ElementKeyString)(nil),
		(*AttributePath_Step_ElementKeyInt)(nil),
	}
	file_stacks_proto_msgTypes[78].OneofWrappers = []any{
		(*PlannedChange_ChangeDescription_ComponentInstancePlanned)(nil),
		(*PlannedChange_ChangeDescription_ResourceInstancePlanned)(nil),
		(*PlannedChange_ChangeDescription_OutputValuePlanned)(nil),
		(*PlannedChange_ChangeDescription_PlanApplyable)(nil),
		(*PlannedChange_ChangeDescription_ResourceInstanceDeferred)(nil),
		(*PlannedChange_ChangeDescription_InputVariablePlanned)(nil),
	}
	file_stacks_proto_msgTypes[88].OneofWrappers = []any{
		(*AppliedChange_ChangeDescription_Deleted)(nil),
		(*AppliedChange_ChangeDescription_Moved)(nil),
		(*AppliedChange_ChangeDescription_ResourceInstance)(nil),
		(*AppliedChange_ChangeDescription_OutputValue)(nil),
		(*AppliedChange_ChangeDescription_InputVariable)(nil),
		(*AppliedChange_ChangeDescription_ComponentInstance)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_stacks_proto_rawDesc), len(file_stacks_proto_rawDesc)),
			NumEnums:      8,
			NumMessages:   108,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_stacks_proto_goTypes,
		DependencyIndexes: file_stacks_proto_depIdxs,
		EnumInfos:         file_stacks_proto_enumTypes,
		MessageInfos:      file_stacks_proto_msgTypes,
	}.Build()
	File_stacks_proto = out.File
	file_stacks_proto_goTypes = nil
	file_stacks_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StacksClient is the client API for Stacks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StacksClient interface {
	// Load and perform initial static validation of a stack configuration
	// in a previously-opened source bundle. If successful, returns a
	// stack configuration handle that can be used with other operations.
	OpenStackConfiguration(ctx context.Context, in *OpenStackConfiguration_Request, opts ...grpc.CallOption) (*OpenStackConfiguration_Response, error)
	// Close a previously-opened stack configuration using its handle.
	CloseStackConfiguration(ctx context.Context, in *CloseStackConfiguration_Request, opts ...grpc.CallOption) (*CloseStackConfiguration_Response, error)
	// Validate an open stack configuration.
	ValidateStackConfiguration(ctx context.Context, in *ValidateStackConfiguration_Request, opts ...grpc.CallOption) (*ValidateStackConfiguration_Response, error)
	// Analyze a stack configuration to find all of the components it declares.
	// This is static analysis only, so it cannot produce dynamic information
	// such as the number of instances of each component.
	FindStackConfigurationComponents(ctx context.Context, in *FindStackConfigurationComponents_Request, opts ...grpc.CallOption) (*FindStackConfigurationComponents_Response, error)
	// Load a stack state by sending a stream of raw state objects that were
	// streamed from a previous ApplyStackChanges response.
	OpenState(ctx context.Context, opts ...grpc.CallOption) (Stacks_OpenStateClient, error)
	// Close a stack state handle, discarding the associated state.
	CloseState(ctx context.Context, in *CloseStackState_Request, opts ...grpc.CallOption) (*CloseStackState_Response, error)
	// Calculate a desired state from the given configuration and compare it
	// with the current state to propose a set of changes to converge the
	// current state with the desired state, at least in part.
	PlanStackChanges(ctx context.Context, in *PlanStackChanges_Request, opts ...grpc.CallOption) (Stacks_PlanStackChangesClient, error)
	// Load a previously-created plan by sending a stream of raw change objects
	// that were streamed from a previous PlanStackChanges response.
	OpenPlan(ctx context.Context, opts ...grpc.CallOption) (Stacks_OpenPlanClient, error)
	// Close a saved plan handle, discarding the associated saved plan.
	ClosePlan(ctx context.Context, in *CloseStackPlan_Request, opts ...grpc.CallOption) (*CloseStackPlan_Response, error)
	// Execute the changes proposed by an earlier call to PlanStackChanges.
	ApplyStackChanges(ctx context.Context, in *ApplyStackChanges_Request, opts ...grpc.CallOption) (Stacks_ApplyStackChangesClient, error)
	// OpenStackInspector creates a stack inspector handle that can be used
	// with subsequent calls to the "Inspect"-prefixed functions.
	OpenStackInspector(ctx context.Context, in *OpenStackInspector_Request, opts ...grpc.CallOption) (*OpenStackInspector_Response, error)
	// InspectExpressionResult evaluates an arbitrary expression in the context
	// of a stack inspector handle.
	InspectExpressionResult(ctx context.Context, in *InspectExpressionResult_Request, opts ...grpc.CallOption) (*InspectExpressionResult_Response, error)
	// Open a previously-saved Terraform state, returning a handle that can be
	// used with other operations. This is distinct from OpenState because it
	// means core state rather than stack state.
	OpenTerraformState(ctx context.Context, in *OpenTerraformState_Request, opts ...grpc.CallOption) (*OpenTerraformState_Response, error)
	// Close a previously-opened Terraform state using its handle.
	CloseTerraformState(ctx context.Context, in *CloseTerraformState_Request, opts ...grpc.CallOption) (*CloseTerraformState_Response, error)
	// MigrateTerraformState migrates a Terraform state into Stacks state using
	// a mapping of addresses.
	MigrateTerraformState(ctx context.Context, in *MigrateTerraformState_Request, opts ...grpc.CallOption) (Stacks_MigrateTerraformStateClient, error)
	// ListResourceIdentities lists the identities of all resources in a stack.
	ListResourceIdentities(ctx context.Context, in *ListResourceIdentities_Request, opts ...grpc.CallOption) (*ListResourceIdentities_Response, error)
}

type stacksClient struct {
	cc grpc.ClientConnInterface
}

func NewStacksClient(cc grpc.ClientConnInterface) StacksClient {
	return &stacksClient{cc}
}

func (c *stacksClient) OpenStackConfiguration(ctx context.Context, in *OpenStackConfiguration_Request, opts ...grpc.CallOption) (*OpenStackConfiguration_Response, error) {
	out := new(OpenStackConfiguration_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/OpenStackConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) CloseStackConfiguration(ctx context.Context, in *CloseStackConfiguration_Request, opts ...grpc.CallOption) (*CloseStackConfiguration_Response, error) {
	out := new(CloseStackConfiguration_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/CloseStackConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) ValidateStackConfiguration(ctx context.Context, in *ValidateStackConfiguration_Request, opts ...grpc.CallOption) (*ValidateStackConfiguration_Response, error) {
	out := new(ValidateStackConfiguration_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/ValidateStackConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) FindStackConfigurationComponents(ctx context.Context, in *FindStackConfigurationComponents_Request, opts ...grpc.CallOption) (*FindStackConfigurationComponents_Response, error) {
	out := new(FindStackConfigurationComponents_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/FindStackConfigurationComponents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) OpenState(ctx context.Context, opts ...grpc.CallOption) (Stacks_OpenStateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Stacks_serviceDesc.Streams[0], "/terraform1.stacks.Stacks/OpenState", opts...)
	if err != nil {
		return nil, err
	}
	x := &stacksOpenStateClient{stream}
	return x, nil
}

type Stacks_OpenStateClient interface {
	Send(*OpenStackState_RequestItem) error
	CloseAndRecv() (*OpenStackState_Response, error)
	grpc.ClientStream
}

type stacksOpenStateClient struct {
	grpc.ClientStream
}

func (x *stacksOpenStateClient) Send(m *OpenStackState_RequestItem) error {
	return x.ClientStream.SendMsg(m)
}

func (x *stacksOpenStateClient) CloseAndRecv() (*OpenStackState_Response, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(OpenStackState_Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *stacksClient) CloseState(ctx context.Context, in *CloseStackState_Request, opts ...grpc.CallOption) (*CloseStackState_Response, error) {
	out := new(CloseStackState_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/CloseState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) PlanStackChanges(ctx context.Context, in *PlanStackChanges_Request, opts ...grpc.CallOption) (Stacks_PlanStackChangesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Stacks_serviceDesc.Streams[1], "/terraform1.stacks.Stacks/PlanStackChanges", opts...)
	if err != nil {
		return nil, err
	}
	x := &stacksPlanStackChangesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Stacks_PlanStackChangesClient interface {
	Recv() (*PlanStackChanges_Event, error)
	grpc.ClientStream
}

type stacksPlanStackChangesClient struct {
	grpc.ClientStream
}

func (x *stacksPlanStackChangesClient) Recv() (*PlanStackChanges_Event, error) {
	m := new(PlanStackChanges_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *stacksClient) OpenPlan(ctx context.Context, opts ...grpc.CallOption) (Stacks_OpenPlanClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Stacks_serviceDesc.Streams[2], "/terraform1.stacks.Stacks/OpenPlan", opts...)
	if err != nil {
		return nil, err
	}
	x := &stacksOpenPlanClient{stream}
	return x, nil
}

type Stacks_OpenPlanClient interface {
	Send(*OpenStackPlan_RequestItem) error
	CloseAndRecv() (*OpenStackPlan_Response, error)
	grpc.ClientStream
}

type stacksOpenPlanClient struct {
	grpc.ClientStream
}

func (x *stacksOpenPlanClient) Send(m *OpenStackPlan_RequestItem) error {
	return x.ClientStream.SendMsg(m)
}

func (x *stacksOpenPlanClient) CloseAndRecv() (*OpenStackPlan_Response, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(OpenStackPlan_Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *stacksClient) ClosePlan(ctx context.Context, in *CloseStackPlan_Request, opts ...grpc.CallOption) (*CloseStackPlan_Response, error) {
	out := new(CloseStackPlan_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/ClosePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) ApplyStackChanges(ctx context.Context, in *ApplyStackChanges_Request, opts ...grpc.CallOption) (Stacks_ApplyStackChangesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Stacks_serviceDesc.Streams[3], "/terraform1.stacks.Stacks/ApplyStackChanges", opts...)
	if err != nil {
		return nil, err
	}
	x := &stacksApplyStackChangesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Stacks_ApplyStackChangesClient interface {
	Recv() (*ApplyStackChanges_Event, error)
	grpc.ClientStream
}

type stacksApplyStackChangesClient struct {
	grpc.ClientStream
}

func (x *stacksApplyStackChangesClient) Recv() (*ApplyStackChanges_Event, error) {
	m := new(ApplyStackChanges_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *stacksClient) OpenStackInspector(ctx context.Context, in *OpenStackInspector_Request, opts ...grpc.CallOption) (*OpenStackInspector_Response, error) {
	out := new(OpenStackInspector_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/OpenStackInspector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) InspectExpressionResult(ctx context.Context, in *InspectExpressionResult_Request, opts ...grpc.CallOption) (*InspectExpressionResult_Response, error) {
	out := new(InspectExpressionResult_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/InspectExpressionResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) OpenTerraformState(ctx context.Context, in *OpenTerraformState_Request, opts ...grpc.CallOption) (*OpenTerraformState_Response, error) {
	out := new(OpenTerraformState_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/OpenTerraformState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) CloseTerraformState(ctx context.Context, in *CloseTerraformState_Request, opts ...grpc.CallOption) (*CloseTerraformState_Response, error) {
	out := new(CloseTerraformState_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/CloseTerraformState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stacksClient) MigrateTerraformState(ctx context.Context, in *MigrateTerraformState_Request, opts ...grpc.CallOption) (Stacks_MigrateTerraformStateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Stacks_serviceDesc.Streams[4], "/terraform1.stacks.Stacks/MigrateTerraformState", opts...)
	if err != nil {
		return nil, err
	}
	x := &stacksMigrateTerraformStateClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Stacks_MigrateTerraformStateClient interface {
	Recv() (*MigrateTerraformState_Event, error)
	grpc.ClientStream
}

type stacksMigrateTerraformStateClient struct {
	grpc.ClientStream
}

func (x *stacksMigrateTerraformStateClient) Recv() (*MigrateTerraformState_Event, error) {
	m := new(MigrateTerraformState_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *stacksClient) ListResourceIdentities(ctx context.Context, in *ListResourceIdentities_Request, opts ...grpc.CallOption) (*ListResourceIdentities_Response, error) {
	out := new(ListResourceIdentities_Response)
	err := c.cc.Invoke(ctx, "/terraform1.stacks.Stacks/ListResourceIdentities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StacksServer is the server API for Stacks service.
type StacksServer interface {
	// Load and perform initial static validation of a stack configuration
	// in a previously-opened source bundle. If successful, returns a
	// stack configuration handle that can be used with other operations.
	OpenStackConfiguration(context.Context, *OpenStackConfiguration_Request) (*OpenStackConfiguration_Response, error)
	// Close a previously-opened stack configuration using its handle.
	CloseStackConfiguration(context.Context, *CloseStackConfiguration_Request) (*CloseStackConfiguration_Response, error)
	// Validate an open stack configuration.
	ValidateStackConfiguration(context.Context, *ValidateStackConfiguration_Request) (*ValidateStackConfiguration_Response, error)
	// Analyze a stack configuration to find all of the components it declares.
	// This is static analysis only, so it cannot produce dynamic information
	// such as the number of instances of each component.
	FindStackConfigurationComponents(context.Context, *FindStackConfigurationComponents_Request) (*FindStackConfigurationComponents_Response, error)
	// Load a stack state by sending a stream of raw state objects that were
	// streamed from a previous ApplyStackChanges response.
	OpenState(Stacks_OpenStateServer) error
	// Close a stack state handle, discarding the associated state.
	CloseState(context.Context, *CloseStackState_Request) (*CloseStackState_Response, error)
	// Calculate a desired state from the given configuration and compare it
	// with the current state to propose a set of changes to converge the
	// current state with the desired state, at least in part.
	PlanStackChanges(*PlanStackChanges_Request, Stacks_PlanStackChangesServer) error
	// Load a previously-created plan by sending a stream of raw change objects
	// that were streamed from a previous PlanStackChanges response.
	OpenPlan(Stacks_OpenPlanServer) error
	// Close a saved plan handle, discarding the associated saved plan.
	ClosePlan(context.Context, *CloseStackPlan_Request) (*CloseStackPlan_Response, error)
	// Execute the changes proposed by an earlier call to PlanStackChanges.
	ApplyStackChanges(*ApplyStackChanges_Request, Stacks_ApplyStackChangesServer) error
	// OpenStackInspector creates a stack inspector handle that can be used
	// with subsequent calls to the "Inspect"-prefixed functions.
	OpenStackInspector(context.Context, *OpenStackInspector_Request) (*OpenStackInspector_Response, error)
	// InspectExpressionResult evaluates an arbitrary expression in the context
	// of a stack inspector handle.
	InspectExpressionResult(context.Context, *InspectExpressionResult_Request) (*InspectExpressionResult_Response, error)
	// Open a previously-saved Terraform state, returning a handle that can be
	// used with other operations. This is distinct from OpenState because it
	// means core state rather than stack state.
	OpenTerraformState(context.Context, *OpenTerraformState_Request) (*OpenTerraformState_Response, error)
	// Close a previously-opened Terraform state using its handle.
	CloseTerraformState(context.Context, *CloseTerraformState_Request) (*CloseTerraformState_Response, error)
	// MigrateTerraformState migrates a Terraform state into Stacks state using
	// a mapping of addresses.
	MigrateTerraformState(*MigrateTerraformState_Request, Stacks_MigrateTerraformStateServer) error
	// ListResourceIdentities lists the identities of all resources in a stack.
	ListResourceIdentities(context.Context, *ListResourceIdentities_Request) (*ListResourceIdentities_Response, error)
}

// UnimplementedStacksServer can be embedded to have forward compatible implementations.
type UnimplementedStacksServer struct {
}

func (*UnimplementedStacksServer) OpenStackConfiguration(context.Context, *OpenStackConfiguration_Request) (*OpenStackConfiguration_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenStackConfiguration not implemented")
}
func (*UnimplementedStacksServer) CloseStackConfiguration(context.Context, *CloseStackConfiguration_Request) (*CloseStackConfiguration_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseStackConfiguration not implemented")
}
func (*UnimplementedStacksServer) ValidateStackConfiguration(context.Context, *ValidateStackConfiguration_Request) (*ValidateStackConfiguration_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateStackConfiguration not implemented")
}
func (*UnimplementedStacksServer) FindStackConfigurationComponents(context.Context, *FindStackConfigurationComponents_Request) (*FindStackConfigurationComponents_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindStackConfigurationComponents not implemented")
}
func (*UnimplementedStacksServer) OpenState(Stacks_OpenStateServer) error {
	return status.Errorf(codes.Unimplemented, "method OpenState not implemented")
}
func (*UnimplementedStacksServer) CloseState(context.Context, *CloseStackState_Request) (*CloseStackState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseState not implemented")
}
func (*UnimplementedStacksServer) PlanStackChanges(*PlanStackChanges_Request, Stacks_PlanStackChangesServer) error {
	return status.Errorf(codes.Unimplemented, "method PlanStackChanges not implemented")
}
func (*UnimplementedStacksServer) OpenPlan(Stacks_OpenPlanServer) error {
	return status.Errorf(codes.Unimplemented, "method OpenPlan not implemented")
}
func (*UnimplementedStacksServer) ClosePlan(context.Context, *CloseStackPlan_Request) (*CloseStackPlan_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClosePlan not implemented")
}
func (*UnimplementedStacksServer) ApplyStackChanges(*ApplyStackChanges_Request, Stacks_ApplyStackChangesServer) error {
	return status.Errorf(codes.Unimplemented, "method ApplyStackChanges not implemented")
}
func (*UnimplementedStacksServer) OpenStackInspector(context.Context, *OpenStackInspector_Request) (*OpenStackInspector_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenStackInspector not implemented")
}
func (*UnimplementedStacksServer) InspectExpressionResult(context.Context, *InspectExpressionResult_Request) (*InspectExpressionResult_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InspectExpressionResult not implemented")
}
func (*UnimplementedStacksServer) OpenTerraformState(context.Context, *OpenTerraformState_Request) (*OpenTerraformState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenTerraformState not implemented")
}
func (*UnimplementedStacksServer) CloseTerraformState(context.Context, *CloseTerraformState_Request) (*CloseTerraformState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseTerraformState not implemented")
}
func (*UnimplementedStacksServer) MigrateTerraformState(*MigrateTerraformState_Request, Stacks_MigrateTerraformStateServer) error {
	return status.Errorf(codes.Unimplemented, "method MigrateTerraformState not implemented")
}
func (*UnimplementedStacksServer) ListResourceIdentities(context.Context, *ListResourceIdentities_Request) (*ListResourceIdentities_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListResourceIdentities not implemented")
}

func RegisterStacksServer(s *grpc.Server, srv StacksServer) {
	s.RegisterService(&_Stacks_serviceDesc, srv)
}

func _Stacks_OpenStackConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenStackConfiguration_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).OpenStackConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/OpenStackConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).OpenStackConfiguration(ctx, req.(*OpenStackConfiguration_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_CloseStackConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseStackConfiguration_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).CloseStackConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/CloseStackConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).CloseStackConfiguration(ctx, req.(*CloseStackConfiguration_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_ValidateStackConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateStackConfiguration_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).ValidateStackConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/ValidateStackConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).ValidateStackConfiguration(ctx, req.(*ValidateStackConfiguration_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_FindStackConfigurationComponents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindStackConfigurationComponents_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).FindStackConfigurationComponents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/FindStackConfigurationComponents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).FindStackConfigurationComponents(ctx, req.(*FindStackConfigurationComponents_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_OpenState_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StacksServer).OpenState(&stacksOpenStateServer{stream})
}

type Stacks_OpenStateServer interface {
	SendAndClose(*OpenStackState_Response) error
	Recv() (*OpenStackState_RequestItem, error)
	grpc.ServerStream
}

type stacksOpenStateServer struct {
	grpc.ServerStream
}

func (x *stacksOpenStateServer) SendAndClose(m *OpenStackState_Response) error {
	return x.ServerStream.SendMsg(m)
}

func (x *stacksOpenStateServer) Recv() (*OpenStackState_RequestItem, error) {
	m := new(OpenStackState_RequestItem)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Stacks_CloseState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseStackState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).CloseState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/CloseState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).CloseState(ctx, req.(*CloseStackState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_PlanStackChanges_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlanStackChanges_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StacksServer).PlanStackChanges(m, &stacksPlanStackChangesServer{stream})
}

type Stacks_PlanStackChangesServer interface {
	Send(*PlanStackChanges_Event) error
	grpc.ServerStream
}

type stacksPlanStackChangesServer struct {
	grpc.ServerStream
}

func (x *stacksPlanStackChangesServer) Send(m *PlanStackChanges_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Stacks_OpenPlan_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StacksServer).OpenPlan(&stacksOpenPlanServer{stream})
}

type Stacks_OpenPlanServer interface {
	SendAndClose(*OpenStackPlan_Response) error
	Recv() (*OpenStackPlan_RequestItem, error)
	grpc.ServerStream
}

type stacksOpenPlanServer struct {
	grpc.ServerStream
}

func (x *stacksOpenPlanServer) SendAndClose(m *OpenStackPlan_Response) error {
	return x.ServerStream.SendMsg(m)
}

func (x *stacksOpenPlanServer) Recv() (*OpenStackPlan_RequestItem, error) {
	m := new(OpenStackPlan_RequestItem)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Stacks_ClosePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseStackPlan_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).ClosePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/ClosePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).ClosePlan(ctx, req.(*CloseStackPlan_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_ApplyStackChanges_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ApplyStackChanges_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StacksServer).ApplyStackChanges(m, &stacksApplyStackChangesServer{stream})
}

type Stacks_ApplyStackChangesServer interface {
	Send(*ApplyStackChanges_Event) error
	grpc.ServerStream
}

type stacksApplyStackChangesServer struct {
	grpc.ServerStream
}

func (x *stacksApplyStackChangesServer) Send(m *ApplyStackChanges_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Stacks_OpenStackInspector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenStackInspector_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).OpenStackInspector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/OpenStackInspector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).OpenStackInspector(ctx, req.(*OpenStackInspector_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_InspectExpressionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectExpressionResult_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).InspectExpressionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/InspectExpressionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).InspectExpressionResult(ctx, req.(*InspectExpressionResult_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_OpenTerraformState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenTerraformState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).OpenTerraformState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/OpenTerraformState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).OpenTerraformState(ctx, req.(*OpenTerraformState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_CloseTerraformState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseTerraformState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).CloseTerraformState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/CloseTerraformState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).CloseTerraformState(ctx, req.(*CloseTerraformState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Stacks_MigrateTerraformState_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(MigrateTerraformState_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StacksServer).MigrateTerraformState(m, &stacksMigrateTerraformStateServer{stream})
}

type Stacks_MigrateTerraformStateServer interface {
	Send(*MigrateTerraformState_Event) error
	grpc.ServerStream
}

type stacksMigrateTerraformStateServer struct {
	grpc.ServerStream
}

func (x *stacksMigrateTerraformStateServer) Send(m *MigrateTerraformState_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Stacks_ListResourceIdentities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourceIdentities_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StacksServer).ListResourceIdentities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/terraform1.stacks.Stacks/ListResourceIdentities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StacksServer).ListResourceIdentities(ctx, req.(*ListResourceIdentities_Request))
	}
	return interceptor(ctx, in, info, handler)
}

var _Stacks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "terraform1.stacks.Stacks",
	HandlerType: (*StacksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "OpenStackConfiguration",
			Handler:    _Stacks_OpenStackConfiguration_Handler,
		},
		{
			MethodName: "CloseStackConfiguration",
			Handler:    _Stacks_CloseStackConfiguration_Handler,
		},
		{
			MethodName: "ValidateStackConfiguration",
			Handler:    _Stacks_ValidateStackConfiguration_Handler,
		},
		{
			MethodName: "FindStackConfigurationComponents",
			Handler:    _Stacks_FindStackConfigurationComponents_Handler,
		},
		{
			MethodName: "CloseState",
			Handler:    _Stacks_CloseState_Handler,
		},
		{
			MethodName: "ClosePlan",
			Handler:    _Stacks_ClosePlan_Handler,
		},
		{
			MethodName: "OpenStackInspector",
			Handler:    _Stacks_OpenStackInspector_Handler,
		},
		{
			MethodName: "InspectExpressionResult",
			Handler:    _Stacks_InspectExpressionResult_Handler,
		},
		{
			MethodName: "OpenTerraformState",
			Handler:    _Stacks_OpenTerraformState_Handler,
		},
		{
			MethodName: "CloseTerraformState",
			Handler:    _Stacks_CloseTerraformState_Handler,
		},
		{
			MethodName: "ListResourceIdentities",
			Handler:    _Stacks_ListResourceIdentities_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "OpenState",
			Handler:       _Stacks_OpenState_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "PlanStackChanges",
			Handler:       _Stacks_PlanStackChanges_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "OpenPlan",
			Handler:       _Stacks_OpenPlan_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "ApplyStackChanges",
			Handler:       _Stacks_ApplyStackChanges_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "MigrateTerraformState",
			Handler:       _Stacks_MigrateTerraformState_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "stacks.proto",
}
