/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

class EventTable {
    int[] types;
    Listener[] listeners;
    int level;
    static final int GROW_SIZE = 4;

    EventTable() {
    }

    public Listener[] getListeners(int eventType) {
        if (this.types == null) {
            return new Listener[0];
        }
        int count = 0;
        for (int type : this.types) {
            if (type != eventType) continue;
            ++count;
        }
        if (count == 0) {
            return new Listener[0];
        }
        Listener[] result = new Listener[count];
        count = 0;
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != eventType) continue;
            result[count++] = this.listeners[i];
        }
        return result;
    }

    public void hook(int eventType, Listener listener) {
        int index;
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.listeners == null) {
            this.listeners = new Listener[4];
        }
        int length = this.types.length;
        for (index = length - 1; index >= 0 && this.types[index] == 0; --index) {
        }
        if (++index == length) {
            int[] newTypes = new int[length + 4];
            System.arraycopy(this.types, 0, newTypes, 0, length);
            this.types = newTypes;
            Listener[] newListeners = new Listener[length + 4];
            System.arraycopy(this.listeners, 0, newListeners, 0, length);
            this.listeners = newListeners;
        }
        this.types[index] = eventType;
        this.listeners[index] = listener;
    }

    public boolean hooks(int eventType) {
        if (this.types == null) {
            return false;
        }
        for (int type : this.types) {
            if (type != eventType) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendEvent(Event event) {
        block21: {
            block20: {
                if (this.types == null) {
                    return;
                }
                this.level += this.level >= 0 ? 1 : -1;
                try {
                    exceptions = new ExceptionStash();
                    try {
                        i = 0;
lbl8:
                        // 2 sources

                        while (i < this.types.length) {
                            if (event.type == 0) {
                                exceptions.close();
                                v0 = this.level < 0;
                                break block20;
                            }
                            ** GOTO lbl-1000
                        }
                        break block21;
                    }
                    catch (Throwable i) {
                        try {
                            exceptions.close();
                            throw i;
                        }
                        catch (Throwable listener) {
                            i.addSuppressed(listener);
                        }
                        throw i;
                    }
                }
                catch (Throwable var7_13) {
                    compact = this.level < 0;
                    this.level -= this.level >= 0 ? 1 : -1;
                    if (compact == false) throw var7_13;
                    if (this.level != 0) throw var7_13;
                    index = 0;
                    for (i = 0; i < this.types.length; ++i) {
                        if (this.types[i] == 0) continue;
                        this.types[index] = this.types[i];
                        this.listeners[index] = this.listeners[i];
                        ++index;
                    }
                    i = index;
                    while (i < this.types.length) {
                        this.types[i] = 0;
                        this.listeners[i] = null;
                        ++i;
                    }
                    throw var7_13;
                }
            }
            compact = v0;
            this.level -= this.level >= 0 ? 1 : -1;
            if (compact == false) return;
            if (this.level != 0) return;
            index = 0;
            for (i = 0; i < this.types.length; ++i) {
                if (this.types[i] == 0) continue;
                this.types[index] = this.types[i];
                this.listeners[index] = this.listeners[i];
                ++index;
            }
            i = index;
            while (i < this.types.length) {
                this.types[i] = 0;
                this.listeners[i] = null;
                ++i;
            }
            return;
lbl-1000:
            // 1 sources

            {
                if (this.types[i] == event.type && (listener = this.listeners[i]) != null) {
                    try {
                        listener.handleEvent(event);
                    }
                    catch (Error | RuntimeException ex) {
                        exceptions.stash(ex);
                    }
                }
                ++i;
                ** GOTO lbl8
            }
        }
        exceptions.close();
        compact = this.level < 0;
        this.level -= this.level >= 0 ? 1 : -1;
        if (compact == false) return;
        if (this.level != 0) return;
        index = 0;
        for (i = 0; i < this.types.length; ++i) {
            if (this.types[i] == 0) continue;
            this.types[index] = this.types[i];
            this.listeners[index] = this.listeners[i];
            ++index;
        }
        i = index;
        while (i < this.types.length) {
            this.types[i] = 0;
            this.listeners[i] = null;
            ++i;
        }
    }

    public int size() {
        if (this.types == null) {
            return 0;
        }
        int count = 0;
        for (int type : this.types) {
            if (type == 0) continue;
            ++count;
        }
        return count;
    }

    void remove(int index) {
        if (this.level == 0) {
            int end = this.types.length - 1;
            System.arraycopy(this.types, index + 1, this.types, index, end - index);
            System.arraycopy(this.listeners, index + 1, this.listeners, index, end - index);
            index = end;
        } else if (this.level > 0) {
            this.level = -this.level;
        }
        this.types[index] = 0;
        this.listeners[index] = null;
    }

    public void unhook(int eventType, Listener listener) {
        if (this.types == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != eventType || this.listeners[i] != listener) continue;
            this.remove(i);
            return;
        }
    }

    public void unhook(int eventType, SWTEventListener listener) {
        if (this.types == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            TypedListener typedListener;
            if (this.types[i] != eventType || !(this.listeners[i] instanceof TypedListener) || (typedListener = (TypedListener)this.listeners[i]).getEventListener() != listener) continue;
            this.remove(i);
            return;
        }
    }
}

