import type * as swc from '@swc/types';
import type { Node, Callback, RecursiveVisitors } from './types.cjs';
/**
 * @see https://github.com/swc-project/swc/blob/main/packages/core/src/Visitor.ts
 */
export declare class BaseVisitor implements Required<RecursiveVisitors<unknown>> {
    ArrayExpression<S>(n: swc.ArrayExpression, st: S, cb: Callback<S>): void;
    ArrayPattern<S>(n: swc.ArrayPattern, st: S, cb: Callback<S>): void;
    ArrowFunctionExpression<S>(n: swc.ArrowFunctionExpression, st: S, cb: Callback<S>): void;
    AssignmentExpression<S>(n: swc.AssignmentExpression, st: S, cb: Callback<S>): void;
    AssignmentPattern<S>(n: swc.AssignmentPattern, st: S, cb: Callback<S>): void;
    AssignmentPatternProperty<S>(n: swc.AssignmentPatternProperty, st: S, cb: Callback<S>): void;
    AssignmentProperty<S>(n: swc.AssignmentProperty, st: S, cb: Callback<S>): void;
    AwaitExpression<S>(n: swc.AwaitExpression, st: S, cb: Callback<S>): void;
    BigIntLiteral: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    BinaryExpression<S>(n: swc.BinaryExpression, st: S, cb: Callback<S>): void;
    BlockStatement<S>(n: swc.BlockStatement, st: S, cb: Callback<S>): void;
    BooleanLiteral: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    BreakStatement<S>(n: swc.BreakStatement, st: S, cb: Callback<S>): void;
    CallExpression<S>(n: swc.CallExpression, st: S, cb: Callback<S>): void;
    CatchClause<S>(n: swc.CatchClause, st: S, cb: Callback<S>): void;
    ClassDeclaration<S>(n: swc.ClassDeclaration, st: S, cb: Callback<S>): void;
    ClassExpression<S>(n: swc.ClassExpression, st: S, cb: Callback<S>): void;
    ClassMethod<S>(n: swc.ClassMethod, st: S, cb: Callback<S>): void;
    ClassProperty<S>(n: swc.ClassProperty, st: S, cb: Callback<S>): void;
    Computed<S>(n: swc.ComputedPropName, st: S, cb: Callback<S>): void;
    ConditionalExpression<S>(n: swc.ConditionalExpression, st: S, cb: Callback<S>): void;
    Constructor<S>(n: swc.Constructor, st: S, cb: Callback<S>): void;
    ContinueStatement<S>(n: swc.ContinueStatement, st: S, cb: Callback<S>): void;
    DebuggerStatement: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    Decorator<S>(n: swc.Decorator, st: S, cb: Callback<S>): void;
    DoWhileStatement<S>(n: swc.DoWhileStatement, st: S, cb: Callback<S>): void;
    EmptyStatement: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    ExportAllDeclaration<S>(n: swc.ExportAllDeclaration, st: S, cb: Callback<S>): void;
    ExportDeclaration<S>(n: swc.ExportDeclaration, st: S, cb: Callback<S>): void;
    ExportDefaultDeclaration<S>(n: swc.ExportDefaultDeclaration, st: S, cb: Callback<S>): void;
    ExportDefaultExpression<S>(n: swc.ExportDefaultExpression, st: S, cb: Callback<S>): void;
    ExportDefaultSpecifier<S>(n: swc.ExportDefaultSpecifier, st: S, cb: Callback<S>): void;
    ExportNamedDeclaration<S>(n: swc.ExportNamedDeclaration, st: S, cb: Callback<S>): void;
    ExportNamespaceSpecifier<S>(n: swc.ExportNamespaceSpecifier, st: S, cb: Callback<S>): void;
    ExportSpecifier<S>(n: swc.NamedExportSpecifier, st: S, cb: Callback<S>): void;
    ExpressionStatement<S>(n: swc.ExpressionStatement, st: S, cb: Callback<S>): void;
    ForInStatement<S>(n: swc.ForInStatement, st: S, cb: Callback<S>): void;
    ForOfStatement<S>(n: swc.ForOfStatement, st: S, cb: Callback<S>): void;
    ForStatement<S>(n: swc.ForStatement, st: S, cb: Callback<S>): void;
    FunctionDeclaration<S>(n: swc.FunctionDeclaration, st: S, cb: Callback<S>): void;
    FunctionExpression<S>(n: swc.FunctionExpression, st: S, cb: Callback<S>): void;
    GetterProperty<S>(n: swc.GetterProperty, st: S, cb: Callback<S>): void;
    Identifier<S>(n: swc.Identifier | swc.BindingIdentifier, st: S, cb: Callback<S>): void;
    IfStatement<S>(n: swc.IfStatement, st: S, cb: Callback<S>): void;
    Import: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    ImportDeclaration<S>(n: swc.ImportDeclaration, st: S, cb: Callback<S>): void;
    ImportDefaultSpecifier<S>(n: swc.ImportDefaultSpecifier, st: S, cb: Callback<S>): void;
    ImportNamespaceSpecifier<S>(n: swc.ImportNamespaceSpecifier, st: S, cb: Callback<S>): void;
    ImportSpecifier<S>(n: swc.NamedImportSpecifier, st: S, cb: Callback<S>): void;
    Invalid: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    JSXAttribute<S>(n: swc.JSXAttribute, st: S, cb: Callback<S>): void;
    JSXClosingElement<S>(n: swc.JSXClosingElement, st: S, cb: Callback<S>): void;
    JSXClosingFragment: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    JSXElement<S>(n: swc.JSXElement, st: S, cb: Callback<S>): void;
    JSXEmptyExpression: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    JSXExpressionContainer<S>(n: swc.JSXExpressionContainer, st: S, cb: Callback<S>): void;
    JSXFragment<S>(n: swc.JSXFragment, st: S, cb: Callback<S>): void;
    JSXMemberExpression<S>(n: swc.JSXMemberExpression, st: S, cb: Callback<S>): void;
    JSXNamespacedName<S>(n: swc.JSXNamespacedName, st: S, cb: Callback<S>): void;
    JSXOpeningElement<S>(n: swc.JSXOpeningElement, st: S, cb: Callback<S>): void;
    JSXOpeningFragment: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    JSXSpreadChild<S>(n: swc.JSXSpreadChild, st: S, cb: Callback<S>): void;
    JSXText: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    KeyValuePatternProperty<S>(n: swc.KeyValuePatternProperty, st: S, cb: Callback<S>): void;
    KeyValueProperty<S>(n: swc.KeyValueProperty, st: S, cb: Callback<S>): void;
    LabeledStatement<S>(n: swc.LabeledStatement, st: S, cb: Callback<S>): void;
    MemberExpression<S>(n: swc.MemberExpression, st: S, cb: Callback<S>): void;
    MetaProperty: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    MethodProperty<S>(n: swc.MethodProperty, st: S, cb: Callback<S>): void;
    Module<S>(n: swc.Module, st: S, cb: Callback<S>): void;
    NewExpression<S>(n: swc.NewExpression, st: S, cb: Callback<S>): void;
    NullLiteral: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    NumericLiteral: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    ObjectExpression<S>(n: swc.ObjectExpression, st: S, cb: Callback<S>): void;
    ObjectPattern<S>(n: swc.ObjectPattern, st: S, cb: Callback<S>): void;
    OptionalChainingExpression<S>(n: swc.OptionalChainingExpression, st: S, cb: Callback<S>): void;
    Parameter<S>(n: swc.Param, st: S, cb: Callback<S>): void;
    ParenthesisExpression<S>(n: swc.ParenthesisExpression, st: S, cb: Callback<S>): void;
    PrivateMethod<S>(n: swc.PrivateMethod, st: S, cb: Callback<S>): void;
    PrivateName: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    PrivateProperty<S>(n: swc.PrivateProperty, st: S, cb: Callback<S>): void;
    RegExpLiteral: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    RestElement<S>(n: swc.RestElement, st: S, cb: Callback<S>): void;
    ReturnStatement<S>(n: swc.ReturnStatement, st: S, cb: Callback<S>): void;
    Script<S>(n: swc.Script, st: S, cb: Callback<S>): void;
    SequenceExpression<S>(n: swc.SequenceExpression, st: S, cb: Callback<S>): void;
    SetterProperty<S>(n: swc.SetterProperty, st: S, cb: Callback<S>): void;
    SpreadElement<S>(n: swc.SpreadElement, st: S, cb: Callback<S>): void;
    StaticBlock<S>(n: swc.StaticBlock, st: S, cb: Callback<S>): void;
    StringLiteral: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    Super: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    SuperPropExpression<S>(n: swc.SuperPropExpression, st: S, cb: Callback<S>): void;
    SwitchCase<S>(n: swc.SwitchCase, st: S, cb: Callback<S>): void;
    SwitchStatement<S>(n: swc.SwitchStatement, st: S, cb: Callback<S>): void;
    TaggedTemplateExpression<S>(n: swc.TaggedTemplateExpression, st: S, cb: Callback<S>): void;
    TemplateElement: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    TemplateLiteral<S>(n: swc.TemplateLiteral | swc.TsTemplateLiteralType, st: S, cb: Callback<S>): void;
    ThisExpression: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    ThrowStatement<S>(n: swc.ThrowStatement, st: S, cb: Callback<S>): void;
    TryStatement<S>(n: swc.TryStatement, st: S, cb: Callback<S>): void;
    TsArrayType<S>(n: swc.TsArrayType, st: S, cb: Callback<S>): void;
    TsExpressionWithTypeArguments<S>(n: swc.TsExpressionWithTypeArguments, st: S, cb: Callback<S>): void;
    TsInterfaceDeclaration<S>(n: swc.TsInterfaceDeclaration, st: S, cb: Callback<S>): void;
    TsInterfaceBody<S>(n: swc.TsInterfaceBody, st: S, cb: Callback<S>): void;
    TsKeywordType: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    TsPropertySignature<S>(n: swc.TsPropertySignature, st: S, cb: Callback<S>): void;
    TsAsExpression<S>(n: swc.TsAsExpression, st: S, cb: Callback<S>): void;
    TsCallSignatureDeclaration<S>(n: swc.TsCallSignatureDeclaration, st: S, cb: Callback<S>): void;
    TsConditionalType<S>(n: swc.TsConditionalType, st: S, cb: Callback<S>): void;
    TsConstAssertion<S>(n: swc.TsConstAssertion, st: S, cb: Callback<S>): void;
    TsConstructorType<S>(n: swc.TsConstructorType, st: S, cb: Callback<S>): void;
    TsConstructSignatureDeclaration<S>(n: swc.TsConstructSignatureDeclaration, st: S, cb: Callback<S>): void;
    TsEnumDeclaration<S>(n: swc.TsEnumDeclaration, st: S, cb: Callback<S>): void;
    TsEnumMember<S>(n: swc.TsEnumMember, st: S, cb: Callback<S>): void;
    TsExportAssignment<S>(n: swc.TsExportAssignment, st: S, cb: Callback<S>): void;
    TsExternalModuleReference<S>(n: swc.TsExternalModuleReference, st: S, cb: Callback<S>): void;
    TsFunctionType<S>(n: swc.TsFunctionType, st: S, cb: Callback<S>): void;
    TsGetterSignature<S>(n: swc.TsGetterSignature, st: S, cb: Callback<S>): void;
    TsImportEqualsDeclaration<S>(n: swc.TsImportEqualsDeclaration, st: S, cb: Callback<S>): void;
    TsImportType<S>(n: swc.TsImportType, st: S, cb: Callback<S>): void;
    TsIndexedAccessType<S>(n: swc.TsIndexedAccessType, st: S, cb: Callback<S>): void;
    TsIndexSignature<S>(n: swc.TsIndexSignature, st: S, cb: Callback<S>): void;
    TsInferType<S>(n: swc.TsInferType, st: S, cb: Callback<S>): void;
    TsInstantiation<S>(n: swc.TsInstantiation, st: S, cb: Callback<S>): void;
    TsIntersectionType<S>(n: swc.TsIntersectionType, st: S, cb: Callback<S>): void;
    TsLiteralType<S>(n: swc.TsLiteralType, st: S, cb: Callback<S>): void;
    TsMappedType<S>(n: swc.TsMappedType, st: S, cb: Callback<S>): void;
    TsMethodSignature<S>(n: swc.TsMethodSignature, st: S, cb: Callback<S>): void;
    TsModuleBlock<S>(n: swc.TsModuleBlock, st: S, cb: Callback<S>): void;
    TsModuleDeclaration<S>(n: swc.TsModuleDeclaration, st: S, cb: Callback<S>): void;
    TsNamespaceDeclaration<S>(n: swc.TsNamespaceDeclaration, st: S, cb: Callback<S>): void;
    TsNamespaceExportDeclaration<S>(n: swc.TsNamespaceExportDeclaration, st: S, cb: Callback<S>): void;
    TsNonNullExpression<S>(n: swc.TsNonNullExpression, st: S, cb: Callback<S>): void;
    TsOptionalType<S>(n: swc.TsOptionalType, st: S, cb: Callback<S>): void;
    TsParameterProperty<S>(n: swc.TsParameterProperty, st: S, cb: Callback<S>): void;
    TsParenthesizedType<S>(n: swc.TsParenthesizedType, st: S, cb: Callback<S>): void;
    TsQualifiedName<S>(n: swc.TsQualifiedName, st: S, cb: Callback<S>): void;
    TsRestType<S>(n: swc.TsRestType, st: S, cb: Callback<S>): void;
    TsSatisfiesExpression<S>(n: swc.TsSatisfiesExpression, st: S, cb: Callback<S>): void;
    TsSetterSignature<S>(n: swc.TsSetterSignature, st: S, cb: Callback<S>): void;
    TsThisType: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    TsTupleElement<S>(n: swc.TsTupleElement, st: S, cb: Callback<S>): void;
    TsTupleType<S>(n: swc.TsTupleType, st: S, cb: Callback<S>): void;
    TsTypeAliasDeclaration<S>(n: swc.TsTypeAliasDeclaration, st: S, cb: Callback<S>): void;
    TsType: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    TsTypeAnnotation<S>(n: swc.TsTypeAnnotation, st: S, cb: Callback<S>): void;
    TsTypeParameter<S>(n: swc.TsTypeParameter, st: S, cb: Callback<S>): void;
    TsTypeParameterDeclaration<S>(n: swc.TsTypeParameterDeclaration, st: S, cb: Callback<S>): void;
    TsTypeAssertion<S>(n: swc.TsTypeAssertion, st: S, cb: Callback<S>): void;
    TsTypeElement: <S>(_n: Node, _st: S, _cb: Callback<S>) => void;
    TsTypeLiteral<S>(n: swc.TsTypeLiteral, st: S, cb: Callback<S>): void;
    TsTypeOperator<S>(n: swc.TsTypeOperator, st: S, cb: Callback<S>): void;
    TsTypeParameterInstantiation<S>(n: swc.TsTypeParameterInstantiation, st: S, cb: Callback<S>): void;
    TsTypeReference<S>(n: swc.TsTypeReference, st: S, cb: Callback<S>): void;
    TsTypePredicate<S>(n: swc.TsTypePredicate, st: S, cb: Callback<S>): void;
    TsTypeQuery<S>(n: swc.TsTypeQuery, st: S, cb: Callback<S>): void;
    TsUnionType<S>(n: swc.TsUnionType, st: S, cb: Callback<S>): void;
    UnaryExpression<S>(n: swc.UnaryExpression, st: S, cb: Callback<S>): void;
    UpdateExpression<S>(n: swc.UpdateExpression, st: S, cb: Callback<S>): void;
    VariableDeclaration<S>(n: swc.VariableDeclaration, st: S, cb: Callback<S>): void;
    VariableDeclarator<S>(n: swc.VariableDeclarator, st: S, cb: Callback<S>): void;
    WhileStatement<S>(n: swc.WhileStatement, st: S, cb: Callback<S>): void;
    WithStatement<S>(n: swc.WithStatement, st: S, cb: Callback<S>): void;
    YieldExpression<S>(n: swc.YieldExpression, st: S, cb: Callback<S>): void;
}
export default BaseVisitor;
