//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4VPrimaryGenerator class implementation
//
// Author: Makoto Asai (SLAC)
// --------------------------------------------------------------------

#include "G4VPrimaryGenerator.hh"
#include "G4TransportationManager.hh"
#include "G4StateManager.hh"
#include "G4Navigator.hh"
#include "G4VPhysicalVolume.hh"
#include "G4VSolid.hh"

G4bool G4VPrimaryGenerator::CheckVertexInsideWorld(const G4ThreeVector& pos)
{
  // Check can only happen if run has been initialised
  //
  if (G4StateManager::GetStateManager()->GetCurrentState() != G4State_Idle)
  {
    return true;
  }

  G4Navigator* navigator= G4TransportationManager::GetTransportationManager()
                                                 -> GetNavigatorForTracking();
  G4VPhysicalVolume* world= navigator-> GetWorldVolume();
  G4VSolid* solid = world-> GetLogicalVolume()-> GetSolid();
  EInside qinside = solid-> Inside(pos);
  
  return qinside == kInside;
}

void G4VPrimaryGenerator::SetParticlePosition(G4ThreeVector aPosition)
{
  if (ifCheckInside && !CheckVertexInsideWorld(aPosition))
  {
    G4ExceptionDescription ed;
    ed << "Invalid vertex position (" << aPosition << "). "
       << "Position MUST be located -inside- the world volume." << G4endl
       << "Gun position has NOT been changed!";
    G4Exception("G4VPrimaryGenerator::SetParticlePosition",
                "Event0401", JustWarning, ed);
    return;
  }
  particle_position = aPosition;
}
