#! /bin/sh
#
# custom install to set per-file ownership (except in staged install)
# check $(whoami) != "root" to account for fakeroot
#

case $1 in
	zdkimfilter)
		install_options=' -o courier -g courier'
		if [ $(whoami) != "root" ]; then
			stars="***************************************************************"
			printf '%s\n**  WARNING:\n**  %s\n**  %s\n%s\n' \
				"$stars" \
				'Permissions and ownership of installed files not being set!' \
				'You must be root in order to install this package properly.' \
				"$stars"
		fi
		;;
	zdkimsign)
		install_options='  -o courier -g courier';;
	zdkimfilter.conf.dist)
		install_options='-m 640  -o courier -g courier';;
	*)
		install_options=;;
esac
if [ $(whoami) != "root" ]; then
		install_options=
fi

echo /usr/bin/install -c $install_options $@
/usr/bin/install -c $install_options $@

