%
% From Przymusinska and Przymusinski (weakly stratified paper).
% Example of a program that has a well-founded (and unique stable)
% model M = {s}, but does not have a weakly perfect model.
%
% It requires negative simplification while delay elements are
% interned (for the tnot(p) literal).
%

:- table p/0, q/0, r/0, s/0.

p :- tnot(s), q, tnot(r).
q :- r, tnot(p).
r :- p, tnot(q).
s :- tnot(p), tnot(q), tnot(r).

%--------------------------------------------------------------

test :- p, fail.
test :-
	( p ->
	    ( tnot(p) -> writeln('p is undefined') ; writeln('p is true') )
	; writeln('p is false (OK)') ),
	( q ->
	    ( tnot(q) -> writeln('q is undefined') ; writeln('q is true') )
	; writeln('q is false (OK)') ),
	( r ->
	    ( tnot(r) -> writeln('r is undefined') ; writeln('r is true') )
	; writeln('r is false (OK)') ),
	( s ->
	    ( tnot(s) -> writeln('s is undefined') ; writeln('s is true (OK)') )
	; writeln('s is false')
	).

%---------------------------------------------------------------

