## RabbitMQ 3.7.1

RabbitMQ `3.7.1` is a bug fix release.

### Upgrades and Compatibility

This release has no known incompatibilities with 3.7.0. See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0)
upgrade and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html)
for general documentation on upgrades.

See [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Standalone Mac build now bundles a version of Erlang/OTP that is compatible with High Sierra (20.1, to be specific).
 
   GitHub issue: [rabbitmq/rabbitmq-server-release#68](https://github.com/rabbitmq/rabbitmq-server-release/issues/68)

 * RabbitMQ distribution now again can be built in an offline environment (one without access to the Internet).
 
   GitHub issue: [rabbitmq/rabbitmq-server-release#61](https://github.com/rabbitmq/rabbitmq-server-release/issues/61)

 * `total_memory_available_override_value` was not available via the [new config format](https://www.rabbitmq.com/configure.html).
 
   GitHub issue: [rabbitmq/rabbitmq-server#1445](https://github.com/rabbitmq/rabbitmq-server/issues/1445)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl set_parameter` ignored the virtual host argument and default to the default (`/`) vhost.
 
    GitHub issue: [rabbitmq/rabbitmq-cli#232](https://github.com/rabbitmq/rabbitmq-cli/issues/232)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * HTTP client proxy settings were applied to late and thus didn't have any effect.
 
   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-common#5](https://github.com/rabbitmq/rabbitmq-peer-discovery-common/issues/5)


### Consul Peer Discovery Plugin

#### Bug Fixes

 * HTTP client proxy settings were applied to late and thus didn't have any effect.
 
   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-common#5](https://github.com/rabbitmq/rabbitmq-peer-discovery-common/issues/5)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * HTTP client proxy settings were applied to late and thus didn't have any effect.
 
   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-common#5](https://github.com/rabbitmq/rabbitmq-peer-discovery-common/issues/5)


### Kubernetes Peer Discovery Plugin

#### Bug Fixes

 * HTTP client proxy settings were applied to late and thus didn't have any effect.
 
   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-common#5](https://github.com/rabbitmq/rabbitmq-peer-discovery-common/issues/5)


### Management and Management Agent Plugins

#### Bug Fixes

 * Certain node metrics in multi-cluster environment were not merged correctly
   when aggregated.
   
   GitHub issue: [rabbitmq/rabbitmq-management#525](https://github.com/rabbitmq/rabbitmq-management/issues/525)


### Auth Backend HTTP Plugin

#### Bug Fixes

 * It was not possible to configure request HTTP method using the [new style config file](https://www.rabbitmq.com/configure.html).
 
   GitHub issue: [rabbitmq/rabbitmq-auth-backend-http#61](https://github.com/rabbitmq/rabbitmq-auth-backend-http/issues/61)


### Shovel Management Plugin

#### Bug Fixes

 * Move Messages form on individual queue page didn't provide all the Shovel parameters required as
   of 3.7.0 and thus did not transfer any messages.
 
   GitHub issue: [rabbitmq/rabbitmq-shovel-management#24](https://github.com/rabbitmq/rabbitmq-shovel-management/issues/24)


### Erlang AMQP 1.0 Client

#### Bug Fixes

 * Continuation frames without `delivery_id` were not handled correctly.
 
   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#11](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/11)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.1.tar.gz`.
